/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.PBEKeyGenParams;

public class PBEAlgorithm
extends KeyGenAlgorithm {
    private EncryptionAlgorithm encAlg;
    private int saltLength;
    private static final OBJECT_IDENTIFIER PKCS5 = OBJECT_IDENTIFIER.PKCS5;
    private static final OBJECT_IDENTIFIER PKCS12_PBE = OBJECT_IDENTIFIER.PKCS12.subBranch(1L);
    public static final PBEAlgorithm PBE_MD2_DES_CBC = new PBEAlgorithm(18, "PBE/MD2/DES/CBC", 56, PKCS5.subBranch(1L), EncryptionAlgorithm.DES_CBC, 8);
    public static final PBEAlgorithm PBE_MD5_DES_CBC = new PBEAlgorithm(19, "PBE/MD5/DES/CBC", 56, PKCS5.subBranch(3L), EncryptionAlgorithm.DES_CBC, 8);
    public static final PBEAlgorithm PBE_SHA1_DES_CBC = new PBEAlgorithm(20, "PBE/SHA1/DES/CBC", 56, PKCS5.subBranch(10L), EncryptionAlgorithm.DES_CBC, 8);
    public static final PBEAlgorithm PBE_SHA1_RC4_128 = new PBEAlgorithm(21, "PBE/SHA1/RC4-128", 128, PKCS12_PBE.subBranch(1L), EncryptionAlgorithm.RC4, 20);
    public static final PBEAlgorithm PBE_SHA1_RC4_40 = new PBEAlgorithm(22, "PBE/SHA1/RC4-40", 40, PKCS12_PBE.subBranch(2L), EncryptionAlgorithm.RC4, 20);
    public static final PBEAlgorithm PBE_SHA1_DES3_CBC = new PBEAlgorithm(23, "PBE/SHA1/DES3/CBC", 168, PKCS12_PBE.subBranch(3L), EncryptionAlgorithm.DES3_CBC, 20);
    public static final PBEAlgorithm PBE_SHA1_RC2_128_CBC = new PBEAlgorithm(28, "PBE/SHA1/RC2-128", 128, PKCS12_PBE.subBranch(5L), EncryptionAlgorithm.RC2_CBC, 20);
    public static final PBEAlgorithm PBE_SHA1_RC2_40_CBC = new PBEAlgorithm(29, "PBE/SHA1/RC2-40", 40, PKCS12_PBE.subBranch(6L), EncryptionAlgorithm.RC2_CBC, 20);

    protected PBEAlgorithm(int n, String string, int n2, OBJECT_IDENTIFIER oBJECT_IDENTIFIER, EncryptionAlgorithm encryptionAlgorithm, int n3) {
        super(n, string, new KeyGenAlgorithm.FixedKeyStrengthValidator(n2), oBJECT_IDENTIFIER, PBEKeyGenParams.class);
        this.encAlg = encryptionAlgorithm;
        this.saltLength = n3;
    }

    public EncryptionAlgorithm getEncryptionAlg() {
        return this.encAlg;
    }

    public int getSaltLength() {
        return this.saltLength;
    }
}

