/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import java.util.Vector;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.crypto.Algorithm;
import org.mozilla.jss.crypto.IVParameterSpec;

public class EncryptionAlgorithm
extends Algorithm {
    private int blockSize;
    private Alg alg;
    private Mode mode;
    private Padding padding;
    private int keyStrength;
    private static Hashtable oidMap = new Hashtable();
    private static Hashtable nameMap = new Hashtable();
    private static Vector algList = new Vector();
    private static Class[] IVParameterSpecClasses = null;
    public static final EncryptionAlgorithm RC4;
    public static final EncryptionAlgorithm DES_ECB;
    public static final EncryptionAlgorithm DES_CBC;
    public static final EncryptionAlgorithm DES_CBC_PAD;
    public static final EncryptionAlgorithm DES3_ECB;
    public static final EncryptionAlgorithm DES3_CBC;
    public static final EncryptionAlgorithm DES3_CBC_PAD;
    public static final EncryptionAlgorithm RC2_CBC;
    public static final EncryptionAlgorithm RC2_CBC_PAD;
    public static final OBJECT_IDENTIFIER AES_ROOT_OID;
    public static final EncryptionAlgorithm AES_128_ECB;
    public static final EncryptionAlgorithm AES_128_CBC;
    public static final EncryptionAlgorithm AES_128_CBC_PAD;
    public static final EncryptionAlgorithm AES_192_ECB;
    public static final EncryptionAlgorithm AES_192_CBC;
    public static final EncryptionAlgorithm AES_192_CBC_PAD;
    public static final EncryptionAlgorithm AES_256_ECB;
    public static final EncryptionAlgorithm AES_256_CBC;
    public static final EncryptionAlgorithm AES_CBC_PAD;
    public static final EncryptionAlgorithm AES_256_CBC_PAD;

    private static String makeName(Alg alg2, Mode mode, Padding padding) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(alg2.toString());
        stringBuffer.append('/');
        stringBuffer.append(mode.toString());
        stringBuffer.append('/');
        stringBuffer.append(padding.toString());
        return stringBuffer.toString();
    }

    protected EncryptionAlgorithm(int n, Alg alg2, Mode mode, Padding padding, Class clazz, int n2, OBJECT_IDENTIFIER oBJECT_IDENTIFIER, int n3) {
        super(n, EncryptionAlgorithm.makeName(alg2, mode, padding), oBJECT_IDENTIFIER, clazz);
        this.alg = alg2;
        this.mode = mode;
        this.padding = padding;
        this.blockSize = n2;
        if (oBJECT_IDENTIFIER != null) {
            oidMap.put(oBJECT_IDENTIFIER, this);
        }
        if (this.name != null) {
            nameMap.put(this.name.toLowerCase(), this);
        }
        this.keyStrength = n3;
        algList.addElement(this);
    }

    protected EncryptionAlgorithm(int n, Alg alg2, Mode mode, Padding padding, Class[] classArray, int n2, OBJECT_IDENTIFIER oBJECT_IDENTIFIER, int n3) {
        super(n, EncryptionAlgorithm.makeName(alg2, mode, padding), oBJECT_IDENTIFIER, classArray);
        this.alg = alg2;
        this.mode = mode;
        this.padding = padding;
        this.blockSize = n2;
        if (oBJECT_IDENTIFIER != null) {
            oidMap.put(oBJECT_IDENTIFIER, this);
        }
        if (this.name != null) {
            nameMap.put(this.name.toLowerCase(), this);
        }
        this.keyStrength = n3;
        algList.addElement(this);
    }

    public Alg getAlg() {
        return this.alg;
    }

    public Mode getMode() {
        return this.mode;
    }

    public Padding getPadding() {
        return this.padding;
    }

    public int getKeyStrength() {
        return this.keyStrength;
    }

    public static EncryptionAlgorithm fromOID(OBJECT_IDENTIFIER oBJECT_IDENTIFIER) throws NoSuchAlgorithmException {
        Object v = oidMap.get(oBJECT_IDENTIFIER);
        if (v == null) {
            throw new NoSuchAlgorithmException("OID: " + oBJECT_IDENTIFIER.toString());
        }
        return (EncryptionAlgorithm)v;
    }

    public static EncryptionAlgorithm fromString(String string) throws NoSuchAlgorithmException {
        Object v = nameMap.get(string.toLowerCase());
        if (v == null) {
            throw new NoSuchAlgorithmException();
        }
        return (EncryptionAlgorithm)v;
    }

    public static EncryptionAlgorithm lookup(String string, String string2, String string3, int n) throws NoSuchAlgorithmException {
        int n2;
        int n3 = algList.size();
        Alg alg2 = Alg.fromString(string);
        Mode mode = Mode.fromString(string2);
        Padding padding = Padding.fromString(string3);
        for (n2 = 0; n2 < n3; ++n2) {
            EncryptionAlgorithm encryptionAlgorithm = (EncryptionAlgorithm)algList.elementAt(n2);
            if (encryptionAlgorithm.alg == alg2 && encryptionAlgorithm.mode == mode && encryptionAlgorithm.padding == padding && (encryptionAlgorithm.keyStrength == 0 || encryptionAlgorithm.keyStrength == n)) break;
        }
        if (n2 == n3) {
            throw new NoSuchAlgorithmException(string + "/" + string2 + "/" + string3 + " with key strength " + n + " not found");
        }
        return (EncryptionAlgorithm)algList.elementAt(n2);
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public boolean isPadded() {
        return !Padding.NONE.equals(this.padding);
    }

    public Padding getPaddingType() {
        return this.padding;
    }

    public native int getIVLength();

    static {
        IVParameterSpecClasses = new Class[2];
        EncryptionAlgorithm.IVParameterSpecClasses[0] = IVParameterSpec.class;
        EncryptionAlgorithm.IVParameterSpecClasses[1] = IvParameterSpec.class;
        RC4 = new EncryptionAlgorithm(8, Alg.RC4, Mode.NONE, Padding.NONE, (Class)null, 1, OBJECT_IDENTIFIER.RSA_CIPHER.subBranch(4L), 0);
        DES_ECB = new EncryptionAlgorithm(9, Alg.DES, Mode.ECB, Padding.NONE, (Class)null, 8, OBJECT_IDENTIFIER.ALGORITHM.subBranch(6L), 56);
        DES_CBC = new EncryptionAlgorithm(10, Alg.DES, Mode.CBC, Padding.NONE, IVParameterSpecClasses, 8, OBJECT_IDENTIFIER.ALGORITHM.subBranch(7L), 56);
        DES_CBC_PAD = new EncryptionAlgorithm(11, Alg.DES, Mode.CBC, Padding.PKCS5, IVParameterSpecClasses, 8, null, 56);
        DES3_ECB = new EncryptionAlgorithm(12, Alg.DESede, Mode.ECB, Padding.NONE, (Class)null, 8, null, 168);
        DES3_CBC = new EncryptionAlgorithm(13, Alg.DESede, Mode.CBC, Padding.NONE, IVParameterSpecClasses, 8, OBJECT_IDENTIFIER.RSA_CIPHER.subBranch(7L), 168);
        DES3_CBC_PAD = new EncryptionAlgorithm(14, Alg.DESede, Mode.CBC, Padding.PKCS5, IVParameterSpecClasses, 8, null, 168);
        RC2_CBC = new EncryptionAlgorithm(30, Alg.RC2, Mode.CBC, Padding.NONE, RC2ParameterSpec.class, 8, null, 0);
        RC2_CBC_PAD = new EncryptionAlgorithm(36, Alg.RC2, Mode.CBC, Padding.PKCS5, RC2ParameterSpec.class, 8, OBJECT_IDENTIFIER.RSA_CIPHER.subBranch(2L), 0);
        AES_ROOT_OID = new OBJECT_IDENTIFIER(new long[]{2L, 16L, 840L, 1L, 101L, 3L, 4L, 1L});
        AES_128_ECB = new EncryptionAlgorithm(33, Alg.AES, Mode.ECB, Padding.NONE, (Class)null, 16, AES_ROOT_OID.subBranch(1L), 128);
        AES_128_CBC = new EncryptionAlgorithm(34, Alg.AES, Mode.CBC, Padding.NONE, IVParameterSpecClasses, 16, AES_ROOT_OID.subBranch(2L), 128);
        AES_128_CBC_PAD = new EncryptionAlgorithm(35, Alg.AES, Mode.CBC, Padding.PKCS5, IVParameterSpecClasses, 16, null, 128);
        AES_192_ECB = new EncryptionAlgorithm(33, Alg.AES, Mode.ECB, Padding.NONE, (Class)null, 16, AES_ROOT_OID.subBranch(21L), 192);
        AES_192_CBC = new EncryptionAlgorithm(34, Alg.AES, Mode.CBC, Padding.NONE, IVParameterSpecClasses, 16, AES_ROOT_OID.subBranch(22L), 192);
        AES_192_CBC_PAD = new EncryptionAlgorithm(35, Alg.AES, Mode.CBC, Padding.PKCS5, IVParameterSpecClasses, 16, null, 192);
        AES_256_ECB = new EncryptionAlgorithm(33, Alg.AES, Mode.ECB, Padding.NONE, (Class)null, 16, AES_ROOT_OID.subBranch(41L), 256);
        AES_256_CBC = new EncryptionAlgorithm(34, Alg.AES, Mode.CBC, Padding.NONE, IVParameterSpecClasses, 16, AES_ROOT_OID.subBranch(42L), 256);
        AES_256_CBC_PAD = AES_CBC_PAD = new EncryptionAlgorithm(35, Alg.AES, Mode.CBC, Padding.PKCS5, IVParameterSpecClasses, 16, null, 256);
    }

    public static class Padding {
        private String name;
        private static Hashtable nameHash = new Hashtable();
        public static final Padding NONE = new Padding("NoPadding");
        public static final Padding PKCS5 = new Padding("PKCS5Padding");

        private Padding() {
        }

        private Padding(String string) {
            this.name = string;
            nameHash.put(string.toLowerCase(), this);
        }

        public String toString() {
            return this.name;
        }

        public static Padding fromString(String string) throws NoSuchAlgorithmException {
            Padding padding = (Padding)nameHash.get(string.toLowerCase());
            if (padding == null) {
                throw new NoSuchAlgorithmException("Unrecognized Padding type \"" + string + "\"");
            }
            return padding;
        }
    }

    public static class Alg {
        private String name;
        private static Hashtable nameHash = new Hashtable();
        public static final Alg RC4 = new Alg("RC4");
        public static final Alg DES = new Alg("DES");
        public static final Alg DESede = new Alg("DESede");
        public static final Alg AES = new Alg("AES");
        public static final Alg RC2 = new Alg("RC2");

        private Alg() {
        }

        private Alg(String string) {
            this.name = string;
            nameHash.put(string.toLowerCase(), this);
        }

        private static Alg fromString(String string) throws NoSuchAlgorithmException {
            Alg alg2 = (Alg)nameHash.get(string.toLowerCase());
            if (alg2 == null) {
                throw new NoSuchAlgorithmException("Unrecognized algorithm \"" + string + "\"");
            }
            return alg2;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Mode {
        private String name;
        private static Hashtable nameHash = new Hashtable();
        public static final Mode NONE = new Mode("NONE");
        public static final Mode ECB = new Mode("ECB");
        public static final Mode CBC = new Mode("CBC");

        private Mode() {
        }

        private Mode(String string) {
            this.name = string;
            nameHash.put(string.toLowerCase(), this);
        }

        public static Mode fromString(String string) throws NoSuchAlgorithmException {
            Mode mode = (Mode)nameHash.get(string.toLowerCase());
            if (mode == null) {
                throw new NoSuchAlgorithmException("Unrecognized mode \"" + string + "\"");
            }
            return mode;
        }

        public String toString() {
            return this.name;
        }
    }
}

