/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.keycert;

import com.netscape.management.client.keycert.CertBasicInfo;
import com.netscape.management.client.keycert.CertInfo;
import com.netscape.management.client.keycert.CipherEntry;
import com.netscape.management.client.keycert.KeyCertUtility;
import com.netscape.management.client.keycert.Message;
import com.netscape.management.client.util.Debug;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

class Response {
    String _response;
    String _cert = "";
    Vector _messages = new Vector();
    Vector _certList;
    CertInfo _certInfo;
    Hashtable _certInstInfo;
    Hashtable _ssl2Preference;
    Hashtable _ssl3Preference;
    String startCert = "-----BEGIN NEW CERTIFICATE REQUEST-----";
    String endCert = "-----END NEW CERTIFICATE REQUEST-----";
    String startCertList = "-----BEGIN CERT LIST-----";
    String endCertList = "-----END CERT LIST-----";
    String startCertInfo = "-----BEGIN CERTIFICATE INFO-----";
    String endCertInfo = "-----END CERTIFICATE INFO-----";
    String startCRLCertInfo = "-----BEGIN CRL INFO-----";
    String endCRLCertInfo = "-----END CRL INFO-----";
    String startCertInstInfo = "-----BEGIN CERTIFICATE INSTALL INFO-----";
    String endCertInstInfo = "-----END CERTIFICATE INSTALL INFO-----";
    String startCRLCertInstInfo = "-----BEGIN CRL INSTALL INFO-----";
    String endCRLCertInstInfo = "-----END CRL INSTALL INFO-----";
    boolean _fCert = false;
    boolean _fCertList = false;
    boolean _fCertInfo = false;
    boolean _fCertInstInfo = false;
    boolean _fsecurityDomestic = false;
    boolean _fsecurityFortezza = false;
    Vector familyList;
    Vector moduleList;

    void parseCertificate(String response) {
        if (response.indexOf(this.startCert) != -1) {
            this._cert = response.substring(response.indexOf(this.startCert), response.indexOf(this.endCert) + this.endCert.length());
            this._fCert = true;
        }
    }

    void parseCertificateList(String response) {
        if (response.indexOf(this.startCertList) != -1) {
            this._certList = new Vector();
            try {
                String line;
                BufferedReader stream = new BufferedReader(new StringReader(response));
                while (!stream.readLine().equals(this.startCertList)) {
                }
                while (!(line = stream.readLine()).equals(this.endCertList)) {
                    line = Response.urlDecode(line);
                    StringTokenizer token = new StringTokenizer(line, "=;\n", false);
                    Debug.print((String)line);
                    String certName = "";
                    String certType = "";
                    String certExpire = "";
                    try {
                        certName = token.nextToken();
                        certType = token.nextToken();
                        certExpire = token.nextToken();
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                    this._certList.addElement(new CertBasicInfo(certName, certType, certExpire));
                }
            }
            catch (IOException e) {
                Debug.println((String)e.getMessage());
            }
            this._fCertList = true;
        }
    }

    void parseCertificateInfo(String response) {
        if (response.indexOf(this.startCertInfo) != -1 || response.indexOf(this.startCRLCertInfo) != -1) {
            try {
                String line;
                BufferedReader stream = new BufferedReader(new StringReader(response));
                while (!(line = stream.readLine()).equals(this.startCertInfo) && !line.equals(this.startCRLCertInfo)) {
                }
                String issuer = "";
                String subject = "";
                String serialNumber = "";
                String version = "";
                String validFrom = "";
                String validTo = "";
                String fingerPrint = "";
                String trustCert = "";
                String certName = "";
                String certDeleted = "0";
                String certTitle = "";
                while (!(line = stream.readLine()).equals(this.endCertInfo) && !line.equals(this.endCRLCertInfo)) {
                    line = Response.urlDecode(line);
                    StringTokenizer token = new StringTokenizer(line, "=\n", false);
                    Debug.print((String)line);
                    try {
                        String keyWord = token.nextToken();
                        if (keyWord.equals("ISSUER")) {
                            issuer = KeyCertUtility.replace(token.nextToken(), "<br>", "\n");
                            continue;
                        }
                        if (keyWord.equals("SUBJECT")) {
                            subject = KeyCertUtility.replace(token.nextToken(), "<br>", "\n");
                            continue;
                        }
                        if (keyWord.equals("SERIALNUMBER")) {
                            serialNumber = token.nextToken();
                            continue;
                        }
                        if (keyWord.equals("VERSION")) {
                            version = token.nextToken();
                            continue;
                        }
                        if (keyWord.equals("NOTBEFORE")) {
                            validFrom = token.nextToken();
                            continue;
                        }
                        if (keyWord.equals("NOTAFTER")) {
                            validTo = token.nextToken();
                            continue;
                        }
                        if (keyWord.equals("FINGERPRINT")) {
                            fingerPrint = token.nextToken();
                            continue;
                        }
                        if (keyWord.equals("TRUSTED")) {
                            trustCert = token.nextToken();
                            continue;
                        }
                        if (keyWord.equals("CERTNAME")) {
                            certName = token.nextToken();
                            continue;
                        }
                        if (keyWord.equals("CERTDELETED")) {
                            certDeleted = token.nextToken();
                            continue;
                        }
                        if (!keyWord.equals("CERTTITLE")) continue;
                        certTitle = token.nextToken();
                    }
                    catch (NoSuchElementException noToken) {
                        Debug.print((String)noToken.getMessage());
                    }
                }
                this._certInfo = new CertInfo(certName, issuer, subject, serialNumber, version, validFrom, validTo, fingerPrint, trustCert, certDeleted, certTitle);
            }
            catch (IOException e) {
                Debug.println((String)e.getMessage());
            }
            this._fCertInfo = true;
        }
    }

    void parseCertificateInstInfo(String response) {
        if (response.indexOf(this.startCertInstInfo) != -1 || response.indexOf(this.startCRLCertInstInfo) != -1) {
            this._certInstInfo = new Hashtable();
            try {
                String line;
                BufferedReader stream = new BufferedReader(new StringReader(response));
                while (!(line = stream.readLine()).equals(this.startCertInstInfo) && !line.equals(this.startCRLCertInstInfo)) {
                }
                while (!(line = stream.readLine()).equals(this.endCertInstInfo) && !line.equals(this.endCRLCertInstInfo)) {
                    StringTokenizer token = new StringTokenizer(line, "=\n", false);
                    Debug.print((String)line);
                    try {
                        String key = token.nextToken();
                        String val = token.nextToken();
                        this._certInstInfo.put(key, val);
                    }
                    catch (NoSuchElementException noToken) {
                        Debug.print((String)noToken.getMessage());
                    }
                }
            }
            catch (IOException e) {
                Debug.println((String)e.getMessage());
            }
            this._fCertInstInfo = true;
        }
    }

    public static String urlDecode(String urlString) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(urlString.length());
        int i = 0;
        while (i < urlString.length()) {
            char c = urlString.charAt(i);
            if (c == '+') {
                out.write(32);
            } else if (c == '%') {
                int c1 = Character.digit(urlString.charAt(++i), 16);
                int c2 = Character.digit(urlString.charAt(++i), 16);
                out.write((char)(c1 * 16 + c2));
            } else {
                out.write(c);
            }
            ++i;
        }
        return out.toString();
    }

    public Vector parseFamilyList(String response) {
        this.familyList = new Vector();
        this._fsecurityFortezza = false;
        this._fsecurityDomestic = false;
        try {
            BufferedReader stream = new BufferedReader(new StringReader(response));
            String line = null;
            while (!(line = stream.readLine()).startsWith("NULL")) {
                String cipherName = line.substring(0, line.indexOf("="));
                StringTokenizer st = new StringTokenizer(line.substring(line.indexOf("=") + 1, line.length()), ",\n", false);
                Vector<String> tokenList = new Vector<String>();
                Hashtable<String, Object> tokenCertList = new Hashtable<String, Object>();
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    tokenList.addElement(token);
                    tokenCertList.put(token, "");
                }
                Enumeration e = tokenList.elements();
                while (e.hasMoreElements()) {
                    String token = (String)e.nextElement();
                    line = stream.readLine();
                    String certListString = line.substring((String.valueOf(token) + "-certs=").length(), line.length());
                    StringTokenizer certNames = new StringTokenizer(certListString, ",\n", false);
                    Vector<String> certList = new Vector<String>();
                    while (certNames.hasMoreTokens()) {
                        certList.addElement(certNames.nextToken());
                    }
                    tokenCertList.put(token, certList);
                }
                this.familyList.addElement(new CipherEntry(cipherName, tokenCertList));
            }
            line = stream.readLine();
            if (line.startsWith("security")) {
                if (line.endsWith("fortezza")) {
                    this._fsecurityFortezza = true;
                    this._fsecurityDomestic = true;
                }
                if (line.endsWith("domestic")) {
                    this._fsecurityDomestic = true;
                }
            }
        }
        catch (Exception e) {
            Debug.println((String)("com.netscape.management.client.keycert.response:" + e.toString()));
        }
        return this.familyList;
    }

    public Vector parseModuleList(String response) {
        this.moduleList = new Vector();
        try {
            BufferedReader stream = new BufferedReader(new StringReader(response));
            String line = stream.readLine();
            StringTokenizer st = new StringTokenizer(line.substring(line.indexOf("=") + 1, line.length()), ",\n", false);
            while (st.hasMoreTokens()) {
                this.moduleList.addElement(st.nextToken());
            }
        }
        catch (Exception exception) {}
        return this.moduleList;
    }

    public Response(String response) {
        if (response == null) {
            return;
        }
        this._response = response;
        int beginIndex = 0;
        int endIndex = 0;
        while ((endIndex = response.indexOf("NMC_Status:", (beginIndex = response.indexOf("NMC_Status:", endIndex)) + "NMC_Status:".length())) != -1 || beginIndex != -1) {
            if (endIndex != -1) {
                this._messages.addElement(new Message(KeyCertUtility.replace(response.substring(beginIndex, endIndex), "\r", "")));
                continue;
            }
            this._messages.addElement(new Message(KeyCertUtility.replace(response.substring(beginIndex, response.length()), "\r", "")));
            break;
        }
    }

    public Vector getFamilyList() {
        return this.parseFamilyList(this._response);
    }

    public Vector getModuleList() {
        return this.parseModuleList(this._response);
    }

    public boolean isSecurityDomestic() {
        return this._fsecurityDomestic;
    }

    public boolean isSecurityFortezza() {
        return this._fsecurityFortezza;
    }

    public boolean hasCert() {
        this.parseCertificate(this._response);
        return this._fCert;
    }

    public boolean hasMessage() {
        return this._messages.size() > 0;
    }

    public boolean hasCertList() {
        this.parseCertificateList(this._response);
        return this._fCertList;
    }

    public boolean hasCertInfo() {
        this.parseCertificateInfo(this._response);
        return this._fCertInfo;
    }

    public boolean hasCertInstInfo() {
        this.parseCertificateInstInfo(this._response);
        return this._fCertInstInfo;
    }

    public String getCert() {
        return this._fCert ? this._cert : "";
    }

    public Vector getMessages() {
        return this._messages;
    }

    public Vector getCertList() {
        return this._fCertList ? this._certList : new Vector();
    }

    public CertInfo getCertInfo() {
        return this._certInfo;
    }

    public Hashtable getCertInstInfo() {
        return this._certInstInfo;
    }

    public String getServerResponse() {
        return this._response;
    }
}

