/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cimom.adapters.provider.jni;

import com.sun.wbem.utility.log.LogUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMProviderException;
import javax.wbem.client.Debug;
import javax.wbem.client.ProviderCIMOMHandle;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.CIMAssociatorProvider;
import javax.wbem.provider.CIMInstanceProvider;
import javax.wbem.provider.CIMMethodProvider;
import javax.wbem.provider.EventProvider;
import javax.wbem.provider.PropertyProvider;
import javax.wbem.query.NonJoinExp;
import javax.wbem.query.QueryExp;
import javax.wbem.query.SelectExp;
import javax.wbem.query.SelectList;

public class SolarisNative
implements CIMInstanceProvider,
PropertyProvider,
CIMMethodProvider,
EventProvider,
Authorizable,
CIMAssociatorProvider {
    private ProviderCIMOMHandle cimomhandle = null;
    private String mCimClassName = null;
    private String mLibName = null;
    private int mProviderFlags = 0;
    public static final long TIMEOUT = 60000L;
    private static int mRequestID = 0;
    private static Map queuedResults = Collections.synchronizedMap(new HashMap());
    private static final String nativelib = "SolarisNative";
    private static Exception loadLibraryError = null;

    private String getLibName() {
        return this.mLibName;
    }

    private String getCimClassName() {
        return this.mCimClassName;
    }

    private void writeLogMessage(String string, String string2) {
        Debug.trace1((String)("" + string2));
        try {
            LogUtil logUtil = LogUtil.getInstance((CIMOMHandle)this.cimomhandle);
            logUtil.writeLog("JNIAdapter:SolarisNative", string, string2, null, this.getCimClassName(), true, 2, 2, null);
        }
        catch (CIMException cIMException) {
            Debug.trace1((String)"Unable to log msg", (Throwable)cIMException);
        }
    }

    private synchronized int getRequestID() {
        if (mRequestID < 0) {
            mRequestID = 0;
        }
        return mRequestID++;
    }

    private static final String[] getPropertyNames(Vector vector) {
        int n = 0;
        String[] stringArray = new String[vector.size()];
        Iterator iterator = vector.iterator();
        Debug.trace3((String)"Determining the names of the properties returned");
        while (iterator.hasNext()) {
            CIMProperty cIMProperty = (CIMProperty)iterator.next();
            if (cIMProperty != null) {
                stringArray[n] = cIMProperty.getName();
            }
            ++n;
        }
        return stringArray;
    }

    private final CIMInstance filterInstance(CIMInstance cIMInstance, boolean bl, boolean bl2, boolean bl3, boolean bl4, String[] stringArray, CIMClass cIMClass) throws CIMException {
        CIMInstance cIMInstance2 = null;
        if (cIMInstance == null) {
            return null;
        }
        Vector vector = cIMInstance.getProperties();
        if (cIMClass == null) {
            cIMInstance2 = cIMInstance;
        } else {
            cIMInstance2 = cIMClass.newInstance();
            cIMInstance2.updatePropertyValues(vector);
        }
        if (bl) {
            cIMInstance2 = cIMInstance2.localElements();
        }
        String[] stringArray2 = null;
        stringArray2 = stringArray == null && bl4 ? SolarisNative.getPropertyNames(vector) : stringArray;
        return cIMInstance2.filterProperties(stringArray2, bl2, bl3);
    }

    private final CIMInstance[] convertList2Instance(List list, boolean bl, boolean bl2, boolean bl3, boolean bl4, String[] stringArray, CIMClass cIMClass) throws CIMException {
        int n = list.size();
        CIMInstance[] cIMInstanceArray = list.toArray(new CIMInstance[n]);
        CIMInstance[] cIMInstanceArray2 = new CIMInstance[n];
        String[] stringArray2 = stringArray;
        boolean bl5 = bl4;
        int n2 = 0;
        while (n2 < n) {
            cIMInstanceArray2[n2] = this.filterInstance(cIMInstanceArray[n2], bl, bl2, bl3, bl5, stringArray2, cIMClass);
            if (stringArray2 == null && bl5 && cIMInstanceArray2[n2] != null) {
                stringArray2 = SolarisNative.getPropertyNames(cIMInstanceArray2[n2].getProperties());
                bl5 = false;
            }
            ++n2;
        }
        return cIMInstanceArray2;
    }

    public SolarisNative(String string, String string2) {
        this.mCimClassName = string2.toLowerCase();
        this.mLibName = string;
    }

    public static void setQueuedResultClass(int n, Object object) {
        ResultClass resultClass = (ResultClass)queuedResults.get(new Integer(n));
        if (resultClass != null) {
            resultClass.setResult(object);
        }
    }

    int getProviderFlags() {
        return this.mProviderFlags;
    }

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        if (loadLibraryError != null) {
            throw new CIMException("CIM_ERR_FAILED", (Object)loadLibraryError);
        }
        this.cimomhandle = (ProviderCIMOMHandle)cIMOMHandle;
        this.initNative(this.cimomhandle);
        this.mProviderFlags = this.getProviderFlags(this.getCimClassName(), this.getLibName());
    }

    public void cleanup() throws CIMException {
        String string = this.getCimClassName();
        if (string == null) {
            throw new CIMException("CIM_ERR_FAILED", (Object)new NullPointerException("No CIM Class available"));
        }
        this.shutdownProvider(string);
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        ContextHelper contextHelper = new ContextHelper();
        Debug.trace2((String)("Calling Native method, request ID: " + contextHelper.getKey()));
        this.createInstance(contextHelper.getProviderContext(), this.getLibName(), cIMObjectPath, cIMInstance);
        Debug.trace2((String)"Native method returned");
        contextHelper.waitForRemoteProvider(60000L);
        Object object = contextHelper.getResult();
        if (object == null) {
            return null;
        }
        if (object instanceof CIMObjectPath) {
            return (CIMObjectPath)object;
        }
        if (object instanceof CIMException) {
            Debug.trace2((String)"Remote provider threw a CIMException", (Throwable)((CIMException)((Object)object)));
            throw (CIMException)((Object)object);
        }
        Debug.trace1((String)("Invalid type returned from provider: " + object.getClass().getName()));
        throw new CIMProviderException("CIM_ERR_FAILED");
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        ContextHelper contextHelper = new ContextHelper();
        Debug.trace2((String)("Calling Native method, request ID: " + contextHelper.getKey()));
        this.deleteInstance(contextHelper.getProviderContext(), this.getLibName(), cIMObjectPath);
        Debug.trace2((String)"Native method returned");
        contextHelper.waitForRemoteProvider(60000L);
        Object object = contextHelper.getResult();
        if (object != null) {
            if (object instanceof CIMException) {
                Debug.trace2((String)"Remote provider thru a CIMException", (Throwable)((Exception)object));
                throw (CIMException)((Object)object);
            }
            Debug.trace1((String)("Invalid type returned from provider: " + object.getClass().getName()));
            throw new CIMProviderException("CIM_ERR_FAILED");
        }
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance, boolean bl, String[] stringArray) throws CIMException {
        ContextHelper contextHelper = new ContextHelper();
        Debug.trace2((String)("Calling Native method, request ID: " + contextHelper.getKey()));
        this.setInstance(contextHelper.getProviderContext(), this.getLibName(), cIMObjectPath, cIMInstance, stringArray);
        Debug.trace2((String)"Native method returned");
        contextHelper.waitForRemoteProvider(60000L);
        Object object = contextHelper.getResult();
        if (object != null) {
            if (object instanceof CIMException) {
                Debug.trace2((String)"Remote provider thru a CIMException", (Throwable)((Exception)object));
                throw (CIMException)((Object)object);
            }
            Debug.trace1((String)("Invalid type returned from provider: " + object.getClass().getName()));
            throw new CIMProviderException("CIM_ERR_FAILED");
        }
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        ContextHelper contextHelper = new ContextHelper();
        Debug.trace2((String)("Calling Native method, request ID: " + contextHelper.getKey()));
        this.enumInstanceNames(contextHelper.getProviderContext(), this.getLibName(), cIMObjectPath);
        Debug.trace2((String)"Native method returned");
        contextHelper.waitForRemoteProvider(60000L);
        Object object = contextHelper.getResult();
        if (object == null) {
            return null;
        }
        if (object instanceof CIMException) {
            Debug.trace2((String)"Remote provider thru a CIMException", (Throwable)((CIMException)((Object)object)));
            throw (CIMException)((Object)object);
        }
        if (object instanceof List) {
            List list = (List)object;
            CIMObjectPath[] cIMObjectPathArray = new CIMObjectPath[list.size()];
            cIMObjectPathArray = list.toArray(cIMObjectPathArray);
            return cIMObjectPathArray;
        }
        Debug.trace1((String)("Invalid type returned from provider: " + object.getClass().getName()));
        throw new CIMProviderException("CIM_ERR_FAILED");
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        ContextHelper contextHelper = new ContextHelper();
        Debug.trace2((String)("Calling Native method, request ID: " + contextHelper.getKey()));
        this.enumInstances(contextHelper.getProviderContext(), this.getLibName(), cIMObjectPath);
        Debug.trace2((String)"Native method returned");
        contextHelper.waitForRemoteProvider(60000L);
        Object object = contextHelper.getResult();
        if (object == null) {
            Debug.trace3((String)"result is null!");
            return null;
        }
        if (object instanceof CIMException) {
            Debug.trace2((String)"Remote provider thru a CIMException", (Throwable)((CIMException)((Object)object)));
            throw (CIMException)((Object)object);
        }
        if (object instanceof List) {
            return this.convertList2Instance((List)object, bl, bl2, bl3, false, stringArray, cIMClass);
        }
        Debug.trace1((String)("Invalid type returned from provider: " + object.getClass().getName()));
        throw new CIMProviderException("CIM_ERR_FAILED");
    }

    public CIMInstance[] execQuery(CIMObjectPath cIMObjectPath, String string, String string2, CIMClass cIMClass) throws CIMException {
        Object object;
        ContextHelper contextHelper = new ContextHelper();
        SelectList selectList = null;
        NonJoinExp nonJoinExp = null;
        QueryExp queryExp = null;
        try {
            object = new SelectExp(string);
            selectList = object.getSelectList();
            if (selectList == null) {
                Debug.trace3((String)"SelectList is null, aborting...");
                throw new NullPointerException("SelectList is null");
            }
            nonJoinExp = (NonJoinExp)object.getFromClause();
            if (nonJoinExp == null) {
                Debug.trace3((String)"from clause is null, aborting...");
                throw new NullPointerException("from clause is null");
            }
            queryExp = object.getWhereClause();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.toString());
        }
        Debug.trace2((String)("Calling Native method, request ID: " + contextHelper.getKey()));
        this.execQuery(contextHelper.getProviderContext(), this.getLibName(), cIMObjectPath, selectList.toString(), nonJoinExp.toString(), queryExp == null ? null : queryExp.toString(), string2);
        Debug.trace2((String)"Native method returned");
        contextHelper.waitForRemoteProvider(60000L);
        object = contextHelper.getResult();
        if (object == null) {
            return null;
        }
        if (object instanceof CIMException) {
            Debug.trace2((String)"Remote provider thru a CIMException", (Throwable)((CIMException)((Object)object)));
            throw (CIMException)((Object)object);
        }
        if (object instanceof List) {
            return this.convertList2Instance((List)object, false, true, true, true, null, cIMClass);
        }
        Debug.trace1((String)("Invalid type returned from provider: " + object.getClass().getName()));
        throw new CIMProviderException("CIM_ERR_FAILED");
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        ContextHelper contextHelper = new ContextHelper();
        Debug.trace2((String)("Calling Native method, request ID: " + contextHelper.getKey()));
        this.getInstance(contextHelper.getProviderContext(), this.getLibName(), cIMObjectPath);
        Debug.trace2((String)"Native method returned");
        contextHelper.waitForRemoteProvider(60000L);
        Object object = contextHelper.getResult();
        if (object == null) {
            return null;
        }
        if (object instanceof CIMException) {
            Debug.trace2((String)"Remote provider thru a CIMException", (Throwable)((CIMException)((Object)object)));
            throw (CIMException)((Object)object);
        }
        if (object instanceof CIMInstance) {
            return this.filterInstance((CIMInstance)object, bl, bl2, bl3, false, stringArray, cIMClass);
        }
        Debug.trace1((String)("Invalid type returned from provider: " + object.getClass().getName()));
        throw new CIMProviderException("CIM_ERR_FAILED");
    }

    public CIMValue getPropertyValue(CIMObjectPath cIMObjectPath, String string, String string2) throws CIMException {
        ContextHelper contextHelper = new ContextHelper();
        Debug.trace2((String)("Calling Native method, request ID: " + contextHelper.getKey()));
        this.getProperty(contextHelper.getProviderContext(), this.getLibName(), cIMObjectPath, string2);
        Debug.trace2((String)"Native method returned");
        contextHelper.waitForRemoteProvider(60000L);
        Object object = contextHelper.getResult();
        if (object == null) {
            return null;
        }
        if (object instanceof CIMException) {
            Debug.trace2((String)"Remote provider thru a CIMException", (Throwable)((CIMException)((Object)object)));
            throw (CIMException)((Object)object);
        }
        if (object instanceof CIMProperty) {
            CIMProperty cIMProperty = (CIMProperty)object;
            return cIMProperty.getValue();
        }
        Debug.trace1((String)("Invalid type returned from provider: " + object.getClass().getName()));
        throw new CIMProviderException("CIM_ERR_FAILED");
    }

    public void setPropertyValue(CIMObjectPath cIMObjectPath, String string, String string2, CIMValue cIMValue) throws CIMException {
        if (string2 == null) {
            throw new CIMException("CIM_ERR_FAILED");
        }
        ContextHelper contextHelper = new ContextHelper();
        Debug.trace2((String)("Calling Native method, request ID: " + contextHelper.getKey()));
        this.setProperty(contextHelper.getProviderContext(), this.getLibName(), cIMObjectPath, string2, cIMValue);
        Debug.trace2((String)"Native method returned");
        contextHelper.waitForRemoteProvider(60000L);
        Object object = contextHelper.getResult();
        if (object == null) {
            return;
        }
        if (object instanceof CIMException) {
            Debug.trace2((String)"Remote provider thru a CIMException", (Throwable)((CIMException)((Object)object)));
            throw (CIMException)((Object)object);
        }
        Debug.trace1((String)("Invalid type returned from provider: " + object.getClass().getName()));
        throw new CIMProviderException("CIM_ERR_FAILED");
    }

    public CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, CIMArgument[] cIMArgumentArray, CIMArgument[] cIMArgumentArray2) throws CIMException {
        if (string == null) {
            Debug.trace2((String)"method name is null");
            return null;
        }
        ContextHelper contextHelper = new ContextHelper();
        Debug.trace2((String)("Calling Native method, request ID: " + contextHelper.getKey()));
        this.invokeMethod(contextHelper.getProviderContext(), this.getLibName(), cIMObjectPath, string, cIMArgumentArray);
        Debug.trace2((String)"Native method returned");
        contextHelper.waitForRemoteProvider(60000L);
        Object object = contextHelper.getResult();
        if (object == null) {
            Debug.trace3((String)"Provider returned null");
            return null;
        }
        if (object instanceof CIMException) {
            Debug.trace2((String)"Remote provider thru a CIMException", (Throwable)((CIMException)((Object)object)));
            throw (CIMException)((Object)object);
        }
        if (object instanceof CIMValue) {
            CIMValue cIMValue = (CIMValue)object;
            return cIMValue;
        }
        if (object instanceof List) {
            List list = (List)object;
            CIMArgument cIMArgument = (CIMArgument)list.remove(0);
            CIMValue cIMValue = cIMArgument.getValue();
            if (cIMArgumentArray2 != null) {
                CIMArgument[] cIMArgumentArray3 = list.toArray(new CIMArgument[list.size()]);
                try {
                    System.arraycopy(cIMArgumentArray3, 0, cIMArgumentArray2, 0, cIMArgumentArray2.length);
                }
                catch (Exception exception) {
                    Debug.trace1((String)"Exception occurred while copying array", (Throwable)exception);
                    throw new CIMException("CIM_ERR_FAILED", (Object)exception);
                }
            }
            return cIMValue;
        }
        Debug.trace1((String)("Invalid type returned from provider: " + object.getClass().getName()));
        throw new CIMProviderException("CIM_ERR_FAILED");
    }

    public void activateFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        ContextHelper contextHelper = new ContextHelper();
        Debug.trace2((String)("Calling Native method, request ID: " + contextHelper.getKey()));
        this.activateFilter(contextHelper.getProviderContext(), this.getLibName(), selectExp.toString(), string, cIMObjectPath, bl);
        Debug.trace2((String)"Native method returned");
        contextHelper.waitForRemoteProvider(60000L);
        Object object = contextHelper.getResult();
        if (object != null) {
            if (object instanceof CIMException) {
                Debug.trace2((String)"Remote provider thru a CIMException", (Throwable)((Exception)object));
                throw (CIMException)((Object)object);
            }
            Debug.trace1((String)("Invalid type returned from provider: " + object.getClass().getName()));
            throw new CIMProviderException("CIM_ERR_FAILED");
        }
    }

    public void authorizeFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, String string2) throws CIMException {
        ContextHelper contextHelper = new ContextHelper();
        Debug.trace2((String)("Calling Native method, request ID: " + contextHelper.getKey()));
        this.authorizeFilter(contextHelper.getProviderContext(), this.getLibName(), selectExp.toString(), string, cIMObjectPath, string2);
        Debug.trace2((String)"Native method returned");
        contextHelper.waitForRemoteProvider(60000L);
        Object object = contextHelper.getResult();
        if (object != null) {
            if (object instanceof CIMException) {
                Debug.trace2((String)"Remote provider thru a CIMException", (Throwable)((Exception)object));
                throw (CIMException)((Object)object);
            }
            Debug.trace1((String)("Invalid type returned from provider: " + object.getClass().getName()));
            throw new CIMProviderException("CIM_ERR_FAILED");
        }
    }

    public void deActivateFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        ContextHelper contextHelper = new ContextHelper();
        Debug.trace2((String)("Calling Native method, request ID: " + contextHelper.getKey()));
        this.deActivateFilter(contextHelper.getProviderContext(), this.getLibName(), selectExp.toString(), string, cIMObjectPath, bl);
        Debug.trace2((String)"Native method returned");
        contextHelper.waitForRemoteProvider(60000L);
        Object object = contextHelper.getResult();
        if (object != null) {
            if (object instanceof CIMException) {
                Debug.trace2((String)"Remote provider thru a CIMException", (Throwable)((Exception)object));
                throw (CIMException)((Object)object);
            }
            Debug.trace1((String)("Invalid type returned from provider: " + object.getClass().getName()));
            throw new CIMProviderException("CIM_ERR_FAILED");
        }
    }

    public boolean mustPoll(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath) throws CIMException {
        ContextHelper contextHelper = new ContextHelper();
        Debug.trace2((String)("Calling Native method, request ID: " + contextHelper.getKey()));
        this.mustPoll(contextHelper.getProviderContext(), this.getLibName(), selectExp.toString(), string, cIMObjectPath);
        Debug.trace2((String)"Native method returned");
        contextHelper.waitForRemoteProvider(60000L);
        Object object = contextHelper.getResult();
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof CIMException) {
            Debug.trace2((String)"Remote provider thru a CIMException", (Throwable)((Exception)object));
            throw (CIMException)((Object)object);
        }
        Debug.trace1((String)("Invalid type returned from provider: " + object.getClass().getName()));
        throw new CIMProviderException("CIM_ERR_FAILED");
    }

    public CIMObjectPath[] associatorNames(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string, String string2, String string3) throws CIMException {
        ContextHelper contextHelper = new ContextHelper();
        Debug.trace2((String)("Calling Native method, request ID: " + contextHelper.getKey()));
        this.associatorNames(contextHelper.getProviderContext(), this.getLibName(), cIMObjectPath, cIMObjectPath2, string, string2, string3);
        Debug.trace2((String)"Native method returned");
        contextHelper.waitForRemoteProvider(60000L);
        Object object = contextHelper.getResult();
        if (object == null) {
            return null;
        }
        if (object instanceof CIMException) {
            Debug.trace2((String)"Remote provider thru a CIMException", (Throwable)((CIMException)((Object)object)));
            throw (CIMException)((Object)object);
        }
        if (object instanceof List) {
            List list = (List)object;
            CIMObjectPath[] cIMObjectPathArray = new CIMObjectPath[list.size()];
            cIMObjectPathArray = list.toArray(cIMObjectPathArray);
            return cIMObjectPathArray;
        }
        Debug.trace1((String)("Invalid type returned from provider: " + object.getClass().getName()));
        throw new CIMProviderException("CIM_ERR_FAILED");
    }

    public CIMInstance[] associators(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string, String string2, String string3, boolean bl, boolean bl2, String[] stringArray) throws CIMException {
        ContextHelper contextHelper = new ContextHelper();
        Debug.trace2((String)("Calling Native method, request ID: " + contextHelper.getKey()));
        this.associators(contextHelper.getProviderContext(), this.getLibName(), cIMObjectPath, cIMObjectPath2, string, string2, string3);
        Debug.trace2((String)"Native method returned");
        contextHelper.waitForRemoteProvider(60000L);
        Object object = contextHelper.getResult();
        if (object == null) {
            Debug.trace3((String)"result is null!");
            return null;
        }
        if (object instanceof CIMException) {
            Debug.trace2((String)"Remote provider thru a CIMException", (Throwable)((CIMException)((Object)object)));
            throw (CIMException)((Object)object);
        }
        if (object instanceof List) {
            return this.convertList2Instance((List)object, false, bl, bl2, false, stringArray, null);
        }
        Debug.trace1((String)("Invalid type returned from provider: " + object.getClass().getName()));
        throw new CIMProviderException("CIM_ERR_FAILED");
    }

    public CIMObjectPath[] referenceNames(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string) throws CIMException {
        ContextHelper contextHelper = new ContextHelper();
        Debug.trace2((String)("Calling Native method, request ID: " + contextHelper.getKey()));
        this.referenceNames(contextHelper.getProviderContext(), this.getLibName(), cIMObjectPath, cIMObjectPath2, string);
        Debug.trace2((String)"Native method returned");
        contextHelper.waitForRemoteProvider(60000L);
        Object object = contextHelper.getResult();
        if (object == null) {
            return null;
        }
        if (object instanceof CIMException) {
            Debug.trace2((String)"Remote provider thru a CIMException", (Throwable)((CIMException)((Object)object)));
            throw (CIMException)((Object)object);
        }
        if (object instanceof List) {
            List list = (List)object;
            CIMObjectPath[] cIMObjectPathArray = new CIMObjectPath[list.size()];
            cIMObjectPathArray = list.toArray(cIMObjectPathArray);
            return cIMObjectPathArray;
        }
        Debug.trace1((String)("Invalid type returned from provider: " + object.getClass().getName()));
        throw new CIMProviderException("CIM_ERR_FAILED");
    }

    public CIMInstance[] references(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string, boolean bl, boolean bl2, String[] stringArray) throws CIMException {
        ContextHelper contextHelper = new ContextHelper();
        Debug.trace2((String)("Calling Native method, request ID: " + contextHelper.getKey()));
        this.references(contextHelper.getProviderContext(), this.getLibName(), cIMObjectPath, cIMObjectPath2, string);
        Debug.trace2((String)"Native method returned");
        contextHelper.waitForRemoteProvider(60000L);
        Object object = contextHelper.getResult();
        if (object == null) {
            Debug.trace3((String)"result is null!");
            return null;
        }
        if (object instanceof CIMException) {
            Debug.trace2((String)"Remote provider thru a CIMException", (Throwable)((CIMException)((Object)object)));
            throw (CIMException)((Object)object);
        }
        if (object instanceof List) {
            return this.convertList2Instance((List)object, false, bl, bl2, false, stringArray, null);
        }
        Debug.trace1((String)("Invalid type returned from provider: " + object.getClass().getName()));
        throw new CIMProviderException("CIM_ERR_FAILED");
    }

    public native void initNative(ProviderCIMOMHandle var1);

    public native void createInstance(ProviderContext var1, String var2, CIMObjectPath var3, CIMInstance var4);

    public native void deleteInstance(ProviderContext var1, String var2, CIMObjectPath var3);

    public native void enumInstanceNames(ProviderContext var1, String var2, CIMObjectPath var3);

    public native void enumInstances(ProviderContext var1, String var2, CIMObjectPath var3);

    public native void getInstance(ProviderContext var1, String var2, CIMObjectPath var3);

    public native void getProperty(ProviderContext var1, String var2, CIMObjectPath var3, String var4);

    private native void setInstance(ProviderContext var1, String var2, CIMObjectPath var3, CIMInstance var4, String[] var5);

    private native void setProperty(ProviderContext var1, String var2, CIMObjectPath var3, String var4, CIMValue var5);

    public native void invokeMethod(ProviderContext var1, String var2, CIMObjectPath var3, String var4, CIMArgument[] var5);

    public native void execQuery(ProviderContext var1, String var2, CIMObjectPath var3, String var4, String var5, String var6, String var7);

    public native void activateFilter(ProviderContext var1, String var2, String var3, String var4, CIMObjectPath var5, boolean var6);

    public native void deActivateFilter(ProviderContext var1, String var2, String var3, String var4, CIMObjectPath var5, boolean var6);

    public native void authorizeFilter(ProviderContext var1, String var2, String var3, String var4, CIMObjectPath var5, String var6);

    public native void mustPoll(ProviderContext var1, String var2, String var3, String var4, CIMObjectPath var5);

    public native void associatorNames(ProviderContext var1, String var2, CIMObjectPath var3, CIMObjectPath var4, String var5, String var6, String var7);

    public native void associators(ProviderContext var1, String var2, CIMObjectPath var3, CIMObjectPath var4, String var5, String var6, String var7);

    public native void referenceNames(ProviderContext var1, String var2, CIMObjectPath var3, CIMObjectPath var4, String var5);

    public native void references(ProviderContext var1, String var2, CIMObjectPath var3, CIMObjectPath var4, String var5);

    public native void shutdownProvider(String var1);

    private native boolean isDoorRunning(String var1);

    private native int getProviderFlags(String var1, String var2);

    static {
        try {
            System.loadLibrary(nativelib);
        }
        catch (Exception exception) {
            Debug.trace1((String)"Unable to load SolarisNative", (Throwable)exception);
            loadLibraryError = exception;
        }
    }

    private final class ContextHelper {
        private ProviderContext ctx = this.createProviderContext();
        private Integer key = new Integer(this.ctx.getRequestId());
        private ResultClass result = new ResultClass();

        public ContextHelper() {
            queuedResults.put(this.key, this.result);
        }

        private ProviderContext createProviderContext() {
            ProviderContext providerContext = new ProviderContext();
            providerContext.setUserName(SolarisNative.this.cimomhandle.getCurrentUser());
            providerContext.setRoleName(SolarisNative.this.cimomhandle.getCurrentRole());
            providerContext.setHostName(SolarisNative.this.cimomhandle.getCurrentClientHost());
            providerContext.setAuditId(SolarisNative.this.cimomhandle.getCurrentAuditId());
            providerContext.setRequestId(SolarisNative.this.getRequestID());
            return providerContext;
        }

        public ProviderContext getProviderContext() {
            return this.ctx;
        }

        public Integer getKey() {
            return this.key;
        }

        public ResultClass getResultClass() {
            return this.result;
        }

        public Object getResult() {
            if (this.result != null) {
                return this.result.getResult();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void waitForRemoteProvider(long l) throws CIMException {
            try {
                try {
                    ResultClass resultClass = this.result;
                    synchronized (resultClass) {
                        Debug.trace2((String)"Waiting for remote provider to process request");
                        if (this.result.getTimedOut()) {
                            this.result.wait(l);
                        }
                        Debug.trace2((String)"Remote process has completed, or timed out");
                    }
                }
                catch (InterruptedException interruptedException) {
                    Debug.trace2((String)"Wait was interrupted", (Throwable)interruptedException);
                    throw new CIMProviderException("CIM_ERR_FAILED", (Object)interruptedException);
                }
                Object var6_4 = null;
                queuedResults.remove(this.key);
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                queuedResults.remove(this.key);
                if (!this.result.getTimedOut()) {
                    throw throwable;
                }
                Debug.trace2((String)("Remote process timed out for request " + this.getKey()));
                if (SolarisNative.this.isDoorRunning(SolarisNative.this.getCimClassName())) {
                    throw new CIMProviderException("TIMED_OUT");
                }
                SolarisNative.this.writeLogMessage("Remote provider abnormally terminated", "The provider for the CIM Class: " + SolarisNative.this.getCimClassName() + " has terminated!");
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)"Provider is no longer available!");
            }
            if (!this.result.getTimedOut()) {
                return;
            }
            Debug.trace2((String)("Remote process timed out for request " + this.getKey()));
            if (SolarisNative.this.isDoorRunning(SolarisNative.this.getCimClassName())) {
                throw new CIMProviderException("TIMED_OUT");
            }
            SolarisNative.this.writeLogMessage("Remote provider abnormally terminated", "The provider for the CIM Class: " + SolarisNative.this.getCimClassName() + " has terminated!");
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)"Provider is no longer available!");
        }
    }

    private static class ResultClass {
        boolean mTimedOut = true;
        Object mOp = null;

        public synchronized Object getResult() {
            Debug.trace3((String)("Returning result: " + this.mOp));
            return this.mOp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setResult(Object object) {
            Debug.trace3((String)("Setting result to: " + object));
            ResultClass resultClass = this;
            synchronized (resultClass) {
                this.mOp = object;
                this.mTimedOut = false;
                this.notifyAll();
            }
        }

        public synchronized boolean getTimedOut() {
            Debug.trace3((String)("returning timedout: " + this.mTimedOut));
            return this.mTimedOut;
        }
    }

    private static class ProviderContext {
        private String user = null;
        private String role = null;
        private String host = null;
        private int request_id = 0;
        private int audit_id = 0;
        private byte[] audit_session = null;

        public String getUserName() {
            return this.user;
        }

        public String getRoleName() {
            return this.role;
        }

        public String getHostName() {
            return this.host;
        }

        public byte[] getAuditSession() {
            return this.audit_session;
        }

        public int getAuditId() {
            return this.audit_id;
        }

        public int getRequestId() {
            return this.request_id;
        }

        public void setUserName(String string) {
            this.user = string;
        }

        public void setRoleName(String string) {
            this.role = string;
        }

        public void setHostName(String string) {
            this.host = string;
        }

        public void setAuditSession(byte[] byArray) {
            this.audit_session = byArray;
        }

        public void setAuditId(int n) {
            this.audit_id = n;
        }

        public void setRequestId(int n) {
            this.request_id = n;
        }
    }
}

