/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.manipulators;

import com.sun.patchpro.host.HardwareComponent;
import com.sun.patchpro.manipulators.InstallFailedException;
import com.sun.patchpro.manipulators.Manipulator;
import com.sun.patchpro.manipulators.PatchInstallFailedException;
import com.sun.patchpro.manipulators.SunOSRmtT4ControllerInstallerPrtl;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.util.InteractiveSessionException;
import com.sun.patchpro.util.TelnetSession;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;

public class SunOSRmtT4OSImageInstaller
extends SunOSRmtT4ControllerInstallerPrtl {
    public SunOSRmtT4OSImageInstaller(Manipulator manipulator, PatchProProperties patchProProperties) throws InstallFailedException {
        super(manipulator, patchProProperties);
    }

    public void install() {
        File file;
        this.initializeProgress(0.0, 5.0);
        try {
            file = this.extractPatch();
        }
        catch (Exception exception) {
            this.log.printStackTrace(this, 2, exception);
            this.issueFail(new PatchInstallFailedException(57));
            return;
        }
        this.incrementProgress(1.0);
        try {
            if (this.debug) {
                System.out.println("Install command procedure for 6120 single brick at " + this.manipulator.getHost().getAddress());
                this.incrementProgress(3.0);
            } else {
                this.getControllerFirmwareImages(file);
                this.incrementProgress(1.0);
                this.uploadFirmwareImages(this.manipulator.getHost().getAddress());
                this.incrementProgress(1.0);
                this.applyControllerFirmwareImages(this.manipulator.getHost().getAddress());
                this.incrementProgress(1.0);
                this.applyLoopCardFirmwareImages(this.manipulator.getHost().getAddress());
            }
        }
        catch (InteractiveSessionException interactiveSessionException) {
            this.log.printStackTrace(this, 2, interactiveSessionException);
            this.issueFail(new PatchInstallFailedException(interactiveSessionException.getMessage()));
            System.out.println("Interactive Session Diagnostic Messages:\n" + interactiveSessionException.getMessage());
        }
        this.incrementProgress(1.0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void applyControllerFirmwareImages(String string) throws InteractiveSessionException {
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl2 = false;
        String string2 = null;
        String string3 = null;
        Object var10_10 = null;
        Object var11_11 = null;
        Object var12_12 = null;
        boolean bl3 = false;
        Enumeration enumeration = null;
        HardwareComponent hardwareComponent = null;
        Vector<String> vector = new Vector<String>();
        enumeration = this.getHardwareComponentsToUpdate();
        if (enumeration != null) {
            while (true) {
                if (!enumeration.hasMoreElements()) {
                    if (vector.contains("u1ctr")) break;
                    return;
                }
                hardwareComponent = (HardwareComponent)enumeration.nextElement();
                vector.addElement(hardwareComponent.getLocator());
            }
        }
        if (this.getControllerImage() == null) return;
        if (this.getLevel2Image() == null) return;
        TelnetSession telnetSession = null;
        try {
            try {
                n = this.convertToMilliseconds(this.convertStringToInteger(this.properties.getProperty("patchpro.setautomode.controller.limit", "300")));
                n4 = this.convertToMilliseconds(this.convertStringToInteger(this.properties.getProperty("patchpro.downloadl1fw.controller.limit", "600")));
                n3 = this.convertToMilliseconds(this.convertStringToInteger(this.properties.getProperty("patchpro.downloadl2fw.controller.limit", "600")));
                n2 = this.convertToMilliseconds(this.convertStringToInteger(this.properties.getProperty("patchpro.downloadl3fw.controller.limit", "600")));
                string2 = this.properties.getProperty("patchpro.userid", "root");
                string3 = this.getPassword(string);
                telnetSession = new TelnetSession();
                telnetSession.connect(string, string2, string3);
                if (!telnetSession.expectedResponse("set bootmode auto\r", "<2>", n)) {
                    this.log.println(this, 2, "The amount of time reserved to set the bootmode to auto has expired.");
                    throw new Exception("Expected : \"<2>\" prompt not detected after \"set bootmode auto\" issued.\n\nSession output:\n" + telnetSession.getAllSessionMessages());
                }
                telnetSession.send("cd /\r", 1000);
                if (!telnetSession.expectedResponse("ls\r", this.getControllerImage(), 5000)) {
                    this.log.println(this, 2, "The controller image that was uploaded is not present on the storage array.");
                    throw new Exception(this.getControllerImage() + " image was not found");
                }
                if (!telnetSession.expectedResponse("ls\r", this.getLevel2Image(), 5000)) {
                    this.log.println(this, 2, "The level2 image that was uploaded is not present on the storage array.");
                    throw new Exception(this.getLevel2Image() + " image was not found");
                }
                if (!telnetSession.expectedResponse("ep download " + this.getControllerImage() + "\r", "<6>", n2)) {
                    this.log.println(this, 2, "The amount of time reserved to set the boot image via \"ep download <image>\" has expired");
                    throw new Exception("Expected : \"<6>\" prompt not detected after \"ep download " + this.getControllerImage() + "\" issued." + "\n\nSession output:\n" + telnetSession.getAllSessionMessages());
                }
                if (telnetSession.getAllSessionMessages().indexOf("failed") != -1) {
                    this.log.println(this, 2, "ep download " + this.getControllerImage() + " did not complete successfully");
                    throw new Exception("Could not write EPROM image to controller.\n\nSession output:\n" + telnetSession.getAllSessionMessages());
                }
                if (!telnetSession.expectedResponse("ep download " + this.getLevel2Image() + "\r", "<7>", n3)) {
                    this.log.println(this, 2, "The amount of time reserved to set the level 2 image via \"ep download <image>\" has expired");
                    throw new Exception("Expected : \"<7>\" prompt not detected after \"ep download " + this.getLevel2Image() + "\" issued." + "\n\nSession output:\n" + telnetSession.getAllSessionMessages());
                }
                if (telnetSession.getAllSessionMessages().indexOf("failed") != -1) {
                    this.log.println(this, 2, "ep download " + this.getLevel2Image() + " did not complete successfully");
                    throw new Exception("Could not write EPROM image to controller.\n\nSession output:\n" + telnetSession.getAllSessionMessages());
                }
                if (this.getLevel1Image() != null) {
                    if (!telnetSession.expectedResponse("ls\r", this.getLevel1Image(), 5000)) {
                        this.log.println(this, 2, "The level 1 image that was uploaded is not present on the storage array.");
                        throw new Exception(this.getLevel1Image() + " image was not found");
                    }
                    if (!telnetSession.expectedResponse("ep download " + this.getLevel1Image() + "\r", "<9>", n4)) {
                        this.log.println(this, 2, "The amount of time reserved to set the boot image via \"ep download <image>\" has expired");
                        throw new Exception("Expected : \"<9>\" prompt not detected after \"ep download " + this.getLevel1Image() + "\" issued." + "\n\nSession output:\n" + telnetSession.getAllSessionMessages());
                    }
                    if (telnetSession.getAllSessionMessages().indexOf("failed") != -1) {
                        this.log.println(this, 2, "ep download " + this.getLevel1Image() + " did not complete successfully");
                        throw new Exception("Could not write EPROM image to controller.\n\nSession output:\n" + telnetSession.getAllSessionMessages());
                    }
                }
                telnetSession.send("reset -y\r", 60000);
                telnetSession.disconnect();
                telnetSession = null;
                this.waitForEstablishedConnection(string, string2, string3);
            }
            catch (Exception exception) {
                this.log.printStackTrace(this, 2, exception);
                throw new InteractiveSessionException(exception.getMessage());
            }
            Object var20_18 = null;
            if (telnetSession == null) return;
        }
        catch (Throwable throwable) {
            Object var20_19 = null;
            if (telnetSession == null) throw throwable;
            telnetSession.disconnect();
            throw throwable;
        }
        telnetSession.disconnect();
    }
}

