/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.wizard;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.admin.dirserv.wizard.IWizardPanel;
import com.netscape.admin.dirserv.wizard.WizardInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Stack;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class WizardWidget
extends JDialog
implements ActionListener {
    static final Dimension DEFAULT_SIZE = new Dimension(460, 500);
    static final int STRUT_SIZE = UIFactory.getDifferentSpace();
    protected boolean _isCancelled = false;
    private JButton _bNext_Done;
    private JButton _bCancel;
    private JButton _bBack;
    private JButton _bHelp;
    private Stack _prev = new Stack();
    private Stack _next = new Stack();
    protected JPanel _current = null;
    private JPanel _display;
    private String _doneLabel;
    private String _nextLabel;
    private WizardInfo _info;
    private JFrame _parent;
    private String _title;
    private Dimension _size;
    private static ResourceSet _resource = new ResourceSet("com.netscape.admin.dirserv.wizard.wizard");

    public WizardWidget(JFrame jFrame, String string, Dimension dimension) {
        this(jFrame, string);
        this._size = dimension;
        ((Component)this).setSize(dimension.width, dimension.height);
    }

    public WizardWidget(JFrame jFrame, String string) {
        super(jFrame, string, true);
        this._title = string;
        this._size = DEFAULT_SIZE;
        this._parent = jFrame;
        this.getContentPane().setLayout(new BorderLayout());
        ((Component)this).setSize(this._size.width, this._size.height);
        ((JComponent)this.getRootPane()).setDoubleBuffered(true);
        this.setLocationRelativeTo(jFrame);
        this._info = new WizardInfo();
        this._nextLabel = _resource.getString("wizard", "nextButton");
        this._doneLabel = _resource.getString("wizard", "doneButton");
        this._display = new JPanel();
        this._display.setLayout(new BorderLayout());
        this._display.setBorder(BorderFactory.createEtchedBorder());
        this.getContentPane().add("Center", this._display);
        this._bHelp = new JButton();
        this._bHelp.setText(_resource.getString("wizard", "helpButton"));
        this._bHelp.addActionListener(this);
        this._bBack = new JButton();
        this._bBack.setText(_resource.getString("wizard", "backButton"));
        this._bBack.addActionListener(this);
        this._bBack.setEnabled(false);
        this._bNext_Done = new JButton();
        this._bNext_Done.setText(this._nextLabel);
        this._bNext_Done.addActionListener(this);
        this._bCancel = new JButton();
        this._bCancel.setText(_resource.getString("wizard", "cancelButton"));
        this._bCancel.addActionListener(this);
        JButton[] jButtonArray = new JButton[]{this._bBack, this._bNext_Done, this._bCancel, this._bHelp};
        JPanel jPanel = UIFactory.makeJButtonPanel(jButtonArray, true);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add("North", Box.createVerticalStrut(STRUT_SIZE));
        jPanel2.add("Center", jPanel);
        jPanel2.add("South", Box.createVerticalStrut(STRUT_SIZE));
        jPanel2.add("East", Box.createHorizontalStrut(STRUT_SIZE));
        this.getContentPane().add("South", jPanel2);
        this.getContentPane().add("East", Box.createHorizontalStrut(STRUT_SIZE));
        this.getContentPane().add("West", Box.createHorizontalStrut(STRUT_SIZE));
        this.getContentPane().add("North", Box.createVerticalStrut(STRUT_SIZE));
    }

    public JFrame getFrame() {
        return this._parent;
    }

    public void addPage(JPanel jPanel) {
        if (this._current == null) {
            this._current = jPanel;
            this._display.add("Center", jPanel);
            this.initializeWizardPanel();
        } else {
            this._next.insertElementAt(jPanel, 0);
        }
    }

    protected WizardInfo getWizardInfo() {
        return this._info;
    }

    protected void setWizardInfo(WizardInfo wizardInfo) {
        this._info = wizardInfo;
    }

    protected boolean initializeWizardPanel() {
        if (this._current instanceof IWizardPanel) {
            boolean bl = ((IWizardPanel)((Object)this._current)).initializePanel(this._info);
            this.setTitle(((IWizardPanel)((Object)this._current)).getTitle());
            return bl;
        }
        return true;
    }

    boolean validateWizardPanel() {
        boolean bl = true;
        if (this._current instanceof IWizardPanel && !((IWizardPanel)((Object)this._current)).validatePanel()) {
            String string = ((IWizardPanel)((Object)this._current)).getErrorMessage();
            DSUtil.showErrorDialog((Component)this._parent, "error", string, "wizard");
            Debug.println((String)((IWizardPanel)((Object)this._current)).getErrorMessage());
            bl = false;
        }
        return bl;
    }

    boolean concludeWizardPanel() {
        boolean bl = true;
        if (this._current instanceof IWizardPanel && !((IWizardPanel)((Object)this._current)).concludePanel(this._info)) {
            bl = false;
        }
        return bl;
    }

    void updateWizardInfo() {
        if (this._current instanceof IWizardPanel) {
            ((IWizardPanel)((Object)this._current)).getUpdateInfo(this._info);
        }
    }

    protected void callHelp() {
        Debug.println((String)"Overwrite this method");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        int n;
        if (actionEvent.getSource().equals(this._bNext_Done)) {
            if (!this.validateWizardPanel()) {
                return;
            }
            if (this.concludeWizardPanel()) {
                if (this._next.empty()) {
                    this.dispose();
                    DSUtil.dialogCleanup();
                    return;
                }
                this.updateWizardInfo();
                this._prev.push(this._current);
                this._display.remove(this._current);
                this.setCurrentPanel((JPanel)this._next.pop());
                while (!this.initializeWizardPanel()) {
                    if (this._next.empty()) {
                        this.dispose();
                        DSUtil.dialogCleanup();
                        return;
                    }
                    this._prev.push(this._current);
                    this.setCurrentPanel((JPanel)this._next.pop());
                }
                this._display.add("Center", this._current);
                this._display.invalidate();
                this._display.validate();
                this._display.repaint(1L);
                this.getRootPane().paintImmediately(this.getRootPane().getVisibleRect());
            } else {
                return;
            }
        }
        if (actionEvent.getSource().equals(this._bCancel) && (n = DSUtil.showConfirmationDialog((Component)this, "question", string = _resource.getString("wizard", "confirmMessage"), "wizard")) == 0) {
            this.dispose();
            DSUtil.dialogCleanup();
            this._isCancelled = true;
        }
        if (actionEvent.getSource().equals(this._bBack) && !this._prev.empty()) {
            Debug.println((String)"Back Called");
            this._next.push(this._current);
            this._display.remove(this._current);
            this.setCurrentPanel((JPanel)this._prev.pop());
            while (!this.initializeWizardPanel()) {
                if (this._prev.empty()) {
                    return;
                }
                this._next.push(this._current);
                this.setCurrentPanel((JPanel)this._prev.pop());
            }
            this._display.add("Center", this._current);
            this._display.invalidate();
            this._display.validate();
            this._display.repaint(1L);
            this.getRootPane().paintImmediately(this.getRootPane().getVisibleRect());
        }
        if (actionEvent.getSource().equals(this._bHelp)) {
            this.callHelp();
        }
        this.changeButton();
    }

    protected void setCurrentPanel(JPanel jPanel) {
        Debug.println((String)("WizardWidget.setCurrentPanel: " + jPanel));
        this._current = jPanel;
    }

    private void changeButton() {
        if (this._prev.size() == 0) {
            this._bBack.setEnabled(false);
            this._bBack.repaint();
        } else {
            this._bBack.setEnabled(true);
            this._bBack.repaint();
        }
        if (this._next.size() == 0) {
            this._bNext_Done.setText(this._doneLabel);
        } else {
            this._bNext_Done.setText(this._nextLabel);
        }
        this._bNext_Done.repaint();
    }

    protected JButton getbNext_Done() {
        return this._bNext_Done;
    }

    public boolean isCancelled() {
        return this._isCancelled;
    }
}

