/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.task;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.task.CGITask;
import com.netscape.admin.dirserv.task.NewInstanceDialog;
import com.netscape.admin.dirserv.task.StatusDialog;
import com.netscape.management.client.comm.CommRecord;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.topology.IProductObject;
import com.netscape.management.client.topology.ProductSelectionDialog;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.LDAPUtil;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.UtilConsoleGlobals;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPUrl;
import netscape.ldap.util.DN;
import netscape.ldap.util.RDN;

public class MigrateCreate
extends CGITask
implements IProductObject {
    private static final String CREATE_CGI_NAME = "Tasks/Operation/Create";
    private static final String MIGRATE_CGI_NAME = "Tasks/Operation/Migrate";
    private static final String GET_CONFIG_INFO_CGI_NAME = "Tasks/Operation/GetConfigInfo";
    private boolean _success = false;
    private Hashtable _cgiResponse = null;
    private String _cgiTask = null;
    private StatusDialog _statusDialog = null;
    private String _finishedString = null;
    private static final String MIGRATION_FINISHED_STRING = "###MIGRATION FINISHED###";
    private static ResourceSet _resource = new ResourceSet("com.netscape.admin.dirserv.dirserv");

    public MigrateCreate() {
        this.setAsync(true);
    }

    public void initialize(ConsoleInfo consoleInfo) {
        this.print((Hashtable)consoleInfo, "MigrateCreate.initialize():");
        this._consoleInfo = consoleInfo;
    }

    public boolean migrate(String string, String string2, String string3) {
        return this.migrate(string, string2, string3, true);
    }

    public boolean migrate(String string, String string2, String string3, boolean bl) {
        Debug.println((String)("MigrateCreate.migrate(): serverRoot = " + string + " server = " + string2 + " targetDN = " + string3));
        Hashtable hashtable = new Hashtable();
        String string4 = string2;
        String string5 = "slapd-";
        if (string2.startsWith(string5)) {
            string4 = string2.substring(string5.length());
        }
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        hashtable2.put("rootdn", "rootdn");
        hashtable2.put("port", "port");
        if (!this.isNT(string3)) {
            hashtable2.put("oldlocaluser", "localuser");
            hashtable2.put("newlocaluser", "localuser");
        }
        hashtable2.put("oldServerRoot", string);
        hashtable2.put("oldServerName", string4);
        hashtable2.put("localhost", "localhost");
        this._consoleInfo.put("arguments", hashtable2);
        this._consoleInfo.put(GET_CONFIG_INFO_CGI_NAME, "slapd");
        if (this._consoleInfo.get("AdminUsername") == null) {
            this._consoleInfo.put("AdminUsername", this._consoleInfo.getAuthenticationDN());
        }
        Debug.println((String)("AdminUsername = " + this._consoleInfo.get("AdminUsername")));
        if (this._consoleInfo.get("AdminUserPassword") == null) {
            this._consoleInfo.put("AdminUserPassword", this._consoleInfo.getAuthenticationPassword());
        }
        Debug.println((String)("AdminUserPassword = " + this._consoleInfo.get("AdminUserPassword")));
        boolean bl2 = super.run(null, GET_CONFIG_INFO_CGI_NAME);
        if (this._cgiResponse.containsKey("port")) {
            hashtable.put("servport", this._cgiResponse.get("port"));
        }
        if (this._cgiResponse.containsKey("rootdn")) {
            hashtable.put("rootdn", this._cgiResponse.get("rootdn"));
        }
        if (this._cgiResponse.containsKey("oldlocaluser")) {
            hashtable.put("oldlocaluser", this._cgiResponse.get("oldlocaluser"));
        }
        if (this._cgiResponse.containsKey("newlocaluser")) {
            hashtable.put("newlocaluser", this._cgiResponse.get("newlocaluser"));
        }
        if (this._cgiResponse.containsKey("needSecPwd")) {
            hashtable.put("secpwd", "");
        }
        if (this._cgiResponse.containsKey("localhost")) {
            hashtable.put("localhost", this._cgiResponse.get("localhost"));
        }
        JFrame jFrame = UtilConsoleGlobals.getActivatedFrame();
        String string6 = _resource.getString("MigrateCreate", "creation-label");
        String[] stringArray = this.getServerList(string3, string6, null);
        ProductSelectionDialog productSelectionDialog = new ProductSelectionDialog((Frame)jFrame, 1);
        productSelectionDialog.setProductList(stringArray);
        productSelectionDialog.show();
        if (productSelectionDialog.isCancel()) {
            Debug.println((String)"MigrateCreate.migrate: server selection dialog was cancelled.");
            return false;
        }
        int[] nArray = productSelectionDialog.getSelectedIndices();
        if (nArray.length == 0) {
            Debug.println((String)"MigrateCreate.migrate: no destination server selected.");
            return false;
        }
        String[] stringArray2 = new String[]{null, null, null, null, null, null, null, null, null};
        String string7 = stringArray[nArray[0]];
        boolean bl3 = false;
        if (string7.equals(string6)) {
            Debug.println((String)("MigrateCreate.migrate(): searching for serverid=" + string4 + " under DN=" + string3));
            if (this.attrValueExists(string3, "nsServerID", string4, true) || this.attrValueExists(string3, "nsServerID", "slapd-" + string4, true)) {
                stringArray2[0] = "servid";
                hashtable.remove("servid");
            } else {
                hashtable.put("servid", string4);
            }
            if (this.isNT(string3)) {
                hashtable.put("servid", string4 + "-m");
                hashtable.put("oldServerID", string4);
                stringArray2[0] = "servid";
            }
        } else {
            if (string7.startsWith(string5)) {
                string7 = string7.substring(string5.length());
            }
            hashtable.put("servid", string7);
            bl3 = true;
        }
        stringArray2[4] = "rootpw";
        hashtable.put("oldServerRoot", string);
        hashtable.put("oldServerName", string4);
        stringArray2[6] = "shutdown_old_server";
        hashtable.put("shutdown_old_server", new Boolean(true));
        if (!this.isNT(string3)) {
            String string8 = (String)hashtable.get("oldlocaluser");
            String string9 = (String)hashtable.get("newlocaluser");
            if (string8 == null || !string8.equals(string9)) {
                stringArray2[5] = "servuser";
                hashtable.put("servuser", string9);
            }
        }
        if (hashtable.containsKey("secpwd")) {
            stringArray2[7] = "secpwd";
        }
        this._finishedString = MIGRATION_FINISHED_STRING;
        return this.createAnInstance(string3, stringArray2, hashtable, MIGRATE_CGI_NAME, bl3);
    }

    public boolean createNewInstance(String string) {
        boolean bl = false;
        Debug.println((String)("MigrateCreate.createNewInstance(): targetDN = " + string));
        Hashtable hashtable = new Hashtable();
        String[] stringArray = null;
        String[] stringArray2 = new String[]{"servid", "servport", "suffix", "rootdn", "rootpw", null, null, null, "servname"};
        String[] stringArray3 = new String[]{"servid", "servport", "suffix", "rootdn", "rootpw", "servuser", null, null, "servname"};
        stringArray = this.isNT(string) ? stringArray2 : stringArray3;
        return this.createAnInstance(string, stringArray, hashtable, CREATE_CGI_NAME, false);
    }

    private boolean createAnInstance(String string, String[] stringArray, Hashtable hashtable, String string2, boolean bl) {
        String[] stringArray2;
        int n;
        boolean bl2;
        boolean bl3;
        String string3;
        boolean bl4;
        JFrame jFrame;
        block45: {
            Object object;
            String string4;
            String string5;
            String string6;
            String string7;
            jFrame = UtilConsoleGlobals.getActivatedFrame();
            bl4 = false;
            Debug.println((String)("MigrateCreate.createNewInstance(): targetDN = " + string));
            String[] stringArray3 = LDAPDN.explodeDN((String)string, (boolean)false);
            string3 = stringArray3[stringArray3.length - 3] + ", " + stringArray3[stringArray3.length - 2] + ", " + stringArray3[stringArray3.length - 1];
            hashtable.put("servname", this.getValue(string3, "serverHostName", 0, null));
            LDAPConnection lDAPConnection = this._consoleInfo.getLDAPConnection();
            String string8 = lDAPConnection.getAuthenticationDN();
            hashtable.put("cfg_sspt_uid", string8);
            hashtable.put("cfg_sspt_uid_pw", lDAPConnection.getAuthenticationPassword());
            if (!hashtable.containsKey("suitespot3x_uid")) {
                string7 = "(cn=Configuration Administrator)";
                string6 = "ou=TopologyManagement, " + stringArray3[stringArray3.length - 1];
                string5 = this.getValue(string6, "uid", 2, string7);
                if (string5 == null) {
                    string5 = "admin";
                }
                hashtable.put("suitespot3x_uid", string5);
            }
            string7 = (String)this._consoleInfo.get("BaseDN");
            hashtable.put("ldap_url", DSUtil.getLdapURL(lDAPConnection, string7));
            if (!this.isNT(string) && !hashtable.containsKey("servuser")) {
                string6 = "(&(objectclass=nsConfig)(objectclass=nsDirectoryServer))";
                string5 = new DN(string);
                string4 = null;
                while (string4 == null && string5 != null && string5.countRDNs() > 1) {
                    string4 = this.getValue(string5.toString(), "nssuitespotuser", 2, string6);
                    string5 = string5.getParent();
                }
                if (string4 != null) {
                    hashtable.put("servuser", string4);
                } else {
                    Debug.println((String)("MigrateCreate.createNewInstance(): did not find nssuitespotuser under DN=" + string));
                }
            }
            if (!hashtable.containsKey("admin_domain")) {
                string6 = new RDN(stringArray3[stringArray3.length - 2]);
                hashtable.put("admin_domain", string6.getValues()[0]);
            }
            if (!hashtable.containsKey("servport")) {
                string6 = "389";
                boolean bl5 = this.getValue(string3, "nsserverport", 2, "nsserverport=" + string6) != null;
                string4 = null;
                object = null;
                if (!bl5 && !this.isNT(string)) {
                    string4 = (String)hashtable.get("servuser");
                    String string9 = "(&(objectclass=nsConfig)(objectclass=nsAdminConfig))";
                    object = this.getValue(string, "nssuitespotuser", 2, string9);
                }
                if (bl5 || string4 != null && !string4.equals("root") || object != null && !object.equals("root")) {
                    double d = 31743.0;
                    double d2 = Math.random() * d + 1024.0;
                    string6 = Integer.toString((int)Math.rint(d2));
                } else {
                    Debug.println((String)("inuse=" + bl5 + " dsuser=" + string4 + " asuser=" + (String)object));
                }
                hashtable.put("servport", string6);
            }
            if (!hashtable.containsKey("servid")) {
                String string10 = (String)hashtable.get("servname");
                int n2 = string10.indexOf(46);
                string6 = n2 > -1 ? string10.substring(0, n2) : string10;
                object = this.getServerList(string, null, string6);
                if (object != null && ((String[])object).length > 0) {
                    hashtable.put("servid", string6 + (((String[])object).length + 1));
                } else {
                    hashtable.put("servid", string6);
                }
            }
            if (!hashtable.containsKey("suffix")) {
                String string11;
                hashtable.put("suffix", string7);
                string6 = "(objectclass=nsDirectoryInfo)";
                String string12 = this.getValue(string, "nsdirectoryinforef", 0, string6);
                if (string12 != null && (string11 = this.getValue(string12, "nsdirectoryurl", 0, string6)) != null) {
                    try {
                        object = new LDAPUrl(string11);
                        if (object != null && object.getDN() != null) {
                            hashtable.put("suffix", object.getDN());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (!hashtable.containsKey("rootdn")) {
                string6 = "(&(objectclass=netscapeServer)(objectclass=nsDirectoryServer))";
                DN dN = new DN(string);
                String string13 = null;
                while (string13 == null && dN != null && dN.countRDNs() > 1) {
                    string13 = this.getValue(dN.toString(), "nsbinddn", 2, string6);
                    dN = dN.getParent();
                }
                if (string13 == null) {
                    hashtable.put("rootdn", DSUtil.getRootDN());
                } else {
                    hashtable.put("rootdn", string13);
                }
            }
            if (!hashtable.containsKey("rootpw")) {
                hashtable.put("rootpw", "");
            }
            if (!hashtable.containsKey("start_server")) {
                hashtable.put("start_server", "1");
            }
            bl3 = false;
            boolean bl6 = bl2 = stringArray[6] != null;
            if (stringArray[6] != null) {
                String string14 = (String)hashtable.get("localhost");
                if (string14 == null) {
                    string14 = (String)hashtable.get("servname");
                }
                int n3 = 0;
                try {
                    n3 = Integer.parseInt((String)hashtable.get("servport"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (string14 != null && n3 > 0) {
                    try {
                        LDAPConnection lDAPConnection2 = new LDAPConnection();
                        lDAPConnection2.connect(string14, n3);
                        lDAPConnection2.disconnect();
                    }
                    catch (Exception exception) {
                        Debug.println((String)("MigrateCreate.createAnInstance(): failed to connect to old server at " + string14 + ":" + n3 + " error [" + exception + "] " + "assuming it is already down"));
                        stringArray[6] = null;
                        if (!hashtable.containsKey("shutdown_old_server")) break block45;
                        hashtable.remove("shutdown_old_server");
                    }
                }
            }
        }
        while (!bl3 && stringArray != null) {
            Object object;
            try {
                object = new NewInstanceDialog(jFrame, stringArray, hashtable);
                Debug.println((String)"MigrateCreate.createAnInstance(): now calling show()");
                object.show();
                if (object.isCancel()) {
                    return bl4;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            object = (String)hashtable.get("servid");
            if (!bl2) {
                if (this.attrValueExists(string, "nsServerID", (String)object, true) || this.attrValueExists(string, "nsServerID", "slapd-" + (String)object, true)) {
                    DSUtil.showErrorDialog((Component)jFrame, "117", (String)object);
                    continue;
                }
                bl3 = true;
                continue;
            }
            if (this.isNT(string)) {
                String string15 = (String)hashtable.get("oldServerID");
                Debug.println((String)("MigrateCreate.createAnInstance():serverid=" + (String)object + " oldServerID=" + string15));
                if (((String)object).equals(string15)) {
                    DSUtil.showErrorDialog((Component)jFrame, "ntserviceinuse", (String)object);
                    continue;
                }
                bl3 = true;
                continue;
            }
            bl3 = true;
        }
        if (this.attrValueExists(string3, "nsServerPort", hashtable.get("servport").toString(), true) && !bl && (n = DSUtil.showConfirmationDialog((Component)jFrame, "portinuse2", stringArray2 = new String[]{hashtable.get("servport").toString(), hashtable.get("servname").toString()}, "general")) == 1) {
            return false;
        }
        if (hashtable.containsKey("shutdown_old_server")) {
            Boolean bl7 = (Boolean)hashtable.get("shutdown_old_server");
            Debug.println((String)("MigrateCreate.createNewServer: shutdown=" + bl7));
            if (!bl7.booleanValue()) {
                hashtable.remove("shutdown_old_server");
            }
        }
        this._consoleInfo.put("arguments", hashtable);
        this._consoleInfo.put(string2, "slapd");
        if (this._consoleInfo.get("AdminUsername") == null) {
            this._consoleInfo.put("AdminUsername", this._consoleInfo.getAuthenticationDN());
        }
        Debug.println((String)("AdminUsername = " + this._consoleInfo.get("AdminUsername")));
        if (this._consoleInfo.get("AdminUserPassword") == null) {
            this._consoleInfo.put("AdminUserPassword", this._consoleInfo.getAuthenticationPassword());
        }
        Debug.println((String)("AdminUserPassword = " + this._consoleInfo.get("AdminUserPassword")));
        this._statusDialog = new StatusDialog(jFrame);
        this._statusDialog.setOKButtonEnabled(false);
        ((Dialog)((Object)this._statusDialog)).setTitle(_resource.getString("MigrateCreate-statuswindow", "title"));
        this._statusDialog.appendText(_resource.getString("MigrateCreate-statuswindow", "creating-text") + '\n');
        this._statusDialog.show();
        Debug.println((String)("MigrateCreate.createAnInstance(): before run task=" + string2));
        this._cgiTask = string2;
        bl4 = super.run(null, string2);
        Debug.println((String)("MigrateCreate.createAnInstance(): after run status=" + bl4 + " _success=" + this._success));
        String string16 = this._success ? "success-label" : "failed-label";
        String string17 = _resource.getString("MigrateCreate", string16);
        this._statusDialog.appendText("\n" + string17);
        this._statusDialog.setOKButtonEnabled(true);
        return this._success;
    }

    protected boolean attrValueExists(String string, String string2, String string3, boolean bl) {
        LDAPSearchResults lDAPSearchResults = null;
        if (string3 == null) {
            return false;
        }
        if (string2 == null) {
            string2 = "*";
        }
        String string4 = "(" + string2 + "=" + string3 + ")";
        int n = 1;
        if (bl) {
            n = 2;
        }
        try {
            LDAPConnection lDAPConnection = this._consoleInfo.getLDAPConnection();
            if (lDAPConnection != null) {
                lDAPSearchResults = lDAPConnection.search(string, n, string4, null, false);
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("error MigrateCreate.serverExists: LDAP search failed: " + string4));
            Debug.println((String)("error MigrateCreate.serverExists: could not find any servers under " + string + " error: " + (Object)((Object)lDAPException)));
        }
        boolean bl2 = false;
        if (lDAPSearchResults.hasMoreElements()) {
            bl2 = true;
        }
        return bl2;
    }

    protected String[] getValues(String string, String[] stringArray, int n, String string2) {
        LDAPConnection lDAPConnection;
        String[] stringArray2 = null;
        LDAPSearchResults lDAPSearchResults = null;
        if (string2 == null) {
            string2 = "(objectclass=*)";
        }
        try {
            lDAPConnection = this._consoleInfo.getLDAPConnection();
            if (lDAPConnection != null) {
                lDAPSearchResults = lDAPConnection.search(string, n, string2, stringArray, false);
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("error MigrateCreate.getValues: LDAP read failed for DN=" + string + " attributes " + stringArray));
            Debug.println((String)("error MigrateCreate.getValues: LDAP Exception:" + (Object)((Object)lDAPException)));
        }
        if (lDAPSearchResults != null && lDAPSearchResults.hasMoreElements()) {
            stringArray2 = new String[stringArray.length];
            lDAPConnection = (LDAPEntry)lDAPSearchResults.nextElement();
            int n2 = 0;
            while (lDAPConnection != null && n2 < stringArray.length) {
                stringArray2[n2] = LDAPUtil.flatting((LDAPAttribute)lDAPConnection.getAttribute(stringArray[n2]));
                ++n2;
            }
        } else {
            Debug.println((String)("error MigrateCreate.getValues: LDAP read failed for DN=" + string + " attributes=" + stringArray));
        }
        return stringArray2;
    }

    protected String getValue(String string, String string2, int n, String string3) {
        String[] stringArray = new String[]{string2};
        String[] stringArray2 = this.getValues(string, stringArray, n, string3);
        if (stringArray2 != null) {
            return stringArray2[0];
        }
        return null;
    }

    protected String[] getServerList(String string, String string2, String string3) {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        LDAPSearchResults lDAPSearchResults = null;
        String string4 = string3 != null ? string3 : "";
        String string5 = "&(nsServerID=slapd-" + string4 + "*)(cn=slapd-" + string4 + "*)";
        int n = 2;
        try {
            object = this._consoleInfo.getLDAPConnection();
            if (object != null) {
                lDAPSearchResults = object.search(string, n, string5, null, false);
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("error MigrateCreate.getServerList: LDAP search failed: " + string5));
            Debug.println((String)("error MigrateCreate.getServerList: could not find any servers under " + string + " error: " + (Object)((Object)lDAPException)));
        }
        if (string2 != null) {
            vector.addElement(string2);
        }
        while (lDAPSearchResults.hasMoreElements()) {
            object = LDAPUtil.flatting((LDAPAttribute)((LDAPEntry)lDAPSearchResults.nextElement()).getAttribute("nsServerID"));
            Debug.println((String)("MigrateCreate.getServerList(): val = " + (String)object));
            vector.addElement(object);
        }
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    private boolean isNT(String string) {
        boolean bl = false;
        Debug.println((String)"MigrateCreate:isNT(): BEGIN");
        String string2 = (String)this._consoleInfo.get("AdminOS");
        Debug.println((String)("MigrateCreate:isNT(): os string=" + string2));
        if (string2 == null) {
            DN dN = new DN(string);
            string2 = this.getValue(dN.getParent().toString(), "nsosversion", 0, null);
            Debug.println((String)("MigrateCreate:isNT(): search under DN=" + string + " for os=" + string2));
            if (string2 != null) {
                this._consoleInfo.put("AdminOS", string2);
            }
        }
        if (string2 != null && string2.indexOf("Windows NT") >= 0) {
            bl = true;
        }
        Debug.println((String)("MigrateCreate:isNT(): return=" + bl));
        return bl;
    }

    public void replyHandler(InputStream inputStream, CommRecord commRecord) {
        Debug.println((String)("MigrateCreate.replyHandler BEGIN this=" + (Object)((Object)this) + " cr=" + commRecord + " task=" + this._cgiTask));
        this._success = false;
        if (this._cgiResponse != null) {
            this._cgiResponse.clear();
        }
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF8"));
            Debug.println((String)"MigrateCreate.replyHandler: start");
            boolean bl = false;
            while (!bl && (string = bufferedReader.readLine()) != null) {
                Debug.println((String)("MigrateCreate.replyHandler: read [" + string + "]"));
                if (!(this._statusDialog == null || string.startsWith("NMC_") || this._finishedString != null && string.indexOf(this._finishedString) != -1)) {
                    this._statusDialog.invokeAppendText(string + "\n");
                    Thread.yield();
                }
                bl = this.parse(string);
            }
        }
        catch (Exception exception) {
            Debug.println((String)("MigrateCreate.replyHandler: " + exception.toString()));
        }
        Debug.println((String)("MigrateCreate.replyHandler END this=" + (Object)((Object)this) + " cr=" + commRecord + " task=" + this._cgiTask));
        this.finish();
    }

    private boolean parse(String string) {
        boolean bl = false;
        Debug.println((String)("Parse input: " + string));
        int n = string.indexOf(":");
        if (n != -1) {
            String string2 = string.substring(0, n).trim();
            String string3 = string.substring(n + 1).trim();
            Debug.println((String)("Parse input: name=" + string2 + " value=" + string3));
            if (this._cgiResponse == null) {
                this._cgiResponse = new Hashtable();
            }
            this._cgiResponse.put(string2, string3);
            if (string2.equalsIgnoreCase("NMC_Status")) {
                int n2 = Integer.parseInt(string3);
                this._success = n2 == 0;
                Debug.println((String)("Parse input: code=" + n2 + " _success=" + this._success));
                bl = true;
            }
        } else if (this._finishedString != null && string.indexOf(this._finishedString) != -1) {
            bl = true;
        }
        Debug.println((String)("Parse finished val=" + bl));
        return bl;
    }

    private void print(Hashtable hashtable, String string) {
        Debug.println((String)string);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Debug.println((String)("\t" + string2 + "=" + hashtable.get(string2)));
        }
        Debug.println((String)"");
    }
}

