/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel.replication;

import com.netscape.admin.dirserv.panel.replication.ReplicationAgreement;
import com.netscape.admin.dirserv.panel.replication.ReplicationTool;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.io.IOException;
import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;

public class MMRAgreement
extends ReplicationAgreement {
    private boolean usePersistentSearch;
    private int syncInterval;
    private boolean supplierUnreachable;
    private static final int DEFAULT_SYNC_INTERVAL = 10;
    private static ResourceSet _resource = new ResourceSet("com.netscape.admin.dirserv.panel.replication.replication");
    private static final String MMRAgreementClass = "nsDS5ReplicationAgreement";

    public MMRAgreement(ConsoleInfo consoleInfo, LDAPEntry lDAPEntry, LDAPEntry lDAPEntry2) {
        super(2);
        this.supplierHost = consoleInfo.getHost();
        this.supplierPort = consoleInfo.getPort();
        this.setServerInfo(consoleInfo);
        String string = null;
        if (lDAPEntry != null) {
            string = lDAPEntry.getDN();
            this.setOrigEntryDN(string);
            this.setEntryDN(string);
            this.readValuesFromEntry(lDAPEntry);
            this.agreementIsNew = false;
        } else if (lDAPEntry2 != null) {
            string = "cn=xxx," + lDAPEntry2.getDN();
            this.agreementIsNew = true;
            this.setOrigEntryDN(string);
        }
    }

    public void setUsePersistentSearch(String string) {
        this.usePersistentSearch = string.equalsIgnoreCase("true");
    }

    public boolean getUsePersistentSearch() {
        return this.usePersistentSearch;
    }

    public void setSyncInterval(int n) {
        this.syncInterval = n;
    }

    public int getSyncInterval() {
        return this.syncInterval;
    }

    public void setUnreachable(boolean bl) {
        this.supplierUnreachable = bl;
        Debug.println((String)("MMRAgreement.setUnreachable: " + bl));
    }

    public boolean getUnreachable() {
        return this.supplierUnreachable;
    }

    public void readValuesFromEntry(LDAPEntry lDAPEntry) {
        LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
        Enumeration enumeration = lDAPAttributeSet.getAttributes();
        String string = null;
        while (enumeration.hasMoreElements()) {
            String string2;
            Enumeration enumeration2;
            LDAPAttribute lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
            if (lDAPAttribute.getName().equalsIgnoreCase("nsDS5ReplicaUpdateSchedule")) {
                enumeration2 = lDAPAttribute.getStringValues();
                while (enumeration2.hasMoreElements()) {
                    string2 = (String)enumeration2.nextElement();
                    this.addUpdateSchedule(string2);
                }
                continue;
            }
            enumeration2 = lDAPAttribute.getStringValues();
            if (!enumeration2.hasMoreElements()) continue;
            string2 = (String)enumeration2.nextElement();
            if (lDAPAttribute.getName().equalsIgnoreCase("cn")) {
                this.setNickname(string2);
                continue;
            }
            if (lDAPAttribute.getName().equalsIgnoreCase("description")) {
                this.setDescription(string2);
                continue;
            }
            if (lDAPAttribute.getName().equalsIgnoreCase("nsDS5ReplicaRoot")) {
                this.setReplicatedSubtree(string2);
                this.origReplicatedSubtree = this.getReplicatedSubtree();
                continue;
            }
            if (lDAPAttribute.getName().equalsIgnoreCase("nsDS5ReplicaHost")) {
                this.setConsumerHost(string2);
                this.origConsumerHost = this.getConsumerHost();
                continue;
            }
            if (lDAPAttribute.getName().equalsIgnoreCase("nsDS5ReplicaPort")) {
                this.setConsumerPort(Integer.parseInt(string2));
                this.origConsumerPort = this.getConsumerPort();
                continue;
            }
            if (lDAPAttribute.getName().equalsIgnoreCase("nsDS5ReplicaBindDN")) {
                this.setBindDN(string2);
                continue;
            }
            if (lDAPAttribute.getName().equalsIgnoreCase("nsDS5ReplicaCredentials")) {
                this.setBindCredentials(string2);
                continue;
            }
            if (lDAPAttribute.getName().equalsIgnoreCase("nsDS5ReplicaTransportInfo")) {
                this.setUseSSL(string2);
                continue;
            }
            if (lDAPAttribute.getName().equalsIgnoreCase("cn")) {
                string = string2;
                continue;
            }
            if (lDAPAttribute.getName().equalsIgnoreCase("nsDS5ReplicaBindMethod")) {
                this.setUseSSLAuth(string2);
                continue;
            }
            if (!lDAPAttribute.getName().equalsIgnoreCase("nsds5BeginReplicaRefresh")) continue;
            this.setORCValue(string2);
        }
        if (string != null) {
            this.setEntryCN(string);
        }
    }

    public int writeToServer() throws IOException {
        Object var4_1 = null;
        if (this.agreementIsNew) {
            this.computeNewEntryCNandDN();
            LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
            LDAPAttribute lDAPAttribute = new LDAPAttribute("objectclass", ReplicationTool.MMR_AGREEMENT_OBJECTCLASSES);
            lDAPAttributeSet.add(lDAPAttribute);
            lDAPAttribute = new LDAPAttribute("description", this._description);
            lDAPAttributeSet.add(lDAPAttribute);
            lDAPAttribute = new LDAPAttribute("cn", this.entryCN);
            lDAPAttributeSet.add(lDAPAttribute);
            lDAPAttribute = this.replicatedSubtree == null ? new LDAPAttribute("nsDS5ReplicaRoot", "") : new LDAPAttribute("nsDS5ReplicaRoot", this.replicatedSubtree);
            lDAPAttributeSet.add(lDAPAttribute);
            lDAPAttribute = new LDAPAttribute("nsDS5ReplicaHost", this.consumerHost);
            lDAPAttributeSet.add(lDAPAttribute);
            lDAPAttribute = new LDAPAttribute("nsDS5ReplicaPort", Integer.toString(this.consumerPort));
            lDAPAttributeSet.add(lDAPAttribute);
            if (this.bindDN != null) {
                lDAPAttribute = new LDAPAttribute("nsDS5ReplicaBindDN", this.bindDN);
                lDAPAttributeSet.add(lDAPAttribute);
            }
            if (this.bindCredentials != null) {
                lDAPAttribute = new LDAPAttribute("nsDS5ReplicaCredentials", this.bindCredentials);
                lDAPAttributeSet.add(lDAPAttribute);
            }
            if (this.useSSL) {
                lDAPAttribute = new LDAPAttribute("nsDS5ReplicaTransportInfo", "SSL");
                lDAPAttributeSet.add(lDAPAttribute);
            }
            if (this.useSSL && this.useSSLAuth) {
                lDAPAttribute = new LDAPAttribute("nsDS5ReplicaBindMethod", "SSLCLIENTAUTH");
                lDAPAttributeSet.add(lDAPAttribute);
            } else {
                lDAPAttribute = new LDAPAttribute("nsDS5ReplicaBindMethod", "SIMPLE");
                lDAPAttributeSet.add(lDAPAttribute);
            }
            String[] stringArray = this.getUpdateScheduleStrings();
            if (stringArray != null) {
                boolean bl = false;
                int n = 0;
                while (!bl && n < stringArray.length) {
                    bl = stringArray[n] != null && stringArray[n].length() > 0;
                    ++n;
                }
                if (bl) {
                    lDAPAttribute = new LDAPAttribute("nsDS5ReplicaUpdateSchedule", stringArray);
                    lDAPAttributeSet.add(lDAPAttribute);
                }
            }
            LDAPEntry lDAPEntry = new LDAPEntry(this.entryDN, lDAPAttributeSet);
            try {
                this.createNewEntry(lDAPEntry);
            }
            catch (LDAPException lDAPException) {
                Debug.println((String)("MMRAgreement.writeToServer: <" + this.entryDN + "> " + lDAPException.toString()));
                return lDAPException.getLDAPResultCode();
            }
            if (!this.agreementIsNew) {
                try {
                    this.deleteOldEntry();
                    this.setOrigEntryDN(this.getEntryDN());
                }
                catch (LDAPException lDAPException) {
                    Debug.println((String)("MMRAgreement.writeToServer: <" + this.entryDN + "> " + lDAPException.toString()));
                    return lDAPException.getLDAPResultCode();
                }
            }
        } else {
            LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
            LDAPAttribute lDAPAttribute = new LDAPAttribute("description", this._description);
            lDAPModificationSet.add(2, lDAPAttribute);
            lDAPAttribute = this.bindDN != null ? new LDAPAttribute("nsDS5ReplicaBindDN", this.bindDN) : new LDAPAttribute("nsDS5ReplicaBindDN");
            lDAPModificationSet.add(2, lDAPAttribute);
            if (this.bindCredentials != null) {
                lDAPAttribute = new LDAPAttribute("nsDS5ReplicaCredentials", this.bindCredentials);
                lDAPModificationSet.add(2, lDAPAttribute);
            }
            Debug.println((String)("MMRAgreement.writeToServer: useSSLAuth=" + this.useSSLAuth));
            lDAPAttribute = this.useSSLAuth ? new LDAPAttribute("nsDS5ReplicaBindMethod", "SSLCLIENTAUTH") : new LDAPAttribute("nsDS5ReplicaBindMethod", "SIMPLE");
            lDAPModificationSet.add(2, lDAPAttribute);
            String[] stringArray = this.getUpdateScheduleStrings();
            lDAPAttribute = new LDAPAttribute("nsDS5ReplicaUpdateSchedule");
            if (stringArray != null) {
                boolean bl = false;
                int n = 0;
                while (!bl && n < stringArray.length) {
                    bl = stringArray[n] != null && stringArray[n].length() > 0;
                    ++n;
                }
                if (bl) {
                    lDAPAttribute = new LDAPAttribute("nsDS5ReplicaUpdateSchedule", stringArray);
                }
                lDAPModificationSet.add(2, lDAPAttribute);
            }
            try {
                Debug.println((String)("MMRAgreement.writeToServer: upd:" + lDAPModificationSet));
                this.updateEntry(lDAPModificationSet);
            }
            catch (LDAPException lDAPException) {
                Debug.println((String)("MMRAgreement.writeToServer: <" + this.entryDN + "> " + lDAPException.toString()));
                return lDAPException.getLDAPResultCode();
            }
        }
        return 0;
    }
}

