/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel.replication;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.GroupPanel;
import com.netscape.admin.dirserv.panel.replication.ReplicationTool;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.text.JTextComponent;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;

public class LegacyConsumerSettingPanel
extends BlankPanel {
    private IDSModel _model;
    private boolean _entryExists;
    private boolean _isValid = true;
    private boolean _isDirty = false;
    private boolean _isDNDirty = false;
    private boolean _isDNOK = true;
    private boolean _isPwdDirty = false;
    private boolean _isPasswdOK = true;
    private boolean _isEnableDirty = false;
    private boolean _mustDelete;
    private boolean _isLegacyConsumerEnabled;
    private JTextField _dnText;
    private JPasswordField _pwdText;
    private JPasswordField _againText;
    private JCheckBox _cbEnable = null;
    private JLabel _dnLabel;
    private JLabel _againLabel;
    private JLabel _pwdLabel;
    private String _savePwd;
    private String _saveDN;
    private LDAPEntry _legacyEntry;
    private static ResourceSet _resource = new ResourceSet("com.netscape.admin.dirserv.panel.replication.replication");
    private static final String _section = "replication-legacyconsumer";
    private static final int _pwdMinLength = 8;
    private static final String REPSETTINGS_CN = "legacy consumer";
    public static final String REPSETTINGS_DN = "cn=legacy consumer,cn=replication,cn=config";
    private static final String[] REPSETTINGS_OBJECTCLASSES = new String[]{"top", "extensibleObject"};
    private static final String UPDATEDN_ATTR_NAME = "nsslapd-legacy-updatedn";
    private static final String UPDATEDN_PASSWORD_ATTR_NAME = "nsslapd-legacy-updatepw";

    public LegacyConsumerSettingPanel(IDSModel iDSModel) {
        super(iDSModel, "replication");
        this.setTitle(_resource.getString("replication-legacyconsumer-setting", "title"));
        this._model = iDSModel;
        this._helpToken = "configuration-replication-legacyconsumersettings-help";
        this._refreshWhenSelect = false;
    }

    public void init() {
        Object object;
        if (this._isInitialized) {
            return;
        }
        this._entryExists = false;
        try {
            object = this._model.getServerInfo().getLDAPConnection();
            this._legacyEntry = object.read(REPSETTINGS_DN);
            if (this._legacyEntry != null) {
                this._entryExists = true;
            }
        }
        catch (LDAPException lDAPException) {
            // empty catch block
        }
        this._isLegacyConsumerEnabled = this._entryExists;
        object = this.getGBC();
        this._myPanel.setLayout(new GridBagLayout());
        this._myPanel.setBackground(this.getBackground());
        this._myPanel.setPreferredSize(ReplicationTool.DEFAULT_PANEL_SIZE);
        this._myPanel.setMaximumSize(ReplicationTool.DEFAULT_PANEL_SIZE);
        JTextArea jTextArea = this.makeMultiLineLabel(2, 60, _resource.getString(_section, "setting-desc"));
        object.anchor = 18;
        object.gridwidth = 2;
        object.weightx = 1.0;
        object.fill = 2;
        this._myPanel.add((Component)jTextArea, object);
        object.weightx = 0.0;
        object.fill = 2;
        object.gridwidth = 0;
        this._myPanel.add(Box.createGlue(), object);
        this._cbEnable = this.makeJCheckBox(_section, "enable", this._entryExists, _resource);
        this._cbEnable.setSelected(this._entryExists);
        this._cbEnable.addItemListener(this);
        object.gridwidth = 2;
        object.weightx = 0.0;
        object.fill = 0;
        this._myPanel.add((Component)this._cbEnable, object);
        object.weightx = 1.0;
        object.fill = 2;
        object.gridwidth = 0;
        this._myPanel.add(Box.createGlue(), object);
        ReplicationTool.resetGBC((GridBagConstraints)object);
        object.insets = (Insets)ReplicationTool.BOTTOM_INSETS.clone();
        object.anchor = 11;
        object.gridwidth = 0;
        object.weightx = 1.0;
        this._myPanel.add((Component)this.createAuth(), object);
        this.checkEnabledField();
        this.addBottomGlue();
        this._isInitialized = true;
    }

    private JPanel createAuth() {
        String string = _resource.getString("replication-legacyconsumer-normalAuth", "label");
        GroupPanel groupPanel = new GroupPanel(string);
        this._dnLabel = this.makeJLabel(_resource.getString("replication-legacyconsumer-supplierDN", "label"));
        this._dnLabel.setToolTipText(_resource.getString("replication-legacyconsumer-supplierDN", "ttip"));
        this._dnLabel.resetKeyboardActions();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.insets = (Insets)ReplicationTool.BOTTOM_INSETS.clone();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        groupPanel.add((Component)this._dnLabel, gridBagConstraints);
        this._dnText = this.makeJTextField(_section, "supplierDN", _resource);
        this._dnLabel.setLabelFor(this._dnText);
        this._saveDN = DSUtil.getAttrValue(this._legacyEntry, UPDATEDN_ATTR_NAME);
        if (this._saveDN != null) {
            this._dnText.setText(this._saveDN);
        } else {
            this._dnText.setText("");
        }
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        groupPanel.add((Component)this._dnText, gridBagConstraints);
        this._pwdLabel = this.makeJLabel(_resource.getString("replication-legacyconsumer-SupplierNewPwd", "label"));
        this._pwdLabel.setToolTipText(_resource.getString("replication-legacyconsumer-SupplierNewPwd", "ttip"));
        this._pwdLabel.resetKeyboardActions();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        groupPanel.add((Component)this._pwdLabel, gridBagConstraints);
        this._pwdText = this.makeJPasswordField(_section, "SupplierNewPwd", "", 10, _resource);
        this._pwdLabel.setLabelFor(this._pwdText);
        this._savePwd = DSUtil.getAttrValue(this._legacyEntry, UPDATEDN_PASSWORD_ATTR_NAME);
        if (this._savePwd != null) {
            ((JTextComponent)this._pwdText).setText(this._savePwd);
        } else {
            this._savePwd = "";
            ((JTextComponent)this._pwdText).setText("");
        }
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        groupPanel.add((Component)this._pwdText, gridBagConstraints);
        this._againLabel = this.makeJLabel(_resource.getString("replication-legacyconsumer-SupplierNewPwd", "again"));
        this._againLabel.resetKeyboardActions();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        groupPanel.add((Component)this._againLabel, gridBagConstraints);
        this._againText = this.makeJPasswordField(_section, "SupplierNewPwd", "", 10, _resource);
        this._againLabel.setLabelFor(this._againText);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        ((JTextComponent)this._againText).setText(this._savePwd);
        groupPanel.add((Component)this._againText, gridBagConstraints);
        return groupPanel;
    }

    public boolean refresh() {
        Debug.println((String)"LegacyConsumerPanel.refresh()");
        this._entryExists = false;
        try {
            LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
            this._legacyEntry = lDAPConnection.read(REPSETTINGS_DN);
            if (this._legacyEntry != null) {
                this._entryExists = true;
            }
        }
        catch (LDAPException lDAPException) {
            this._legacyEntry = null;
        }
        this._isLegacyConsumerEnabled = this._entryExists;
        this._saveDN = DSUtil.getAttrValue(this._legacyEntry, UPDATEDN_ATTR_NAME);
        this._savePwd = DSUtil.getAttrValue(this._legacyEntry, UPDATEDN_PASSWORD_ATTR_NAME);
        this.checkOkay();
        return true;
    }

    public void refreshFromServer() {
        Debug.println((String)"LegacyConsumerPanel.refreshFromServer()");
        this.resetCallback();
    }

    public void resetCallback() {
        this._entryExists = false;
        try {
            LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
            this._legacyEntry = lDAPConnection.read(REPSETTINGS_DN);
            if (this._legacyEntry != null) {
                this._entryExists = true;
            }
        }
        catch (LDAPException lDAPException) {
            this._legacyEntry = null;
        }
        this._isLegacyConsumerEnabled = this._entryExists;
        this._saveDN = DSUtil.getAttrValue(this._legacyEntry, UPDATEDN_ATTR_NAME);
        this._savePwd = DSUtil.getAttrValue(this._legacyEntry, UPDATEDN_PASSWORD_ATTR_NAME);
        if (this._saveDN != null) {
            this._dnText.setText(this._saveDN);
        } else {
            this._dnText.setText("");
        }
        this._cbEnable.setSelected(this._entryExists);
        this._isDNDirty = false;
        ((JTextComponent)this._pwdText).setText(this._savePwd);
        ((JTextComponent)this._againText).setText(this._savePwd);
        this._isPwdDirty = false;
        this.checkOkay();
    }

    public void okCallback() {
        if (!this._isValid || !this._isDirty) {
            return;
        }
        LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
        this._entryExists = false;
        try {
            this._legacyEntry = lDAPConnection.read(REPSETTINGS_DN);
            if (this._legacyEntry != null) {
                this._entryExists = true;
            }
        }
        catch (LDAPException lDAPException) {
            this._legacyEntry = null;
        }
        this.checkStatus();
        String string = new String(this._pwdText.getPassword());
        if (this._mustDelete) {
            try {
                lDAPConnection.delete(REPSETTINGS_DN);
                this._entryExists = false;
                this._mustDelete = false;
                this._dnText.setText("");
                ((JTextComponent)this._pwdText).setText("");
                ((JTextComponent)this._againText).setText("");
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() == 32) {
                    this._entryExists = false;
                    this._mustDelete = false;
                    this._dnText.setText("");
                    ((JTextComponent)this._pwdText).setText("");
                    ((JTextComponent)this._againText).setText("");
                }
                String string2 = lDAPException.errorCodeToString();
                String string3 = lDAPException.getLDAPErrorMessage();
                if (string3 != null && string3.length() > 0) {
                    string2 = string2 + ". " + string3;
                }
                String[] stringArray = new String[]{string2};
                DSUtil.showErrorDialog((Component)this._model.getFrame(), "error-del-legacy", stringArray, _section, _resource);
                this.checkOkay();
                return;
            }
        } else if (!this._entryExists) {
            LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
            lDAPAttributeSet.add(new LDAPAttribute("objectclass", REPSETTINGS_OBJECTCLASSES));
            lDAPAttributeSet.add(new LDAPAttribute("cn", REPSETTINGS_CN));
            lDAPAttributeSet.add(new LDAPAttribute(UPDATEDN_ATTR_NAME, this._dnText.getText()));
            lDAPAttributeSet.add(new LDAPAttribute(UPDATEDN_PASSWORD_ATTR_NAME, string));
            LDAPEntry lDAPEntry = new LDAPEntry(REPSETTINGS_DN, lDAPAttributeSet);
            try {
                lDAPConnection.add(lDAPEntry);
            }
            catch (LDAPException lDAPException) {
                String string4 = lDAPException.errorCodeToString();
                String string5 = lDAPException.getLDAPErrorMessage();
                if (string5 != null && string5.length() > 0) {
                    string4 = string4 + ". " + string5;
                }
                String[] stringArray = new String[]{string4};
                DSUtil.showErrorDialog((Component)this._model.getFrame(), "error-add-legacy", stringArray, _section, _resource);
                this.checkOkay();
                return;
            }
            this._legacyEntry = lDAPEntry;
            this._entryExists = true;
        } else {
            LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
            lDAPModificationSet.add(2, new LDAPAttribute(UPDATEDN_ATTR_NAME, this._dnText.getText()));
            lDAPModificationSet.add(2, new LDAPAttribute(UPDATEDN_PASSWORD_ATTR_NAME, string));
            try {
                lDAPConnection.modify(this._legacyEntry.getDN(), lDAPModificationSet);
            }
            catch (LDAPException lDAPException) {
                String string6 = lDAPException.errorCodeToString();
                String string7 = lDAPException.getLDAPErrorMessage();
                if (string7 != null && string7.length() > 0) {
                    string6 = string6 + ". " + string7;
                }
                String[] stringArray = new String[]{string6};
                DSUtil.showErrorDialog((Component)this._model.getFrame(), "error-mod-legacy", stringArray, _section, _resource);
                this.checkOkay();
                return;
            }
        }
        this._saveDN = this._dnText.getText();
        this._savePwd = new String(this._pwdText.getPassword());
        this.checkOkay();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (!this._isInitialized) {
            return;
        }
        this.checkOkay();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this._cbEnable)) {
            this.checkOkay();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.checkOkay();
    }

    private void checkPwd() {
        String string = new String(this._pwdText.getPassword());
        String string2 = new String(this._againText.getPassword());
        this._isPasswdOK = string.length() == 0 && string2.length() == 0 || string.length() >= 8 && string2.length() >= 8 && string.compareTo(string2) == 0;
        boolean bl = this._isPwdDirty = !string.equals(this._savePwd);
        if (this._isPasswdOK) {
            if (this._isPwdDirty) {
                this.setChangeState(this._pwdLabel, 2);
                this.setChangeState(this._againLabel, 2);
            } else {
                this.setChangeState(this._pwdLabel, 1);
                this.setChangeState(this._againLabel, 1);
            }
        } else {
            this.setChangeState(this._pwdLabel, 3);
            this.setChangeState(this._againLabel, 3);
        }
    }

    private void checkDN() {
        this._isDNDirty = !DSUtil.equalDNs(this._dnText.getText(), this._saveDN);
        this._isDNOK = DSUtil.isValidDN(this._dnText.getText());
        if (this._isDNOK) {
            if (this._isDNDirty) {
                this.setChangeState(this._dnLabel, 2);
            } else {
                this.setChangeState(this._dnLabel, 1);
            }
        } else {
            this.setChangeState(this._dnLabel, 3);
        }
    }

    private void checkEnable() {
        boolean bl = this._isEnableDirty = this._cbEnable.isSelected() != this._entryExists;
        if (this._isEnableDirty) {
            this.setChangeState(this._cbEnable, 2);
        } else {
            this.setChangeState(this._cbEnable, 1);
        }
    }

    private void checkOkay() {
        this.checkEnabledField();
        this.checkPwd();
        this.checkDN();
        this.checkEnable();
        this._isValid = this._isPasswdOK && this._isDNOK || !this._cbEnable.isSelected();
        boolean bl = this._isDirty = !(!this._isPwdDirty && !this._isDNDirty && !this._isEnableDirty || !this._isEnableDirty && !this._cbEnable.isSelected());
        if (this._mustDelete) {
            this.setDirtyFlag();
            this.setValidFlag();
        } else {
            if (this._isDirty) {
                this.setDirtyFlag();
            } else {
                this.clearDirtyFlag();
            }
            if (this._isValid) {
                this.setValidFlag();
            } else {
                this.clearValidFlag();
            }
        }
    }

    private void checkStatus() {
        this._mustDelete = this._entryExists && !this._cbEnable.isSelected();
        this._isLegacyConsumerEnabled = this._cbEnable.isSelected();
    }

    private void clearPWDFields() {
        ((JTextComponent)this._pwdText).setText("");
        ((JTextComponent)this._againText).setText("");
    }

    private void checkEnabledField() {
        this.checkStatus();
        this._dnLabel.setEnabled(this._isLegacyConsumerEnabled);
        this._dnText.setEnabled(this._isLegacyConsumerEnabled);
        this._pwdText.setBackground(this._dnText.getBackground());
        this._againText.setBackground(this._dnText.getBackground());
        this._pwdLabel.setEnabled(this._isLegacyConsumerEnabled);
        this._pwdText.setEnabled(this._isLegacyConsumerEnabled);
        this._againLabel.setEnabled(this._isLegacyConsumerEnabled);
        this._againText.setEnabled(this._isLegacyConsumerEnabled);
    }
}

