/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel.replication;

import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.DSTabbedPanel;
import com.netscape.admin.dirserv.panel.replication.AgreementAttributePanel;
import com.netscape.admin.dirserv.panel.replication.AgreementDestinationPanel;
import com.netscape.admin.dirserv.panel.replication.AgreementInfoPanel;
import com.netscape.admin.dirserv.panel.replication.AgreementSchedulePanel;
import com.netscape.admin.dirserv.panel.replication.AgreementWizardInfo;
import com.netscape.admin.dirserv.panel.replication.IAgreementPanel;
import com.netscape.admin.dirserv.panel.replication.ITabPanel;
import com.netscape.admin.dirserv.panel.replication.MMRAgreement;
import com.netscape.admin.dirserv.panel.replication.ReplicationAgreement;
import com.netscape.admin.dirserv.panel.replication.ReplicationTool;
import com.netscape.admin.dirserv.panel.replication.SIRAgreement;
import com.netscape.admin.dirserv.panel.replication.ServerInstance;
import com.netscape.management.client.util.ResourceSet;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;

public class AgreementPanel
extends DSTabbedPanel
implements IAgreementPanel {
    ReplicationAgreement _agreement;
    JFrame _frame;
    IDSModel _model;
    JTabbedPane _tabbedPanel;
    AgreementInfoPanel _infoTab;
    AgreementSchedulePanel _scheduleTab;
    AgreementDestinationPanel _destTab;
    AgreementAttributePanel _attrTab;
    public static ResourceSet _resource = new ResourceSet("com.netscape.admin.dirserv.panel.replication.replication");

    AgreementPanel(JFrame jFrame, IDSModel iDSModel, ReplicationAgreement replicationAgreement) {
        super(iDSModel);
        this._frame = jFrame;
        this._agreement = replicationAgreement;
        this._model = iDSModel;
        this._tabbedPanel = this._tabbedPane;
        this._infoTab = new AgreementInfoPanel(this, 0);
        this._scheduleTab = new AgreementSchedulePanel(this, 1);
        this._destTab = new AgreementDestinationPanel(this, 2);
        this.addTab(this._infoTab);
        this.addTab(this._scheduleTab);
        this.addTab(this._destTab);
        if (this._agreement.getAgreementType() == 2) {
            // empty if block
        }
        this._tabbedPane.setSelectedIndex(0);
        this._infoTab.invalidate();
        this._infoTab.validate();
        this._infoTab.repaint(1L);
        this._tabbedPane.invalidate();
        this._tabbedPane.validate();
        this._tabbedPane.repaint(1L);
    }

    public void okCallback() {
        ITabPanel iTabPanel;
        AgreementWizardInfo agreementWizardInfo = new AgreementWizardInfo();
        ServerInstance serverInstance = new ServerInstance(this._model.getServerInfo().getHost(), this._model.getServerInfo().getPort());
        if (this._agreement.getAgreementType() == 2) {
            agreementWizardInfo.setAgreementType("MMR");
        } else {
            agreementWizardInfo.setAgreementType("LEGACYR");
        }
        agreementWizardInfo.setFromServer(serverInstance);
        ServerInstance serverInstance2 = new ServerInstance(this._agreement.getConsumerHost(), this._agreement.getConsumerPort());
        agreementWizardInfo.setToServer(serverInstance2);
        agreementWizardInfo.setSubtree(this._agreement.getReplicatedSubtree());
        agreementWizardInfo.setSSL(this._agreement.getUseSSL());
        if (this._agreement.getBindDN() != null && this._agreement.getBindCredentials() != null) {
            agreementWizardInfo.setBindDN(this._agreement.getBindDN());
            agreementWizardInfo.setBindPWD(this._agreement.getBindCredentials());
        } else {
            agreementWizardInfo.setBindDN("");
            agreementWizardInfo.setBindPWD("");
        }
        if (this._agreement.getEntryFilter() != null) {
            agreementWizardInfo.setFilter(this._agreement.getEntryFilter());
        } else {
            agreementWizardInfo.setFilter("");
        }
        if (this._agreement.getSelectedAttributes() != null) {
            agreementWizardInfo.setSelectedAttr(this._agreement.getSelectedAttributes());
        }
        agreementWizardInfo.setAttrType(this._agreement.getSelattrType());
        if (this._agreement.getUpdateSchedule() != null) {
            agreementWizardInfo.setDate(this._agreement.getUpdateSchedule());
        }
        agreementWizardInfo.setDescription(this._agreement.getDescription());
        int n = 0;
        while (n < this._tabbedPane.getTabCount()) {
            BlankPanel blankPanel = (BlankPanel)this._tabbedPane.getComponentAt(n);
            iTabPanel = (ITabPanel)((Object)this._tabbedPane.getComponentAt(n));
            if (blankPanel.isDirty()) {
                if (iTabPanel.validateEntries()) {
                    iTabPanel.getUpdateInfo(agreementWizardInfo);
                } else {
                    this._tabbedPane.setSelectedIndex(n);
                    return;
                }
            }
            ++n;
        }
        if (this.saveAgreement(agreementWizardInfo)) {
            int n2 = 0;
            while (n2 < this._tabbedPane.getTabCount()) {
                iTabPanel = (ITabPanel)((Object)this._tabbedPane.getComponentAt(n2));
                iTabPanel.okCallback();
                ++n2;
            }
        }
    }

    private boolean saveAgreement(AgreementWizardInfo agreementWizardInfo) {
        boolean bl;
        ReplicationAgreement replicationAgreement;
        if (this._agreement.getAgreementType() == 2) {
            replicationAgreement = (MMRAgreement)this._agreement;
            replicationAgreement.setConsumerHost(agreementWizardInfo.getToServer().getHost());
            replicationAgreement.setConsumerPort(agreementWizardInfo.getToServer().getPort());
        } else {
            replicationAgreement = (SIRAgreement)this._agreement;
            replicationAgreement.setConsumerHost(agreementWizardInfo.getToServer().getHost());
            replicationAgreement.setConsumerPort(agreementWizardInfo.getToServer().getPort());
            if (!agreementWizardInfo.getFilter().equals("")) {
                replicationAgreement.setEntryFilter(agreementWizardInfo.getFilter());
            } else {
                replicationAgreement.setEntryFilter(null);
            }
            replicationAgreement.setSelattrType(agreementWizardInfo.getAttrType());
            replicationAgreement.setSelectedAttributes(agreementWizardInfo.getSelectedAttr());
        }
        this._agreement.setDescription(agreementWizardInfo.getDescription());
        this._agreement.setReplicatedSubtree(agreementWizardInfo.getSubtree());
        this._agreement.setUpdateSchedule(agreementWizardInfo.getDate());
        this._agreement.setUseSSL(agreementWizardInfo.getSSL());
        this._agreement.setUseSSLAuth(agreementWizardInfo.getSSLAuth());
        if (agreementWizardInfo.getBindDN().equals("")) {
            this._agreement.setBindDN(null);
        } else {
            this._agreement.setBindDN(agreementWizardInfo.getBindDN());
        }
        boolean bl2 = bl = this._destTab != null && this._destTab.isInitialized() && this._destTab.isPwdDirty();
        if (!bl) {
            this._agreement.setBindCredentials(null);
        } else {
            this._agreement.setBindCredentials(agreementWizardInfo.getBindPWD());
        }
        int n = this._agreement.writeAgreementToServer();
        if (n != 0) {
            ReplicationTool.displayError(n);
            return false;
        }
        return true;
    }

    public Object getAgreement() {
        return this._agreement;
    }

    public IDSModel getModel() {
        return this._model;
    }

    public JTabbedPane getTabbedPane() {
        return this._tabbedPanel;
    }

    public JFrame getFrame() {
        return this._frame;
    }

    public Object getInfoTab() {
        return this._infoTab;
    }
}

