/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel.replication;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.panel.DSEntryBoolean;
import com.netscape.admin.dirserv.panel.DSEntryTextStrict;
import com.netscape.admin.dirserv.panel.replication.AgreementInfoPanel;
import com.netscape.admin.dirserv.panel.replication.AgreementWizardInfo;
import com.netscape.admin.dirserv.panel.replication.IAgreementPanel;
import com.netscape.admin.dirserv.panel.replication.ITabPanel;
import com.netscape.admin.dirserv.panel.replication.ReplicationBlankPanel;
import com.netscape.admin.dirserv.panel.replication.ReplicationTool;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;

public class AgreementDestinationPanel
extends ReplicationBlankPanel
implements ActionListener,
ItemListener,
ITabPanel,
DocumentListener {
    private ConsoleInfo _serverInfo;
    private ConsoleInfo _consoleInfo;
    private AgreementInfoPanel _monitor;
    private Hashtable _dsInstances;
    private JTabbedPane _tabbedPanel;
    private Hashtable _baseSuffixes = null;
    JTextField _bindText;
    private JCheckBox _sslEncrypt;
    private JRadioButton _simpAuth;
    private JRadioButton _sslAuth;
    JPasswordField _pwdText;
    private JLabel _bind;
    private JLabel _pwd;
    private JFrame _frame;
    private ImageIcon _icon;
    private bindDSEntry _bindDSEntry;
    private DSEntryTextStrict _pwdDSEntry;
    private DSEntryBoolean _sslDSEntry;
    private DSEntryBoolean _sslAuthDSEntry;
    private DSEntryBoolean _simpAuthDSEntry;
    private String _origBindDN;
    private String _origPwd;
    private String _portAttr = "nsserverport";
    private static final int CONTINUE = 0;
    private static final int PROMPT = 1;
    private static final int SKIP = 3;
    public static ResourceSet _resource = new ResourceSet("com.netscape.admin.dirserv.panel.replication.replication");
    private static final String _section = "replication-destination-dialog";
    private static final String DSClass = "nsDirectoryServer";
    private static final String NSClass = "netscapeServer";
    private static final String ATTR_PORT = "nsserverport";
    private static final String ATTR_SSL_PORT = "nssecureserverport";

    public AgreementDestinationPanel(IAgreementPanel iAgreementPanel, int n) {
        super(iAgreementPanel, n);
        this.setTitle(_resource.getString("replication-destination-tab", "label"));
        this._monitor = (AgreementInfoPanel)iAgreementPanel.getInfoTab();
        this._consoleInfo = this._model.getConsoleInfo();
        this._serverInfo = this._model.getServerInfo();
        this._frame = this._model.getFrame();
        this._dsInstances = new Hashtable();
        this._icon = ReplicationTool.getImage("directory.gif");
        this._helpToken = "configuration-replication-content-help";
        this._refreshWhenSelect = false;
    }

    public void init() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this._myPanel.setLayout(new GridBagLayout());
        this._myPanel.setBackground(this.getBackground());
        this._sslEncrypt = this.makeJCheckBox(_resource.getString("replication-destination-sslEncrypt", "label"));
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        this._myPanel.add((Component)this._sslEncrypt, gridBagConstraints);
        this._sslDSEntry = new DSEntryBoolean("off", this._sslEncrypt);
        this.setComponentTable(this._sslEncrypt, this._sslDSEntry);
        JLabel jLabel = this.makeJLabel(_resource.getString("replication-destination-authUsing", "label"));
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        this._myPanel.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jLabel.setLabelFor(jPanel);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this._myPanel.add((Component)jPanel, gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        this._sslAuth = this.makeJRadioButton(_resource.getString("replication-destination-sslClientAuth", "label"));
        buttonGroup.add(this._sslAuth);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this._sslAuth, gridBagConstraints);
        this._sslAuthDSEntry = new DSEntryBoolean("off", this._sslAuth);
        this.setComponentTable(this._sslAuth, this._sslAuthDSEntry);
        this._simpAuth = this.makeJRadioButton(_resource.getString("replication-destination-simpleAuth", "label"));
        buttonGroup.add(this._simpAuth);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this._simpAuth, gridBagConstraints);
        this._simpAuthDSEntry = new DSEntryBoolean("on", this._simpAuth);
        this.setComponentTable(this._simpAuth, this._simpAuthDSEntry);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this._bind = this.makeJLabel(_resource.getString("replication-destination-bindAs", "label"));
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.left += 20;
        jPanel2.add((Component)this._bind, gridBagConstraints);
        this._bindText = this.makeJTextField(10);
        this._bind.setLabelFor(this._bindText);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.insets.right = gridBagConstraints.insets.left;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this._bindText, gridBagConstraints);
        this._bindDSEntry = new bindDSEntry("", this._bindText, this._bind);
        this.setComponentTable(this._bindText, this._bindDSEntry);
        this._pwd = this.makeJLabel(_resource.getString("replication-destination-bindPwd", "label"));
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets.left += 20;
        gridBagConstraints.fill = 0;
        jPanel2.add((Component)this._pwd, gridBagConstraints);
        this._pwdText = this.makeJPasswordField(10);
        this._pwd.setLabelFor(this._pwdText);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.insets.right = gridBagConstraints.insets.left;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this._pwdText, gridBagConstraints);
        this._pwdDSEntry = new DSEntryTextStrict("", this._pwdText, this._pwd);
        this.setComponentTable(this._pwdText, this._pwdDSEntry);
        this.addBottomGlue();
        this.initialize();
        this.enableFields();
    }

    private void enableFields() {
        this._sslEncrypt.setEnabled(false);
        this._sslAuth.setEnabled(this._sslEncrypt.isSelected());
        this._simpAuth.setEnabled(this._sslEncrypt.isSelected());
    }

    public boolean refresh() {
        this.resetCallback();
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this._sslAuth) && this._sslAuth.isSelected()) {
            this.enableSimpleAuth(false);
        }
        if (actionEvent.getSource().equals(this._simpAuth) && this._simpAuth.isSelected()) {
            this.enableSimpleAuth(true);
        }
        if (actionEvent.getSource().equals(this._sslEncrypt)) {
            this.setDirtyFlag();
            if (this._sslEncrypt.isSelected()) {
                this._sslAuth.setEnabled(true);
                this._portAttr = ATTR_SSL_PORT;
            } else {
                this._sslAuth.setEnabled(false);
                this._simpAuth.setSelected(true);
                this.enableSimpleAuth(true);
                this._portAttr = ATTR_PORT;
            }
        }
        super.actionPerformed(actionEvent);
    }

    static void showErrorDialog(JFrame jFrame, String string, String string2) {
        DSUtil.showErrorDialog((Component)jFrame, string, "", string2, _resource);
    }

    public boolean validateEntries() {
        return true;
    }

    public void getUpdateInfo(Object object) {
        AgreementWizardInfo agreementWizardInfo = (AgreementWizardInfo)object;
        if (this._sslEncrypt.isSelected()) {
            agreementWizardInfo.setSSL(true);
        } else {
            agreementWizardInfo.setSSL(false);
        }
        if (!this._sslAuth.isSelected()) {
            agreementWizardInfo.setBindDN(this._bindText.getText());
            agreementWizardInfo.setBindPWD(this._pwdText.getText());
            agreementWizardInfo.setSSLAuth(false);
        } else {
            agreementWizardInfo.setBindDN("");
            agreementWizardInfo.setBindPWD("");
            agreementWizardInfo.setSSLAuth(true);
        }
    }

    protected void populateData() {
        this.copyData();
    }

    private void copyData() {
        if (this._agreement.getBindCredentials() != null && this._agreement.getBindDN() != null) {
            this._pwdDSEntry.fakeInitModel(this._agreement.getBindCredentials());
            this._bindDSEntry.fakeInitModel(this._agreement.getBindDN());
            this._origPwd = this._agreement.getBindCredentials();
            this._origBindDN = this._agreement.getBindDN();
        }
        if (this._agreement.getUseSSL()) {
            this._sslDSEntry.fakeInitModel("on");
            this._sslEncrypt.setSelected(true);
            this._portAttr = ATTR_SSL_PORT;
            if (this._agreement.getUseSSLAuth()) {
                this.enableSimpleAuth(false);
                this._sslAuth.setEnabled(true);
                this._sslAuthDSEntry.fakeInitModel("on");
                this._simpAuthDSEntry.fakeInitModel("off");
            } else {
                this._sslAuth.setEnabled(true);
                this._simpAuth.setSelected(true);
                this._simpAuthDSEntry.fakeInitModel("on");
                this.enableSimpleAuth(true);
            }
        } else {
            this._portAttr = ATTR_PORT;
            this.setSimpAuth();
        }
    }

    private void setSimpAuth() {
        this._sslDSEntry.fakeInitModel("off");
        this._sslAuth.setEnabled(false);
        this._simpAuthDSEntry.fakeInitModel("on");
    }

    private void enableSimpleAuth(boolean bl) {
        this._bind.setEnabled(bl);
        this._bind.repaint(1L);
        this._bindText.setEnabled(bl);
        this._bindText.repaint(1L);
        this._pwd.setEnabled(bl);
        this._pwd.repaint(1L);
        this._pwdText.setEnabled(bl);
        if (bl) {
            this._pwdText.setBackground(this._bindText.getBackground());
        } else {
            this._pwdText.setBackground(this.getBackground());
        }
    }

    public boolean isPwdDirty() {
        return this._pwdDSEntry.getDirty();
    }

    class bindDSEntry
    extends DSEntryTextStrict {
        bindDSEntry(String string, JComponent jComponent, JComponent jComponent2) {
            super(string, jComponent, jComponent2);
        }

        public int validate() {
            JTextField jTextField = (JTextField)this.getView(0);
            String string = jTextField.getText();
            if (!jTextField.isEnabled()) {
                return 0;
            }
            if (!string.equals("") && DSUtil.isValidDN(string)) {
                return 0;
            }
            return 1;
        }
    }
}

