/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.AttrTableModel;
import com.netscape.admin.dirserv.panel.SchemaAttributesPanel;
import com.netscape.admin.dirserv.panel.UIFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import netscape.ldap.LDAPMatchingRuleSchema;
import netscape.ldap.LDAPSchema;

public class SchemaMatchingRulesPanel
extends SchemaAttributesPanel
implements ListSelectionListener {
    private JButton _helpButton = null;
    private JTable _stdTable = null;
    private AttrTableModel _stdTableModel = null;
    private static int[] _widths = new int[]{190, 155, 90, 65};
    private static int TABLE_ROWS = 18;
    private static final String _section = "matchingrules";
    private static Hashtable _htSyntaxStrings = null;

    public SchemaMatchingRulesPanel(IDSModel iDSModel) {
        super(iDSModel, _section, false);
        this._helpToken = "configuration-schema-mrule-help";
        _htSyntaxStrings = SchemaAttributesPanel.getSyntaxStrings(this.getModel().getSchema());
        this._refreshWhenSelect = false;
    }

    public void init() {
        this.getModel().setWaitCursor(true);
        EmptyBorder emptyBorder = new EmptyBorder(this.getBorderInsets());
        this._myPanel.setBorder(emptyBorder);
        this._myPanel.setLayout(new GridBagLayout());
        this.resetGBC();
        JLabel jLabel = this.makeJLabel(_section, "intro");
        this._gbc.gridwidth = 0;
        this._gbc.insets = new Insets(0, 0, UIFactory.getDifferentSpace(), 0);
        this._myPanel.add((Component)jLabel, this._gbc);
        JComponent jComponent = this.createAttributeListArea(this._myPanel);
        jLabel.setLabelFor(this._stdTable);
        this.populateTables();
        JComponent jComponent2 = this.createButtonsPanel();
        this.resetGBC();
        this._gbc.fill = 2;
        this._gbc.gridwidth = 0;
        this._gbc.weightx = 1.0;
        int n = UIFactory.getDifferentSpace();
        this._gbc.weighty = 0.0;
        this._gbc.insets.top = n;
        this._myPanel.add((Component)jComponent2, this._gbc);
        this.getModel().setWaitCursor(false);
    }

    protected JComponent createAttributeListArea(Container container) {
        this.resetGBC();
        this._gbc.gridwidth = 0;
        this._gbc.anchor = 17;
        this._gbc.fill = 2;
        String string = new String();
        Object[][] objectArray = new Object[][]{{DSUtil._resource.getString(_section, "namecolumn-label"), string.getClass()}, {DSUtil._resource.getString(_section, "oidcolumn-label"), string.getClass()}, {DSUtil._resource.getString(_section, "syntaxcolumn-label"), string.getClass()}, {DSUtil._resource.getString(_section, "description-label"), string.getClass()}};
        this._stdTableModel = new AttrTableModel(objectArray);
        this._stdTable = new JTable(this._stdTableModel);
        this.setColumnWidths(this._stdTable, _widths);
        Dimension dimension = new Dimension();
        dimension.height = this._stdTable.getRowHeight() * TABLE_ROWS + 8;
        dimension.width = 0;
        int n = 0;
        while (n < _widths.length) {
            dimension.width += _widths[n];
            ++n;
        }
        this._gbc.fill = 1;
        this._gbc.weighty = 0.7;
        this._gbc.weightx = 1.0;
        JScrollPane jScrollPane = this.addTableInScrollPane(this._stdTable, container, dimension);
        return jScrollPane;
    }

    protected void populateTables() {
        this._stdTableModel.removeAllRows();
        LDAPSchema lDAPSchema = this.getModel().getSchema();
        if (lDAPSchema == null) {
            return;
        }
        LDAPSchema lDAPSchema2 = lDAPSchema;
        synchronized (lDAPSchema2) {
            Enumeration enumeration = lDAPSchema.getMatchingRules();
            while (enumeration.hasMoreElements()) {
                LDAPMatchingRuleSchema lDAPMatchingRuleSchema = (LDAPMatchingRuleSchema)enumeration.nextElement();
                this.addAttributeRow(lDAPMatchingRuleSchema);
            }
        }
        this.setColumnWidths(this._stdTable, _widths);
        this._stdTable.repaint();
    }

    private void addAttributeRow(LDAPMatchingRuleSchema lDAPMatchingRuleSchema) {
        Object[] objectArray = new Object[]{lDAPMatchingRuleSchema.getName(), lDAPMatchingRuleSchema.getID(), _htSyntaxStrings != null ? (String)_htSyntaxStrings.get(lDAPMatchingRuleSchema.getSyntaxString()) : "", lDAPMatchingRuleSchema.getDescription()};
        this._stdTableModel.addRow(objectArray);
    }

    protected JComponent createButtonsPanel() {
        this._helpButton = this.makeJButton("general", "Help");
        JButton[] jButtonArray = new JButton[]{this._helpButton};
        return UIFactory.makeJButtonPanel(jButtonArray);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this._helpButton)) {
            this.helpCallback();
        }
    }

    protected void setColumnWidths(JTable jTable, int[] nArray) {
        if (jTable == null) {
            return;
        }
        Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setWidth(nArray[n]);
            tableColumn.setResizable(true);
            ++n;
        }
    }
}

