/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.DSEntryBoolean;
import com.netscape.admin.dirserv.panel.DSEntryCombo;
import com.netscape.admin.dirserv.panel.DSEntryInteger;
import com.netscape.admin.dirserv.panel.DSEntrySet;
import com.netscape.admin.dirserv.panel.DSEntryWarning;
import com.netscape.admin.dirserv.panel.GroupPanel;
import com.netscape.admin.dirserv.panel.IDSEntry;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;

public class PasswordPolicyPanel
extends BlankPanel {
    private JCheckBox _cbReset;
    private JCheckBox _cbMayChange;
    private JCheckBox _cbCheckSyntax;
    private JLabel _minLengthLabel;
    private JTextField _tfMinLengthValue;
    private JRadioButton _rbNever;
    private JRadioButton _rbExpiresIn;
    private JTextField _tfExpiresInValue;
    private JTextField _tfSendWarningValue;
    private JLabel _expiresInLabel;
    private JLabel _sendWarningLabel1;
    private JLabel _sendWarningLabel2;
    private JTextField _tfMinAgeValue;
    private JCheckBox _cbKeepHistory;
    private JTextField _tfRememberValue;
    private JLabel _rememberLabel1;
    private JLabel _rememberLabel2;
    private JRadioButton _rbNoLockout;
    private JRadioButton _rbLockout;
    private JTextField _tfLockoutValue;
    private JTextField _tfResetAfterValue;
    private JRadioButton _rbLockoutForever;
    private JRadioButton _rbLockoutMinutes;
    private JTextField _tfLockoutMinutesValue;
    private JLabel _lStorageScheme;
    private JComboBox _cbStorageScheme;
    private static final String CHANGE_DN = "cn=config";
    private static final String MUST_CHANGE_ATTR_NAME = "passwordMustChange";
    private static final String CHANGE_ATTR_NAME = "passwordChange";
    private static final String SYNTAX_DN = "cn=config";
    private static final String SYNTAX_ATTR_NAME = "passwordCheckSyntax";
    private static final String MINLENGTH_DN = "cn=config";
    private static final String MINLENGTH_ATTR_NAME = "passwordMinLength";
    private static final int MINLENGTH_MIN_VAL = 2;
    private static final int MINLENGTH_MAX_VAL = 512;
    private static final String EXPIRES_DN = "cn=config";
    private static final String EXPIRES_ATTR_NAME = "passwordExp";
    private static final String EXPIRES_AGE_DN = "cn=config";
    private static final String EXPIRES_AGE_ATTR_NAME = "passwordMaxAge";
    private static final int EXPIRES_AGE_MIN_VAL = 1;
    private static final int EXPIRES_AGE_MAX_VAL = 24855;
    private static final String EXPIRES_WARNING_DN = "cn=config";
    private static final String EXPIRES_WARNING_ATTR_NAME = "passwordWarning";
    private static final int EXPIRES_WARNING_MIN_VAL = 1;
    private static final int EXPIRES_WARNING_MAX_VAL = 24855;
    private static final String MIN_AGE_DN = "cn=config";
    private static final String MIN_AGE_ATTR_NAME = "passwordMinAge";
    private static final int MIN_AGE_MIN_VAL = 0;
    private static final int MIN_AGE_MAX_VAL = 24855;
    private static final String HISTORY_DN = "cn=config";
    private static final String HISTORY_ATTR_NAME = "passwordHistory";
    private static final String HISTORY_NUM_DN = "cn=config";
    private static final String HISTORY_NUM_ATTR_NAME = "passwordInHistory";
    private static final int HISTORY_NUM_MIN_VAL = 2;
    private static final int HISTORY_NUM_MAX_VAL = 24;
    private static final int DAY_TO_SEC_FACTOR = 86400;
    private static final String STORAGE_DN = "cn=config";
    private static final String STORAGE_SCHEME_ATTR_NAME = "passwordStorageScheme";
    private static final String PLUGIN_TYPE_ATTR_NAME = "nsslapd-plugintype";
    private static final String DESCRIPTION_ATTR_NAME = "nsslapd-plugindescription";
    private static final String PWDSTORAGE = "pwdstoragescheme";
    private static final String CN_ATTR_NAME = "cn";
    private static final String MANAGER_DN = "cn=config";
    private String[] COMBO_ENTRIES;
    private String[] COMBO_DESCRIPTION;
    private final String[] COMBO_ENTRIES_HARDCOPY = new String[]{"sha", "clear", "crypt"};
    private ResourceSet _resource = DSUtil._resource;
    private final String[] COMBO_DESCRIPTION_HARDCOPY = new String[]{this._resource.getString("passwordpolicy-storageScheme", "1"), this._resource.getString("passwordpolicy-storageScheme", "2"), this._resource.getString("passwordpolicy-storageScheme", "3")};
    private static final String _section = "passwordpolicy";

    public PasswordPolicyPanel(IDSModel iDSModel) {
        super(iDSModel, _section);
        this._helpToken = "configuration-database-passwords-help";
        this._refreshWhenSelect = false;
    }

    public void init() {
        if (this._isInitialized) {
            return;
        }
        this._myPanel.setLayout(new GridBagLayout());
        this.createChangeArea(this._myPanel);
        this.createExpirationArea(this._myPanel);
        this.createSyntaxArea(this._myPanel);
        this.createMinLengthArea(this._myPanel);
        this.createStorageArea(this._myPanel);
        this.addBottomGlue();
        this._isInitialized = true;
    }

    public boolean refresh() {
        boolean bl = super.refresh();
        if (bl) {
            this.enableExpire();
            this.enableHistory();
            this.enableSyntax();
        }
        return bl;
    }

    protected void createChangeArea(Container container) {
        this._cbReset = this.makeJCheckBox(_section, "changereset", false);
        this._cbMayChange = this.makeJCheckBox(_section, "changemay", true);
        DSEntrySet dSEntrySet = this.getDSEntrySet();
        DSEntryBoolean dSEntryBoolean = new DSEntryBoolean("0", this._cbReset);
        dSEntrySet.add("cn=config", MUST_CHANGE_ATTR_NAME, dSEntryBoolean);
        this.setComponentTable(this._cbReset, dSEntryBoolean);
        DSEntryBoolean dSEntryBoolean2 = new DSEntryBoolean("1", this._cbMayChange);
        dSEntrySet.add("cn=config", CHANGE_ATTR_NAME, dSEntryBoolean2);
        this.setComponentTable(this._cbMayChange, dSEntryBoolean2);
        GroupPanel groupPanel = new GroupPanel(this._resource.getString(_section, "change-title"));
        GridBagConstraints gridBagConstraints = this.getGBC();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        container.add((Component)groupPanel, gridBagConstraints);
        groupPanel.setLayout(new GridBagLayout());
        gridBagConstraints.fill = 0;
        this._cbReset.setHorizontalAlignment(2);
        groupPanel.add((Component)this._cbReset, gridBagConstraints);
        this._cbMayChange.setHorizontalAlignment(2);
        groupPanel.add((Component)this._cbMayChange, gridBagConstraints);
        this._tfMinAgeValue = this.makeNumericalJTextField(_section, "minage1");
        JLabel jLabel = this.makeJLabel(_section, "minage1");
        jLabel.setLabelFor(this._tfMinAgeValue);
        JLabel jLabel2 = this.makeJLabel(_section, "minage2");
        jLabel2.setLabelFor(this._tfMinAgeValue);
        DSEntryInteger dSEntryInteger = new DSEntryInteger(null, (JComponent)this._tfMinAgeValue, jLabel, 0, 24855, 86400);
        dSEntrySet.add("cn=config", MIN_AGE_ATTR_NAME, dSEntryInteger);
        this.setComponentTable(this._tfMinAgeValue, dSEntryInteger);
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        groupPanel.add((Component)jPanel, gridBagConstraints);
        jLabel.setHorizontalAlignment(2);
        jPanel.add(jLabel);
        int n = UIFactory.getComponentSpace();
        jPanel.add(Box.createHorizontalStrut(n));
        jPanel.add(this._tfMinAgeValue);
        jPanel.add(Box.createHorizontalStrut(n));
        jLabel2.setHorizontalAlignment(2);
        jPanel.add(jLabel2);
        this._cbKeepHistory = this.makeJCheckBox(_section, "keephistory", false);
        this._rememberLabel1 = this.makeJLabel(_section, "remember");
        this._tfRememberValue = this.makeNumericalJTextField(_section, "remember");
        this._rememberLabel1.setLabelFor(this._tfRememberValue);
        this._rememberLabel2 = this.makeJLabel(_section, "remember2");
        this._rememberLabel2.setLabelFor(this._tfRememberValue);
        DSEntryBoolean dSEntryBoolean3 = new DSEntryBoolean("0", this._cbKeepHistory);
        dSEntrySet.add("cn=config", HISTORY_ATTR_NAME, dSEntryBoolean3);
        this.setComponentTable(this._cbKeepHistory, dSEntryBoolean3);
        DSEntryInteger dSEntryInteger2 = new DSEntryInteger(null, (JComponent)this._tfRememberValue, this._rememberLabel1, 2, 24, 1);
        dSEntrySet.add("cn=config", HISTORY_NUM_ATTR_NAME, dSEntryInteger2);
        this.setComponentTable(this._tfRememberValue, dSEntryInteger2);
        this._cbKeepHistory.setHorizontalAlignment(2);
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        groupPanel.add((Component)jPanel2, gridBagConstraints);
        int n2 = UIFactory.getComponentSpace();
        int n3 = UIFactory.getSeparatedSpace();
        jPanel2.add(this._cbKeepHistory);
        jPanel2.add(Box.createHorizontalStrut(n3));
        jPanel2.add(this._rememberLabel1);
        jPanel2.add(Box.createHorizontalStrut(n2));
        jPanel2.add(this._tfRememberValue);
        jPanel2.add(Box.createHorizontalStrut(n));
        jPanel2.add(this._rememberLabel2);
    }

    protected void createSyntaxArea(Container container) {
        this._cbCheckSyntax = this.makeJCheckBox(_section, "check", false);
        DSEntrySet dSEntrySet = this.getDSEntrySet();
        DSEntryBoolean dSEntryBoolean = new DSEntryBoolean("off", this._cbCheckSyntax);
        dSEntrySet.add("cn=config", SYNTAX_ATTR_NAME, dSEntryBoolean);
        this.setComponentTable(this._cbCheckSyntax, dSEntryBoolean);
        GridBagConstraints gridBagConstraints = this.getGBC();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        container.add((Component)this._cbCheckSyntax, gridBagConstraints);
    }

    protected void createMinLengthArea(Container container) {
        this._minLengthLabel = this.makeJLabel(_section, "minlength");
        this._tfMinLengthValue = this.makeNumericalJTextField(_section, "minlength");
        this._minLengthLabel.setLabelFor(this._tfMinLengthValue);
        DSEntrySet dSEntrySet = this.getDSEntrySet();
        DSEntryInteger dSEntryInteger = new DSEntryInteger("", (JComponent)this._tfMinLengthValue, this._minLengthLabel, 2, 512, 1);
        dSEntrySet.add("cn=config", MINLENGTH_ATTR_NAME, dSEntryInteger);
        this.setComponentTable(this._tfMinLengthValue, dSEntryInteger);
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        GridBagConstraints gridBagConstraints = this.getGBC();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        container.add((Component)jPanel, gridBagConstraints);
        jPanel.add(this._minLengthLabel);
        int n = UIFactory.getComponentSpace();
        jPanel.add(Box.createHorizontalStrut(n));
        jPanel.add(this._tfMinLengthValue);
    }

    protected void createExpirationArea(Container container) {
        ButtonGroup buttonGroup = new ButtonGroup();
        this._rbNever = this.makeJRadioButton(_section, "neverexpire", true);
        buttonGroup.add(this._rbNever);
        this._rbExpiresIn = this.makeJRadioButton(_section, "expires");
        buttonGroup.add(this._rbExpiresIn);
        this._tfExpiresInValue = this.makeNumericalJTextField(_section, "expiresin");
        this._expiresInLabel = this.makeJLabel(_section, "expiresin");
        this._expiresInLabel.setLabelFor(this._tfExpiresInValue);
        this._sendWarningLabel1 = this.makeJLabel(_section, "sendwarning");
        this._tfSendWarningValue = this.makeNumericalJTextField(_section, "sendwarning");
        this._sendWarningLabel1.setLabelFor(this._tfSendWarningValue);
        this._sendWarningLabel2 = this.makeJLabel(_section, "sendwarning2");
        this._sendWarningLabel2.setLabelFor(this._tfSendWarningValue);
        DSEntrySet dSEntrySet = this.getDSEntrySet();
        DSEntryExpire dSEntryExpire = new DSEntryExpire("0", this._rbExpiresIn);
        dSEntrySet.add("cn=config", EXPIRES_ATTR_NAME, dSEntryExpire);
        this.setComponentTable(this._rbExpiresIn, dSEntryExpire);
        DSEntryInteger dSEntryInteger = new DSEntryInteger(null, (JComponent)this._tfExpiresInValue, this._expiresInLabel, 1, 24855, 86400);
        dSEntrySet.add("cn=config", EXPIRES_AGE_ATTR_NAME, dSEntryInteger);
        this.setComponentTable(this._tfExpiresInValue, dSEntryInteger);
        DSEntryWarning dSEntryWarning = new DSEntryWarning(null, this._tfSendWarningValue, (JComponent)this._sendWarningLabel1, 1, 24855, 86400, this._tfExpiresInValue);
        dSEntrySet.add("cn=config", EXPIRES_WARNING_ATTR_NAME, dSEntryWarning);
        this.setComponentTable(this._tfSendWarningValue, dSEntryWarning);
        GroupPanel groupPanel = new GroupPanel(this._resource.getString(_section, "expiration-title"));
        groupPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = this.getGBC();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        container.add((Component)groupPanel, gridBagConstraints);
        gridBagConstraints.fill = 0;
        this._rbNever.setHorizontalAlignment(2);
        groupPanel.add((Component)this._rbNever, gridBagConstraints);
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        groupPanel.add((Component)jPanel, gridBagConstraints);
        this._rbExpiresIn.setHorizontalAlignment(2);
        jPanel.add(this._rbExpiresIn);
        jPanel.add(this._tfExpiresInValue);
        int n = UIFactory.getComponentSpace();
        jPanel.add(Box.createHorizontalStrut(n));
        jPanel.add(this._expiresInLabel);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        groupPanel.add((Component)jPanel2, gridBagConstraints);
        this._sendWarningLabel1.setHorizontalAlignment(2);
        jPanel2.add(this._sendWarningLabel1);
        jPanel2.add(this._tfSendWarningValue);
        this._sendWarningLabel2.add(Box.createHorizontalStrut(n));
        this._sendWarningLabel2.setHorizontalAlignment(2);
        jPanel2.add(this._sendWarningLabel2);
    }

    protected void createStorageArea(Container container) {
        Object object;
        this._cbStorageScheme = this.makeJComboBox();
        this._lStorageScheme = this.makeJLabel(_section, "storageScheme");
        this._lStorageScheme.setLabelFor(this._cbStorageScheme);
        DSEntrySet dSEntrySet = this.getDSEntrySet();
        this.findPasswordPlugins();
        if (this.COMBO_ENTRIES == null || this.COMBO_ENTRIES.length == 0) {
            Debug.println((String)"PasswordPolicyPanel.init(): we are not creating the right thing");
            this.COMBO_ENTRIES = this.COMBO_ENTRIES_HARDCOPY;
            this.COMBO_DESCRIPTION = this.COMBO_DESCRIPTION_HARDCOPY;
        }
        int n = 0;
        while (n < this.COMBO_ENTRIES.length) {
            object = this.COMBO_DESCRIPTION[n];
            if (((String)object).equals("")) {
                object = this.COMBO_ENTRIES[n];
            }
            this._cbStorageScheme.addItem(object);
            ++n;
        }
        object = new DSEntryCombo(this.COMBO_ENTRIES, this._cbStorageScheme, this._lStorageScheme, true);
        dSEntrySet.add("cn=config", STORAGE_SCHEME_ATTR_NAME, (IDSEntry)object);
        this.setComponentTable(this._cbStorageScheme, object);
        GridBagConstraints gridBagConstraints = this.getGBC();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        container.add((Component)jPanel, gridBagConstraints);
        jPanel.add(this._lStorageScheme);
        int n2 = UIFactory.getComponentSpace();
        jPanel.add(Box.createHorizontalStrut(n2));
        jPanel.add(this._cbStorageScheme);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this._cbCheckSyntax)) {
            this.enableSyntax();
        } else if (actionEvent.getSource().equals(this._cbKeepHistory)) {
            this.enableHistory();
        } else if (actionEvent.getSource().equals(this._rbExpiresIn) || actionEvent.getSource().equals(this._rbNever)) {
            this.enableExpire();
        }
        super.actionPerformed(actionEvent);
    }

    private void enableHistory() {
        boolean bl = this._cbKeepHistory.isSelected();
        this._rememberLabel1.setEnabled(bl);
        this._rememberLabel1.repaint();
        this._tfRememberValue.setEnabled(bl);
        this._tfRememberValue.repaint();
        this._rememberLabel2.setEnabled(bl);
        this._rememberLabel2.repaint();
    }

    private void enableSyntax() {
        boolean bl = this._cbCheckSyntax.isSelected();
        this._minLengthLabel.setEnabled(bl);
        this._minLengthLabel.repaint();
        this._tfMinLengthValue.setEnabled(bl);
        this._tfMinLengthValue.repaint();
    }

    private void enableExpire() {
        boolean bl = this._rbExpiresIn.isSelected();
        this._tfExpiresInValue.setEnabled(bl);
        this._tfExpiresInValue.repaint();
        this._expiresInLabel.setEnabled(bl);
        this._expiresInLabel.repaint();
        this._sendWarningLabel1.setEnabled(bl);
        this._sendWarningLabel1.repaint();
        this._tfSendWarningValue.setEnabled(bl);
        this._tfSendWarningValue.repaint();
        this._sendWarningLabel2.setEnabled(bl);
        this._sendWarningLabel2.repaint();
    }

    private void findPasswordPlugins() {
        try {
            String string;
            Object object;
            Object object2;
            LDAPAttribute lDAPAttribute;
            LDAPEntry lDAPEntry;
            String string2 = "nsslapd-plugintype=pwdstoragescheme";
            Debug.println((String)("PasswordPolicyPanel.findPasswordPlugins: the filter is " + string2));
            String[] stringArray = new String[]{CN_ATTR_NAME, DESCRIPTION_ATTR_NAME};
            LDAPConnection lDAPConnection = this.getModel().getServerInfo().getLDAPConnection();
            if (lDAPConnection == null) {
                return;
            }
            LDAPSearchConstraints lDAPSearchConstraints = (LDAPSearchConstraints)lDAPConnection.getSearchConstraints().clone();
            lDAPSearchConstraints.setMaxResults(0);
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search("cn=plugins,cn=config", 2, string2, stringArray, false, lDAPSearchConstraints);
            Vector<String> vector = new Vector<String>();
            Vector<String> vector2 = new Vector<String>();
            while (lDAPSearchResults.hasMoreElements()) {
                lDAPEntry = (LDAPEntry)lDAPSearchResults.nextElement();
                lDAPAttribute = lDAPEntry.getAttribute(CN_ATTR_NAME);
                if (lDAPAttribute == null || ((String)(object2 = (String)(object = lDAPAttribute.getStringValues()).nextElement())).equalsIgnoreCase("ns-mta-md5")) continue;
                vector.addElement(((String)object2).toLowerCase());
                string = "";
                lDAPAttribute = lDAPEntry.getAttribute(DESCRIPTION_ATTR_NAME);
                if (lDAPAttribute != null) {
                    object = lDAPAttribute.getStringValues();
                    string = (String)object.nextElement();
                }
                vector2.addElement(string);
            }
            object = new String[]{STORAGE_SCHEME_ATTR_NAME};
            lDAPEntry = DSUtil.readEntry(lDAPConnection, "cn=config", (String[])object, lDAPSearchConstraints);
            if (lDAPEntry != null && (lDAPAttribute = lDAPEntry.getAttribute(STORAGE_SCHEME_ATTR_NAME)) != null) {
                object2 = lDAPAttribute.getStringValues();
                string = (String)object2.nextElement();
                int n = vector.indexOf(string = string.toLowerCase());
                if (n >= 0) {
                    Object e = vector.elementAt(0);
                    vector.set(n, (String)e);
                    vector.set(0, string);
                    Object e2 = vector2.elementAt(0);
                    Object e3 = vector2.elementAt(n);
                    vector2.set(n, (String)e2);
                    vector2.set(0, (String)e3);
                }
            }
            this.COMBO_ENTRIES = new String[vector.size()];
            vector.toArray(this.COMBO_ENTRIES);
            this.COMBO_DESCRIPTION = new String[vector2.size()];
            vector2.toArray(this.COMBO_DESCRIPTION);
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("PasswordPolicyPanel.findPasswordPlugins: " + (Object)((Object)lDAPException)));
        }
    }

    class DSEntryExpire
    extends DSEntryBoolean {
        public DSEntryExpire(String string, AbstractButton abstractButton) {
            super(string, abstractButton);
        }

        public void show() {
            String string = this.getModel(0);
            if (string.equals(this._trueValue)) {
                PasswordPolicyPanel.this._rbNever.setSelected(false);
                PasswordPolicyPanel.this._rbExpiresIn.setSelected(true);
            } else {
                PasswordPolicyPanel.this._rbNever.setSelected(true);
                PasswordPolicyPanel.this._rbExpiresIn.setSelected(false);
            }
            this.viewInitialized();
        }
    }
}

