/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSFileDialog;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.GroupPanel;
import com.netscape.admin.dirserv.panel.MappingUtils;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.Debug;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.util.DN;

public class NewLDBMPanel
extends BlankPanel {
    private JLabel _suffixLabel;
    private JLabel _suffixValue;
    private JTextField _instanceNameText;
    private JLabel _instanceNameLabel;
    private JTextField _mappingNameText;
    private JLabel _mappingNameLabel;
    private JTextField _NewNodeText;
    private JLabel _NewNodeLabel;
    private IDSModel _model = null;
    private JComboBox _comboNames;
    private JComboBox _comboMapping;
    private JLabel _comboLabel;
    private JTextField _tfDirDB;
    private JButton _bDirDB;
    private JButton _browseButton;
    private String _baseDir = "";
    private String _PluginLoc = "";
    private JRadioButton _rbExistingNode;
    private JRadioButton _rbNewNode;
    private JRadioButton _rbNoNode;
    private JComboBox _comboNewNodeMapping;
    private JLabel _comboNewNodeLabel;
    private boolean _dbLocChanged = false;
    private boolean _isAutoLoc = false;
    private boolean _isNewMappingNodeValid = false;
    private String _dbLoc;
    private LDAPEntry _entrySuffix;
    private String _suffix = "";
    private static final String _section = "newldbminst";
    static final String CONFIG_BASEDN = "cn=plugins, cn=config";
    static final String CONFIG_MAPPING = "cn=mapping tree, cn=config";
    static final String ROOT_MAPPING_NODE = "is root suffix";
    static final int EXISTING_NODE = 0;
    static final int NEW_NODE = 1;
    static final int NO_NODE = 2;

    public NewLDBMPanel(IDSModel iDSModel, LDAPEntry lDAPEntry) {
        super(iDSModel, _section);
        this._helpToken = "configuration-new-ldbm-instance-dbox-help";
        this._model = iDSModel;
        this._entrySuffix = lDAPEntry;
    }

    public void init() {
        AbstractDialog abstractDialog;
        this._myPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = this.getGBC();
        this.createFileArea(this._myPanel);
        String string = this.getInstanceDirectory();
        if (string != null) {
            this._baseDir = string;
        }
        if ((abstractDialog = this.getAbstractDialog()) != null) {
            abstractDialog.setOKButtonEnabled(false);
        }
    }

    protected void createFileArea(JPanel jPanel) {
        String string;
        GridBagConstraints gridBagConstraints = this.getGBC();
        gridBagConstraints.insets.bottom = this._gbc.insets.top;
        gridBagConstraints.gridwidth = 0;
        this._dbLoc = this.getDatabaseLoc();
        String[] stringArray = new String[]{this._dbLoc};
        GroupPanel groupPanel = new GroupPanel(DSUtil._resource.getString(_section, "new-ldbm-db-title"));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)groupPanel, gridBagConstraints);
        LDAPAttribute lDAPAttribute = this._entrySuffix.getAttribute("cn");
        if (lDAPAttribute != null) {
            this._suffix = MappingUtils.unQuote(lDAPAttribute.getStringValueArray()[0]);
        }
        this._suffixLabel = this.makeJLabel(_section, "suffix-name");
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        groupPanel.add((Component)this._suffixLabel, gridBagConstraints);
        this._suffixValue = new JLabel(this._suffix);
        this._suffixLabel.setLabelFor(this._suffixValue);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        groupPanel.add((Component)this._suffixValue, gridBagConstraints);
        this._instanceNameLabel = this.makeJLabel(_section, "instance-name");
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        groupPanel.add((Component)this._instanceNameLabel, gridBagConstraints);
        this._instanceNameText = this.makeJTextField(_section, "instance-name");
        this._instanceNameLabel.setLabelFor(this._instanceNameText);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        groupPanel.add((Component)this._instanceNameText, gridBagConstraints);
        this._comboNames = new JComboBox();
        this._comboNames.addItemListener(this);
        this._comboNames.addActionListener(this);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                this._comboNames.addItem(stringArray[n]);
                ++n;
            }
            if (stringArray.length > 0) {
                this._comboNames.setSelectedIndex(0);
            }
        }
        if ((string = DSUtil._resource.getString(_section, "select-dir-ttip")) != null) {
            this._comboNames.setToolTipText(string);
        }
        JLabel jLabel = this.makeJLabel(_section, "filename");
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        groupPanel.add((Component)jLabel, gridBagConstraints);
        this._tfDirDB = this.makeJTextField(_section, "filename");
        jLabel.setLabelFor(this._tfDirDB);
        if (stringArray.length > 0) {
            this._tfDirDB.setText((String)this._comboNames.getSelectedItem());
            this.setOkay(true);
        } else {
            this.setOkay(false);
        }
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        groupPanel.add((Component)this._tfDirDB, gridBagConstraints);
        this._bDirDB = this.makeJButton(_section, "browse-file");
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        groupPanel.add((Component)this._bDirDB, gridBagConstraints);
        this._bDirDB.setEnabled(true);
        this._dbLocChanged = false;
    }

    private String getDatabaseLoc() {
        String string = null;
        try {
            block4: {
                try {
                    this._model.setWaitCursor(true);
                    LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
                    LDAPSearchResults lDAPSearchResults = lDAPConnection.search(CONFIG_BASEDN, 1, "nsslapd-pluginid=ldbm-backend", null, false);
                    if (!lDAPSearchResults.hasMoreElements()) break block4;
                    LDAPEntry lDAPEntry = (LDAPEntry)lDAPSearchResults.nextElement();
                    this._PluginLoc = lDAPEntry.getDN();
                    Debug.println((String)"NewLDBMPanel.getDatabaseLoc() {");
                    Debug.println((String)("*** plugin db: " + this._PluginLoc));
                    LDAPSearchResults lDAPSearchResults2 = lDAPConnection.search(lDAPEntry.getDN(), 1, "cn=config", null, false);
                    if (!lDAPSearchResults2.hasMoreElements()) break block4;
                    LDAPEntry lDAPEntry2 = (LDAPEntry)lDAPSearchResults2.nextElement();
                    LDAPAttribute lDAPAttribute = lDAPEntry2.getAttribute("nsslapd-directory");
                    Debug.println((String)("*** nsslapd-directory =" + lDAPAttribute));
                    Enumeration enumeration = lDAPAttribute.getStringValues();
                    if (!enumeration.hasMoreElements()) break block4;
                    string = (String)enumeration.nextElement() + "/";
                }
                catch (LDAPException lDAPException) {
                    Debug.println((String)("NewLDBMPanel.init() " + (Object)((Object)lDAPException)));
                    Object var10_11 = null;
                    this._model.setWaitCursor(false);
                }
            }
            Object var10_10 = null;
            this._model.setWaitCursor(false);
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this._model.setWaitCursor(false);
            throw throwable;
        }
        return string;
    }

    private void setOkay(boolean bl) {
        AbstractDialog abstractDialog = this.getAbstractDialog();
        if (abstractDialog != null) {
            abstractDialog.setOKButtonEnabled(bl);
        }
    }

    private void checkOkay() {
        String string = this._instanceNameText.getText();
        String string2 = this.getInstancename();
        Debug.println((String)("NewLDBMPanel.checkOkay() path =" + string2));
        boolean bl = string2 != null && string2.length() > 0 && string != null && DSUtil.isValidBckName(string);
        this.setOkay(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this._bDirDB)) {
            String string = this.getDBLoc().trim();
            if (string.length() < 1) {
                string = this._baseDir;
            }
            if ((string = DSFileDialog.getDirectoryName(string, false, this)) != null) {
                this._tfDirDB.setText(string.trim());
                this._dbLocChanged = true;
            }
        } else if (actionEvent.getSource().equals(this._comboNames)) {
            if (this._tfDirDB != null) {
                this._tfDirDB.setText((String)this._comboNames.getSelectedItem());
                this.checkOkay();
            }
        } else if (actionEvent.getSource().equals(this._rbExistingNode)) {
            this.setMappingState(0);
        } else if (actionEvent.getSource().equals(this._rbNewNode)) {
            this.setMappingState(1);
        } else if (actionEvent.getSource().equals(this._rbNoNode)) {
            this.setMappingState(2);
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public int addLDBMBackend(String string) {
        String[] stringArray;
        String string2 = this._instanceNameText.getText().trim();
        LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
        Debug.println((String)"NewLDBMPanel.addLDBMBackend()");
        String string3 = "cn=" + string2 + "," + this._PluginLoc;
        LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
        String[] stringArray2 = new String[]{"top", "extensibleObject", "nsBackendInstance"};
        LDAPAttribute lDAPAttribute = new LDAPAttribute("objectclass", stringArray2);
        lDAPAttributeSet.add(lDAPAttribute);
        String[] stringArray3 = new String[]{string2};
        lDAPAttributeSet.add(new LDAPAttribute("cn", stringArray3));
        String[] stringArray4 = new String[]{string};
        lDAPAttributeSet.add(new LDAPAttribute("nsslapd-suffix", stringArray4));
        String[] stringArray5 = new String[]{"-1"};
        lDAPAttributeSet.add(new LDAPAttribute("nsslapd-cachesize", stringArray5));
        String[] stringArray6 = new String[]{"10485760"};
        lDAPAttributeSet.add(new LDAPAttribute("nsslapd-cachememsize", stringArray6));
        String string4 = this._tfDirDB.getText().trim();
        if (string4.length() > 0) {
            stringArray = new String[]{string4};
            lDAPAttributeSet.add(new LDAPAttribute("nsslapd-directory", stringArray));
        }
        stringArray = new LDAPEntry(string3, lDAPAttributeSet);
        this._model.setWaitCursor(true);
        try {
            try {
                lDAPConnection.add((LDAPEntry)stringArray);
                Debug.println((String)("****** add:" + string3));
            }
            catch (LDAPException lDAPException) {
                String[] stringArray7 = new String[]{string3, lDAPException.toString()};
                DSUtil.showErrorDialog((Component)this.getModel().getFrame(), "error-add-mapping", stringArray7, _section);
                int n = 0;
                Object var18_15 = null;
                this._model.setWaitCursor(false);
                return n;
            }
            Object var18_14 = null;
            this._model.setWaitCursor(false);
        }
        catch (Throwable throwable) {
            Object var18_16 = null;
            this._model.setWaitCursor(false);
            throw throwable;
        }
        return 1;
    }

    public boolean checkUnique() {
        this._model.setWaitCursor(true);
        try {
            try {
                String string = this._instanceNameText.getText();
                this._model.setWaitCursor(true);
                LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
                if (string != null) {
                    LDAPSearchResults lDAPSearchResults = lDAPConnection.search(CONFIG_BASEDN, 2, "(&(cn=" + string + ")(objectclass=nsBackendInstance))", null, false);
                    this._model.setWaitCursor(false);
                    if (lDAPSearchResults.hasMoreElements()) {
                        DSUtil.showErrorDialog((Component)this.getModel().getFrame(), "backendname-exist", string);
                        this._instanceNameText.selectAll();
                        boolean bl = false;
                        Object var6_7 = null;
                        this._model.setWaitCursor(false);
                        return bl;
                    }
                }
                Object var6_8 = null;
                this._model.setWaitCursor(false);
            }
            catch (LDAPException lDAPException) {
                this._model.setWaitCursor(false);
                DSUtil.showErrorDialog((Component)this.getModel().getFrame(), "backendname-can-create", lDAPException.toString());
                boolean bl = false;
                Object var6_9 = null;
                this._model.setWaitCursor(false);
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            this._model.setWaitCursor(false);
            throw throwable;
        }
        return true;
    }

    public void resetCallback() {
        this.clearDirtyFlag();
        this.hideDialog();
    }

    private void setMappingState() {
        this.setMappingState(1);
    }

    private void setMappingState(int n) {
        switch (n) {
            case 0: {
                this._NewNodeText.setEnabled(false);
                this._NewNodeLabel.setEnabled(false);
                this._comboNewNodeMapping.setEnabled(false);
                this._comboNewNodeLabel.setEnabled(false);
                this._comboMapping.setEnabled(true);
                this._comboLabel.setEnabled(true);
                this._isNewMappingNodeValid = true;
                break;
            }
            case 1: {
                this._comboMapping.setEnabled(false);
                this._comboLabel.setEnabled(false);
                this._comboNewNodeMapping.setEnabled(true);
                this._comboNewNodeLabel.setEnabled(true);
                this._NewNodeText.setEnabled(true);
                this._NewNodeLabel.setEnabled(true);
                this._isNewMappingNodeValid = false;
                break;
            }
            case 2: {
                this._NewNodeText.setEnabled(false);
                this._NewNodeLabel.setEnabled(false);
                this._comboMapping.setEnabled(false);
                this._comboLabel.setEnabled(false);
                this._comboNewNodeMapping.setEnabled(false);
                this._comboNewNodeLabel.setEnabled(false);
                this._isNewMappingNodeValid = true;
            }
        }
        this.repaint();
        this.checkOkay();
    }

    public void okCallback() {
        if (this.checkUnique()) {
            LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
            try {
                this._entrySuffix = lDAPConnection.read(this._entrySuffix.getDN());
            }
            catch (LDAPException lDAPException) {
                String[] stringArray = new String[]{this._entrySuffix.getDN(), lDAPException.toString()};
                DSUtil.showErrorDialog((Component)this.getModel().getFrame(), "error-reload-suffix", stringArray, _section);
                return;
            }
            if (this.addLDBMBackend(this._suffix) > 0 && MappingUtils.addBackendInSuffix(this._model, this._entrySuffix, this._instanceNameText.getText(), _section)) {
                this.hideDialog();
            }
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this._instanceNameText.getDocument()) {
            if (DSUtil.isValidBckName(this._instanceNameText.getText())) {
                this.setChangeState(this._instanceNameLabel, 1);
                if (!this._dbLocChanged) {
                    this._isAutoLoc = true;
                    this._tfDirDB.setText(this._dbLoc + this._instanceNameText.getText());
                    this._isAutoLoc = false;
                }
            } else {
                this.setChangeState(this._instanceNameLabel, 3);
            }
        } else if (documentEvent.getDocument() == this._tfDirDB.getDocument()) {
            if (!this._isAutoLoc) {
                this._dbLocChanged = true;
            }
        } else if (documentEvent.getDocument() == this._NewNodeText.getDocument()) {
            if (DN.isDN((String)this._NewNodeText.getText())) {
                this.setChangeState(this._NewNodeLabel, 1);
                this._isNewMappingNodeValid = true;
            } else {
                this.setChangeState(this._NewNodeLabel, 3);
                this._isNewMappingNodeValid = false;
            }
        } else {
            super.changedUpdate(documentEvent);
        }
        this.checkOkay();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this._instanceNameText.getDocument()) {
            if (DSUtil.isValidBckName(this._instanceNameText.getText())) {
                this.setChangeState(this._instanceNameLabel, 1);
                if (!this._dbLocChanged) {
                    this._isAutoLoc = true;
                    this._tfDirDB.setText(this._dbLoc + this._instanceNameText.getText());
                    this._isAutoLoc = false;
                }
            } else {
                this.setChangeState(this._instanceNameLabel, 3);
            }
        } else if (documentEvent.getDocument() == this._tfDirDB.getDocument()) {
            if (!this._isAutoLoc) {
                this._dbLocChanged = true;
            }
        } else if (documentEvent.getDocument() == this._NewNodeText.getDocument()) {
            if (DN.isDN((String)this._NewNodeText.getText())) {
                this.setChangeState(this._NewNodeLabel, 1);
                this._isNewMappingNodeValid = true;
            } else {
                this.setChangeState(this._NewNodeLabel, 3);
                this._isNewMappingNodeValid = false;
            }
        } else {
            super.removeUpdate(documentEvent);
        }
        this.checkOkay();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this._instanceNameText.getDocument()) {
            if (DSUtil.isValidBckName(this._instanceNameText.getText())) {
                this.setChangeState(this._instanceNameLabel, 1);
                if (!this._dbLocChanged) {
                    this._isAutoLoc = true;
                    this._tfDirDB.setText(this._dbLoc + this._instanceNameText.getText());
                    this._isAutoLoc = false;
                }
            } else {
                this.setChangeState(this._instanceNameLabel, 3);
            }
        } else if (documentEvent.getDocument() == this._tfDirDB.getDocument()) {
            if (!this._isAutoLoc) {
                this._dbLocChanged = true;
            }
        } else if (documentEvent.getDocument() == this._NewNodeText.getDocument()) {
            if (DN.isDN((String)this._NewNodeText.getText())) {
                this.setChangeState(this._NewNodeLabel, 1);
                this._isNewMappingNodeValid = true;
            } else {
                this.setChangeState(this._NewNodeLabel, 3);
                this._isNewMappingNodeValid = false;
            }
        } else {
            super.insertUpdate(documentEvent);
        }
        this.checkOkay();
    }

    public String getDBLoc() {
        return this._tfDirDB.getText().trim();
    }

    public String getInstancename() {
        return this._instanceNameText.getText().trim();
    }
}

