/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;

public class IndexAttrUtility {
    public static final int SUCCESS = 0;
    public static final int FAILURE = 1;
    public static final int MODIFYAGAIN = 2;
    public static final int DELETEAGAIN = 3;
    public static final int ADDAGAIN = 4;

    public static boolean modifyAttributes(IDSModel iDSModel, String string, LDAPModificationSet lDAPModificationSet) {
        int n = IndexAttrUtility.isModifySuccess(iDSModel, string, lDAPModificationSet);
        if (n == 0) {
            return true;
        }
        if (n == 1) {
            return false;
        }
        if (n == 2) {
            try {
                LDAPConnection lDAPConnection = iDSModel.getServerInfo().getLDAPConnection();
                lDAPConnection.modify(string, lDAPModificationSet);
            }
            catch (LDAPException lDAPException) {
                if (SwingUtilities.isEventDispatchThread()) {
                    JOptionPane.showMessageDialog(iDSModel.getFrame(), lDAPException.toString(), "Error Message", 0);
                } else {
                    final IDSModel iDSModel2 = iDSModel;
                    final LDAPException lDAPException2 = lDAPException;
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            public void run() {
                                JOptionPane.showMessageDialog(iDSModel2.getFrame(), lDAPException2.toString(), "Error Message", 0);
                            }
                        });
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                return false;
            }
        }
        return true;
    }

    public static boolean addAttribute(IDSModel iDSModel, LDAPEntry lDAPEntry) {
        int n = IndexAttrUtility.isAddSuccess(iDSModel, lDAPEntry);
        if (n == 0) {
            return true;
        }
        if (n == 1) {
            return false;
        }
        if (n == 4) {
            try {
                LDAPConnection lDAPConnection = iDSModel.getServerInfo().getLDAPConnection();
                lDAPConnection.add(lDAPEntry);
            }
            catch (LDAPException lDAPException) {
                if (SwingUtilities.isEventDispatchThread()) {
                    DSUtil.showLDAPErrorDialog(iDSModel.getFrame(), lDAPException, "updating-directory-title");
                } else {
                    final IDSModel iDSModel2 = iDSModel;
                    final LDAPException lDAPException2 = lDAPException;
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            public void run() {
                                DSUtil.showLDAPErrorDialog(iDSModel2.getFrame(), lDAPException2, "updating-directory-title");
                            }
                        });
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                return false;
            }
        }
        return true;
    }

    public static boolean deleteAttribute(IDSModel iDSModel, String string) {
        int n = IndexAttrUtility.isDeleteSuccess(iDSModel, string);
        if (n == 0) {
            return true;
        }
        if (n == 1) {
            return false;
        }
        if (n == 3) {
            try {
                LDAPConnection lDAPConnection = iDSModel.getServerInfo().getLDAPConnection();
                lDAPConnection.delete(string);
            }
            catch (LDAPException lDAPException) {
                if (SwingUtilities.isEventDispatchThread()) {
                    JOptionPane.showMessageDialog(iDSModel.getFrame(), lDAPException.toString(), "Error Message", 0);
                } else {
                    final IDSModel iDSModel2 = iDSModel;
                    final LDAPException lDAPException2 = lDAPException;
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            public void run() {
                                JOptionPane.showMessageDialog(iDSModel2.getFrame(), lDAPException2.toString(), "Error Message", 0);
                            }
                        });
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                return false;
            }
        }
        return true;
    }

    private static int isModifySuccess(IDSModel iDSModel, String string, LDAPModificationSet lDAPModificationSet) {
        LDAPConnection lDAPConnection = iDSModel.getServerInfo().getLDAPConnection();
        try {
            try {
                lDAPConnection.modify(string, lDAPModificationSet);
                int n = 0;
                Object var10_6 = null;
                iDSModel.notifyAuthChangeListeners();
                return n;
            }
            catch (LDAPException lDAPException) {
                switch (lDAPException.getLDAPResultCode()) {
                    case 49: {
                        if (iDSModel.getNewAuthentication(false)) break;
                        int n = 1;
                        Object var10_7 = null;
                        iDSModel.notifyAuthChangeListeners();
                        return n;
                    }
                    default: {
                        if (SwingUtilities.isEventDispatchThread()) {
                            JOptionPane.showMessageDialog(iDSModel.getFrame(), lDAPException.toString(), "Error Message", 0);
                        } else {
                            final IDSModel iDSModel2 = iDSModel;
                            final LDAPException lDAPException2 = lDAPException;
                            try {
                                SwingUtilities.invokeAndWait(new Runnable(){

                                    public void run() {
                                        JOptionPane.showMessageDialog(iDSModel2.getFrame(), lDAPException2.toString(), "Error Message", 0);
                                    }
                                });
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        int n = 1;
                        Object var10_8 = null;
                        iDSModel.notifyAuthChangeListeners();
                        return n;
                    }
                }
                Object var10_9 = null;
                iDSModel.notifyAuthChangeListeners();
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            iDSModel.notifyAuthChangeListeners();
            throw throwable;
        }
        return 2;
    }

    private static int isAddSuccess(IDSModel iDSModel, LDAPEntry lDAPEntry) {
        LDAPConnection lDAPConnection = iDSModel.getServerInfo().getLDAPConnection();
        try {
            try {
                lDAPConnection.add(lDAPEntry);
                int n = 0;
                Object var9_5 = null;
                iDSModel.notifyAuthChangeListeners();
                return n;
            }
            catch (LDAPException lDAPException) {
                switch (lDAPException.getLDAPResultCode()) {
                    case 49: {
                        if (iDSModel.getNewAuthentication(false)) break;
                        int n = 1;
                        Object var9_6 = null;
                        iDSModel.notifyAuthChangeListeners();
                        return n;
                    }
                    default: {
                        if (SwingUtilities.isEventDispatchThread()) {
                            DSUtil.showLDAPErrorDialog(iDSModel.getFrame(), lDAPException, "updating-directory-title");
                        } else {
                            final IDSModel iDSModel2 = iDSModel;
                            final LDAPException lDAPException2 = lDAPException;
                            try {
                                SwingUtilities.invokeAndWait(new Runnable(){

                                    public void run() {
                                        DSUtil.showLDAPErrorDialog(iDSModel2.getFrame(), lDAPException2, "updating-directory-title");
                                    }
                                });
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        int n = 1;
                        Object var9_7 = null;
                        iDSModel.notifyAuthChangeListeners();
                        return n;
                    }
                }
                Object var9_8 = null;
                iDSModel.notifyAuthChangeListeners();
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            iDSModel.notifyAuthChangeListeners();
            throw throwable;
        }
        return 4;
    }

    private static int isDeleteSuccess(IDSModel iDSModel, String string) {
        LDAPConnection lDAPConnection = iDSModel.getServerInfo().getLDAPConnection();
        try {
            try {
                lDAPConnection.delete(string);
                int n = 0;
                Object var9_5 = null;
                iDSModel.notifyAuthChangeListeners();
                return n;
            }
            catch (LDAPException lDAPException) {
                switch (lDAPException.getLDAPResultCode()) {
                    case 49: {
                        if (iDSModel.getNewAuthentication(false)) break;
                        int n = 1;
                        Object var9_6 = null;
                        iDSModel.notifyAuthChangeListeners();
                        return n;
                    }
                    default: {
                        if (SwingUtilities.isEventDispatchThread()) {
                            JOptionPane.showMessageDialog(iDSModel.getFrame(), lDAPException.toString(), "Error Message", 0);
                        } else {
                            final IDSModel iDSModel2 = iDSModel;
                            final LDAPException lDAPException2 = lDAPException;
                            try {
                                SwingUtilities.invokeAndWait(new Runnable(){

                                    public void run() {
                                        JOptionPane.showMessageDialog(iDSModel2.getFrame(), lDAPException2.toString(), "Error Message", 0);
                                    }
                                });
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        int n = 1;
                        Object var9_7 = null;
                        iDSModel.notifyAuthChangeListeners();
                        return n;
                    }
                }
                Object var9_8 = null;
                iDSModel.notifyAuthChangeListeners();
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            iDSModel.notifyAuthChangeListeners();
            throw throwable;
        }
        return 3;
    }
}

