/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.Timer;

public class GalleryPanel
extends BlankPanel {
    private boolean _animate = false;
    private Timer _animator = null;
    private boolean _selected = false;
    private ImageIcon[] _images;
    private int _x;
    private int _y;
    private double _scale;
    private int _index = 0;
    private static ResourceSet _resource = DSUtil._resource;
    private static final String _section = "imagegallery";
    private static final String _sImageDir = "com/netscape/admin/dirserv/also";

    public GalleryPanel(IDSModel iDSModel) {
        super(iDSModel, _section, false);
        this.setOpaque(false);
    }

    public void init() {
        Closeable closeable;
        Object object;
        this.remove(this._myPanel);
        Vector<String> vector = new Vector<String>();
        try {
            this.getModel().setWaitCursor(true);
            object = this.getClass().getClassLoader().getResourceAsStream("com/netscape/admin/dirserv/also/files.lst");
            if (object == null) {
                Debug.println((String)"GalleryPanel.init: could not open com/netscape/admin/dirserv/also/files.lst");
            } else {
                String string;
                closeable = new BufferedReader(new InputStreamReader((InputStream)object));
                while ((string = ((BufferedReader)closeable).readLine()) != null) {
                    vector.addElement(string);
                }
            }
        }
        catch (Exception exception) {
            Debug.println((String)("GalleryPanel.init: " + exception));
        }
        this._images = new ImageIcon[vector.size()];
        Enumeration enumeration = vector.elements();
        object = "";
        int n = 0;
        try {
            try {
                while (enumeration.hasMoreElements()) {
                    object = "com/netscape/admin/dirserv/also/" + (String)enumeration.nextElement();
                    closeable = this.getClass().getClassLoader().getResourceAsStream((String)object);
                    byte[] byArray = new byte[((InputStream)closeable).available()];
                    ((InputStream)closeable).read(byArray);
                    Image image = Toolkit.getDefaultToolkit().createImage(byArray);
                    this._images[n++] = new ImageIcon(image);
                }
            }
            catch (Exception exception) {
                System.err.println("GalleryPanel: reading " + (String)object + ", " + exception);
                this._images = new ImageIcon[0];
                Object var9_12 = null;
                this.getModel().setWaitCursor(false);
            }
            Object var9_11 = null;
            this.getModel().setWaitCursor(false);
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            this.getModel().setWaitCursor(false);
            throw throwable;
        }
        this.initCoords();
        this._animator = new Timer(50, this);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                int n;
                int n2 = mouseEvent.getModifiers();
                boolean bl = (n2 & (n = 1 | 2)) != 0 && mouseEvent.getX() < 8 && mouseEvent.getY() < 8;
                GalleryPanel.this.setAnimation(bl);
            }
        });
        this._isInitialized = true;
    }

    private void setAnimation(boolean bl) {
        if (bl && !this._animate) {
            this._animator.start();
        } else if (!bl && this._animate) {
            this._animator.stop();
            this.repaint();
        }
        this._animate = bl;
    }

    private void initCoords() {
        int n = this.getWidth() / 4;
        this._x = ((int)(Math.random() * (double)this.getWidth() / 2.0) & 0xFFFFFFFE) + n;
        n = this.getHeight() / 4;
        this._y = ((int)(Math.random() * (double)this.getHeight() / 2.0) & 0xFFFFFFFE) + n;
        this._scale = 0.25;
    }

    public void select(IResourceObject iResourceObject, IPage iPage) {
        Debug.println((String)"GalleryPanel.select");
        this._selected = true;
        if (!this._isInitialized) {
            this.init();
        }
    }

    public void unselect(IResourceObject iResourceObject, IPage iPage) {
        this._selected = false;
        this.setAnimation(false);
    }

    public void paint(Graphics graphics) {
        if (this._animate) {
            graphics.setColor(Color.black);
        } else {
            graphics.setColor(this.getParent().getBackground());
        }
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (!this._animate || this._images.length < 1) {
            return;
        }
        ImageIcon imageIcon = this._images[this._index];
        int n = (int)((double)imageIcon.getIconWidth() * this._scale);
        int n2 = (int)((double)imageIcon.getIconHeight() * this._scale);
        int n3 = this._x - n / 2;
        int n4 = this._y - n2 / 2;
        graphics.drawImage(imageIcon.getImage(), n3, n4, n, n2, this);
        if (n > this.getWidth() || n2 > this.getHeight() || this._scale >= 4.0) {
            ++this._index;
            if (this._index >= this._images.length) {
                this._index = 0;
            }
            this.initCoords();
        } else {
            this._scale += 0.05;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this._animate) {
            this.repaint();
        }
    }
}

