/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.IDSEntry;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.Debug;
import java.io.File;
import java.util.Enumeration;
import javax.swing.JTextField;

class DSFileField
extends JTextField
implements IDSEntry {
    String _model;
    private int fileType = FILE;
    private boolean isLocal = false;
    public static int DIRECTORY = 0;
    public static int FILE = 1;
    public static int BOTH = 2;

    public DSFileField(BlankPanel blankPanel, String string, String string2, String string3, int n, int n2) {
        String string4;
        this._model = DSUtil._resource.getString(string, string2 + "-default");
        if (this._model == null) {
            this._model = string3;
        }
        int n3 = 0;
        try {
            n3 = Integer.parseInt(DSUtil._resource.getString(string, string2 + "-columns"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n3 < 1) {
            n3 = n;
        }
        if ((string4 = DSUtil._resource.getString(string, string2 + "-ttip")) != null) {
            this.setToolTipText(string4);
        }
        if (this._model != null) {
            this.setText(this._model);
        }
        if (n3 != -1) {
            this.setColumns(n3);
        }
        this.setMargin(UIFactory.getTextInsets());
        this.addActionListener(blankPanel);
        this.getDocument().addDocumentListener(blankPanel);
        this.fileType = n2;
        this.isLocal = blankPanel.isLocal();
    }

    public DSFileField(BlankPanel blankPanel, String string, String string2, String string3, int n) {
        this(blankPanel, string, string2, string3, n, FILE);
    }

    public void show() {
        this.setText(this._model);
    }

    public void store() {
        this._model = this.getText();
    }

    public boolean dsValidate() {
        String string = this.getText();
        File file = new File(string);
        String string2 = null;
        String[] stringArray = null;
        if (!this.isLocal()) {
            return true;
        }
        if (file.isDirectory() && this.fileType == FILE) {
            string2 = "directoryButNeedFile";
            stringArray = new String[]{string};
            Debug.println((String)("You need to enter a file name as well as a dir: " + file.getPath()));
        } else if (file.isFile() && this.fileType == DIRECTORY) {
            string2 = "fileButNeedDirectory";
            stringArray = new String[]{string};
        } else if (file.isFile()) {
            String string3 = file.getParent();
            if (string3 == null) {
                Debug.println((String)("The parent directory of " + string + " is null"));
                string2 = "notValidDirectory";
                stringArray = new String[]{string};
            } else {
                File file2 = new File(file.getParent());
                if (!file2.isDirectory()) {
                    string2 = "notValidDirectory";
                    stringArray = new String[]{file2.getPath()};
                    Debug.println((String)"Not a valid directory!");
                }
            }
        }
        if (string2 != null) {
            DSUtil.showErrorDialog(null, string2, stringArray, "general");
            this.grabFocus();
        }
        return string2 == null;
    }

    public void remoteToLocal(String string) {
        this._model = string;
    }

    public void remoteToLocal(Enumeration enumeration) {
        this._model = (String)enumeration.nextElement();
    }

    public String[] localToRemote() {
        String[] stringArray = null;
        if (this._model != null) {
            stringArray = new String[]{this._model};
        }
        return stringArray;
    }

    public boolean isLocal() {
        return this.isLocal;
    }
}

