/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSSchemaHelper;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.SchemaAttributesPanel;
import com.netscape.admin.dirserv.panel.SimpleDialog;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.Debug;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.ComboBoxEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import netscape.ldap.LDAPAttributeSchema;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSchema;

class AttributePanel
extends BlankPanel {
    private JLabel _lAttributeAliases;
    private JLabel _lAttributeOID;
    private JLabel _lAttributeName;
    private JLabel _lAttributeDesc;
    private JLabel _lAttributeSyntax;
    private JTextField _tfAttributeName;
    private JTextField _tfAttributeAliases;
    private JTextField _tfAttributeOID;
    private JTextField _tfAttributeDesc;
    private JCheckBox _ckbAttributeIsMulti;
    private JComboBox _cmbAttributeSyntax;
    private LDAPAttributeSchema _las = null;
    private boolean _create = false;
    private SimpleDialog _dlg;
    private Hashtable _htSyntaxStrings = null;
    public static final String PANEL_NAME = "schemaattributes";

    public AttributePanel(IDSModel iDSModel, LDAPAttributeSchema lDAPAttributeSchema, SimpleDialog simpleDialog) {
        super(iDSModel, PANEL_NAME);
        this._las = lDAPAttributeSchema;
        this._create = this._las == null;
        this._dlg = simpleDialog;
        this._myPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JPanel jPanel = this.createNewAttributeArea();
        this._myPanel.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        this._helpToken = "configuration-schema-attr-create-dbox-help";
        this.checkOkay();
    }

    public void init() {
    }

    public void okCallback() {
        Object object;
        Object object2;
        String string = this._tfAttributeName.getText();
        String[] stringArray = DSSchemaHelper.stringToArray(this._tfAttributeAliases.getText().trim());
        boolean bl = false;
        if (this._create && this.getModel().getSchema().getAttribute(string) != null) {
            DSUtil.showErrorDialog((Component)this, "exists", string, PANEL_NAME);
            bl = true;
        }
        if (!bl && stringArray != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length && !bl) {
                int n2;
                if (this.getModel().getSchema().getAttribute(stringArray[n]) != null && !stringArray[n].equalsIgnoreCase(string) && (n2 = DSUtil.showConfirmationDialog((Component)this, "exists-alias-attribute", stringArray[n], PANEL_NAME)) != 0) {
                    bl = true;
                }
                ++n;
            }
        }
        if (!bl) {
            Enumeration enumeration = this.getModel().getSchema().getAttributes();
            while (enumeration.hasMoreElements() && !bl) {
                LDAPAttributeSchema lDAPAttributeSchema = (LDAPAttributeSchema)enumeration.nextElement();
                String[] stringArray2 = lDAPAttributeSchema.getAliases();
                if (stringArray2 == null) continue;
                int n = 0;
                while (n < stringArray2.length && !bl) {
                    if (stringArray2[n].equalsIgnoreCase(string)) {
                        int n3;
                        object2 = lDAPAttributeSchema.getName();
                        if (!((String)object2).equalsIgnoreCase(string) && (n3 = DSUtil.showConfirmationDialog((Component)this, "exists-attribute-alias", (String[])(object = new String[]{object2, stringArray2[n]}), PANEL_NAME)) != 0) {
                            bl = true;
                        }
                    } else if (stringArray != null && stringArray.length > 0) {
                        int n4 = 0;
                        while (n4 < stringArray.length && !bl) {
                            String[] stringArray3;
                            int n5;
                            if (stringArray2[n].equalsIgnoreCase(stringArray[n4]) && !((String)(object = lDAPAttributeSchema.getName())).equalsIgnoreCase(string) && (n5 = DSUtil.showConfirmationDialog((Component)this, "exists-alias-alias", stringArray3 = new String[]{object, stringArray2[n]}, PANEL_NAME)) != 0) {
                                bl = true;
                            }
                            ++n4;
                        }
                    }
                    ++n;
                }
            }
        }
        if (!bl) {
            Object object3;
            String string2;
            String string3 = this._tfAttributeOID.getText();
            if (string3 == null || string3.length() == 0) {
                string3 = string + "-oid";
            }
            if ((string2 = this._tfAttributeDesc.getText()) == null) {
                string2 = "User defined attribute";
            }
            boolean bl2 = this._ckbAttributeIsMulti.isSelected();
            String string4 = (String)this._cmbAttributeSyntax.getSelectedItem();
            object2 = this._htSyntaxStrings.keys();
            object = null;
            while (object2.hasMoreElements()) {
                object = (String[])object2.nextElement();
                if (string4.equals(this._htSyntaxStrings.get(object))) break;
            }
            String string5 = null;
            LDAPAttributeSchema lDAPAttributeSchema = new LDAPAttributeSchema(string, string3, string2, (String)object, !bl2, string5, stringArray);
            lDAPAttributeSchema.setQualifier("X-ORIGIN", "user defined");
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = true;
            String string6 = null;
            IDSModel iDSModel = this.getModel();
            while (!bl3) {
                try {
                    if (!this._create && !bl4) {
                        try {
                            Debug.println((String)("AttributeDialog.okCallback: deleting " + this._las + ", " + this._las.getValue()));
                            this._las.remove(iDSModel.getServerInfo().getLDAPConnection());
                            bl4 = true;
                        }
                        catch (LDAPException lDAPException) {
                            Debug.println((String)("AttributeDialog.okCallback(): " + (Object)((Object)lDAPException)));
                        }
                    }
                    Debug.println((String)("AttributeDialog.okCallback: updating " + lDAPAttributeSchema + ", " + lDAPAttributeSchema.getValue()));
                    lDAPAttributeSchema.add(iDSModel.getServerInfo().getLDAPConnection());
                    this._las = lDAPAttributeSchema;
                    bl3 = true;
                    bl5 = true;
                }
                catch (LDAPException lDAPException) {
                    if (lDAPException.getLDAPResultCode() != 50) {
                        this.restoreAttr(iDSModel, this._las);
                    }
                    Debug.println((String)("AttributeDialog.okCallback(): " + (Object)((Object)lDAPException) + " new attr=" + lDAPAttributeSchema.getValue()));
                    if (lDAPException.getLDAPResultCode() == 50) {
                        DSUtil.showPermissionDialog((Component)iDSModel.getFrame(), iDSModel.getServerInfo().getLDAPConnection());
                        if (iDSModel.getNewAuthentication(false)) continue;
                        bl3 = true;
                        bl5 = false;
                        continue;
                    }
                    if (lDAPException.getLDAPResultCode() == 20 || lDAPException.getLDAPResultCode() == 68) {
                        bl3 = true;
                        bl5 = false;
                        bl6 = false;
                        DSUtil.showErrorDialog((Component)iDSModel.getFrame(), "oidexists", lDAPAttributeSchema.getID(), PANEL_NAME);
                        return;
                    }
                    if (lDAPException.getLDAPResultCode() == 1) {
                        bl3 = true;
                        bl5 = false;
                        bl6 = false;
                        object3 = lDAPException.getLDAPErrorMessage();
                        if (object3 != null && ((String)object3).indexOf("must begin and end with a digit") > 0) {
                            DSUtil.showErrorDialog((Component)iDSModel.getFrame(), "invalid-oid-digit", lDAPAttributeSchema.getID(), PANEL_NAME);
                            continue;
                        }
                        if (object3 != null && ((String)object3).indexOf("contains an invalid character") > 0) {
                            DSUtil.showErrorDialog((Component)iDSModel.getFrame(), "invalid-oid-char", lDAPAttributeSchema.getID(), PANEL_NAME);
                            continue;
                        }
                        DSUtil.showErrorDialog((Component)iDSModel.getFrame(), "failed-add", lDAPException.toString(), PANEL_NAME);
                        continue;
                    }
                    bl3 = true;
                    bl5 = false;
                    DSUtil.showErrorDialog((Component)iDSModel.getFrame(), "failed-add", lDAPException.toString(), PANEL_NAME);
                }
            }
            iDSModel.notifyAuthChangeListeners();
            if (bl3 || bl4) {
                this.invalidateSchema();
            }
            if (bl5) {
                string6 = this._create ? "successful-add" : "successful-update";
                LDAPSchema lDAPSchema = this.getModel().getSchema();
                if (lDAPSchema != null) {
                    object3 = lDAPSchema;
                    synchronized (object3) {
                    }
                }
                this.clearDirtyFlag();
                this.hideDialog();
                string = "'" + DSUtil.abreviateString(string, 20) + "'";
                DSUtil.showInformationDialog((Component)iDSModel.getFrame(), string6, string, PANEL_NAME);
            } else if (bl6) {
                this.hideDialog();
            }
        }
    }

    public void resetCallback() {
        this._las = null;
        this.hideDialog();
    }

    private void checkOkay() {
        String string;
        int n;
        String string2;
        int n2;
        Object object;
        boolean bl = true;
        boolean bl2 = false;
        String string3 = this._tfAttributeName.getText();
        if (string3 != null && string3.length() > 0 && this.isValidSchemaSyntax(string3)) {
            string3 = string3.trim();
            if (this._las != null && !string3.equalsIgnoreCase(this._las.getName())) {
                bl2 = true;
            }
        } else {
            bl = false;
        }
        boolean bl3 = true;
        boolean bl4 = false;
        String string4 = this._tfAttributeAliases.getText();
        string4 = string4 == null ? "" : string4.trim();
        if (string4.length() > 0 && string3 != null) {
            object = DSSchemaHelper.stringToArray(string4);
            n2 = 0;
            while (n2 < ((String[])object).length && bl3) {
                if (object[n2].equalsIgnoreCase(string3)) {
                    bl3 = false;
                }
                ++n2;
            }
        }
        object = "";
        if (this._las != null && !string4.equals(object = (object = DSSchemaHelper.arrayToString(this._las.getAliases())) == null ? "" : object.trim())) {
            bl4 = true;
        }
        n2 = 1;
        boolean bl5 = false;
        String string5 = this._tfAttributeOID.getText().trim();
        if (string5 == null) {
            string5 = "";
        }
        if (string3 != null && string5.length() > 0 && !string5.equalsIgnoreCase(string3 + "-oid")) {
            string2 = string5.substring(0, 1);
            String string6 = string5.substring(string5.length() - 1, string5.length());
            try {
                int n3 = Integer.valueOf(string2);
                int n4 = Integer.valueOf(string6);
                if (0 > n3 || n3 > 9 || 0 > n4 || n4 > 9) {
                    n2 = 0;
                }
                if (n2 != 0) {
                    n = 1;
                    while (n < string5.length() - 1) {
                        int n5;
                        string = string5.substring(n, n + 1);
                        if (!(string.equals(".") || 0 <= (n5 = Integer.valueOf(string).intValue()) && n5 <= 9)) {
                            n2 = 0;
                        }
                        ++n;
                    }
                }
            }
            catch (Exception exception) {
                n2 = 0;
            }
        }
        string2 = "";
        if (this._las != null && !string5.equalsIgnoreCase(string2 = (string2 = this._las.getID()) == null ? "" : string2.trim())) {
            bl5 = true;
        }
        boolean bl6 = false;
        String string7 = this._tfAttributeDesc.getText().trim();
        if (string7 == null) {
            string7 = "";
        }
        String string8 = "";
        if (this._las != null && !string7.equals(string8 = (string8 = this._las.getDescription()) == null ? "" : string8.trim())) {
            bl6 = true;
        }
        n = 0;
        string = (String)this._cmbAttributeSyntax.getSelectedItem();
        String string9 = null;
        if (this._las != null && (string9 = (String)this._htSyntaxStrings.get(this._las.getSyntaxString())) != null && string != null && !string9.equals(string)) {
            n = 1;
        }
        boolean bl7 = false;
        boolean bl8 = this._ckbAttributeIsMulti.isSelected();
        if (this._las != null && bl8 == this._las.isSingleValued()) {
            bl7 = true;
        }
        if (!bl) {
            this.setChangeState(this._lAttributeName, 3);
        } else if (bl2) {
            this.setChangeState(this._lAttributeName, 2);
        } else {
            this.setChangeState(this._lAttributeName, 1);
        }
        if (!bl3) {
            this.setChangeState(this._lAttributeAliases, 3);
        } else if (bl4) {
            this.setChangeState(this._lAttributeAliases, 2);
        } else {
            this.setChangeState(this._lAttributeAliases, 1);
        }
        if (n2 == 0) {
            this.setChangeState(this._lAttributeOID, 3);
        } else if (bl5) {
            this.setChangeState(this._lAttributeOID, 2);
        } else {
            this.setChangeState(this._lAttributeOID, 1);
        }
        if (bl6) {
            this.setChangeState(this._lAttributeDesc, 2);
        } else {
            this.setChangeState(this._lAttributeDesc, 1);
        }
        if (n != 0) {
            this.setChangeState(this._lAttributeSyntax, 2);
        } else {
            this.setChangeState(this._lAttributeSyntax, 1);
        }
        if (bl7) {
            this.setChangeState(this._ckbAttributeIsMulti, 2);
        } else {
            this.setChangeState(this._ckbAttributeIsMulti, 1);
        }
        boolean bl9 = bl && bl3 && n2 != 0;
        this._dlg.setOKButtonEnabled(bl9);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        super.changedUpdate(documentEvent);
        this.checkOkay();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        super.removeUpdate(documentEvent);
        this.checkOkay();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        super.insertUpdate(documentEvent);
        this.checkOkay();
    }

    protected JPanel createNewAttributeArea() {
        Object object;
        Object object2;
        this._lAttributeName = this.makeJLabel(PANEL_NAME, "newname");
        this._tfAttributeName = this.makeJTextField(PANEL_NAME, "newname", null, 20);
        this._lAttributeName.setLabelFor(this._tfAttributeName);
        this._lAttributeAliases = this.makeJLabel(PANEL_NAME, "newaliases");
        this._tfAttributeAliases = this.makeJTextField(PANEL_NAME, "newaliases", null, 20);
        this._lAttributeAliases.setLabelFor(this._tfAttributeAliases);
        this._lAttributeOID = this.makeJLabel(PANEL_NAME, "newoid");
        this._tfAttributeOID = this.makeJTextField(PANEL_NAME, "newoid", null, 20);
        this._lAttributeOID.setLabelFor(this._tfAttributeOID);
        this._lAttributeDesc = this.makeJLabel(PANEL_NAME, "newdesc");
        this._tfAttributeDesc = this.makeJTextField(PANEL_NAME, "newdesc", null, 20);
        this._lAttributeDesc.setLabelFor(this._tfAttributeDesc);
        this._ckbAttributeIsMulti = this.makeJCheckBox(PANEL_NAME, "newmulti", false);
        this._ckbAttributeIsMulti.setSelected(true);
        this._ckbAttributeIsMulti.addActionListener(this);
        this._lAttributeSyntax = this.makeJLabel(PANEL_NAME, "newsyntax");
        this._cmbAttributeSyntax = this.makeJComboBox(PANEL_NAME, "newsyntax", null);
        this._lAttributeSyntax.setLabelFor(this._cmbAttributeSyntax);
        this._cmbAttributeSyntax.addItemListener(this);
        this._cmbAttributeSyntax = UIFactory.makeJComboBox(this, null);
        UIFactory.setToolTip(PANEL_NAME, "newsyntax", this._cmbAttributeSyntax);
        ComboBoxEditor comboBoxEditor = this._cmbAttributeSyntax.getEditor();
        if (comboBoxEditor != null && (object2 = comboBoxEditor.getEditorComponent()) instanceof JTextField) {
            ((JTextField)object2).setMargin(this.getTextInsets());
        }
        if (this._htSyntaxStrings == null) {
            this._htSyntaxStrings = SchemaAttributesPanel.getSyntaxStrings(this.getModel().getSchema());
        }
        object2 = this._htSyntaxStrings.elements();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            if (object == null) continue;
            this._cmbAttributeSyntax.addItem(object);
        }
        object = new JPanel(new GridBagLayout());
        ((JComponent)object).setBorder(new EmptyBorder(0, 0, 0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = UIFactory.getDifferentSpace();
        Insets insets = new Insets(0, 0, n, 0);
        Insets insets2 = new Insets(0, 0, n, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 0.0;
        ((Container)object).add((Component)this._lAttributeName, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = insets2;
        ((Container)object).add((Component)this._tfAttributeName, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = insets;
        ((Container)object).add((Component)this._lAttributeOID, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = insets2;
        ((Container)object).add((Component)this._tfAttributeOID, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = insets;
        ((Container)object).add((Component)this._lAttributeAliases, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = insets2;
        ((Container)object).add((Component)this._tfAttributeAliases, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = insets;
        ((Container)object).add((Component)this._lAttributeDesc, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = insets2;
        ((Container)object).add((Component)this._tfAttributeDesc, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = insets;
        ((Container)object).add((Component)this._lAttributeSyntax, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = insets2;
        ((Container)object).add((Component)this._cmbAttributeSyntax, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridwidth = -1;
        ((Container)object).add(Box.createGlue(), gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        gridBagConstraints.insets.bottom = 0;
        ((Container)object).add((Component)this._ckbAttributeIsMulti, gridBagConstraints);
        if (this._las != null) {
            this._tfAttributeName.setText(this._las.getName());
            this._tfAttributeOID.setText(this._las.getID());
            this._tfAttributeAliases.setText(DSSchemaHelper.arrayToString(this._las.getAliases()));
            this._tfAttributeDesc.setText(this._las.getDescription());
            String string = (String)this._htSyntaxStrings.get(this._las.getSyntaxString());
            if (string != null) {
                this._cmbAttributeSyntax.setSelectedItem(string);
            }
            this._ckbAttributeIsMulti.setSelected(!this._las.isSingleValued());
        } else {
            this._tfAttributeName.setText(DSUtil._resource.getString(PANEL_NAME, "newname-default"));
        }
        return object;
    }

    private boolean attributeExists(String string) {
        LDAPAttributeSchema lDAPAttributeSchema = null;
        LDAPSchema lDAPSchema = this.getModel().getSchema();
        if (lDAPSchema != null) {
            LDAPSchema lDAPSchema2 = lDAPSchema;
            synchronized (lDAPSchema2) {
                lDAPAttributeSchema = lDAPSchema.getAttribute(string);
            }
        }
        return lDAPAttributeSchema != null;
    }

    private void invalidateSchema() {
        this.getModel().setSchema(null);
    }

    private void restoreAttr(IDSModel iDSModel, LDAPAttributeSchema lDAPAttributeSchema) {
        if (lDAPAttributeSchema == null) {
            return;
        }
        try {
            lDAPAttributeSchema.add(iDSModel.getServerInfo().getLDAPConnection());
        }
        catch (LDAPException lDAPException) {
            DSUtil.showErrorDialog((Component)iDSModel.getFrame(), "failed-add", lDAPException.toString(), PANEL_NAME);
        }
    }

    LDAPAttributeSchema getAttribute() {
        return this._las;
    }

    public JComponent getDefaultFocusComponent() {
        return this._tfAttributeName;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this._ckbAttributeIsMulti)) {
            this.checkOkay();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this._cmbAttributeSyntax)) {
            this.checkOkay();
        }
    }
}

