/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.node;

import com.netscape.admin.dirserv.DSResourceModel;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.node.DSResourceObject;
import com.netscape.admin.dirserv.panel.PluginPanel;
import com.netscape.management.client.IMenuInfo;
import com.netscape.management.client.IMenuItem;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.MenuItemText;
import com.netscape.management.client.ResourcePage;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.RemoteImage;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;

public class PluginResourceObject
extends DSResourceObject
implements IMenuInfo,
ActionListener,
TreeExpansionListener {
    private boolean _isLoaded = false;
    private boolean _isInitiallyExpanded = false;
    private boolean _isLeaf = false;
    private static final String pluginsIconName = "pluginfolder.gif";
    private static final String pluginsIconNameL = "backupcL.gif";
    private static final String _pluginImageName = "plugin.gif";
    private static final String OCLASS = "nsslapdplugin";
    private static final String PATH = "nsslapd-pluginpath";
    private static final String ID = "nsslapd-pluginid";
    private static final String ENABLED = "nsslapd-pluginenabled";
    protected String[] _categoryID;
    protected IMenuItem[] _contextMenuItems;
    protected IMenuItem[] _objectMenuItems;
    private static final String NAME_ATTR = "cn";
    private PluginPanel _sharedPanel = null;

    public PluginResourceObject(IDSModel iDSModel) {
        super(DSResourceObject._resource.getString("resourcepage", "Plugins"), DSUtil.getPackageImage(pluginsIconName), DSUtil.getPackageImage(pluginsIconNameL), iDSModel);
    }

    public boolean run(IPage iPage) {
        Debug.println((String)("PluginResourceObject.run(" + iPage.getClass().getName() + ")"));
        this.reload();
        if (super.getChildCount() != 0) {
            this.expandPath((ResourcePage)iPage);
        }
        this.refreshTree();
        return true;
    }

    public boolean run(IPage iPage, IResourceObject[] iResourceObjectArray) {
        return this.run(iPage);
    }

    public void reload() {
        this.cleanTree();
        RemoteImage remoteImage = DSUtil.getPackageImage(_pluginImageName);
        this._isLeaf = true;
        try {
            try {
                this._model.fireChangeFeedbackCursor(null, 3);
                LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
                LDAPSearchResults lDAPSearchResults = lDAPConnection.search("cn=config", 2, "objectclass=nsslapdplugin", null, false);
                while (lDAPSearchResults.hasMoreElements()) {
                    Object object;
                    LDAPEntry lDAPEntry = (LDAPEntry)lDAPSearchResults.nextElement();
                    String string = lDAPEntry.getDN();
                    Debug.println((String)("Plugin: " + string));
                    LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(NAME_ATTR);
                    if (lDAPAttribute == null) {
                        lDAPAttribute = lDAPEntry.getAttribute(ID);
                    }
                    if (lDAPAttribute == null) {
                        lDAPAttribute = lDAPEntry.getAttribute(PATH);
                    }
                    if (lDAPAttribute != null) {
                        this._isLeaf = false;
                        object = lDAPAttribute.getStringValues();
                        if (object.hasMoreElements()) {
                            string = (String)object.nextElement();
                        }
                    }
                    object = new PluginObject(string, remoteImage, this._model, lDAPEntry);
                    ((DefaultMutableTreeNode)((Object)this)).add((MutableTreeNode)object);
                    DSUtil.addRequiresRestart(lDAPEntry.getDN(), ENABLED);
                }
            }
            catch (LDAPException lDAPException) {
                Debug.println((String)("PluginResourceObject.reload: " + (Object)((Object)lDAPException)));
                Object var9_10 = null;
                this._model.fireChangeFeedbackCursor(null, 0);
            }
            Object var9_9 = null;
            this._model.fireChangeFeedbackCursor(null, 0);
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this._model.fireChangeFeedbackCursor(null, 0);
            throw throwable;
        }
        this.refreshTree();
        this._isLoaded = true;
    }

    public void select(IPage iPage) {
        if (!this.isLoaded()) {
            this.reload();
        }
        super.select(iPage);
    }

    public boolean isLoaded() {
        return this._isLoaded;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("refresh")) {
            this.reload();
            this.refreshTree();
            this._sharedPanel = null;
        }
    }

    public String[] getMenuCategoryIDs() {
        if (this._categoryID == null) {
            this._categoryID = new String[]{"OBJECT", "CONTEXT"};
        }
        return this._categoryID;
    }

    public IMenuItem[] getMenuItems(String string) {
        if (string.equals("CONTEXT")) {
            if (this._contextMenuItems == null) {
                this._contextMenuItems = this.createMenuItems();
            }
            return this._contextMenuItems;
        }
        if (string.equals("OBJECT")) {
            if (this._objectMenuItems == null) {
                this._objectMenuItems = this.createMenuItems();
            }
            return this._objectMenuItems;
        }
        return null;
    }

    private IMenuItem[] createMenuItems() {
        return new IMenuItem[]{new MenuItemText("refresh", DSUtil._resource.getString("menu", "refresh"), DSUtil._resource.getString("menu", "refresh-description"))};
    }

    public void actionMenuSelected(IPage iPage, IMenuItem iMenuItem) {
        if (iMenuItem.getID().equals("refresh")) {
            ((DSResourceModel)this._model).actionMenuSelected(iPage, iMenuItem);
        }
    }

    public boolean isLeaf() {
        return this._isLeaf;
    }

    void refreshTree() {
        this._model.fireTreeStructureChanged(this);
    }

    private void expandPath(ResourcePage resourcePage) {
        TreePath treePath = new TreePath(((DefaultMutableTreeNode)((Object)this)).getPath());
        resourcePage.expandTreePath(treePath);
    }

    private void cleanTree() {
        ((DefaultMutableTreeNode)((Object)this)).removeAllChildren();
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        IResourceObject iResourceObject = (IResourceObject)treeExpansionEvent.getPath().getLastPathComponent();
        if (this.equals(iResourceObject) && !this._isInitiallyExpanded) {
            this._isInitiallyExpanded = true;
            Debug.println((String)"PluginResourceObject.treeExpanded: this");
            if (!this.isLoaded()) {
                this.reload();
            }
        }
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }

    class PluginObject
    extends DSResourceObject
    implements PropertyChangeListener,
    ActionListener,
    IMenuInfo {
        protected String[] _categoryID;
        protected IMenuItem[] _contextMenuItems;
        protected IMenuItem[] _objectMenuItems;
        private boolean _initialized = false;
        private String _name = null;
        private LDAPEntry _entry = null;

        public PluginObject(String string, RemoteImage remoteImage, IDSModel iDSModel, LDAPEntry lDAPEntry) {
            super(string, remoteImage, null, iDSModel);
            this._entry = lDAPEntry;
        }

        public Component getCustomPanel() {
            if (PluginResourceObject.this._sharedPanel == null) {
                PluginResourceObject.this._sharedPanel = new PluginPanel(this._model);
                PluginResourceObject.this._sharedPanel.addPropertyChangeListener(this);
            }
            this._panel = PluginResourceObject.this._sharedPanel;
            return PluginResourceObject.this._sharedPanel;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Debug.println((String)"PluginResourceObject.propertyChange()");
            if (propertyChangeEvent.getPropertyName().equals(PluginPanel.ENTRY)) {
                this._entry = (LDAPEntry)propertyChangeEvent.getNewValue();
                String string = this.getAttrVal(PluginResourceObject.NAME_ATTR);
                if (string != null && !string.equals("")) {
                    this.setName(string);
                }
            }
        }

        private String getAttrVal(String string) {
            Enumeration enumeration;
            LDAPAttribute lDAPAttribute;
            if (this._entry != null && (lDAPAttribute = this._entry.getAttribute(string)) != null && (enumeration = lDAPAttribute.getStringValues()) != null && enumeration.hasMoreElements()) {
                return (String)enumeration.nextElement();
            }
            return "";
        }

        public void select(IPage iPage) {
            PluginResourceObject.this._sharedPanel.updateFromEntry(this._entry);
        }

        public boolean run(IPage iPage) {
            Debug.println((String)("PluginObject.run(" + iPage.getClass().getName() + ")"));
            PluginResourceObject.this._sharedPanel.advancedCallBack();
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals("refresh")) {
                this.reloadEntry();
                if (this._entry == null) {
                    PluginResourceObject.this.reload();
                    PluginResourceObject.this.refreshTree();
                } else {
                    PluginResourceObject.this._sharedPanel.refreshFromServer();
                }
            }
        }

        public String[] getMenuCategoryIDs() {
            if (this._categoryID == null) {
                this._categoryID = new String[]{"OBJECT", "CONTEXT"};
            }
            return this._categoryID;
        }

        public IMenuItem[] getMenuItems(String string) {
            if (string.equals("CONTEXT")) {
                if (this._contextMenuItems == null) {
                    this._contextMenuItems = this.createMenuItems();
                }
                return this._contextMenuItems;
            }
            if (string.equals("OBJECT")) {
                if (this._objectMenuItems == null) {
                    this._objectMenuItems = this.createMenuItems();
                }
                return this._objectMenuItems;
            }
            return null;
        }

        private IMenuItem[] createMenuItems() {
            return new IMenuItem[]{new MenuItemText("refresh", DSUtil._resource.getString("menu", "refresh"), DSUtil._resource.getString("menu", "refresh-description"))};
        }

        public void actionMenuSelected(IPage iPage, IMenuItem iMenuItem) {
            if (iMenuItem.getID().equals("refresh")) {
                ((DSResourceModel)this._model).actionMenuSelected(iPage, iMenuItem);
            }
        }

        private void reloadEntry() {
            block2: {
                LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
                try {
                    this._entry = lDAPConnection.read(this._entry.getDN());
                }
                catch (LDAPException lDAPException) {
                    this._entry = null;
                    Debug.println((String)("PluginResourceObject.PluginObject.reloadEntry(): " + (Object)((Object)lDAPException)));
                    if (lDAPException.getLDAPResultCode() == 32) break block2;
                    DSUtil.showLDAPErrorDialog(this._model.getFrame(), lDAPException, "fetching-directory");
                }
            }
        }
    }
}

