/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.browser;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.browser.AuthRecord;
import com.netscape.admin.dirserv.browser.ConnectionRecord;
import com.netscape.management.client.util.UtilConsoleGlobals;
import java.util.Enumeration;
import java.util.Hashtable;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSocketFactory;
import netscape.ldap.LDAPUrl;

public class LDAPConnectionPool {
    Hashtable _authTable = new Hashtable();
    Hashtable _connectionTable = new Hashtable();

    public void registerConnection(LDAPConnection lDAPConnection) {
        this.registerAuth(lDAPConnection);
        LDAPUrl lDAPUrl = LDAPConnectionPool.makeLDAPUrl(lDAPConnection.getHost(), lDAPConnection.getPort(), "", LDAPConnectionPool.isSecureConnection(lDAPConnection));
        String string = LDAPConnectionPool.makeKeyFromLDAPUrl(lDAPUrl);
        ConnectionRecord connectionRecord = new ConnectionRecord();
        connectionRecord.ldc = lDAPConnection;
        connectionRecord.counter = 1;
        connectionRecord.disconnectAfterUse = false;
        this._connectionTable.put(string, connectionRecord);
    }

    public LDAPConnection getConnection(LDAPUrl lDAPUrl) throws LDAPException {
        ConnectionRecord connectionRecord;
        String string = LDAPConnectionPool.makeKeyFromLDAPUrl(lDAPUrl);
        LDAPConnectionPool lDAPConnectionPool = this;
        synchronized (lDAPConnectionPool) {
            connectionRecord = (ConnectionRecord)this._connectionTable.get(string);
            if (connectionRecord == null) {
                connectionRecord = new ConnectionRecord();
                connectionRecord.ldc = null;
                connectionRecord.counter = 1;
                connectionRecord.disconnectAfterUse = false;
                this._connectionTable.put(string, connectionRecord);
            } else {
                ++connectionRecord.counter;
            }
        }
        ConnectionRecord connectionRecord2 = connectionRecord;
        synchronized (connectionRecord2) {
            try {
                if (connectionRecord.ldc == null) {
                    connectionRecord.ldc = LDAPConnectionPool.createLDAPConnection(lDAPUrl, (AuthRecord)this._authTable.get(string));
                }
            }
            catch (LDAPException lDAPException) {
                LDAPConnectionPool lDAPConnectionPool2 = this;
                synchronized (lDAPConnectionPool2) {
                    --connectionRecord.counter;
                    if (connectionRecord.counter == 0) {
                        this._connectionTable.remove(string);
                    }
                }
                throw lDAPException;
            }
        }
        return connectionRecord.ldc;
    }

    public synchronized void releaseConnection(LDAPConnection lDAPConnection) {
        Enumeration enumeration;
        String string = null;
        ConnectionRecord connectionRecord = null;
        LDAPConnectionPool lDAPConnectionPool = this;
        synchronized (lDAPConnectionPool) {
            enumeration = this._connectionTable.keys();
            while (enumeration.hasMoreElements() && string == null) {
                String string2 = (String)enumeration.nextElement();
                ConnectionRecord connectionRecord2 = (ConnectionRecord)this._connectionTable.get(string2);
                if (connectionRecord2.ldc != lDAPConnection) continue;
                string = string2;
                connectionRecord = connectionRecord2;
            }
        }
        if (connectionRecord == null) {
            throw new IllegalArgumentException("Invalid LDAP connection");
        }
        enumeration = connectionRecord;
        synchronized (enumeration) {
            --connectionRecord.counter;
            if (connectionRecord.counter == 0 && connectionRecord.disconnectAfterUse) {
                this.disconnectAndRemove(connectionRecord);
            }
        }
    }

    public synchronized void flush() {
        Enumeration enumeration = this._connectionTable.elements();
        while (enumeration.hasMoreElements()) {
            ConnectionRecord connectionRecord = (ConnectionRecord)enumeration.nextElement();
            if (connectionRecord.counter <= 0) {
                this.disconnectAndRemove(connectionRecord);
                continue;
            }
            connectionRecord.disconnectAfterUse = true;
        }
    }

    public void registerAuth(LDAPUrl lDAPUrl, String string, String string2, boolean bl) throws LDAPException {
        LDAPConnectionPool lDAPConnectionPool;
        String string3 = LDAPConnectionPool.makeKeyFromLDAPUrl(lDAPUrl);
        AuthRecord authRecord = new AuthRecord();
        authRecord.ldapUrl = lDAPUrl;
        authRecord.dn = string;
        authRecord.password = string2;
        if (bl) {
            lDAPConnectionPool = LDAPConnectionPool.createLDAPConnection(lDAPUrl, authRecord);
            lDAPConnectionPool.disconnect();
        }
        lDAPConnectionPool = this;
        synchronized (lDAPConnectionPool) {
            this._authTable.put(string3, authRecord);
            ConnectionRecord connectionRecord = (ConnectionRecord)this._connectionTable.get(string3);
            if (connectionRecord != null) {
                if (connectionRecord.counter <= 0) {
                    this.disconnectAndRemove(connectionRecord);
                } else {
                    connectionRecord.disconnectAfterUse = true;
                }
            }
        }
    }

    public void registerAuth(LDAPConnection lDAPConnection) {
        LDAPUrl lDAPUrl = LDAPConnectionPool.makeLDAPUrl(lDAPConnection.getHost(), lDAPConnection.getPort(), "", LDAPConnectionPool.isSecureConnection(lDAPConnection));
        try {
            this.registerAuth(lDAPUrl, lDAPConnection.getAuthenticationDN(), lDAPConnection.getAuthenticationPassword(), false);
        }
        catch (LDAPException lDAPException) {
            throw new IllegalStateException("Bug");
        }
    }

    public void registerAuth(LDAPUrl lDAPUrl, LDAPConnection lDAPConnection) {
        try {
            this.registerAuth(lDAPUrl, lDAPConnection.getAuthenticationDN(), lDAPConnection.getAuthenticationPassword(), false);
        }
        catch (LDAPException lDAPException) {
            throw new IllegalStateException("Bug");
        }
    }

    public synchronized String getAuthDN(LDAPUrl lDAPUrl) {
        String string = LDAPConnectionPool.makeKeyFromLDAPUrl(lDAPUrl);
        AuthRecord authRecord = (AuthRecord)this._authTable.get(string);
        String string2 = authRecord == null ? null : authRecord.dn;
        return string2;
    }

    public synchronized String getAuthPassword(LDAPUrl lDAPUrl) {
        String string = LDAPConnectionPool.makeKeyFromLDAPUrl(lDAPUrl);
        AuthRecord authRecord = (AuthRecord)this._authTable.get(string);
        String string2 = authRecord == null ? null : authRecord.password;
        return string2;
    }

    static boolean isSecureConnection(LDAPConnection lDAPConnection) {
        LDAPSocketFactory lDAPSocketFactory = LDAPConnectionPool.getLDAPSSLSocketFactory();
        boolean bl = lDAPSocketFactory == null ? false : lDAPConnection.getSocketFactory() == lDAPSocketFactory;
        return bl;
    }

    private void disconnectAndRemove(ConnectionRecord connectionRecord) {
        String string = LDAPConnectionPool.makeKeyFromRecord(connectionRecord);
        this._connectionTable.remove(string);
        try {
            connectionRecord.ldc.disconnect();
        }
        catch (LDAPException lDAPException) {
            // empty catch block
        }
    }

    private static String makeKeyFromLDAPUrl(LDAPUrl lDAPUrl) {
        String string = LDAPConnectionPool.isSecureLDAPUrl(lDAPUrl) ? "LDAPS" : "LDAP";
        return string + ":" + lDAPUrl.getHost() + ":" + lDAPUrl.getPort();
    }

    private static String makeKeyFromRecord(ConnectionRecord connectionRecord) {
        String string = LDAPConnectionPool.isSecureConnection(connectionRecord.ldc) ? "LDAPS" : "LDAP";
        return string + ":" + connectionRecord.ldc.getHost() + ":" + connectionRecord.ldc.getPort();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static LDAPConnection createLDAPConnection(LDAPUrl lDAPUrl, AuthRecord authRecord) throws LDAPException {
        LDAPConnection lDAPConnection;
        if (LDAPConnectionPool.isSecureLDAPUrl(lDAPUrl)) {
            LDAPSocketFactory lDAPSocketFactory = LDAPConnectionPool.getLDAPSSLSocketFactory();
            if (lDAPSocketFactory == null) throw new LDAPException("Can't get LDAPS socket factory", 91);
            lDAPConnection = new LDAPConnection(lDAPSocketFactory);
            lDAPConnection.connect(lDAPUrl.getHost(), lDAPUrl.getPort());
            if (authRecord != null) {
                lDAPConnection.authenticate(3, authRecord.dn, authRecord.password);
            }
            DSUtil.setDefaultReferralCredentials(lDAPConnection);
            return lDAPConnection;
        } else {
            lDAPConnection = new LDAPConnection();
            lDAPConnection.connect(lDAPUrl.getHost(), lDAPUrl.getPort());
            if (authRecord != null) {
                lDAPConnection.authenticate(3, authRecord.dn, authRecord.password);
            }
            DSUtil.setDefaultReferralCredentials(lDAPConnection);
        }
        return lDAPConnection;
    }

    private static LDAPSocketFactory getLDAPSSLSocketFactory() {
        LDAPSocketFactory lDAPSocketFactory;
        try {
            lDAPSocketFactory = UtilConsoleGlobals.getLDAPSSLSocketFactory();
        }
        catch (Throwable throwable) {
            lDAPSocketFactory = null;
        }
        return lDAPSocketFactory;
    }

    public static boolean isSecureLDAPUrl(LDAPUrl lDAPUrl) {
        return lDAPUrl.isSecure();
    }

    public static LDAPUrl makeLDAPUrl(String string, int n, String string2, boolean bl) {
        return new LDAPUrl(string, n, string2, null, 0, null, bl);
    }

    public static LDAPUrl makeLDAPUrl(LDAPConnection lDAPConnection, String string) {
        return new LDAPUrl(lDAPConnection.getHost(), lDAPConnection.getPort(), string, null, 0, null, LDAPConnectionPool.isSecureConnection(lDAPConnection));
    }

    public static LDAPUrl makeLDAPUrl(LDAPUrl lDAPUrl, String string) {
        return new LDAPUrl(lDAPUrl.getHost(), lDAPUrl.getPort(), string, null, 0, null, lDAPUrl.isSecure());
    }
}

