/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv;

import com.netscape.admin.dirserv.DSContentPage;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.Database;
import com.netscape.admin.dirserv.Suffix;
import com.netscape.admin.dirserv.browser.NumSubordinateHacker;
import com.netscape.management.client.util.Debug;
import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPReferralException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.util.DN;

public class DatabaseConfig {
    Vector _rootSuffixes;
    NumSubordinateHacker _numSubordinateHacker = new NumSubordinateHacker();
    LDAPSearchConstraints _searchConstraints;
    public static final int LDBM_DATABASES = 0;
    public static final int CHAINING_DATABASES = 1;
    public static final int ALL_DATABASES = 2;
    private static final String CHAINING_CONFIG_BASEDN = "cn=chaining database, cn=plugins, cn=config";
    private static final String LDBM_CONFIG_BASEDN = "cn=ldbm database, cn=plugins, cn=config";

    public synchronized void reload(LDAPConnection lDAPConnection) throws LDAPException {
        Suffix suffix;
        String string;
        Database database;
        String string2;
        LDAPEntry lDAPEntry;
        this._rootSuffixes = new Vector();
        String string3 = "objectclass=nsBackendInstance";
        String string4 = LDBM_CONFIG_BASEDN;
        String[] stringArray = new String[]{"cn", "nsslapd-suffix"};
        this._searchConstraints = (LDAPSearchConstraints)lDAPConnection.getSearchConstraints().clone();
        this._searchConstraints.setServerControls(DSContentPage._manageDSAITControl);
        LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string4, 2, string3, stringArray, false, this._searchConstraints);
        while (lDAPSearchResults.hasMoreElements()) {
            lDAPEntry = (LDAPEntry)lDAPSearchResults.nextElement();
            string2 = DSUtil.getAttrValue(lDAPEntry, "cn");
            database = new Database();
            database.setName(string2);
            database.setIsLocal(true);
            string = DSUtil.getAttrValue(lDAPEntry, "nsslapd-suffix");
            suffix = this.getSuffix(string, this._rootSuffixes);
            if (suffix == null) {
                suffix = new Suffix();
                suffix.setName(string);
                suffix.setHasRootEntry(this.hasRootEntry(lDAPConnection, suffix));
                this.insertSuffix(suffix);
            }
            database.setSuffix(suffix);
            suffix.addDatabase(database);
        }
        string4 = CHAINING_CONFIG_BASEDN;
        lDAPSearchResults = lDAPConnection.search(string4, 2, string3, stringArray, false, this._searchConstraints);
        while (lDAPSearchResults.hasMoreElements()) {
            lDAPEntry = (LDAPEntry)lDAPSearchResults.nextElement();
            string2 = DSUtil.getAttrValue(lDAPEntry, "cn");
            database = new Database();
            database.setName(string2);
            database.setIsLocal(false);
            string = DSUtil.getAttrValue(lDAPEntry, "nsslapd-suffix");
            suffix = this.getSuffix(string, this._rootSuffixes);
            if (suffix == null) {
                suffix = new Suffix();
                suffix.setName(string);
                suffix.setHasRootEntry(this.hasRootEntry(lDAPConnection, suffix));
                this.insertSuffix(suffix);
            }
            database.setSuffix(suffix);
            suffix.addDatabase(database);
        }
        this._numSubordinateHacker.update(this.getSuffixesWithEntryList(), this.getRootSuffixesWithEntry(), lDAPConnection.getHost(), lDAPConnection.getPort());
    }

    public NumSubordinateHacker getNumSubordinateHacker() {
        return this._numSubordinateHacker;
    }

    public Vector getRootSuffixesWithEntry() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this._rootSuffixes.elements();
        while (enumeration.hasMoreElements()) {
            Suffix suffix = (Suffix)enumeration.nextElement();
            if (!suffix.hasRootEntry()) continue;
            vector.addElement(suffix.getName());
        }
        return vector;
    }

    public Vector getRootSuffixesWithoutEntry() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this._rootSuffixes.elements();
        while (enumeration.hasMoreElements()) {
            Suffix suffix = (Suffix)enumeration.nextElement();
            if (suffix.hasRootEntry()) continue;
            vector.addElement(suffix.getName());
        }
        return vector;
    }

    public Vector getSuffixesWithEntryList() {
        Vector vector = new Vector();
        this.getSuffixesWithEntryList(this._rootSuffixes, vector);
        return vector;
    }

    public Vector getSuffixesWithoutEntryList() {
        Vector vector = new Vector();
        this.getSuffixesWithoutEntryList(this._rootSuffixes, vector);
        return vector;
    }

    public Vector getDatabaseList(int n) {
        Vector vector = new Vector();
        this.getDatabaseList(this._rootSuffixes, vector, n);
        return vector;
    }

    public String getRootSuffixForEntry(String string) {
        DN dN = new DN(string);
        String string2 = null;
        boolean bl = false;
        Enumeration enumeration = this._rootSuffixes.elements();
        while (enumeration.hasMoreElements() && !bl) {
            Suffix suffix = (Suffix)enumeration.nextElement();
            DN dN2 = new DN(suffix.getName());
            if (!dN.equals(dN2) && !dN.isDescendantOf(dN2)) continue;
            bl = true;
            string2 = suffix.getName();
        }
        return string2;
    }

    public String getSuffixForDatabase(String string) {
        Suffix suffix;
        String string2 = null;
        Database database = this.getDatabase(string, this._rootSuffixes);
        if (database != null && (suffix = database.getSuffix()) != null) {
            string2 = suffix.getName();
        }
        return string2;
    }

    public String getParentSuffix(String string) {
        String string2 = null;
        Suffix suffix = this.getParentSuffix(string, this._rootSuffixes);
        if (suffix != null) {
            string2 = suffix.getName();
        }
        return string2;
    }

    public void setHasRootEntry(String string, boolean bl) {
        Suffix suffix = this.getSuffix(string, this._rootSuffixes);
        if (suffix == null) {
            throw new IllegalArgumentException("Suffix " + string + " does not exist");
        }
        suffix.setHasRootEntry(bl);
    }

    private Suffix getParentSuffix(String string, Vector vector) {
        Suffix suffix = null;
        boolean bl = false;
        DN dN = new DN(string);
        int n = 0;
        while (n < vector.size() && !bl) {
            Suffix suffix2 = (Suffix)vector.elementAt(n);
            String string2 = suffix2.getName();
            DN dN2 = new DN(string2);
            if (dN.equals(dN2) || dN2.isDescendantOf(dN)) {
                suffix = suffix2.getParentSuffix();
                if (suffix == null) {
                    suffix = new Suffix();
                    suffix.setName("");
                    suffix.setHasRootEntry(true);
                }
                bl = true;
            } else if (dN.isDescendantOf(dN2)) {
                suffix = this.getParentSuffix(string, suffix2.getChildSuffixes());
                bl = true;
            }
            ++n;
        }
        return suffix;
    }

    private boolean hasRootEntry(LDAPConnection lDAPConnection, Suffix suffix) throws LDAPException {
        boolean bl;
        block4: {
            bl = false;
            String[] stringArray = new String[]{"dn"};
            try {
                if (lDAPConnection.read(suffix.getName(), stringArray, this._searchConstraints) != null) {
                    bl = true;
                }
            }
            catch (LDAPException lDAPException) {
                if (lDAPException instanceof LDAPReferralException) {
                    bl = true;
                }
                if (lDAPException.getLDAPResultCode() == 32) break block4;
                bl = true;
                Debug.println((String)("DatabaseConfig.hasRootEntry: " + (Object)((Object)lDAPException)));
            }
        }
        return bl;
    }

    private void insertSuffix(Suffix suffix) {
        Suffix suffix2 = this.getParentSuffix(suffix, this._rootSuffixes);
        Vector vector = new Vector();
        if (suffix2 == null) {
            this._rootSuffixes.addElement(suffix);
            vector = this.getChildSuffixes(suffix, this._rootSuffixes);
        } else {
            suffix.setParentSuffix(suffix2);
            suffix2.addChildSuffix(suffix);
            vector = this.getChildSuffixes(suffix, suffix2.getChildSuffixes());
        }
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                Suffix suffix3 = (Suffix)vector.elementAt(n);
                suffix.addChildSuffix(suffix3);
                if (suffix3.getParentSuffix() != null) {
                    suffix3.getParentSuffix().removeChildSuffix(suffix3);
                } else {
                    this._rootSuffixes.removeElement(suffix3);
                }
                suffix3.setParentSuffix(suffix);
                ++n;
            }
        }
    }

    private Vector getChildSuffixes(Suffix suffix, Vector vector) {
        Vector<Suffix> vector2 = new Vector<Suffix>();
        DN dN = new DN(suffix.getName());
        int n = 0;
        while (n < vector.size()) {
            Suffix suffix2 = (Suffix)vector.elementAt(n);
            String string = suffix2.getName();
            DN dN2 = new DN(string);
            if (dN2.isDescendantOf(dN)) {
                vector2.addElement(suffix2);
            }
            ++n;
        }
        return vector2;
    }

    private Suffix getParentSuffix(Suffix suffix, Vector vector) {
        Suffix suffix2 = null;
        boolean bl = false;
        DN dN = new DN(suffix.getName());
        int n = 0;
        while (n < vector.size() && !bl) {
            Suffix suffix3 = (Suffix)vector.elementAt(n);
            String string = suffix3.getName();
            DN dN2 = new DN(string);
            if (dN2.isDescendantOf(dN)) {
                bl = true;
            } else if (dN.isDescendantOf(dN2)) {
                Suffix suffix4 = this.getParentSuffix(suffix, suffix3.getChildSuffixes());
                suffix2 = suffix4 == null ? suffix3 : suffix4;
                bl = true;
            }
            ++n;
        }
        return suffix2;
    }

    private Suffix getSuffix(String string, Vector vector) {
        Suffix suffix = null;
        boolean bl = false;
        DN dN = new DN(string);
        int n = 0;
        while (n < vector.size() && !bl) {
            Suffix suffix2 = (Suffix)vector.elementAt(n);
            String string2 = suffix2.getName();
            DN dN2 = new DN(string2);
            if (dN.equals(dN2)) {
                suffix = suffix2;
            } else if (dN2.isDescendantOf(dN)) {
                bl = true;
            } else if (dN.isDescendantOf(dN2)) {
                suffix = this.getSuffix(string, suffix2.getChildSuffixes());
                bl = true;
            }
            ++n;
        }
        return suffix;
    }

    private void getSuffixesWithEntryList(Vector vector, Vector vector2) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Suffix suffix = (Suffix)enumeration.nextElement();
            if (suffix.hasRootEntry()) {
                vector2.addElement(suffix.getName());
            }
            if (suffix.getChildSuffixes() == null) continue;
            this.getSuffixesWithEntryList(suffix.getChildSuffixes(), vector2);
        }
    }

    private void getSuffixesWithoutEntryList(Vector vector, Vector vector2) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Suffix suffix = (Suffix)enumeration.nextElement();
            if (!suffix.hasRootEntry()) {
                vector2.addElement(suffix.getName());
            }
            if (suffix.getChildSuffixes() == null) continue;
            this.getSuffixesWithoutEntryList(suffix.getChildSuffixes(), vector2);
        }
    }

    private void getDatabaseList(Vector vector, Vector vector2, int n) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Suffix suffix = (Suffix)enumeration.nextElement();
            Vector vector3 = suffix.getDatabases();
            if (vector3 != null) {
                Enumeration enumeration2 = vector3.elements();
                while (enumeration2.hasMoreElements()) {
                    Database database = (Database)enumeration2.nextElement();
                    if (n != 2 && (n != 0 || !database.isLocal()) && (n != 1 || database.isLocal())) continue;
                    vector2.addElement(database.getName());
                }
            }
            if (suffix.getChildSuffixes() == null) continue;
            this.getDatabaseList(suffix.getChildSuffixes(), vector2, n);
        }
    }

    private Database getDatabase(String string, Vector vector) {
        Database database = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements() && database == null) {
            Suffix suffix = (Suffix)enumeration.nextElement();
            Vector vector2 = suffix.getDatabases();
            if (vector2 != null) {
                Enumeration enumeration2 = vector2.elements();
                while (enumeration2.hasMoreElements() && database == null) {
                    Database database2 = (Database)enumeration2.nextElement();
                    if (!database2.getName().equals(string)) continue;
                    database = database2;
                }
            }
            if (database != null || suffix.getChildSuffixes() == null) continue;
            database = this.getDatabase(string, suffix.getChildSuffixes());
        }
        return database;
    }
}

