/*
 * Copyright 2007 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef	_SYS_TASK_H
#define	_SYS_TASK_H

#pragma ident	"@(#)task.h	1.4	07/10/04 SMI"

#ifdef	__cplusplus
extern "C" {
#endif

#include <sys/param.h>
#include <sys/types.h>
#include <sys/rctl.h>

#define	TASK_NORMAL	0x0	/* task may create tasks via settaskid() */
#define	TASK_FINAL	0x1	/* task finalized, settaskid() will fail */

#ifdef _KERNEL

#include <sys/id_space.h>
#include <sys/exacct_impl.h>
#include <sys/kmem.h>

struct proc;

typedef struct task {
	taskid_t	tk_tkid;	/* task id			*/
	uint_t		tk_flags;	/* task properties		*/
	struct kproject	*tk_proj;	/* project membership		*/
	uint_t		tk_hold_count;	/* number of members/observers	*/
	struct proc	*tk_memb_list;	/* pointer to the first process */
					/* in a doubly linked list of	*/
					/* task members			*/
	kmutex_t	tk_usage_lock;	/* lock to protect tk_*usage	*/
	task_usage_t	*tk_usage;	/* total task resource usage	*/
	task_usage_t	*tk_prevusage;	/* previous interval usage	*/
	rctl_set_t	*tk_rctls;	/* task's resource controls	*/
	rctl_qty_t	tk_nlwps;	/* number of LWPs within task	*/
	rctl_qty_t	tk_cpu_time;	/* accumulated CPU seconds	*/
	task_usage_t	*tk_inherited;	/* task resource usage		*/
					/* inherited with the first	*/
					/* member process		*/
} task_t;

extern task_t *task0p;
extern rctl_hndl_t rc_task_lwps;
extern rctl_hndl_t rc_task_cpu_time;

extern void task_init(void);
extern task_t *task_create(projid_t);
extern void task_begin(task_t *, struct proc *);
extern void task_attach(task_t *, struct proc *);
extern void task_change(task_t *, struct proc *);
extern void task_detach(struct proc *);
extern task_t *task_hold_by_id(taskid_t);
extern void task_rele(task_t *);
extern void task_hold(task_t *);
extern void task_end(task_t *);

#else /* _KERNEL */

struct task;

extern taskid_t settaskid(projid_t, uint_t);
extern taskid_t gettaskid(void);

#endif /* _KERNEL */

#ifdef	__cplusplus
}
#endif

#endif	/* _SYS_TASK_H */
