/*
 * Copyright 1997-2002 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef _SYS_VIS_H
#define	_SYS_VIS_H

#pragma ident	"@(#)vis.h	1.2	02/06/21 SMI"

#ifdef	__cplusplus
extern "C" {
#endif

/*
 * This file is cpu dependent.
 */

#ifdef _KERNEL

#include <sys/asi.h>
#include <sys/machparam.h>

#ifdef _ASM

#define	BSTORE_FPREGS(FP, TEMP) \
	membar	#Sync; \
	stda	%d0, [FP]ASI_BLK_P; \
	add	FP, 64, TEMP; \
	stda	%d16, [TEMP]ASI_BLK_P; \
	add	FP, 128, TEMP; \
	stda	%d32, [TEMP]ASI_BLK_P; \
	add	FP, 192, TEMP; \
	stda	%d48, [TEMP]ASI_BLK_P; \
	membar	#Sync;

#define	BSTORE_V8_FPREGS(FP, TEMP) \
	membar	#Sync; \
	stda	%d0, [FP]ASI_BLK_P; \
	add	FP, 64, TEMP; \
	stda	%d16, [TEMP]ASI_BLK_P; \
	membar	#Sync;

#define	BSTORE_V8P_FPREGS(FP, TEMP) \
	membar	#Sync; \
	add	FP, 128, TEMP; \
	stda	%d32, [TEMP]ASI_BLK_P; \
	add	FP, 192, TEMP; \
	stda	%d48, [TEMP]ASI_BLK_P; \
	membar	#Sync;

#define	BLOAD_FPREGS(FP, TEMP) \
	membar	#Sync; \
	ldda	[FP]ASI_BLK_P, %d0; \
	add	FP, 64, TEMP; \
	ldda	[TEMP]ASI_BLK_P, %d16; \
	add	FP, 128, TEMP; \
	ldda	[TEMP]ASI_BLK_P, %d32; \
	add	FP, 192, TEMP; \
	ldda	[TEMP]ASI_BLK_P, %d48; \
	membar	#Sync;

#define	BLOAD_V8_FPREGS(FP, TEMP) \
	membar	#Sync; \
	ldda	[FP]ASI_BLK_P, %d0; \
	add	FP, 64, TEMP; \
	ldda	[TEMP]ASI_BLK_P, %d16; \
	membar	#Sync;

#define	BLOAD_V8P_FPREGS(FP, TEMP) \
	membar	#Sync; \
	add	FP, 128, TEMP; \
	ldda	[TEMP]ASI_BLK_P, %d32; \
	add	FP, 192, TEMP; \
	ldda	[TEMP]ASI_BLK_P, %d48; \
	membar	#Sync;

#endif

#define	GSR_SIZE 8	/* Graphics Status Register size 64 bits */

#endif /* _KERNEL */

#ifdef	__cplusplus
}
#endif

#endif	/* _SYS_VIS_H */
