/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.common;

import com.sun.opencard.common.EventListener;
import com.sun.opencard.common.OCFDebug;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class EventDispatcher {
    private LinkedList eventQueue = new LinkedList();
    private boolean isActive = false;

    public void activate() {
        this.isActive = true;
        new Thread(new Runnable(){

            public void run() {
                EventDispatcher.this.handleEvents();
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleEvents() {
        while (this.isActive) {
            Event event;
            LinkedList linkedList = this.eventQueue;
            synchronized (linkedList) {
                while (this.eventQueue.isEmpty()) {
                    try {
                        this.eventQueue.wait();
                        if (this.isActive) continue;
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        OCFDebug.printStackTrace(interruptedException);
                    }
                }
                event = (Event)this.eventQueue.removeFirst();
            }
            event.doNotify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LinkedList linkedList = this.eventQueue;
        synchronized (linkedList) {
            this.isActive = false;
            this.eventQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueueEvent(Object object, Collection collection) {
        Collection collection2 = collection;
        synchronized (collection2) {
            LinkedList linkedList = this.eventQueue;
            synchronized (linkedList) {
                this.eventQueue.addLast(new Event(collection, object));
                this.eventQueue.notifyAll();
            }
        }
    }

    private static class Event {
        private Collection listeners;
        private Object subject;

        Event(Collection collection, Object object) {
            this.listeners = collection;
            this.subject = object;
        }

        void doNotify() {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ((EventListener)iterator.next()).dispatchEvent(this.subject);
            }
        }
    }
}

