/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.patch;

import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.model.PatchPropertyException;
import com.sun.patchpro.model.PatchPropertyNotFoundException;
import com.sun.patchpro.model.PropertyInfo;
import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.patch.PatchException;

public class PatchConfigUtility {
    private PatchProProperties properties;
    private ProviderUtility provUtil;

    PatchConfigUtility(ProviderUtility providerUtility) {
        this.provUtil = providerUtility;
        this.properties = PatchProProperties.getInstance();
    }

    PropertyInfo[] getPropertyInfos(String[] stringArray) throws PatchException {
        try {
            return this.properties.getPropertyInfos(stringArray);
        }
        catch (PatchPropertyException patchPropertyException) {
            this.provUtil.writeLog(2, (Exception)((Object)patchPropertyException));
            throw new PatchException(patchPropertyException.getLocalizedMessage());
        }
    }

    PropertyInfo getPropertyInfo(String string) throws PatchException {
        try {
            return this.properties.getPropertyInfo(string);
        }
        catch (PatchPropertyNotFoundException patchPropertyNotFoundException) {
            return null;
        }
        catch (PatchPropertyException patchPropertyException) {
            this.provUtil.writeLog(2, (Exception)((Object)patchPropertyException));
            throw new PatchException(patchPropertyException.getLocalizedMessage());
        }
    }

    PropertyInfo[] getAllPropertyInfos() throws PatchException {
        try {
            return this.properties.getAllPropertyInfos();
        }
        catch (PatchPropertyException patchPropertyException) {
            this.provUtil.writeLog(2, (Exception)((Object)patchPropertyException));
            throw new PatchException(patchPropertyException.getLocalizedMessage());
        }
    }

    void unSetProperty(String string) throws PatchException {
        try {
            this.properties.unUpdateProperty(string);
        }
        catch (PatchPropertyException patchPropertyException) {
            throw new PatchException(patchPropertyException.getLocalizedMessage());
        }
    }

    void setProperty(String string, String string2) throws PatchException {
        try {
            this.properties.update(string, string2);
        }
        catch (PatchPropertyException patchPropertyException) {
            this.provUtil.writeLog(2, (Exception)((Object)patchPropertyException));
            throw new PatchException(patchPropertyException.getLocalizedMessage());
        }
    }

    void cleanup() {
        PatchProProperties.freeInstance();
    }
}

