/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ajp.tomcat4.config;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Hashtable;
import org.apache.ajp.tomcat4.config.BaseJkConfig;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;

public class ApacheConfig
extends BaseJkConfig {
    public static final String MOD_JK_CONFIG = "conf/auto/mod_jk.conf";
    public static final String WORKERS_CONFIG = "conf/jk/workers.properties";
    public static final String JK_LOG_LOCATION = "logs/mod_jk.log";
    public static final String MOD_JK;
    private File jkConfig = null;
    private File modJk = null;
    private boolean sslExtract = true;
    private String sslHttpsIndicator = "HTTPS";
    private String sslSessionIndicator = "SSL_SESSION_ID";
    private String sslCipherIndicator = "SSL_CIPHER";
    private String sslCertsIndicator = "SSL_CLIENT_CERT";
    Hashtable NamedVirtualHosts = null;
    String indent = "";

    public void setJkConfig(String path) {
        this.jkConfig = path == null ? null : new File(path);
    }

    public void setModJk(String path) {
        this.modJk = path == null ? null : new File(path);
    }

    public void setExtractSSL(boolean sslMode) {
        this.sslExtract = sslMode;
    }

    public void setHttpsIndicator(String s) {
        this.sslHttpsIndicator = s;
    }

    public void setSessionIndicator(String s) {
        this.sslSessionIndicator = s;
    }

    public void setCipherIndicator(String s) {
        this.sslCipherIndicator = s;
    }

    public void setCertsIndicator(String s) {
        this.sslCertsIndicator = s;
    }

    protected void initProperties() {
        super.initProperties();
        this.jkConfig = BaseJkConfig.getConfigFile(this.jkConfig, this.configHome, MOD_JK_CONFIG);
        this.workersConfig = BaseJkConfig.getConfigFile(this.workersConfig, this.configHome, WORKERS_CONFIG);
        this.modJk = this.modJk == null ? new File(MOD_JK) : BaseJkConfig.getConfigFile(this.modJk, this.configHome, MOD_JK);
        this.jkLog = BaseJkConfig.getConfigFile(this.jkLog, this.configHome, JK_LOG_LOCATION);
    }

    protected PrintWriter getWriter() throws IOException {
        String abJkConfig = this.jkConfig.getAbsolutePath();
        return new PrintWriter(new FileWriter(abJkConfig, this.append));
    }

    protected boolean generateJkHead(PrintWriter mod_jk) {
        mod_jk.println("########## Auto generated on " + new Date() + "##########");
        mod_jk.println();
        if (!this.modJk.exists()) {
            this.log("mod_jk location: " + this.modJk);
            this.log("Make sure it is installed corectly or  set the config location");
            this.log("Using <ApacheConfig modJk=\"PATH_TO_MOD_JK.SO_OR_DLL\" />");
        }
        mod_jk.println("<IfModule !mod_jk.c>");
        mod_jk.println("  LoadModule jk_module " + this.modJk.toString().replace('\\', '/'));
        mod_jk.println("</IfModule>");
        mod_jk.println();
        if (!this.workersConfig.exists()) {
            this.log("Can't find workers.properties at " + this.workersConfig);
            this.log("Please install it in the default location or  set the config location");
            this.log("Using <ApacheConfig workersConfig=\"FULL_PATH\" />");
            return false;
        }
        mod_jk.println("JkWorkersFile \"" + this.workersConfig.toString().replace('\\', '/') + "\"");
        mod_jk.println("JkLogFile \"" + this.jkLog.toString().replace('\\', '/') + "\"");
        mod_jk.println();
        if (this.jkDebug != null) {
            mod_jk.println("JkLogLevel " + this.jkDebug);
            mod_jk.println();
        }
        return true;
    }

    protected void generateVhostHead(Host host, PrintWriter mod_jk) {
        String vhostip;
        mod_jk.println();
        String vhost = vhostip = host.getName();
        int ppos = vhost.indexOf(":");
        if (ppos >= 0) {
            vhost = vhost.substring(0, ppos);
        }
        mod_jk.println("<VirtualHost " + vhostip + ">");
        mod_jk.println("    ServerName " + vhost);
        String[] aliases = host.findAliases();
        if (aliases.length > 0) {
            mod_jk.print("    ServerAlias ");
            int ii = 0;
            while (ii < aliases.length) {
                mod_jk.print(aliases[ii] + " ");
                ++ii;
            }
            mod_jk.println();
        }
        this.indent = "    ";
    }

    protected void generateVhostTail(Host host, PrintWriter mod_jk) {
        mod_jk.println("</VirtualHost>");
        this.indent = "";
    }

    protected void generateSSLConfig(PrintWriter mod_jk) {
        if (!this.sslExtract) {
            mod_jk.println("JkExtractSSL Off");
        }
        if (!"HTTPS".equalsIgnoreCase(this.sslHttpsIndicator)) {
            mod_jk.println("JkHTTPSIndicator " + this.sslHttpsIndicator);
        }
        if (!"SSL_SESSION_ID".equalsIgnoreCase(this.sslSessionIndicator)) {
            mod_jk.println("JkSESSIONIndicator " + this.sslSessionIndicator);
        }
        if (!"SSL_CIPHER".equalsIgnoreCase(this.sslCipherIndicator)) {
            mod_jk.println("JkCIPHERIndicator " + this.sslCipherIndicator);
        }
        if (!"SSL_CLIENT_CERT".equalsIgnoreCase(this.sslCertsIndicator)) {
            mod_jk.println("JkCERTSIndicator " + this.sslCertsIndicator);
        }
        mod_jk.println();
    }

    protected void generateStupidMappings(Context context, PrintWriter mod_jk) {
        String ctxPath = context.getPath();
        if (ctxPath == null) {
            return;
        }
        String nPath = "".equals(ctxPath) ? "/" : ctxPath;
        mod_jk.println();
        mod_jk.println(this.indent + "JkMount " + nPath + " " + this.jkWorker);
        if ("".equals(ctxPath)) {
            mod_jk.println(this.indent + "JkMount " + nPath + "* " + this.jkWorker);
            if (context.getParent() instanceof Host) {
                mod_jk.println(this.indent + "DocumentRoot \"" + this.getApacheDocBase(context) + "\"");
            } else {
                mod_jk.println(this.indent + "# To avoid Apache serving root welcome files from htdocs, update DocumentRoot");
                mod_jk.println(this.indent + "# to point to: \"" + this.getApacheDocBase(context) + "\"");
            }
        } else {
            mod_jk.println(this.indent + "JkMount " + nPath + "/* " + this.jkWorker);
        }
    }

    private void generateNameVirtualHost(PrintWriter mod_jk, String ip) {
        if (!this.NamedVirtualHosts.containsKey(ip)) {
            mod_jk.println("NameVirtualHost " + ip + "");
            this.NamedVirtualHosts.put(ip, ip);
        }
    }

    protected void generateContextMappings(Context context, PrintWriter mod_jk) {
        String loginPage;
        String ctxPath = context.getPath();
        Host vhost = this.getHost((Container)context);
        if (this.noRoot && "".equals(ctxPath)) {
            this.log("Ignoring root context in non-forward-all mode  ");
            return;
        }
        mod_jk.println();
        mod_jk.println(this.indent + "#################### " + (vhost != null ? vhost.getName() + ":" : "") + ("".equals(ctxPath) ? "/" : ctxPath) + " ####################");
        mod_jk.println();
        this.generateStaticMappings(context, mod_jk);
        if (context.getLoginConfig() != null && (loginPage = context.getLoginConfig().getLoginPage()) != null) {
            int lpos = loginPage.lastIndexOf("/");
            String jscurl = loginPage.substring(0, lpos + 1) + "j_security_check";
            this.addMapping(ctxPath, jscurl, mod_jk);
        }
        String[] servletMaps = context.findServletMappings();
        int ii = 0;
        while (ii < servletMaps.length) {
            this.addMapping(ctxPath, servletMaps[ii], mod_jk);
            ++ii;
        }
    }

    protected boolean addExtensionMapping(String ctxPath, String ext, PrintWriter mod_jk) {
        if (this.debug > 0) {
            this.log("Adding extension map for " + ctxPath + "/*." + ext);
        }
        mod_jk.println(this.indent + "JkMount " + ctxPath + "/*." + ext + " " + this.jkWorker);
        return true;
    }

    protected boolean addMapping(String fullPath, PrintWriter mod_jk) {
        if (this.debug > 0) {
            this.log("Adding map for " + fullPath);
        }
        mod_jk.println(this.indent + "JkMount " + fullPath + "  " + this.jkWorker);
        return true;
    }

    protected boolean addMapping(String ctxP, String ext, PrintWriter mod_jk) {
        if (this.debug > 0) {
            this.log("Adding map for " + ext);
        }
        if (!ext.startsWith("/")) {
            ext = "/" + ext;
        }
        if (ext.length() > 1) {
            mod_jk.println(this.indent + "JkMount " + ctxP + ext + "  " + this.jkWorker);
        }
        return true;
    }

    private void generateWelcomeFiles(Context context, PrintWriter mod_jk) {
        String[] wf = context.findWelcomeFiles();
        if (wf == null || wf.length == 0) {
            return;
        }
        mod_jk.print(this.indent + "    DirectoryIndex ");
        int i = 0;
        while (i < wf.length) {
            mod_jk.print(wf[i] + " ");
            ++i;
        }
        mod_jk.println();
    }

    private void generateStaticMappings(Context context, PrintWriter mod_jk) {
        String ctxPath = context.getPath();
        String docBase = this.getApacheDocBase(context);
        if (!"".equals(ctxPath)) {
            mod_jk.println(this.indent + "# Static files ");
            mod_jk.println(this.indent + "Alias " + ctxPath + " \"" + docBase + "\"");
            mod_jk.println();
        } else if (this.getHost((Container)context) != null) {
            mod_jk.println(this.indent + "DocumentRoot \"" + this.getApacheDocBase(context) + "\"");
        } else {
            mod_jk.println(this.indent + "# Be sure to update DocumentRoot");
            mod_jk.println(this.indent + "# to point to: \"" + docBase + "\"");
        }
        mod_jk.println(this.indent + "<Directory \"" + docBase + "\">");
        mod_jk.println(this.indent + "    Options Indexes FollowSymLinks");
        this.generateWelcomeFiles(context, mod_jk);
        mod_jk.println(this.indent + "</Directory>");
        mod_jk.println();
        mod_jk.println();
        mod_jk.println(this.indent + "# Deny direct access to WEB-INF and META-INF");
        mod_jk.println(this.indent + "#");
        mod_jk.println(this.indent + "<Location \"" + ctxPath + "/WEB-INF/*\">");
        mod_jk.println(this.indent + "    AllowOverride None");
        mod_jk.println(this.indent + "    deny from all");
        mod_jk.println(this.indent + "</Location>");
        mod_jk.println();
        mod_jk.println(this.indent + "<Location \"" + ctxPath + "/META-INF/*\">");
        mod_jk.println(this.indent + "    AllowOverride None");
        mod_jk.println(this.indent + "    deny from all");
        mod_jk.println(this.indent + "</Location>");
        if (File.separatorChar == '\\') {
            mod_jk.println(this.indent + "#");
            mod_jk.println(this.indent + "# Use Directory too. On Windows, Location doesn't" + " work unless case matches");
            mod_jk.println(this.indent + "#");
            mod_jk.println(this.indent + "<Directory \"" + docBase + "/WEB-INF/\">");
            mod_jk.println(this.indent + "    AllowOverride None");
            mod_jk.println(this.indent + "    deny from all");
            mod_jk.println(this.indent + "</Directory>");
            mod_jk.println();
            mod_jk.println(this.indent + "<Directory \"" + docBase + "/META-INF/\">");
            mod_jk.println(this.indent + "    AllowOverride None");
            mod_jk.println(this.indent + "    deny from all");
            mod_jk.println(this.indent + "</Directory>");
        }
        mod_jk.println();
    }

    private String getApacheDocBase(Context context) {
        String docBase = this.getAbsoluteDocBase(context);
        if (File.separatorChar == '\\') {
            docBase = docBase.replace('\\', '/');
        }
        return docBase;
    }

    private String getVirtualHostAddress(String vhost, String vhostip) {
        if (vhostip == null) {
            vhostip = vhost != null && vhost.length() > 0 && Character.isDigit(vhost.charAt(0)) ? vhost : "*";
        }
        return vhostip;
    }

    static {
        MOD_JK_CONFIG = MOD_JK_CONFIG;
        WORKERS_CONFIG = WORKERS_CONFIG;
        JK_LOG_LOCATION = JK_LOG_LOCATION;
        String os = System.getProperty("os.name").toLowerCase();
        MOD_JK = os.indexOf("windows") >= 0 ? "modules/mod_jk.dll" : (os.indexOf("netware") >= 0 ? "modules/mod_jk.nlm" : "libexec/mod_jk.so");
    }
}

