/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.parser;

import com.sun.patchpro.host.ControllerHardwareComponent;
import com.sun.patchpro.host.HardwareComponent;
import com.sun.patchpro.host.Host;
import com.sun.patchpro.host.LoopCardHardwareComponent;
import com.sun.patchpro.host.T3PartnerPair;
import com.sun.patchpro.host.T4PartnerPair;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.util.LocalizedMessages;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class StoradeXmlTranslator
extends DefaultHandler {
    PatchProLog log;
    Host host;
    StringBuffer textBuffer;
    String value = "";
    String deviceType = "";
    String componentType = "";
    String attributeId = "";
    String ipAddress;
    String attributeValue = "";
    boolean isController = false;
    boolean isLoopCard = false;
    int numComponents = 0;
    Vector fruIdValueVector = new Vector();
    Vector fruModelValueVector = new Vector();
    Vector fruRevisionValueVector = new Vector();
    Vector level2VersionValueVector = new Vector();
    Vector loopCardVersionValueVector = new Vector();
    Vector fruSerialNoValueVector = new Vector();
    Vector fruVendorValueVector = new Vector();
    Vector associatedHostsVector = new Vector();
    boolean componentExists = false;
    PatchProProperties properties = PatchProProperties.getInstance();
    LocalizedMessages msgcat = new LocalizedMessages(this.properties.getLocale());

    public StoradeXmlTranslator() {
        this(null, null);
    }

    public StoradeXmlTranslator(String string, Host host) {
        this.log = PatchProLog.getInstance();
        this.log.println(this, 7, "Entered StoradeXmlTranslator() with arguments.");
        this.host = host;
        this.log.println(this, 7, "The file is: " + string);
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(true);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(new File(string), (DefaultHandler)this);
        }
        catch (SAXParseException sAXParseException) {
            this.log.println(this, 3, "SAX Parser Exception");
            this.log.println(this, 3, "Parsing error, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId() + sAXParseException.getMessage());
            this.log.printStackTrace(this, 3, sAXParseException);
            Exception exception = sAXParseException;
            if (sAXParseException.getException() != null) {
                exception = sAXParseException.getException();
            }
            this.log.printStackTrace(this, 3, exception);
        }
        catch (SAXException sAXException) {
            this.log.println(this, 3, "SAX Exception");
            this.log.println(this, 3, "Parser-initialization error" + sAXException.getMessage());
            this.log.printStackTrace(this, 3, sAXException);
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            this.log.printStackTrace(this, 3, exception);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.log.println(this, 3, "Parser ConfigurationException");
            this.log.println(this, 3, parserConfigurationException.getMessage());
            this.log.printStackTrace(this, 3, parserConfigurationException);
        }
        catch (Throwable throwable) {
            this.log.println(this, 3, throwable.getMessage());
            this.log.printStackTrace(this, 3, throwable);
        }
    }

    public void startDocument() throws SAXException {
        this.log.println(this, 7, "Start of document.");
    }

    public void endDocument() throws SAXException {
        this.log.println(this, 7, "End of document.");
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        int n;
        this.log.println(this, 7, "Entered StoradeXmlTranslator.startElement().");
        String string4 = string2;
        if ("".equals(string4)) {
            string4 = string3;
        }
        if (attributes != null && (n = attributes.getLength()) == 1) {
            String string5 = attributes.getValue(0);
            this.log.println(this, 7, "The current attribute value: " + string5);
            this.attributeId = "";
            if ("attribute".equals(string4) && "sysRevision".equals(string5)) {
                this.attributeId = string5;
            }
            if ("device".equals(string4)) {
                this.deviceType = string5;
                if (!"".equals(this.deviceType) && !"sp".equals(this.deviceType)) {
                    this.deviceType = this.properties.getProperty("patchpro.storade.translate." + this.deviceType, this.deviceType);
                }
            }
            if ("component".equals(string4)) {
                this.componentType = string5;
                this.isController = false;
                this.isLoopCard = false;
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.log.println(this, 7, "Entered StoradeXmlTranslator.endElement().");
        if (!"".equals(this.deviceType) && !"sp".equals(this.deviceType)) {
            this.assignValue();
            String string4 = string2;
            if ("".equals(string4)) {
                string4 = string3;
            }
            this.log.println(this, 7, "The parsed value is: " + this.value);
            this.log.println(this, 7, "StoradeXmlTranslator.endElement(): eName= " + string4);
            if (!this.value.equals("")) {
                if ("ip".equals(string4)) {
                    this.ipAddress = this.value;
                }
                if ("attribute".equals(string4) && "sysRevision".equals(this.attributeId)) {
                    this.attributeValue = this.value;
                } else if ("fruId".equals(string4)) {
                    this.fruIdValueVector.addElement(this.value);
                } else if ("fruModel".equals(string4)) {
                    this.fruModelValueVector.addElement(this.value);
                } else if ("fruRevision".equals(string4)) {
                    this.fruRevisionValueVector.addElement(this.value);
                } else if ("ctlrVersion".equals(string4)) {
                    this.level2VersionValueVector.addElement(this.value);
                    this.log.println(this, 7, "StoradeXmlTranslator.endElement(): added ctlrVersion.");
                    this.isController = true;
                } else if ("loopVersion".equals(string4)) {
                    this.loopCardVersionValueVector.addElement(this.value);
                    this.log.println(this, 7, "StoradeXmlTranslator.endElement(): added loopCardVersion");
                    this.isLoopCard = true;
                } else if ("fruSerialNo".equals(string4)) {
                    this.fruSerialNoValueVector.addElement(this.value);
                } else if ("fruVendor".equals(string4)) {
                    this.fruVendorValueVector.addElement(this.value);
                }
            }
            if ("component".equals(string4)) {
                if (!this.componentExists) {
                    this.componentExists = true;
                }
                ++this.numComponents;
                if (!"".equals(this.componentType) && !"sp".equals(this.componentType)) {
                    if (!this.isController) {
                        this.level2VersionValueVector.addElement("");
                        this.log.println(this, 7, "StoradeXmlTranslator.endElement(): added empty ctlrVersion");
                    }
                    if (!this.isLoopCard) {
                        this.loopCardVersionValueVector.addElement("");
                        this.log.println(this, 7, "StoradeXmlTranslator.endElement(): added empty loopCardVersion");
                    }
                }
            }
            if ("device".equals(string4)) {
                this.createHost(this.componentExists);
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        if (this.textBuffer == null) {
            this.textBuffer = new StringBuffer(string);
        } else {
            this.textBuffer.append(string);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void error(SAXParseException sAXParseException) throws SAXParseException {
        throw sAXParseException;
    }

    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        this.log.println(this, 4, "StoradeXMLTranslator: warning(), line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId() + sAXParseException.getMessage());
    }

    private void createHost(boolean bl) throws SAXException {
        Object object;
        Object object2;
        this.log.println(this, 7, "Entered StoradeXmlTranslator.createHost()");
        Vector<HardwareComponent> vector = new Vector<HardwareComponent>();
        if (bl) {
            this.log.println(this, 7, "StoradeXmlTranslator.createHost(): Component exists");
            int n = 0;
            int n2 = 0;
            while (n2 < this.numComponents) {
                object2 = (String)this.fruIdValueVector.elementAt(n2);
                this.log.println(this, 7, "The fruId: " + (String)object2);
                if (((String)object2).length() == 5 && ((String)object2).startsWith("u") && ((String)object2).endsWith("ctr")) {
                    ++n;
                }
                this.log.println(this, 7, "The number of controllers: " + n);
                object = (String)this.fruModelValueVector.elementAt(n2);
                String string = (String)this.fruRevisionValueVector.elementAt(n2);
                String string2 = (String)this.level2VersionValueVector.elementAt(n2);
                String string3 = (String)this.loopCardVersionValueVector.elementAt(n2);
                String string4 = (String)this.fruSerialNoValueVector.elementAt(n2);
                String string5 = (String)this.fruVendorValueVector.elementAt(n2);
                if ("".equals(string2) && "".equals(string3)) {
                    HardwareComponent hardwareComponent = new HardwareComponent(string5, (String)object, string, string4, (String)object2);
                    vector.addElement(hardwareComponent);
                } else if (!"".equals(string2) && "".equals(string3)) {
                    ControllerHardwareComponent controllerHardwareComponent = new ControllerHardwareComponent(string5, (String)object, string, string4, string2, (String)object2);
                    controllerHardwareComponent.setLevel3Version(this.attributeValue);
                    vector.addElement(controllerHardwareComponent);
                } else if ("".equals(string2) && !"".equals(string3)) {
                    LoopCardHardwareComponent loopCardHardwareComponent = new LoopCardHardwareComponent(string5, (String)object, string, string4, string3, (String)object2);
                    vector.addElement(loopCardHardwareComponent);
                }
                ++n2;
            }
            if (n > 1) {
                this.deviceType = this.deviceType + "PP";
                if ("T3pp".equals(this.deviceType)) {
                    this.deviceType = this.msgcat.getMessage("patchpro.storade.translate.t3pp", "T3PP");
                } else if ("T4PP".equals(this.deviceType)) {
                    this.deviceType = this.msgcat.getMessage("patchpro.storade.translate.t4pp", "T4PP");
                }
            }
        }
        if ("T3PP".equals(this.deviceType)) {
            object2 = new T3PartnerPair();
            ((T3PartnerPair)object2).setMasterControllerIP(this.ipAddress);
        } else if ("T4PP".equals(this.deviceType)) {
            object2 = new T4PartnerPair();
            ((T4PartnerPair)object2).setMasterControllerIP(this.ipAddress);
        } else {
            object2 = new Host();
        }
        ((Host)object2).markAsAssociate(true);
        ((Host)object2).setType(this.deviceType);
        ((Host)object2).setAddress(this.ipAddress);
        if ("SVE".equals(this.deviceType)) {
            ((Host)object2).setArchitecture("sparc");
            ((Host)object2).setOperatingSystem("SunOS");
            ((Host)object2).setOSRelease("5.9");
        }
        if ("T3".equals(this.deviceType) || "T3PP".equals(this.deviceType) || "T4".equals(this.deviceType) || "T4PP".equals(this.deviceType)) {
            ((Host)object2).setArchitecture("ppc");
            ((Host)object2).setOperatingSystem("pSOS");
            ((Host)object2).setOSRelease("2.5.1");
            ((Host)object2).setPrimaryHost(this.host);
        }
        this.log.println(this, 7, "Creating enumeration of hardwareComponents and adding it to associated Host.");
        if (vector.size() != 0) {
            object = vector.elements();
            ((Host)object2).addHardwareComponents((Enumeration)object);
        }
        try {
            this.host.addAssociate((Host)object2);
            this.log.println(this, 6, "The associated host added: " + ((Host)object2).getType());
        }
        catch (IllegalAccessException illegalAccessException) {
            this.log.println(this, 4, "StoradeXmlTranslator.createHost(): " + illegalAccessException.getMessage());
            this.log.printStackTrace(this, 2, illegalAccessException);
        }
        this.numComponents = 0;
        this.fruIdValueVector.clear();
        this.fruModelValueVector.clear();
        this.fruRevisionValueVector.clear();
        this.level2VersionValueVector.clear();
        this.loopCardVersionValueVector.clear();
        this.fruSerialNoValueVector.clear();
        this.fruVendorValueVector.clear();
    }

    private void assignValue() throws SAXException {
        if (this.textBuffer == null) {
            return;
        }
        String string = "" + this.textBuffer;
        this.value = string.trim();
        this.log.println(this, 7, "StoradeXmlTranslator.getHosts(): The current parsed value= " + this.value);
        this.textBuffer = null;
    }
}

