/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.model;

import com.sun.patchpro.host.ReadOnlyHost;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.HostSpecificProperties;
import com.sun.patchpro.model.PatchPropertyException;
import com.sun.patchpro.model.PatchPropertyNotFoundException;
import com.sun.patchpro.model.PropertyInfo;
import com.sun.patchpro.util.InstallationParameters;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class PatchProProperties {
    private static final String DOT = ".";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String BASE_PATCH_PROPERTIES = "com.sun.patchpro.conf.Config";
    private static final String CONFIG_FILE = "Config.properties";
    private static final String PWCONFIG_FILE = "secret.conf";
    private static final String TMP = "/tmp";
    private static final String PROPERTY_FILE_HEADER = "# THIS FILE IS WRITTEN BY A PROGRAM.\n# Normally you should change the values in this file using\n# the Patch Manager commands (see smpatch (1M)).\n#\n# If you change this file by hand, subsequently running\n# the pprosetup to modify property values will\n# cause any comments that you added to be removed. In\n## addition, the property settings might be reordered.\n#";
    private static final String SECRET_FILE_HEADER = "# THIS FILE IS WRITTEN BY A PROGRAM.\n# Normally you should change the values in this file using\n# the Patch Manager commands (see smpatch (1M)).\n#\n# This file is confidential. It is only readable by root.\n#";
    private static final String DEFAULT = ".default";
    private static final String PUBLIC = ".public";
    private static final String SECRET = ".secret";
    private static final String DESCRIPTION = ".description";
    private static final long STEP = 500000L;
    private static final long TIMEOUT = 5000000L;
    private static PatchProProperties ppprops;
    static final String NO_INSTALL_ALLOWED = "Policy does not allow installation of patches.";
    static final String KEYSTORE_LOCATION_NOT_DEFINED = "patchpro.security.kslocation is not defined.";
    static final String KEYSTORE_DOES_NOT_EXIST = "patchpro.security.kslocation is defined but the file does not exist.";
    protected static Properties props;
    private static Properties staticProps;
    private Properties defaultProps;
    private Locale locale;
    private String configFile;
    private String pwConfigFile;
    private boolean[] interactive = new boolean[2];
    private boolean[] singleuser = new boolean[2];
    private boolean[] rebootafter = new boolean[2];
    private boolean[] reconfigafter = new boolean[2];
    private boolean[] rebootimmediate = new boolean[2];
    private boolean[] reconfigimmediate = new boolean[2];
    private boolean[] nonstandard = new boolean[2];
    private boolean[] discontinued = new boolean[2];
    private boolean[] pointpatch = new boolean[2];
    private boolean[] obsolete = new boolean[2];
    private boolean[] standard = new boolean[2];
    private boolean[] noncontract = new boolean[2];
    private boolean[] clientroot = new boolean[2];
    private boolean[] clientusr = new boolean[2];
    private static InstallationParameters instParms;
    protected String localeString;
    protected static PatchProLog log;

    protected PatchProProperties() {
        this(PatchProProperties.getUserConfigFilePath(), PatchProProperties.getPWConfigFilePath());
    }

    private static void getInstParms() {
        if (instParms == null) {
            instParms = InstallationParameters.getInstance();
        }
    }

    private static String getUserConfigFilePath() {
        PatchProProperties.getInstParms();
        return instParms.getUserConfigFilePath();
    }

    private static String getPWConfigFilePath() {
        PatchProProperties.getInstParms();
        return instParms.getPWConfigFilePath();
    }

    protected PatchProProperties(Properties properties) {
        String string;
        props = properties;
        this.defaultProps = new Properties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (!string.endsWith(DEFAULT) && !string.endsWith(PUBLIC) && !string.endsWith(DESCRIPTION) && !string.endsWith(SECRET) || properties.getProperty(string + DEFAULT) != null) continue;
            this.defaultProps.setProperty(string, properties.getProperty(string));
        }
        instParms = InstallationParameters.getInstance();
        log = PatchProLog.getInstance();
        string = "patchpro.install.types";
        String string2 = this.getProperty(string, "");
        this.setPatchProperties(true, string2);
        string = "patchpro.patch.install.patchtype";
        string2 = this.getProperty(string, "");
        this.setPatchProperties(false, string2);
    }

    private static String getCorrespondingPWFile(String string) {
        if (string == null) {
            return null;
        }
        return new File(string).getParent() + File.separator + PWCONFIG_FILE;
    }

    protected PatchProProperties(String string) {
        this(string, PatchProProperties.getCorrespondingPWFile(string));
    }

    protected PatchProProperties(String string, String string2) {
        PatchProProperties.getInstParms();
        this.configFile = string;
        this.pwConfigFile = string2;
        log = PatchProLog.getInstance();
        this.locale = this.getLocale();
        props = new Properties();
        this.defaultProps = new Properties();
        String string3 = instParms.getClassesDirectoryPath();
        this.loadDefaultPatchProperties(this.getPropertyFiles(string3));
        if (this.configFile != null) {
            this.loadConfigFile(this.configFile);
        }
        if (this.pwConfigFile != null) {
            this.loadConfigFile(this.pwConfigFile);
        }
        String string4 = "patchpro.install.types";
        String string5 = this.getProperty(string4, "");
        this.setPatchProperties(true, string5);
        string4 = "patchpro.patch.install.patchtype";
        string5 = this.getProperty(string4, "");
        this.setPatchProperties(false, string5);
        this.localeString = this.getProperty("patchpro.locale");
        if (this.localeString == null || this.localeString.length() == 0) {
            this.localeString = Locale.getDefault().toString();
            if (this.localeString.length() == 0) {
                this.localeString = "C";
            }
        }
    }

    public static PatchProProperties getInstance(String string) {
        if (ppprops == null) {
            ppprops = new PatchProProperties(string);
        }
        return ppprops;
    }

    public static PatchProProperties getInstance() {
        if (ppprops == null) {
            ppprops = new PatchProProperties();
        }
        return ppprops;
    }

    public static void freeInstance() {
        ppprops = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update(String string, String string2) throws PatchPropertyException {
        String string3;
        File file;
        if (this.defaultProps.getProperty(this.baseKey(string) + DEFAULT) == null) {
            String string4 = "The " + string + " property does not exist.";
            String[] stringArray = new String[]{string};
            throw new PatchPropertyNotFoundException("patchproperties.no.property", stringArray, string4);
        }
        String string5 = this.defaultProps.getProperty(string + SECRET);
        if (string5 != null && string5.equals(TRUE)) {
            file = new File(this.pwConfigFile);
            string3 = SECRET_FILE_HEADER;
        } else {
            file = new File(this.configFile);
            string3 = PROPERTY_FILE_HEADER;
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        this.createCFGLock(file);
        try {
            try {
                fileInputStream = new FileInputStream(file);
                Properties properties = new Properties();
                properties.load(fileInputStream);
                properties.setProperty(string, string2);
                props.setProperty(string, string2);
                fileOutputStream = new FileOutputStream(file);
                properties.store(fileOutputStream, string3);
            }
            catch (IOException iOException) {
                String string6 = "IO Error: Failed to access file " + file;
                String[] stringArray = new String[]{file.toString()};
                throw new PatchPropertyException("patchproperties.io.error", stringArray, string6);
            }
            Object var12_12 = null;
            this.removeCFGLock(file);
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            this.removeCFGLock(file);
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (fileOutputStream == null) throw throwable;
                fileOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        if (fileInputStream != null) {
            fileInputStream.close();
        }
        if (fileOutputStream == null) return;
        fileOutputStream.close();
        return;
    }

    private String baseKey(String string) {
        int n = string.indexOf("@");
        if (n >= 0) {
            string = string.substring(0, n);
        }
        if ((n = string.indexOf("/")) >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    public Object setProperty(String string, String string2) {
        return props.setProperty(string, string2);
    }

    public Object setClassSpecificProperty(String string, String string2, String string3) {
        return this.setProperty(string2 + "/" + string, string3);
    }

    public Object setHostSpecificProperty(String string, String string2, String string3) {
        return this.setProperty(string2 + "@" + string, string3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unUpdateProperty(String string) throws PatchPropertyException {
        String string2;
        File file;
        if (this.defaultProps.getProperty(this.baseKey(string) + DEFAULT) == null) {
            String string3 = "The " + string + " property does not exist.";
            String[] stringArray = new String[]{string};
            throw new PatchPropertyNotFoundException("patchproperties.no.property", stringArray, string3);
        }
        if (props.getProperty(string) == null) {
            return;
        }
        String string4 = this.defaultProps.getProperty(string + SECRET);
        if (string4 != null && string4.equals(TRUE)) {
            file = new File(this.pwConfigFile);
            string2 = SECRET_FILE_HEADER;
        } else {
            file = new File(this.configFile);
            string2 = PROPERTY_FILE_HEADER;
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        this.createCFGLock(file);
        try {
            try {
                fileInputStream = new FileInputStream(file);
                Properties properties = new Properties();
                properties.load(fileInputStream);
                properties.remove(string);
                props.remove(string);
                fileOutputStream = new FileOutputStream(file);
                properties.store(fileOutputStream, string2);
            }
            catch (IOException iOException) {
                String string5 = "IO Error: Failed to access file " + file;
                String[] stringArray = new String[]{file.toString()};
                throw new PatchPropertyException("patchproperties.io.error", stringArray, string5);
            }
            Object var11_11 = null;
            this.removeCFGLock(file);
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.removeCFGLock(file);
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (fileOutputStream == null) throw throwable;
                fileOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        if (fileInputStream != null) {
            fileInputStream.close();
        }
        if (fileOutputStream == null) return;
        fileOutputStream.close();
        return;
    }

    public PropertyInfo getPropertyInfo(String string) throws PatchPropertyNotFoundException {
        PropertyInfo propertyInfo = new PropertyInfo();
        String string2 = this.defaultProps.getProperty(string + DEFAULT);
        if (string2 == null) {
            String string3 = "The " + string + " property does not exist.";
            String[] stringArray = new String[]{string};
            throw new PatchPropertyNotFoundException("patchproperties.no.property", stringArray, string3);
        }
        propertyInfo.setDefaultValue(string2);
        string2 = this.defaultProps.getProperty(string + PUBLIC);
        if (string2 == null) {
            string2 = FALSE;
        }
        propertyInfo.setPublicFlag(new Boolean(string2));
        string2 = this.defaultProps.getProperty(string + DESCRIPTION);
        if (string2 == null) {
            string2 = string;
        }
        propertyInfo.setDescription(string2);
        string2 = this.defaultProps.getProperty(string + SECRET);
        if (string2 == null) {
            string2 = FALSE;
        }
        propertyInfo.setSecretFlag(new Boolean(string2));
        string2 = props.getProperty(string);
        propertyInfo.setCurrentValue(string2);
        propertyInfo.setPropertyName(string);
        return propertyInfo;
    }

    public PropertyInfo[] getPropertyInfos(String[] stringArray) throws PatchPropertyException {
        ArrayList<PropertyInfo> arrayList = new ArrayList<PropertyInfo>();
        int n = 0;
        while (n < stringArray.length) {
            arrayList.add(this.getPropertyInfo(stringArray[n]));
            ++n;
        }
        return arrayList.toArray(new PropertyInfo[arrayList.size()]);
    }

    public synchronized PropertyInfo[] getAllPropertyInfos() throws PatchPropertyException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<?> enumeration = this.defaultProps.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.endsWith(DEFAULT)) continue;
            int n = string.lastIndexOf(DOT);
            String string2 = string.substring(0, n);
            arrayList.add(string2);
        }
        return this.getPropertyInfos(arrayList.toArray(new String[arrayList.size()]));
    }

    public String getProperty(String string) {
        String string2;
        if (staticProps != null && (string2 = staticProps.getProperty(string)) != null) {
            return string2;
        }
        string2 = props.getProperty(string);
        if (string2 != null) {
            return string2;
        }
        return this.defaultProps.getProperty(string + DEFAULT);
    }

    public String getProperty(String string, String string2) {
        String string3 = this.getProperty(string);
        if (string3 != null) {
            return string3;
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Locale getLocale() {
        block19: {
            if (PatchProProperties.props != null) return Locale.getDefault();
            var3_1 = null;
            var4_2 = new Properties();
            try {
                try {
                    var3_1 = new FileInputStream(PatchProProperties.instParms.getUserConfigFilePath());
                    var4_2.load((InputStream)var3_1);
                    var2_3 = var4_2.getProperty("patchpro.locale");
                    if (var2_3 != null && !var2_3.equals("")) break block19;
                    var5_4 = Locale.getDefault();
                    var8_7 = null;
                }
                catch (IOException var5_5) {
                    var6_16 = Locale.getDefault();
                    var8_9 = null;
                    try {
                        if (var3_1 == null) return var6_16;
                        var3_1.close();
                        return var6_16;
                    }
                    catch (Exception var9_14) {
                        // empty catch block
                    }
                    return var6_16;
                }
            }
            catch (Throwable var7_18) {
                var8_10 = null;
                ** try [egrp 2[TRYBLOCK] [5 : 98->109)] { 
lbl29:
                // 1 sources

                if (var3_1 == null) throw var7_18;
                var3_1.close();
                throw var7_18;
lbl32:
                // 1 sources

                catch (Exception var9_15) {
                    // empty catch block
                }
                throw var7_18;
            }
            ** try [egrp 2[TRYBLOCK] [5 : 98->109)] { 
lbl37:
            // 1 sources

            if (var3_1 == null) return var5_4;
            var3_1.close();
            return var5_4;
lbl40:
            // 1 sources

            catch (Exception var9_12) {
                // empty catch block
            }
            return var5_4;
        }
        var8_8 = null;
        try {}
        catch (Exception var9_13) {}
        if (var3_1 != null) {
            var3_1.close();
        }
        var3_1 = new StringTokenizer(var2_3, "_", true);
        var4_2 = new String[3];
        var5_6 = "";
        var6_17 = "";
        var7_19 = 0;
        var8_11 = 0;
        while (var8_11 < 3) {
            var4_2[var8_11] = "";
            ++var8_11;
        }
        while (true) {
            if (!var3_1.hasMoreTokens()) {
                return new Locale(var4_2[0], var4_2[1], var4_2[2]);
            }
            if (var7_19 == 2 && var3_1.countTokens() > 0) {
                var5_6 = var3_1.nextToken();
                if (var3_1.countTokens() > 0) {
                    var5_6 = var3_1.nextToken("\t\n\r\f");
                }
            } else {
                var5_6 = var3_1.nextToken();
            }
            if (var5_6.equals("_")) {
                if (var6_17.equals("") || var6_17.equals("_")) {
                    var4_2[var7_19++] = "";
                }
            } else {
                var4_2[var7_19++] = var5_6;
            }
            var6_17 = var5_6;
        }
    }

    public PatchProProperties getHostSpecificProperties(ReadOnlyHost readOnlyHost) {
        HostSpecificProperties hostSpecificProperties = new HostSpecificProperties(this.localeString, readOnlyHost, props);
        return hostSpecificProperties;
    }

    public boolean installIsAllowed(boolean bl) {
        boolean bl2 = false;
        if (bl) {
            if (this.mayStandard(bl) || this.maySingleuser(bl) || this.mayReconfigafter(bl) || this.mayRebootafter(bl) || this.mayReconfigimmediate(bl) || this.mayRebootimmediate(bl) || this.mayInteractive(bl)) {
                bl2 = true;
            }
        } else if (this.mayStandard(bl) || this.maySingleuser(bl) || this.mayReconfigafter(bl) || this.mayRebootafter(bl) || this.mayReconfigimmediate(bl) || this.mayRebootimmediate(bl)) {
            bl2 = true;
        }
        if (!bl2) {
            log.println(this, 7, NO_INSTALL_ALLOWED);
        }
        return bl2;
    }

    public boolean installAuthenticationRequired() {
        boolean bl = true;
        bl = this.getProperty("patchpro.patch.install.authenticate", TRUE).equals(TRUE);
        return bl;
    }

    public boolean downloadAuthenticationRequired() {
        boolean bl = true;
        bl = this.getProperty("patchpro.patch.download.authenticate", TRUE).equals(TRUE);
        return bl;
    }

    public boolean keystoreIsPresent() {
        boolean bl = true;
        String string = null;
        string = this.getProperty("patchpro.security.kslocation");
        if (string == null) {
            bl = false;
            log.println(this, 2, KEYSTORE_LOCATION_NOT_DEFINED);
        }
        if (!new File(string).exists()) {
            bl = false;
            log.println(this, 2, KEYSTORE_DOES_NOT_EXIST);
        }
        return bl;
    }

    protected void setPatchProperties(boolean bl, String string) {
        Vector<String> vector = new Vector<String>();
        int n = bl ? 0 : 1;
        this.interactive[n] = false;
        this.singleuser[n] = false;
        this.rebootafter[n] = false;
        this.reconfigafter[n] = false;
        this.rebootimmediate[n] = false;
        this.reconfigimmediate[n] = false;
        this.nonstandard[n] = false;
        this.discontinued[n] = false;
        this.pointpatch[n] = false;
        this.obsolete[n] = false;
        this.standard[n] = false;
        if (string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                vector.add(string2);
                if (string2.equals("standard")) {
                    this.standard[n] = true;
                }
                if (string2.equals("singleuser")) {
                    this.singleuser[n] = true;
                }
                if (string2.equals("reconfigafter")) {
                    this.reconfigafter[n] = true;
                }
                if (string2.equals("rebootafter")) {
                    this.rebootafter[n] = true;
                }
                if (string2.equals("reconfigimmediate")) {
                    this.reconfigimmediate[n] = true;
                }
                if (string2.equals("rebootimmediate")) {
                    this.rebootimmediate[n] = true;
                }
                if (string2.equals("interactive")) {
                    this.interactive[n] = true;
                }
                if (string2.equals("nonstandard")) {
                    this.nonstandard[n] = true;
                }
                if (string2.equals("discontinued")) {
                    this.discontinued[n] = true;
                }
                if (string2.equals("pointpatch")) {
                    this.pointpatch[n] = true;
                }
                if (string2.equals("obsolete")) {
                    this.obsolete[n] = true;
                }
                if (string2.equals("clientroot")) {
                    this.clientroot[n] = true;
                }
                if (string2.equals("clientusr")) {
                    this.clientusr[n] = true;
                }
                if (!string2.equals("noncontract")) continue;
                this.noncontract[n] = true;
            }
        }
    }

    public boolean mayStandard(boolean bl) {
        return bl ? this.standard[0] : this.standard[1];
    }

    public boolean mayRebootafter(boolean bl) {
        return bl ? this.rebootafter[0] : this.rebootafter[1];
    }

    public boolean mayReconfigafter(boolean bl) {
        return bl ? this.reconfigafter[0] : this.reconfigafter[1];
    }

    public boolean mayRebootimmediate(boolean bl) {
        return bl ? this.rebootimmediate[0] : this.rebootimmediate[1];
    }

    public boolean mayReconfigimmediate(boolean bl) {
        return bl ? this.reconfigimmediate[0] : this.reconfigimmediate[1];
    }

    public boolean mayInteractive(boolean bl) {
        return bl ? this.interactive[0] : this.interactive[1];
    }

    public boolean maySingleuser(boolean bl) {
        return bl ? this.singleuser[0] : this.singleuser[1];
    }

    public boolean mayNonstandard(boolean bl) {
        return bl ? this.nonstandard[0] : this.nonstandard[1];
    }

    public boolean mayDiscontinued(boolean bl) {
        return bl ? this.discontinued[0] : this.discontinued[1];
    }

    public boolean mayPointpatch(boolean bl) {
        return bl ? this.pointpatch[0] : this.pointpatch[1];
    }

    public boolean mayObsolete(boolean bl) {
        return bl ? this.obsolete[0] : this.obsolete[1];
    }

    public void load(InputStream inputStream) throws IOException {
        props.load(inputStream);
        String string = "patchpro.install.types";
        String string2 = this.getProperty(string, "");
        this.setPatchProperties(true, string2);
        string = "patchpro.patch.install.patchtype";
        string2 = this.getProperty(string, "");
        this.setPatchProperties(false, string2);
    }

    public void dump() {
        Enumeration<?> enumeration = props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            log.println(this, 7, string + " = " + props.getProperty(string));
        }
    }

    public Enumeration propertyNames() {
        return props.propertyNames();
    }

    private String[] getPropertyFiles(String string) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(string);
        if (file.isDirectory()) {
            String[] stringArray2 = file.list();
            if (stringArray2 == null) {
                String string2 = "IO Error: Unable to access the " + string + " file.";
                String[] stringArray3 = new String[]{string};
                throw new PatchPropertyException("patchproperties.io.error", stringArray3, string2);
            }
            if (stringArray2.length != 0) {
                int n = 0;
                while (n < stringArray2.length) {
                    File file2 = new File(string, stringArray2[n]);
                    if (file2.isDirectory()) {
                        stringArray = this.getPropertyFiles(file2.getAbsolutePath());
                        if (stringArray != null && stringArray.length != 0) {
                            int n2 = 0;
                            while (n2 < stringArray.length) {
                                arrayList.add(stringArray[n2]);
                                ++n2;
                            }
                        }
                    } else if (stringArray2[n].equals(CONFIG_FILE)) {
                        arrayList.add(file2.getAbsolutePath());
                    }
                    ++n;
                }
            }
        }
        if (arrayList.size() != 0) {
            stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public void useAlternate(String string) throws IOException {
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(instParms.getConfigDirectoryPath() + "/" + string);
        }
        if (file.exists()) {
            this.load(new FileInputStream(file));
        } else {
            file.createNewFile();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadConfigFile(String string) {
        FileInputStream fileInputStream = null;
        String string2 = null;
        String[] stringArray = null;
        File file = new File(string);
        this.createCFGLock(file);
        try {
            try {
                fileInputStream = new FileInputStream(file);
                props.load(fileInputStream);
            }
            catch (IOException iOException) {
                stringArray = new String[]{string};
                string2 = "IO Error: Failed to read file " + string;
                throw new PatchPropertyException("patchproperties.io.error", stringArray, string2);
            }
            Object var8_6 = null;
            this.removeCFGLock(file);
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.removeCFGLock(file);
            try {
                if (fileInputStream == null) throw throwable;
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        if (fileInputStream == null) return;
        fileInputStream.close();
        return;
    }

    private void loadDefaultPatchProperties(String[] stringArray) {
        String string = instParms.getClassesDirectoryPath();
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n].replace('/', '.');
            string2 = string2.substring(string.length() + 1, string2.lastIndexOf(DOT));
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string2, this.locale);
            Enumeration<String> enumeration = resourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                String string3 = enumeration.nextElement();
                props.setProperty(string3, resourceBundle.getString(string3));
                this.defaultProps.setProperty(string3, resourceBundle.getString(string3));
            }
            ++n;
        }
    }

    protected static void setStaticProperty(String string, String string2) {
        if (staticProps == null) {
            staticProps = new Properties();
        }
        staticProps.setProperty(string, string2);
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public String getPWConfigFile() {
        return this.pwConfigFile;
    }

    private File CFGLockName(File file) {
        return new File(file.getPath() + ".lock");
    }

    public boolean removeCFGLock(File file) {
        return this.CFGLockName(file).delete();
    }

    public boolean checkCFGLock(File file) {
        return this.CFGLockName(file).exists();
    }

    public void createCFGLock(File file) throws PatchPropertyException {
        long l = 5000000L;
        File file2 = this.CFGLockName(file);
        while (true) {
            String string = null;
            String[] stringArray = null;
            if (file2.exists() && l > 0L) {
                try {
                    Thread.sleep(500000L);
                    l -= 500000L;
                }
                catch (Exception exception) {}
            } else if (file2.exists() && l <= 0L) {
                string = "old lock file " + file2 + " was not removed. Please manually remove it and try it again.";
                stringArray = new String[]{file2.toString()};
                throw new PatchPropertyException("patchproperties.lock.remove.error", stringArray, string);
            }
            try {
                if (file2.createNewFile()) break;
            }
            catch (IOException iOException) {
                string = "IO Error: Failed to create lock file " + file2 + ": " + iOException.getLocalizedMessage();
                stringArray = new String[]{file2 + ": " + iOException.getLocalizedMessage()};
                throw new PatchPropertyException("patchproperties.lock.create", stringArray, string);
            }
        }
    }

    static {
        staticProps = null;
        instParms = null;
    }
}

