/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.model;

import com.sun.net.ssl.internal.ssl.Provider;
import com.sun.patchpro.analysis.DetectorFailedException;
import com.sun.patchpro.analysis.HostAnalyzer;
import com.sun.patchpro.analysis.InteractiveAnalyzer;
import com.sun.patchpro.analysis.NoMoreDetectorsException;
import com.sun.patchpro.database.DBBuilderFailedException;
import com.sun.patchpro.database.GroupPatchDBBuilder;
import com.sun.patchpro.database.PatchDB;
import com.sun.patchpro.database.PatchDBBuilder;
import com.sun.patchpro.host.Host;
import com.sun.patchpro.host.ReadOnlyHost;
import com.sun.patchpro.host.SessionData;
import com.sun.patchpro.interpreter.HostSpecificInterpreter;
import com.sun.patchpro.interpreter.ParseError;
import com.sun.patchpro.log.ApplicationLog;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.mail.MailerImpl;
import com.sun.patchpro.model.BaseDataDetectorEvent;
import com.sun.patchpro.model.BaseDataDetectorListener;
import com.sun.patchpro.model.DownloadDetectorsEvent;
import com.sun.patchpro.model.DownloadDetectorsListener;
import com.sun.patchpro.model.DownloadPatchDBEvent;
import com.sun.patchpro.model.DownloadPatchDBListener;
import com.sun.patchpro.model.DownloadPatchEvent;
import com.sun.patchpro.model.DownloadPatchListener;
import com.sun.patchpro.model.InstallPatchEvent;
import com.sun.patchpro.model.InstallPatchListener;
import com.sun.patchpro.model.InternalErrorException;
import com.sun.patchpro.model.Messagable;
import com.sun.patchpro.model.NonFatalException;
import com.sun.patchpro.model.PatchPro;
import com.sun.patchpro.model.PatchProEvent;
import com.sun.patchpro.model.PatchProException;
import com.sun.patchpro.model.PatchProListener;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.model.PatchProStateMachine;
import com.sun.patchpro.model.RealizationDetectorEvent;
import com.sun.patchpro.model.RealizationDetectorListener;
import com.sun.patchpro.model.SequencerEvent;
import com.sun.patchpro.model.SequencerListener;
import com.sun.patchpro.model.SessionProperties;
import com.sun.patchpro.model.StatusEMail;
import com.sun.patchpro.patch.GroupPatchSequencer;
import com.sun.patchpro.patch.MalformedPatchException;
import com.sun.patchpro.patch.NoSuchPatchException;
import com.sun.patchpro.patch.Patch;
import com.sun.patchpro.patch.PatchAccumulator;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.patch.PatchImpl;
import com.sun.patchpro.patch.PatchList;
import com.sun.patchpro.patch.PatchListImpl;
import com.sun.patchpro.server.GroupPatchDownloader;
import com.sun.patchpro.server.ServerProxyAuthenticator;
import com.sun.patchpro.util.GroupPatchBundleInstaller;
import com.sun.patchpro.util.InteractionSet;
import com.sun.patchpro.util.LocalizedMessages;
import com.sun.patchpro.util.MalformedStateException;
import com.sun.patchpro.util.NoResultException;
import com.sun.patchpro.util.NoSuchStateException;
import com.sun.patchpro.util.Percentage;
import com.sun.patchpro.util.ProxyServer;
import java.io.File;
import java.net.Authenticator;
import java.security.Security;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class PatchProModel
implements PatchPro,
SequencerListener,
RealizationDetectorListener,
Messagable {
    protected PatchProStateMachine stateMachine;
    protected PatchProLog log;
    protected PatchListImpl patchList;
    protected GroupPatchBundleInstaller patchInstaller;
    private LocalizedMessages msgcat;
    protected InteractiveAnalyzer interactiveAnalyzer = null;
    protected String criticalFailureMsg;
    protected String[] ccList = new String[]{""};
    private Throwable thrownFailure = null;
    protected PatchProProperties properties;
    protected HostAnalyzer hostAnalyzer;
    private boolean downloadAuthenticate = true;
    private MailerImpl mailerImpl;
    private Collection patchProExceptions;
    private Host hostToInstall = null;
    private String hostToInstallAddress = null;
    private ServerProxyAuthenticator serverProxyAuthenticator = null;
    protected File patchDirectory;
    PatchList patchesToInstall;
    protected File backoutDirectory;
    protected GroupPatchSequencer sequencer;
    protected GroupPatchDBBuilder dbBuilder;
    protected GroupPatchDownloader patchDownloader;
    protected Locale locale;
    protected boolean hostIsExternal = false;
    private Host targetHost;
    private ReadOnlyHost readOnlyTargetHost = null;
    private PatchListImpl sequencerResult;
    private PatchListImpl downloadResult;
    private PatchListImpl installResult;
    private Percentage patchproProgress;
    public Percentage baseDataDetectorProgress;
    public Percentage downloadPatchDBProgress;
    public Percentage downloadDetectorsProgress;
    public Percentage realizationDetectorProgress;
    public Percentage realizationSetProgress;
    public Percentage sequencerProgress;
    public Percentage downloadPatchProgress;
    public Percentage installPatchProgress;
    InnerSequencerThread innerSequencerThread;
    InnerDownloadPatchThread innerDownloadPatchThread;
    InnerInstallPatchThread innerInstallPatchThread;
    private Vector patchproListeners = new Vector();
    private Vector downloadDetectorsListeners = new Vector();
    private Vector downloadPatchDBListeners = new Vector();
    private Vector baseDataDetectorListeners = new Vector();
    private Vector realizationDetectorListeners = new Vector();
    private Vector sequencerListeners = new Vector();
    private Vector downloadPatchListeners = new Vector();
    private Vector installPatchListeners = new Vector();
    protected boolean baseDataDetectorsDone = false;
    protected boolean downloadDetectorsDone = false;
    protected boolean downloadSetDone = false;
    protected boolean downloadPatchDBDone = false;
    protected boolean realizationDetectorsDone = false;
    protected boolean sequencerDone = false;
    protected boolean downloadPatchDone = false;
    protected boolean installPatchDone = false;
    protected boolean hostIsAbbreviated = false;
    protected boolean buildingDatabaseOnly = false;
    private static boolean modelIsInteractive = true;
    PatchListImpl downloadedPatchList = null;

    public PatchProModel(PatchProProperties patchProProperties) throws PatchProException {
        String string;
        this.properties = patchProProperties;
        this.log = PatchProLog.getInstance();
        try {
            string = patchProProperties.getProperty("patchpro.log.file", "system");
            this.log.setLogger(new ApplicationLog(string));
        }
        catch (Exception exception) {
            this.log.printStackTrace(this, 3, exception);
        }
        this.msgcat = new LocalizedMessages(this.properties.getLocale());
        string = patchProProperties.getProperty("patchpro.security.kslocation");
        if (string == null || string.compareTo("") == 0) {
            throw new PatchProException("Critical failure. Unable to determine keystore location.");
        }
        System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
        Security.addProvider((java.security.Provider)new Provider());
        System.setProperty("javax.net.ssl.trustStore", string);
        String string2 = patchProProperties.getProperty("patchpro.proxy.user", "");
        String string3 = patchProProperties.getProperty("patchpro.proxy.passwd", "");
        if (string2 != null && string2.compareTo("") != 0 && string3 != null && string3.compareTo("") != 0) {
            this.serverProxyAuthenticator = new ServerProxyAuthenticator(string2, string3);
            Authenticator.setDefault(this.serverProxyAuthenticator);
        }
        String string4 = patchProProperties.getProperty("patchpro.proxy.host");
        String string5 = patchProProperties.getProperty("patchpro.proxy.port");
        if (string4 != null && string5 != null) {
            System.setProperty("https.proxyHost", string4);
            System.setProperty("https.proxyPort", string5);
            System.setProperty("http.proxyHost", string4);
            System.setProperty("http.proxyPort", string5);
        }
        this.stateMachine = new PatchProStateMachine(patchProProperties, this);
        try {
            this.mailerImpl = new MailerImpl();
        }
        catch (Exception exception) {
            this.log.printStackTrace(this, 3, exception);
        }
        try {
            this.initializeModel();
        }
        catch (MalformedStateException malformedStateException) {
            this.log.printStackTrace(this, 2, malformedStateException);
            throw new PatchProException("Critical failure.  State machine has faulty state " + malformedStateException.getMessage());
        }
        catch (Exception exception) {
            this.log.printStackTrace(this, 2, exception);
            throw new PatchProException("Critical failure.  PatchProModel instantiation error " + exception.getMessage());
        }
    }

    public synchronized void initializeModel() throws Exception {
        ProxyServer proxyServer = ProxyServer.getInstance();
        this.hostAnalyzer = new HostAnalyzer();
        this.dbBuilder = new GroupPatchDBBuilder(null);
        this.downloadAuthenticate = this.properties.getProperty("patchpro.patch.download.authenticate", "true").equals("true");
        this.patchInstaller = new GroupPatchBundleInstaller(this);
        String string = this.properties.getProperty("patchpro.sun.user");
        String string2 = this.properties.getProperty("patchpro.sun.passwd");
    }

    public void initializeDatabase() {
        this.initializeProgress();
        this.buildingDatabaseOnly = true;
        InnerInitializeDatabaseThread innerInitializeDatabaseThread = new InnerInitializeDatabaseThread();
        innerInitializeDatabaseThread.setModel(this);
        innerInitializeDatabaseThread.start();
    }

    public void generateAbbreviatedHost() {
        this.initializeProgress();
        this.hostIsAbbreviated = true;
        InnerAbbreviatedHostThread innerAbbreviatedHostThread = new InnerAbbreviatedHostThread();
        innerAbbreviatedHostThread.setModel(this);
        innerAbbreviatedHostThread.start();
    }

    public void analyzeHost() {
        this.initializeProgress();
        this.hostIsAbbreviated = false;
        InnerAnalyzeHostThread innerAnalyzeHostThread = new InnerAnalyzeHostThread();
        innerAnalyzeHostThread.setModel(this);
        innerAnalyzeHostThread.start();
    }

    public void assessNeededPatches() {
        this.initializeProgress();
        this.hostIsAbbreviated = false;
        this.innerSequencerThread = new InnerSequencerThread();
        this.innerSequencerThread.setModel(this);
        this.innerSequencerThread.start();
    }

    public void downloadPatches(PatchList patchList, File file) {
        this.patchDirectory = file;
        this.hostIsAbbreviated = false;
        if (this.readOnlyTargetHost == null) {
            this.targetHost = new Host();
            this.readOnlyTargetHost = this.targetHost;
            this.hostIsExternal = true;
            this.patchDownloader = new GroupPatchDownloader(this, this.readOnlyTargetHost);
        }
        this.readOnlyTargetHost.getSessionData().setLatestDownloadDestination(this.patchDirectory);
        this.readOnlyTargetHost.getSessionData().setPatchesRequired(patchList);
        this.stateMachine.forcePatchList();
        this.initializeProgress();
        this.innerDownloadPatchThread = new InnerDownloadPatchThread();
        this.innerDownloadPatchThread.setModel(this);
        this.innerDownloadPatchThread.start();
    }

    public void downloadPatches(boolean bl) {
        this.hostIsAbbreviated = false;
        if (bl) {
            this.stateMachine.forcePatchList();
        }
        this.patchDirectory = new File(this.properties.getProperty("patchpro.download.directory"));
        this.initializeProgress();
        this.innerDownloadPatchThread = new InnerDownloadPatchThread();
        this.innerDownloadPatchThread.setModel(this);
        this.innerDownloadPatchThread.start();
    }

    public void downloadPatches() {
        this.downloadPatches(false);
    }

    public void installPatches() {
        this.installPatches(null, null, null);
    }

    public void installPatches(File file) {
        this.installPatches(null, null, file);
    }

    public void installPatches(PatchList patchList, File file) {
        this.installPatches(patchList, file, null);
    }

    public void installPatches(PatchList patchList, File file, File file2) {
        if (patchList != null) {
            this.patchesToInstall = patchList;
        } else {
            try {
                this.patchesToInstall = this.getNeededPatches();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.patchDirectory = file == null ? new File(this.properties.getProperty("patchpro.download.directory")) : file;
        this.backoutDirectory = file2;
        this.initializeProgress();
        this.innerInstallPatchThread = new InnerInstallPatchThread();
        this.innerInstallPatchThread.setModel(this);
        this.hostIsAbbreviated = false;
        this.stateMachine.forcePatchList();
        if (this.hostIsExternal) {
            String string = "InternalErrorException.REMEDY";
            if (this.readOnlyTargetHost == null) {
                String string2 = "InternalErrorException.NOHOST_MESSAGE";
                InternalErrorException internalErrorException = new InternalErrorException("InternalErrorException", string2, string, 3);
                InstallPatchEvent installPatchEvent = new InstallPatchEvent(this, string2);
                this.setPatchProFailure(internalErrorException);
                Vector<InternalErrorException> vector = new Vector<InternalErrorException>();
                vector.add(internalErrorException);
                this.setPatchProExceptions(vector);
                this.innerInstallPatchThread.installPatchFailed(installPatchEvent);
                return;
            }
            try {
                Host host = this.hostAnalyzer.getTargetBase();
                if (host.getOperatingSystem().compareTo(this.readOnlyTargetHost.getOperatingSystem()) != 0 || host.getOSRelease().compareTo(this.readOnlyTargetHost.getOSRelease()) != 0 || host.getPlatform().compareTo(this.readOnlyTargetHost.getPlatform()) != 0 || host.getArchitecture().compareTo(this.readOnlyTargetHost.getArchitecture()) != 0) {
                    String string3 = "InternalErrorException.WRONGHOST_MESSAGE";
                    InternalErrorException internalErrorException = new InternalErrorException("InternalErrorException", string3, string, 3);
                    InstallPatchEvent installPatchEvent = new InstallPatchEvent(this, string3);
                    this.setPatchProFailure(internalErrorException);
                    Vector<InternalErrorException> vector = new Vector<InternalErrorException>();
                    vector.add(internalErrorException);
                    this.setPatchProExceptions(vector);
                    this.innerInstallPatchThread.installPatchFailed(installPatchEvent);
                    return;
                }
                this.readOnlyTargetHost.getSessionData().setPatchesRequired(this.patchesToInstall);
            }
            catch (DetectorFailedException detectorFailedException) {
                String string4 = "InternalErrorException.DETECTOR_MESSAGE";
                InternalErrorException internalErrorException = new InternalErrorException("InternalErrorException", string4, string, 3);
                InstallPatchEvent installPatchEvent = new InstallPatchEvent(this, string4);
                this.setPatchProFailure(internalErrorException);
                Vector<InternalErrorException> vector = new Vector<InternalErrorException>();
                vector.add(internalErrorException);
                this.setPatchProExceptions(vector);
                this.innerInstallPatchThread.installPatchFailed(installPatchEvent);
                return;
            }
        } else {
            this.targetHost.getSessionData().setPatchesRequired(this.patchesToInstall);
        }
        this.innerInstallPatchThread.start();
    }

    public void setInteractive(boolean bl) {
        modelIsInteractive = bl;
    }

    public boolean isInteractive() {
        return modelIsInteractive;
    }

    public boolean isAbbreviatedHost() {
        return this.hostIsAbbreviated;
    }

    public boolean isBuildingDBOnly() {
        return this.buildingDatabaseOnly;
    }

    public Properties getSessionProperties() {
        return new SessionProperties();
    }

    public Throwable getPatchProFailure() {
        if (this.thrownFailure == null) {
            return new Exception("Unknown Failure");
        }
        return this.thrownFailure;
    }

    private synchronized PatchAccumulator getPatchAccumulator(ReadOnlyHost readOnlyHost) {
        if (readOnlyHost == null) {
            throw new NoResultException("Couldn't find the host object");
        }
        return new PatchAccumulator(readOnlyHost, this.locale);
    }

    public PatchAccumulator getPatchAccumulator(String string) throws PatchProException {
        if (this.readOnlyTargetHost == null) {
            throw new NoResultException("Couldn't find the host object");
        }
        Host host = this.readOnlyTargetHost.getAssociateByAddress(string);
        return this.getPatchAccumulator(host);
    }

    public PatchAccumulator getPatchAccumulator() {
        if (this.readOnlyTargetHost == null) {
            throw new NoResultException("Couldn't find the host object");
        }
        return this.getPatchAccumulator(this.readOnlyTargetHost);
    }

    public PatchList getNeededPatches() {
        PatchListImpl patchListImpl = (PatchListImpl)this.readOnlyTargetHost.getSessionData().getPatchesRequired();
        return patchListImpl;
    }

    public PatchList getNeededPatches(String string) throws PatchProException {
        Host host = this.readOnlyTargetHost.getAssociateByAddress(string);
        return host.getSessionData().getPatchesRequired();
    }

    public PatchList getUnavailablePatches() {
        ReadOnlyHost readOnlyHost = (ReadOnlyHost)this.stateMachine.getActionResult(9);
        SessionData sessionData = readOnlyHost.getSessionData();
        return sessionData.getPatchesNotDownloaded();
    }

    public PatchList getUninstalledPatches() {
        PatchList patchList = (PatchList)this.stateMachine.getActionResult(10);
        return patchList;
    }

    public void setHost(ReadOnlyHost readOnlyHost) {
        this.readOnlyTargetHost = readOnlyHost;
        this.initializeHostData(readOnlyHost);
        this.targetHost = null;
        this.hostIsExternal = true;
        this.stateMachine.forceHost(readOnlyHost);
    }

    public ReadOnlyHost getAbbreviatedHost() {
        if (!this.hostIsExternal) {
            this.readOnlyTargetHost = (ReadOnlyHost)this.stateMachine.getActionResult(1);
        }
        return this.readOnlyTargetHost;
    }

    public ReadOnlyHost getHost() {
        if (!this.hostIsExternal) {
            this.readOnlyTargetHost = (ReadOnlyHost)this.stateMachine.getActionResult(1);
        }
        return this.readOnlyTargetHost;
    }

    public Enumeration evaluatePatchListExpression(String string) throws ParseError {
        Enumeration enumeration = this.evaluatePatchListExpression(string, this.readOnlyTargetHost);
        return enumeration;
    }

    public Enumeration evaluatePatchListExpression(String string, String string2) throws PatchProException, ParseError {
        Host host = this.readOnlyTargetHost.getAssociateByAddress(string2);
        Enumeration enumeration = this.evaluatePatchListExpression(string, host);
        return enumeration;
    }

    private Enumeration evaluatePatchListExpression(String string, ReadOnlyHost readOnlyHost) throws ParseError {
        Vector<PatchID> vector = new Vector<PatchID>();
        String[] stringArray = new String[]{};
        HostSpecificInterpreter hostSpecificInterpreter = readOnlyHost.getSessionData().getInterpreter();
        if (string == null) {
            throw new ParseError("Expression is null.");
        }
        if (string.compareTo("") != 0) {
            if (string.indexOf("(") > -1) {
                stringArray = hostSpecificInterpreter.getPatchList(string);
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                stringArray = new String[stringTokenizer.countTokens()];
                int n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    stringArray[n++] = stringTokenizer.nextToken();
                }
            }
        }
        int n = 0;
        while (n < stringArray.length) {
            try {
                vector.add(new PatchID(stringArray[n]));
            }
            catch (MalformedPatchException malformedPatchException) {
                this.log.println(this, 4, "PatchProModel.evaluatePatchListExpression(): Malformed patch ID on applied Patch. " + malformedPatchException.getMessage());
                this.log.printStackTrace(this, 4, malformedPatchException);
            }
            ++n;
        }
        return vector.elements();
    }

    public int getExitCode(String string) throws ParseError {
        int n = this.getExitCode(string, this.readOnlyTargetHost);
        return n;
    }

    public int getExitCode(String string, String string2) throws ParseError, PatchProException {
        Host host = this.readOnlyTargetHost.getAssociateByAddress(string2);
        int n = this.getExitCode(string, host);
        return n;
    }

    private int getExitCode(String string, ReadOnlyHost readOnlyHost) throws ParseError {
        HostSpecificInterpreter hostSpecificInterpreter = readOnlyHost.getSessionData().getInterpreter();
        return hostSpecificInterpreter.getExitCode(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(PatchProListener patchProListener) {
        Vector vector = this.patchproListeners;
        synchronized (vector) {
            this.patchproListeners.addElement(patchProListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DownloadDetectorsListener downloadDetectorsListener) {
        Vector vector = this.downloadDetectorsListeners;
        synchronized (vector) {
            this.downloadDetectorsListeners.addElement(downloadDetectorsListener);
        }
    }

    public void addListener(DownloadPatchDBListener downloadPatchDBListener) {
        this.dbBuilder.addListener(downloadPatchDBListener);
    }

    public void addListener(BaseDataDetectorListener baseDataDetectorListener) {
        this.hostAnalyzer.addListener(baseDataDetectorListener);
    }

    public void addListener(RealizationDetectorListener realizationDetectorListener) {
        this.hostAnalyzer.addListener(realizationDetectorListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(SequencerListener sequencerListener) {
        Vector vector = this.sequencerListeners;
        synchronized (vector) {
            this.sequencerListeners.addElement(sequencerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DownloadPatchListener downloadPatchListener) {
        Vector vector = this.downloadPatchListeners;
        synchronized (vector) {
            this.downloadPatchListeners.addElement(downloadPatchListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(InstallPatchListener installPatchListener) {
        Vector vector = this.installPatchListeners;
        synchronized (vector) {
            this.installPatchListeners.addElement(installPatchListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(PatchProListener patchProListener) {
        Vector vector = this.patchproListeners;
        synchronized (vector) {
            this.patchproListeners.removeElement(patchProListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(DownloadDetectorsListener downloadDetectorsListener) {
        Vector vector = this.downloadDetectorsListeners;
        synchronized (vector) {
            this.downloadDetectorsListeners.removeElement(downloadDetectorsListener);
        }
    }

    public void removeListener(DownloadPatchDBListener downloadPatchDBListener) {
        this.dbBuilder.removeListener(downloadPatchDBListener);
    }

    public void removeListener(BaseDataDetectorListener baseDataDetectorListener) {
        this.hostAnalyzer.removeListener(baseDataDetectorListener);
    }

    public void removeListener(RealizationDetectorListener realizationDetectorListener) {
        this.hostAnalyzer.removeListener(realizationDetectorListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(SequencerListener sequencerListener) {
        Vector vector = this.sequencerListeners;
        synchronized (vector) {
            this.sequencerListeners.removeElement(sequencerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(DownloadPatchListener downloadPatchListener) {
        Vector vector = this.downloadPatchListeners;
        synchronized (vector) {
            this.downloadPatchListeners.removeElement(downloadPatchListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(InstallPatchListener installPatchListener) {
        Vector vector = this.installPatchListeners;
        synchronized (vector) {
            this.installPatchListeners.removeElement(installPatchListener);
        }
    }

    public void initializeInteractiveDetectors() {
        this.interactiveAnalyzer = new InteractiveAnalyzer(this.targetHost);
    }

    public synchronized InteractionSet nextInteractiveDetector() throws NoMoreDetectorsException, DetectorFailedException {
        return this.interactiveAnalyzer.nextInteractiveDetector();
    }

    public InteractionSet priorInteractiveDetector() throws NoMoreDetectorsException, DetectorFailedException {
        return this.interactiveAnalyzer.priorInteractiveDetector();
    }

    public void setInteractionSet(InteractionSet interactionSet) throws DetectorFailedException {
        this.interactiveAnalyzer.setInteractionSet(interactionSet);
    }

    public boolean hasNextInteractiveDetector() {
        return this.interactiveAnalyzer.hasNextInteractiveDetector();
    }

    public boolean hasPriorInteractiveDetector() {
        return this.interactiveAnalyzer.hasPriorInteractiveDetector();
    }

    public void finishedInteractiveDetectors() {
        this.interactiveAnalyzer.finished();
    }

    public void begin() {
    }

    public synchronized Host runTargetInfo() {
        try {
            this.targetHost = this.hostAnalyzer.getTargetBase();
            this.readOnlyTargetHost = this.targetHost;
            this.hostIsExternal = false;
            this.initializeHostData(this.readOnlyTargetHost);
        }
        catch (Exception exception) {
            this.log.printStackTrace(this, 2, exception);
            this.throwCriticalFailure("Critical failure. " + exception.getMessage());
        }
        return this.targetHost;
    }

    private void initializeHostData(ReadOnlyHost readOnlyHost) {
        SessionData sessionData = readOnlyHost.getSessionData();
        sessionData.createProperties();
        sessionData.createPatchDBBuilder();
        sessionData.createInterpreter();
        Enumeration enumeration = readOnlyHost.getAssociates();
        while (enumeration.hasMoreElements()) {
            Host host = (Host)enumeration.nextElement();
            host.markAsAssociate(true);
            sessionData = host.getSessionData();
            sessionData.createProperties();
            sessionData.createPatchDBBuilder();
            sessionData.createInterpreter();
        }
        this.patchDownloader = new GroupPatchDownloader(this, this.readOnlyTargetHost);
    }

    public synchronized void createInterpreter() {
        try {
            this.readOnlyTargetHost.getSessionData().createInterpreter();
            Enumeration enumeration = this.readOnlyTargetHost.getAssociates();
            while (enumeration.hasMoreElements()) {
                ReadOnlyHost readOnlyHost = (ReadOnlyHost)enumeration.nextElement();
                readOnlyHost.getSessionData().createInterpreter();
            }
        }
        catch (Exception exception) {
            this.log.printStackTrace(this, 2, exception);
            this.throwCriticalFailure("Critical failure. " + exception.getMessage());
        }
    }

    public synchronized void downloadDetectors() throws Exception {
        try {
            this.hostAnalyzer.addListener(this);
            this.hostAnalyzer.downloadDetectors();
            while (!this.downloadDetectorsDone) {
                Thread.sleep(1000L);
            }
        }
        catch (Exception exception) {
            this.setPatchProFailure(exception);
            throw exception;
        }
        this.hostAnalyzer.removeListener(this);
    }

    public void realizationDetectorProgress(RealizationDetectorEvent realizationDetectorEvent) {
        this.realizationDetectorProgress = ((HostAnalyzer)realizationDetectorEvent.getSource()).getRealizationProgress();
        this.updateAnalyzeHostProgress();
        this.dispatchPatchProProgressEvent(new PatchProEvent(this));
    }

    public void realizationDetectorDone(RealizationDetectorEvent realizationDetectorEvent) {
        this.downloadDetectorsDone = true;
        this.updateAnalyzeHostProgress();
    }

    public void realizationDetectorFailed(RealizationDetectorEvent realizationDetectorEvent) {
        Throwable throwable = null;
        try {
            throwable = new Throwable(realizationDetectorEvent.getErrorMessage());
            this.setPatchProFailure(throwable);
            this.log.println(this, 3, "Realization set failed." + throwable.getMessage());
            this.dispatchPatchProFailedEvent(new PatchProEvent(this));
        }
        catch (Exception exception) {
            this.log.printStackTrace(this, 3, exception);
        }
    }

    public ReadOnlyHost downloadPatchDB() throws Exception {
        try {
            this.dbBuilder.buildDB(this.readOnlyTargetHost);
        }
        catch (DBBuilderFailedException dBBuilderFailedException) {
            this.setPatchProFailure(dBBuilderFailedException);
            throw dBBuilderFailedException;
        }
        catch (Exception exception) {
            this.setPatchProFailure(exception);
            throw exception;
        }
        return this.readOnlyTargetHost;
    }

    public void runBaseDataDetectors() {
        this.baseDataDetectorsDone = false;
        try {
            this.hostAnalyzer.runBaseDataDetectors();
            while (!this.baseDataDetectorsDone) {
                Thread.sleep(100L);
            }
        }
        catch (Exception exception) {
            this.log.printStackTrace(this, 2, exception);
            this.setPatchProFailure(exception);
        }
    }

    public Host runRealizationDetectors() throws DetectorFailedException {
        try {
            this.hostAnalyzer.addListener(this);
            this.hostAnalyzer.runRealizationDetectors();
            this.realizationDetectorsDone = true;
            this.hostIsExternal = false;
        }
        catch (Exception exception) {
            this.setPatchProFailure(exception);
            DetectorFailedException detectorFailedException = new DetectorFailedException(exception.getMessage());
            throw detectorFailedException;
        }
        this.hostAnalyzer.removeListener(this);
        return this.targetHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadOnlyHost runSequencer() throws Exception {
        this.sequencer = new GroupPatchSequencer(this.readOnlyTargetHost, this.locale);
        this.sequencer.addSequencerListener(this);
        try {
            try {
                this.sequencer.getPatchLists();
                this.sequencerDone = true;
            }
            catch (Error error) {
                this.log.println(this, 3, "non-descript failure during sequencing. " + error.getMessage());
                this.log.printStackTrace(this, 3, error);
                throw new Exception("Sequencer failed.");
            }
            catch (Throwable throwable) {
                this.log.println(this, 3, "non-descript failure while closing database. " + throwable.getMessage());
                this.log.printStackTrace(this, 3, throwable);
                Object var4_2 = null;
                this.sequencer.removeSequencerListener(this);
            }
            Object var4_1 = null;
            this.sequencer.removeSequencerListener(this);
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.sequencer.removeSequencerListener(this);
            throw throwable;
        }
        return this.readOnlyTargetHost;
    }

    public ReadOnlyHost performPatchDownload() throws Exception {
        this.log.println(this, 7, "Entering performPatchDownload...");
        this.patchDownloader.downloadPatches();
        this.downloadPatchDone = true;
        return this.readOnlyTargetHost;
    }

    public ReadOnlyHost performPatchInstallation() {
        this.log.println(this, 7, "Entering performPatchInstallation...");
        try {
            this.patchInstaller.install((Host)this.readOnlyTargetHost);
            this.installPatchDone = true;
        }
        catch (Exception exception) {
            this.log.printStackTrace(this, 3, exception);
        }
        return this.readOnlyTargetHost;
    }

    public void done() {
    }

    public void setPatchProFailure(Throwable throwable) {
        this.thrownFailure = throwable;
    }

    public void criticalFailure(String string) {
        this.criticalFailureMsg = this.criticalFailureMsg == null || this.criticalFailureMsg.compareTo("") == 0 ? string : this.criticalFailureMsg + "\n" + string;
    }

    public String getCriticalFailureMessage() {
        return this.criticalFailureMsg;
    }

    public void throwCriticalFailure(String string) {
        this.log.println(this, 0, string);
        this.criticalFailure(string);
        this.dispatchPatchProFailedEvent(new PatchProEvent(this));
    }

    public void cancelRealizationDetectors() {
        try {
            if (this.stateMachine.getStateResult(6) == 1) {
                this.hostAnalyzer.cancel();
            } else {
                this.log.println(this, 7, "Cancel called for realizationDetection, but not running.");
            }
        }
        catch (NoSuchStateException noSuchStateException) {
            this.log.printStackTrace(this, 7, noSuchStateException);
        }
    }

    public void cancelSequencer() {
        try {
            if (this.stateMachine.getStateResult(8) == 1) {
                this.sequencer.cancel();
            } else {
                this.log.println(this, 7, "Cancel called for Sequencer, but not running.");
            }
        }
        catch (NoSuchStateException noSuchStateException) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void shutdown() {
        try {
            if (this.hostAnalyzer != null) {
                this.hostAnalyzer.cancel();
            }
            this.cancelSequencer();
            if (this.stateMachine.getStateResult(8) != 2) return;
        }
        catch (Exception exception) {
            this.log.println(this, 4, "Failed to shutdown." + exception.getMessage());
        }
    }

    private void initializeProgress() {
        this.patchproProgress = new Percentage(0);
        this.baseDataDetectorProgress = new Percentage(0);
        this.downloadPatchDBProgress = new Percentage(0);
        this.downloadDetectorsProgress = new Percentage(0);
        this.realizationDetectorProgress = new Percentage(0);
        this.sequencerProgress = new Percentage(0);
        this.downloadPatchProgress = new Percentage(0);
        this.installPatchProgress = new Percentage(0);
    }

    private void updateInitializeDatabaseProgress() {
        int n = this.downloadPatchDBProgress.getPercentage();
        this.patchproProgress.setPercentage(n);
    }

    private void updateAbbreviatedHostProgress() {
        int n = this.baseDataDetectorProgress.getPercentage();
        this.patchproProgress.setPercentage(n);
    }

    private void updateAnalyzeHostProgress() {
        int n = this.baseDataDetectorProgress.getPercentage();
        int n2 = this.downloadPatchDBProgress.getPercentage();
        int n3 = this.downloadDetectorsProgress.getPercentage();
        int n4 = this.realizationDetectorProgress.getPercentage();
        this.patchproProgress.setPercentage((n + n2 + n3 + n4) / 4);
    }

    public void updateSequencerProgress(boolean bl) {
        if (bl) {
            int n = this.baseDataDetectorProgress.getPercentage();
            int n2 = this.downloadPatchDBProgress.getPercentage();
            int n3 = this.downloadDetectorsProgress.getPercentage();
            int n4 = this.realizationDetectorProgress.getPercentage();
            int n5 = this.sequencerProgress.getPercentage();
            this.patchproProgress.setPercentage((n + n2 + n3 + n4 + n5) / 5);
        } else {
            this.patchproProgress.setPercentage(this.sequencerProgress.getPercentage());
        }
    }

    public void updateDownloadPatchProgress(boolean bl) {
        if (bl) {
            int n = this.baseDataDetectorProgress.getPercentage();
            int n2 = this.downloadPatchDBProgress.getPercentage();
            int n3 = this.downloadDetectorsProgress.getPercentage();
            int n4 = this.realizationDetectorProgress.getPercentage();
            int n5 = this.sequencerProgress.getPercentage();
            int n6 = this.downloadPatchProgress.getPercentage();
            this.patchproProgress.setPercentage((n + n2 + n3 + n4 + n5 + n6) / 6);
        } else {
            this.patchproProgress.setPercentage(this.downloadPatchProgress.getPercentage());
        }
    }

    public void updateInstallPatchProgress(boolean bl) {
        if (bl) {
            int n = this.baseDataDetectorProgress.getPercentage();
            int n2 = this.downloadPatchDBProgress.getPercentage();
            int n3 = this.downloadDetectorsProgress.getPercentage();
            int n4 = this.realizationDetectorProgress.getPercentage();
            int n5 = this.sequencerProgress.getPercentage();
            int n6 = this.downloadPatchProgress.getPercentage();
            int n7 = this.installPatchProgress.getPercentage();
            this.patchproProgress.setPercentage((n + n2 + n3 + n4 + n5 + n6 + n7) / 7);
        } else {
            this.patchproProgress.setPercentage(this.installPatchProgress.getPercentage());
        }
    }

    public Percentage getPatchProProgress() {
        return this.patchproProgress;
    }

    public void sequencerProgress(SequencerEvent sequencerEvent) {
        Enumeration enumeration = this.sequencerListeners.elements();
        while (enumeration.hasMoreElements()) {
            SequencerListener sequencerListener = (SequencerListener)enumeration.nextElement();
            sequencerListener.sequencerProgress(sequencerEvent);
        }
    }

    public void sequencerDone(SequencerEvent sequencerEvent) {
        Enumeration enumeration = this.sequencerListeners.elements();
        while (enumeration.hasMoreElements()) {
            SequencerListener sequencerListener = (SequencerListener)enumeration.nextElement();
            sequencerListener.sequencerDone(sequencerEvent);
        }
    }

    public void sequencerFailed(SequencerEvent sequencerEvent) {
        Enumeration enumeration = this.sequencerListeners.elements();
        while (enumeration.hasMoreElements()) {
            SequencerListener sequencerListener = (SequencerListener)enumeration.nextElement();
            sequencerListener.sequencerFailed(sequencerEvent);
        }
    }

    public void dispatchPatchProProgressEvent(PatchProEvent patchProEvent) {
        Enumeration enumeration = this.patchproListeners.elements();
        while (enumeration.hasMoreElements()) {
            PatchProListener patchProListener = (PatchProListener)enumeration.nextElement();
            patchProListener.patchproProgress(patchProEvent);
        }
    }

    public void dispatchPatchProDoneEvent(PatchProEvent patchProEvent) {
        Enumeration enumeration = this.patchproListeners.elements();
        while (enumeration.hasMoreElements()) {
            PatchProListener patchProListener = (PatchProListener)enumeration.nextElement();
            patchProListener.patchproDone(patchProEvent);
        }
    }

    public void dispatchPatchProFailedEvent(PatchProEvent patchProEvent) {
        Enumeration enumeration = this.patchproListeners.elements();
        while (enumeration.hasMoreElements()) {
            PatchProListener patchProListener = (PatchProListener)enumeration.nextElement();
            patchProListener.patchproFailed(patchProEvent);
        }
    }

    public Collection getPatchProExceptions() {
        return this.patchProExceptions;
    }

    private void setPatchProExceptions(Collection collection) {
        this.patchProExceptions = collection;
    }

    public Patch getPatch(PatchID patchID) throws NoSuchPatchException {
        PatchImpl patchImpl;
        if (this.readOnlyTargetHost == null) {
            this.log.println(this, 4, "PatchProModel.getPatch(): Unable to retrieve Patch objectfor patch " + patchID.getPatchID() + " since the host is undefined");
            throw new NoSuchPatchException("Host is undefined");
        }
        PatchDB patchDB = this.readOnlyTargetHost.getSessionData().getPatchDB();
        if (patchDB == null) {
            this.log.println(this, 4, "PatchProModel.getPatch(): Unable to retrieve Patch objectfor patch " + patchID.getPatchID() + " since the Patch database does not exists");
            throw new NoSuchPatchException("Patch database does not exists");
        }
        try {
            patchImpl = patchDB.getLatestPatch(patchID);
        }
        catch (Exception exception) {
            this.log.println(this, 4, "PatchProModel.getPatch(): Unable to retrieve the latest patch for patch " + patchID.getPatchID() + "." + " Exception encountered: " + exception.getMessage());
            this.log.printStackTrace(this, 7, exception);
            throw new NoSuchPatchException("Unable to retrieve the latestpatch: " + exception.getMessage());
        }
        if (patchImpl == null) {
            this.log.println(this, 4, "PatchProModel.getPatch(): " + patchID + " could not be found in the Patch database");
            throw new NoSuchPatchException("No such patch found in the Patchdatabase");
        }
        return patchImpl;
    }

    public void setInstallHost(String string) throws PatchProException {
        this.hostToInstallAddress = string;
        this.hostToInstall = this.readOnlyTargetHost.getAssociateByAddress(this.hostToInstallAddress);
    }

    public void resetInstallHost() {
        this.hostToInstallAddress = null;
        this.hostToInstall = null;
        this.dbBuilder = new GroupPatchDBBuilder(this.targetHost);
    }

    public ReadOnlyHost getInstallHost() {
        return this.hostToInstall;
    }

    private class InnerInstallPatchThread
    extends Thread
    implements DownloadPatchDBListener,
    RealizationDetectorListener,
    DownloadDetectorsListener,
    BaseDataDetectorListener,
    SequencerListener,
    DownloadPatchListener,
    InstallPatchListener {
        PatchProModel model = null;
        boolean restarted = true;

        private InnerInstallPatchThread() {
        }

        public void setModel(PatchProModel patchProModel) {
            this.model = patchProModel;
            patchProModel.installPatchDone = false;
            if (patchProModel.baseDataDetectorsDone && patchProModel.downloadPatchDBDone && patchProModel.downloadDetectorsDone && PatchProModel.this.realizationDetectorsDone && PatchProModel.this.sequencerDone && PatchProModel.this.downloadPatchDone) {
                this.restarted = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block14: {
                block12: {
                    try {
                        try {
                            PatchProModel.this.dbBuilder.addListener(this);
                            PatchProModel.this.hostAnalyzer.addListener(this);
                            PatchProModel.this.hostAnalyzer.addListener(this);
                            PatchProModel.this.hostAnalyzer.addListener(this);
                            PatchProModel.this.addListener(this);
                            PatchProModel.this.patchDownloader.addDownloadPatchListener(this);
                            PatchProModel.this.patchInstaller.addListener(this);
                            PatchProModel.this.stateMachine.start(10, 10);
                        }
                        catch (Throwable throwable) {
                            this.model.setPatchProFailure(throwable);
                            this.model.dispatchPatchProFailedEvent(new PatchProEvent(this.model));
                            Object var3_2 = null;
                            boolean bl = true;
                            Object var5_8 = null;
                            Object var6_11 = null;
                            Object var7_14 = null;
                            PatchProModel.this.patchDownloader.removeDownloadPatchListener(this);
                            PatchProModel.this.patchInstaller.removeListener(this);
                            PatchProModel.this.removeListener(this);
                            PatchProModel.this.hostAnalyzer.removeListener(this);
                            PatchProModel.this.hostAnalyzer.removeListener(this);
                            PatchProModel.this.hostAnalyzer.removeListener(this);
                            PatchProModel.this.dbBuilder.removeListener(this);
                            if (this.model.hostIsExternal) {
                                this.model.setPatchProExceptions(PatchProModel.this.readOnlyTargetHost.getSessionData().getPatchProExceptions());
                            } else {
                                this.model.setPatchProExceptions(PatchProModel.this.targetHost.getSessionData().getPatchProExceptions());
                            }
                            if (!modelIsInteractive) {
                                StatusEMail statusEMail = new StatusEMail(PatchProModel.this.targetHost);
                                statusEMail.sendInstallStatusEMail();
                            }
                            this.model.dispatchPatchProDoneEvent(new PatchProEvent(this.model));
                            return;
                        }
                        Object var3_1 = null;
                        boolean bl = true;
                        Object var5_7 = null;
                        Object var6_10 = null;
                        Object var7_13 = null;
                        PatchProModel.this.patchDownloader.removeDownloadPatchListener(this);
                        PatchProModel.this.patchInstaller.removeListener(this);
                        PatchProModel.this.removeListener(this);
                        PatchProModel.this.hostAnalyzer.removeListener(this);
                        PatchProModel.this.hostAnalyzer.removeListener(this);
                        PatchProModel.this.hostAnalyzer.removeListener(this);
                        PatchProModel.this.dbBuilder.removeListener(this);
                        if (!this.model.hostIsExternal) break block12;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        boolean bl = true;
                        Object var5_9 = null;
                        Object var6_12 = null;
                        Object var7_15 = null;
                        PatchProModel.this.patchDownloader.removeDownloadPatchListener(this);
                        PatchProModel.this.patchInstaller.removeListener(this);
                        PatchProModel.this.removeListener(this);
                        PatchProModel.this.hostAnalyzer.removeListener(this);
                        PatchProModel.this.hostAnalyzer.removeListener(this);
                        PatchProModel.this.hostAnalyzer.removeListener(this);
                        PatchProModel.this.dbBuilder.removeListener(this);
                        if (this.model.hostIsExternal) {
                            this.model.setPatchProExceptions(PatchProModel.this.readOnlyTargetHost.getSessionData().getPatchProExceptions());
                        } else {
                            this.model.setPatchProExceptions(PatchProModel.this.targetHost.getSessionData().getPatchProExceptions());
                        }
                        if (!modelIsInteractive) {
                            StatusEMail statusEMail = new StatusEMail(PatchProModel.this.targetHost);
                            statusEMail.sendInstallStatusEMail();
                        }
                        this.model.dispatchPatchProDoneEvent(new PatchProEvent(this.model));
                        throw throwable;
                    }
                    this.model.setPatchProExceptions(PatchProModel.this.readOnlyTargetHost.getSessionData().getPatchProExceptions());
                    break block14;
                }
                this.model.setPatchProExceptions(PatchProModel.this.targetHost.getSessionData().getPatchProExceptions());
            }
            if (!modelIsInteractive) {
                StatusEMail statusEMail = new StatusEMail(PatchProModel.this.targetHost);
                statusEMail.sendInstallStatusEMail();
            }
            this.model.dispatchPatchProDoneEvent(new PatchProEvent(this.model));
        }

        public void downloadDetectorsProgress(DownloadDetectorsEvent downloadDetectorsEvent) {
            this.model.downloadDetectorsProgress = ((HostAnalyzer)downloadDetectorsEvent.getSource()).getDetectorDownloadProgress();
            this.model.updateInstallPatchProgress(this.restarted);
            this.model.dispatchPatchProProgressEvent(new PatchProEvent(this.model));
        }

        public void downloadDetectorsDone(DownloadDetectorsEvent downloadDetectorsEvent) {
            this.model.downloadDetectorsDone = true;
            this.model.updateInstallPatchProgress(this.restarted);
        }

        public void downloadDetectorsFailed(DownloadDetectorsEvent downloadDetectorsEvent) {
            Throwable throwable = null;
            try {
                throwable = new Throwable(downloadDetectorsEvent.getErrorMessage());
                this.model.setPatchProFailure(throwable);
                PatchProModel.this.log.println(this, 3, "Realization detector failed." + throwable.getMessage());
                this.model.dispatchPatchProFailedEvent(new PatchProEvent(this.model));
            }
            catch (Exception exception) {
                PatchProModel.this.log.printStackTrace(this, 3, exception);
            }
        }

        public void baseDataDetectorProgress(BaseDataDetectorEvent baseDataDetectorEvent) {
            this.model.baseDataDetectorProgress = ((HostAnalyzer)baseDataDetectorEvent.getSource()).getBaseDataProgress();
            this.model.updateInstallPatchProgress(this.restarted);
            this.model.dispatchPatchProProgressEvent(new PatchProEvent(this.model));
        }

        public void baseDataDetectorDone(BaseDataDetectorEvent baseDataDetectorEvent) {
            this.model.baseDataDetectorsDone = true;
            this.model.updateInstallPatchProgress(this.restarted);
        }

        public void baseDataDetectorFailed(BaseDataDetectorEvent baseDataDetectorEvent) {
            Throwable throwable = null;
            try {
                throwable = new Throwable(baseDataDetectorEvent.getErrorMessage());
                this.model.setPatchProFailure(throwable);
                PatchProModel.this.log.println(this, 3, " Base Data detectors failed." + throwable.getMessage());
                this.model.dispatchPatchProFailedEvent(new PatchProEvent(this.model));
            }
            catch (Exception exception) {
                PatchProModel.this.log.printStackTrace(this, 3, exception);
            }
        }

        public void downloadPatchProgress(DownloadPatchEvent downloadPatchEvent) {
            this.model.downloadPatchProgress = ((GroupPatchDownloader)downloadPatchEvent.getSource()).getStatus();
            this.model.updateInstallPatchProgress(this.restarted);
            this.model.dispatchPatchProProgressEvent(new PatchProEvent(this.model));
        }

        public void downloadPatchDone(DownloadPatchEvent downloadPatchEvent) {
            this.model.updateInstallPatchProgress(this.restarted);
            this.model.dispatchPatchProProgressEvent(new PatchProEvent(this.model));
        }

        public void downloadPatchFailed(DownloadPatchEvent downloadPatchEvent) {
            Throwable throwable = null;
            try {
                throwable = new Throwable(downloadPatchEvent.getErrorMessage());
                this.model.setPatchProFailure(throwable);
                PatchProModel.this.log.println(this, 3, "Problem downloading patches: " + throwable.getMessage());
                this.model.dispatchPatchProFailedEvent(new PatchProEvent(this.model));
            }
            catch (Exception exception) {
                PatchProModel.this.log.printStackTrace(this, 3, exception);
            }
        }

        public void realizationDetectorProgress(RealizationDetectorEvent realizationDetectorEvent) {
            this.model.realizationDetectorProgress = ((HostAnalyzer)realizationDetectorEvent.getSource()).getRealizationProgress();
            this.model.updateInstallPatchProgress(this.restarted);
            this.model.dispatchPatchProProgressEvent(new PatchProEvent(this.model));
        }

        public void realizationDetectorDone(RealizationDetectorEvent realizationDetectorEvent) {
            PatchProModel.this.realizationDetectorsDone = true;
            this.model.updateInstallPatchProgress(this.restarted);
            this.model.dispatchPatchProProgressEvent(new PatchProEvent(this.model));
        }

        public void realizationDetectorFailed(RealizationDetectorEvent realizationDetectorEvent) {
            this.model.dispatchPatchProFailedEvent(new PatchProEvent(this.model));
        }

        public void downloadPatchDBProgress(DownloadPatchDBEvent downloadPatchDBEvent) {
            this.model.downloadPatchDBProgress = ((PatchDBBuilder)downloadPatchDBEvent.getSource()).percentComplete();
            this.model.updateInstallPatchProgress(this.restarted);
            this.model.dispatchPatchProProgressEvent(new PatchProEvent(this.model));
        }

        public void downloadPatchDBDone(DownloadPatchDBEvent downloadPatchDBEvent) {
            this.model.downloadPatchDBDone = true;
            this.model.updateDownloadPatchProgress(this.restarted);
        }

        public void downloadPatchDBFailed(DownloadPatchDBEvent downloadPatchDBEvent) {
            this.model.dispatchPatchProFailedEvent(new PatchProEvent(this.model));
        }

        public void sequencerProgress(SequencerEvent sequencerEvent) {
            this.model.sequencerProgress = ((GroupPatchSequencer)sequencerEvent.getSource()).getStatus();
            this.model.updateInstallPatchProgress(this.restarted);
            this.model.dispatchPatchProProgressEvent(new PatchProEvent(this.model));
        }

        public void sequencerDone(SequencerEvent sequencerEvent) {
            this.model.updateInstallPatchProgress(this.restarted);
            this.model.dispatchPatchProProgressEvent(new PatchProEvent(this.model));
        }

        public void sequencerFailed(SequencerEvent sequencerEvent) {
            this.model.dispatchPatchProFailedEvent(new PatchProEvent(this.model));
        }

        public void installPatchProgress(InstallPatchEvent installPatchEvent) {
            this.model.installPatchProgress = ((GroupPatchBundleInstaller)installPatchEvent.getSource()).percentComplete();
            this.model.updateInstallPatchProgress(this.restarted);
            this.model.dispatchPatchProProgressEvent(new PatchProEvent(this.model));
        }

        public void installPatchDone(InstallPatchEvent installPatchEvent) {
            this.model.updateInstallPatchProgress(this.restarted);
        }

        public void installPatchFailed(InstallPatchEvent installPatchEvent) {
            try {
                NonFatalException nonFatalException = new NonFatalException(installPatchEvent.getErrorMessage());
                this.model.setPatchProFailure(nonFatalException);
                PatchProModel.this.log.println(this, 3, "Problem installing patches: " + nonFatalException.getMessage());
                this.model.dispatchPatchProFailedEvent(new PatchProEvent(this.model));
            }
            catch (Exception exception) {
                PatchProModel.this.log.printStackTrace(this, 3, exception);
            }
        }
    }

    private class InnerDownloadPatchThread
    extends Thread
    implements DownloadPatchDBListener,
    RealizationDetectorListener,
    DownloadDetectorsListener,
    BaseDataDetectorListener,
    SequencerListener,
    DownloadPatchListener {
        PatchProModel model = null;
        boolean restarted = true;

        private InnerDownloadPatchThread() {
        }

        public void setModel(PatchProModel patchProModel) {
            this.model = patchProModel;
            patchProModel.downloadPatchDone = false;
            if (patchProModel.baseDataDetectorsDone && patchProModel.downloadPatchDBDone && patchProModel.downloadDetectorsDone && PatchProModel.this.realizationDetectorsDone && PatchProModel.this.sequencerDone) {
                this.restarted = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                try {
                    PatchProModel.this.dbBuilder.addListener(this);
                    PatchProModel.this.hostAnalyzer.addListener(this);
                    PatchProModel.this.hostAnalyzer.addListener(this);
                    PatchProModel.this.hostAnalyzer.addListener(this);
                    PatchProModel.this.addListener(this);
                    PatchProModel.this.patchDownloader.addDownloadPatchListener(this);
                    PatchProModel.this.stateMachine.start(9, 9);
                }
                catch (Throwable throwable) {
                    this.model.setPatchProFailure(throwable);
                    this.model.dispatchPatchProFailedEvent(new PatchProEvent(this.model));
                    Object var3_2 = null;
                    PatchProModel.this.patchDownloader.removeDownloadPatchListener(this);
                    PatchProModel.this.removeListener(this);
                    PatchProModel.this.hostAnalyzer.removeListener(this);
                    PatchProModel.this.hostAnalyzer.removeListener(this);
                    PatchProModel.this.hostAnalyzer.removeListener(this);
                    PatchProModel.this.dbBuilder.removeListener(this);
                    this.model.dispatchPatchProDoneEvent(new PatchProEvent(this.model));
                }
                Object var3_1 = null;
                PatchProModel.this.patchDownloader.removeDownloadPatchListener(this);
                PatchProModel.this.removeListener(this);
                PatchProModel.this.hostAnalyzer.removeListener(this);
                PatchProModel.this.hostAnalyzer.removeListener(this);
                PatchProModel.this.hostAnalyzer.removeListener(this);
                PatchProModel.this.dbBuilder.removeListener(this);
                this.model.dispatchPatchProDoneEvent(new PatchProEvent(this.model));
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                PatchProModel.this.patchDownloader.removeDownloadPatchListener(this);
                PatchProModel.this.removeListener(this);
                PatchProModel.this.hostAnalyzer.removeListener(this);
                PatchProModel.this.hostAnalyzer.removeListener(this);
                PatchProModel.this.hostAnalyzer.removeListener(this);
                PatchProModel.this.dbBuilder.removeListener(this);
                this.model.dispatchPatchProDoneEvent(new PatchProEvent(this.model));
                throw throwable;
            }
        }

        public void downloadDetectorsProgress(DownloadDetectorsEvent downloadDetectorsEvent) {
            this.model.downloadDetectorsProgress = ((HostAnalyzer)downloadDetectorsEvent.getSource()).getDetectorDownloadProgress();
            this.model.updateDownloadPatchProgress(this.restarted);
            this.model.dispatchPatchProProgressEvent(new PatchProEvent(this.model));
        }

        public void downloadDetectorsDone(DownloadDetectorsEvent downloadDetectorsEvent) {
            this.model.downloadDetectorsDone = true;
            this.model.updateDownloadPatchProgress(this.restarted);
        }

        public void downloadDetectorsFailed(DownloadDetectorsEvent downloadDetectorsEvent) {
            Throwable throwable = null;
            try {
                throwable = new Throwable(downloadDetectorsEvent.getErrorMessage());
                this.model.setPatchProFailure(throwable);
                PatchProModel.this.log.println(this, 3, "Download detectors failed." + throwable.getMessage());
                this.model.setPatchProFailure(throwable);
                this.model.dispatchPatchProFailedEvent(new PatchProEvent(this.model));
            }
            catch (Exception exception) {
                PatchProModel.this.log.printStackTrace(this, 3, exception);
            }
        }

        public void baseDataDetectorProgress(BaseDataDetectorEvent baseDataDetectorEvent) {
            this.model.baseDataDetectorProgress = ((HostAnalyzer)baseDataDetectorEvent.getSource()).getBaseDataProgress();
            this.model.updateDownloadPatchProgress(this.restarted);
            this.model.dispatchPatchProProgressEvent(new PatchProEvent(this.model));
        }

        public void baseDataDetectorDone(BaseDataDetectorEvent baseDataDetectorEvent) {
            this.model.baseDataDetectorsDone = true;
            this.model.updateDownloadPatchProgress(this.restarted);
        }

        public void baseDataDetectorFailed(BaseDataDetectorEvent baseDataDetectorEvent) {
            Throwable throwable = null;
            try {
                throwable = new Throwable(baseDataDetectorEvent.getErrorMessage());
                this.model.setPatchProFailure(throwable);
                PatchProModel.this.log.println(this, 3, "No detectors to download." + throwable.getMessage());
                this.model.setPatchProFailure(throwable);
                this.model.dispatchPatchProFailedEvent(new PatchProEvent(this.model));
            }
            catch (Exception exception) {
                PatchProModel.this.log.printStackTrace(this, 3, exception);
            }
        }

        public void downloadPatchProgress(DownloadPatchEvent downloadPatchEvent) {
            this.model.downloadPatchProgress = ((GroupPatchDownloader)downloadPatchEvent.getSource()).getStatus();
            this.model.updateDownloadPatchProgress(this.restarted);
            this.model.dispatchPatchProProgressEvent(new PatchProEvent(this.model));
        }

        public void downloadPatchDone(DownloadPatchEvent downloadPatchEvent) {
            this.model.updateDownloadPatchProgress(this.restarted);
            this.model.dispatchPatchProProgressEvent(new PatchProEvent(this.model));
        }

        public void downloadPatchFailed(DownloadPatchEvent downloadPatchEvent) {
            Throwable throwable = null;
            try {
                throwable = new Throwable(downloadPatchEvent.getErrorMessage());
                this.model.setPatchProFailure(throwable);
                PatchProModel.this.log.println(this, 3, "Error: downloading patches." + throwable.getMessage());
                this.model.dispatchPatchProFailedEvent(new PatchProEvent(this.model));
            }
            catch (Exception exception) {
                PatchProModel.this.log.printStackTrace(this, 3, exception);
            }
        }

        public void realizationDetectorProgress(RealizationDetectorEvent realizationDetectorEvent) {
            this.model.realizationDetectorProgress = ((HostAnalyzer)realizationDetectorEvent.getSource()).getRealizationProgress();
            this.model.updateDownloadPatchProgress(this.restarted);
            this.model.dispatchPatchProProgressEvent(new PatchProEvent(this.model));
        }

        public void realizationDetectorDone(RealizationDetectorEvent realizationDetectorEvent) {
            PatchProModel.this.realizationDetectorsDone = true;
            this.model.updateDownloadPatchProgress(this.restarted);
        }

        public void realizationDetectorFailed(RealizationDetectorEvent realizationDetectorEvent) {
            this.model.dispatchPatchProFailedEvent(new PatchProEvent(this.model));
        }

        public void downloadPatchDBProgress(DownloadPatchDBEvent downloadPatchDBEvent) {
            this.model.downloadPatchDBProgress = ((PatchDBBuilder)downloadPatchDBEvent.getSource()).percentComplete();
            this.model.updateDownloadPatchProgress(this.restarted);
            this.model.dispatchPatchProProgressEvent(new PatchProEvent(this.model));
        }

        public void downloadPatchDBDone(DownloadPatchDBEvent downloadPatchDBEvent) {
            this.model.downloadPatchDBDone = true;
            this.model.updateDownloadPatchProgress(this.restarted);
        }

        public void downloadPatchDBFailed(DownloadPatchDBEvent downloadPatchDBEvent) {
            this.model.dispatchPatchProFailedEvent(new PatchProEvent(this.model));
        }

        public void sequencerProgress(SequencerEvent sequencerEvent) {
            this.model.sequencerProgress = ((GroupPatchSequencer)sequencerEvent.getSource()).getStatus();
            this.model.updateDownloadPatchProgress(this.restarted);
            this.model.dispatchPatchProProgressEvent(new PatchProEvent(this.model));
        }

        public void sequencerDone(SequencerEvent sequencerEvent) {
            this.model.updateDownloadPatchProgress(this.restarted);
            this.model.dispatchPatchProProgressEvent(new PatchProEvent(this.model));
        }

        public void sequencerFailed(SequencerEvent sequencerEvent) {
            this.model.dispatchPatchProFailedEvent(new PatchProEvent(this.model));
        }
    }

    private class InnerSequencerThread
    extends Thread
    implements DownloadPatchDBListener,
    RealizationDetectorListener,
    DownloadDetectorsListener,
    BaseDataDetectorListener,
    SequencerListener {
        PatchProModel model = null;
        boolean restarted = true;

        private InnerSequencerThread() {
        }

        public void setModel(PatchProModel patchProModel) {
            this.model = patchProModel;
            patchProModel.sequencerDone = false;
            if (patchProModel.baseDataDetectorsDone && patchProModel.downloadPatchDBDone && patchProModel.downloadDetectorsDone && PatchProModel.this.realizationDetectorsDone) {
                this.restarted = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                try {
                    PatchProModel.this.dbBuilder.addListener(this);
                    PatchProModel.this.hostAnalyzer.addListener(this);
                    PatchProModel.this.hostAnalyzer.addListener(this);
                    PatchProModel.this.hostAnalyzer.addListener(this);
                    PatchProModel.this.addListener(this);
                    PatchProModel.this.stateMachine.start(8, 8);
                }
                catch (Throwable throwable) {
                    this.model.setPatchProFailure(throwable);
                    this.model.dispatchPatchProFailedEvent(new PatchProEvent(this.model));
                    Object var3_2 = null;
                    PatchProModel.this.removeListener(this);
                    PatchProModel.this.hostAnalyzer.removeListener(this);
                    PatchProModel.this.hostAnalyzer.removeListener(this);
                    PatchProModel.this.hostAnalyzer.removeListener(this);
                    PatchProModel.this.dbBuilder.removeListener(this);
                    this.model.dispatchPatchProDoneEvent(new PatchProEvent(this.model));
                }
                Object var3_1 = null;
                PatchProModel.this.removeListener(this);
                PatchProModel.this.hostAnalyzer.removeListener(this);
                PatchProModel.this.hostAnalyzer.removeListener(this);
                PatchProModel.this.hostAnalyzer.removeListener(this);
                PatchProModel.this.dbBuilder.removeListener(this);
                this.model.dispatchPatchProDoneEvent(new PatchProEvent(this.model));
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                PatchProModel.this.removeListener(this);
                PatchProModel.this.hostAnalyzer.removeListener(this);
                PatchProModel.this.hostAnalyzer.removeListener(this);
                PatchProModel.this.hostAnalyzer.removeListener(this);
                PatchProModel.this.dbBuilder.removeListener(this);
                this.model.dispatchPatchProDoneEvent(new PatchProEvent(this.model));
                throw throwable;
            }
        }

        public void downloadDetectorsProgress(DownloadDetectorsEvent downloadDetectorsEvent) {
            this.model.downloadDetectorsProgress = ((HostAnalyzer)downloadDetectorsEvent.getSource()).getDetectorDownloadProgress();
            this.model.updateSequencerProgress(this.restarted);
            this.model.dispatchPatchProProgressEvent(new PatchProEvent(this.model));
        }

        public void downloadDetectorsDone(DownloadDetectorsEvent downloadDetectorsEvent) {
            this.model.downloadDetectorsDone = true;
            PatchProModel.this.log.println(this, 7, " model.downloadDetectorsDone is set to true.");
            this.model.updateAnalyzeHostProgress();
        }

        public void downloadDetectorsFailed(DownloadDetectorsEvent downloadDetectorsEvent) {
            Throwable throwable = null;
            try {
                throwable = new Throwable(downloadDetectorsEvent.getErrorMessage());
                this.model.setPatchProFailure(throwable);
                PatchProModel.this.log.println(this, 3, "Download detectors failed." + throwable.getMessage());
                this.model.dispatchPatchProFailedEvent(new PatchProEvent(this.model));
            }
            catch (Exception exception) {
                PatchProModel.this.log.printStackTrace(this, 3, exception);
            }
        }

        public void baseDataDetectorProgress(BaseDataDetectorEvent baseDataDetectorEvent) {
            this.model.baseDataDetectorProgress = ((HostAnalyzer)baseDataDetectorEvent.getSource()).getBaseDataProgress();
            this.model.updateSequencerProgress(this.restarted);
            this.model.dispatchPatchProProgressEvent(new PatchProEvent(this.model));
        }

        public void baseDataDetectorDone(BaseDataDetectorEvent baseDataDetectorEvent) {
            this.model.baseDataDetectorsDone = true;
            this.model.updateAnalyzeHostProgress();
        }

        public void baseDataDetectorFailed(BaseDataDetectorEvent baseDataDetectorEvent) {
            Throwable throwable = null;
            try {
                throwable = new Throwable(baseDataDetectorEvent.getErrorMessage());
                this.model.setPatchProFailure(throwable);
                PatchProModel.this.log.println(this, 3, "No detectors to download." + throwable.getMessage());
                this.model.dispatchPatchProFailedEvent(new PatchProEvent(this.model));
            }
            catch (Exception exception) {
                PatchProModel.this.log.printStackTrace(this, 3, exception);
            }
        }

        public void realizationDetectorProgress(RealizationDetectorEvent realizationDetectorEvent) {
            this.model.realizationDetectorProgress = ((HostAnalyzer)realizationDetectorEvent.getSource()).getRealizationProgress();
            this.model.updateSequencerProgress(this.restarted);
            this.model.dispatchPatchProProgressEvent(new PatchProEvent(this.model));
        }

        public void realizationDetectorDone(RealizationDetectorEvent realizationDetectorEvent) {
            PatchProModel.this.realizationDetectorsDone = true;
            this.model.updateSequencerProgress(this.restarted);
        }

        public void realizationDetectorFailed(RealizationDetectorEvent realizationDetectorEvent) {
            this.model.dispatchPatchProFailedEvent(new PatchProEvent(this.model));
        }

        public void downloadPatchDBProgress(DownloadPatchDBEvent downloadPatchDBEvent) {
            this.model.downloadPatchDBProgress = ((PatchDBBuilder)downloadPatchDBEvent.getSource()).percentComplete();
            this.model.updateSequencerProgress(this.restarted);
            this.model.dispatchPatchProProgressEvent(new PatchProEvent(this.model));
        }

        public void downloadPatchDBDone(DownloadPatchDBEvent downloadPatchDBEvent) {
            this.model.downloadPatchDBDone = true;
            this.model.updateSequencerProgress(this.restarted);
        }

        public void downloadPatchDBFailed(DownloadPatchDBEvent downloadPatchDBEvent) {
            this.model.dispatchPatchProFailedEvent(new PatchProEvent(this.model));
        }

        public void sequencerProgress(SequencerEvent sequencerEvent) {
            this.model.sequencerProgress = ((GroupPatchSequencer)sequencerEvent.getSource()).getStatus();
            this.model.updateSequencerProgress(this.restarted);
            this.model.dispatchPatchProProgressEvent(new PatchProEvent(this.model));
        }

        public void sequencerDone(SequencerEvent sequencerEvent) {
            this.model.updateSequencerProgress(this.restarted);
            this.model.dispatchPatchProProgressEvent(new PatchProEvent(this.model));
        }

        public void sequencerFailed(SequencerEvent sequencerEvent) {
            Throwable throwable = null;
            try {
                throwable = new Throwable(sequencerEvent.getErrorMessage());
                this.model.setPatchProFailure(throwable);
                PatchProModel.this.log.println(this, 3, "Error with sequencer." + throwable.getMessage());
                this.model.dispatchPatchProFailedEvent(new PatchProEvent(this.model));
            }
            catch (Exception exception) {
                PatchProModel.this.log.printStackTrace(this, 3, exception);
            }
        }
    }

    private class InnerAnalyzeHostThread
    extends Thread
    implements BaseDataDetectorListener,
    DownloadPatchDBListener,
    DownloadDetectorsListener,
    RealizationDetectorListener {
        PatchProModel model = null;

        private InnerAnalyzeHostThread() {
        }

        public void setModel(PatchProModel patchProModel) {
            this.model = patchProModel;
            patchProModel.realizationDetectorsDone = false;
            patchProModel.baseDataDetectorsDone = false;
            patchProModel.downloadPatchDBDone = false;
            patchProModel.downloadDetectorsDone = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                try {
                    PatchProModel.this.dbBuilder.addListener(this);
                    PatchProModel.this.hostAnalyzer.addListener(this);
                    PatchProModel.this.hostAnalyzer.addListener(this);
                    PatchProModel.this.hostAnalyzer.addListener(this);
                    PatchProModel.this.stateMachine.start(0, 7);
                }
                catch (Throwable throwable) {
                    this.model.setPatchProFailure(throwable);
                    this.model.dispatchPatchProFailedEvent(new PatchProEvent(this.model));
                    Object var3_2 = null;
                    this.model.hostIsExternal = false;
                    PatchProModel.this.hostAnalyzer.removeListener(this);
                    PatchProModel.this.hostAnalyzer.removeListener(this);
                    PatchProModel.this.hostAnalyzer.removeListener(this);
                    PatchProModel.this.dbBuilder.removeListener(this);
                    this.model.dispatchPatchProDoneEvent(new PatchProEvent(this.model));
                }
                Object var3_1 = null;
                this.model.hostIsExternal = false;
                PatchProModel.this.hostAnalyzer.removeListener(this);
                PatchProModel.this.hostAnalyzer.removeListener(this);
                PatchProModel.this.hostAnalyzer.removeListener(this);
                PatchProModel.this.dbBuilder.removeListener(this);
                this.model.dispatchPatchProDoneEvent(new PatchProEvent(this.model));
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.model.hostIsExternal = false;
                PatchProModel.this.hostAnalyzer.removeListener(this);
                PatchProModel.this.hostAnalyzer.removeListener(this);
                PatchProModel.this.hostAnalyzer.removeListener(this);
                PatchProModel.this.dbBuilder.removeListener(this);
                this.model.dispatchPatchProDoneEvent(new PatchProEvent(this.model));
                throw throwable;
            }
        }

        public void baseDataDetectorProgress(BaseDataDetectorEvent baseDataDetectorEvent) {
            this.model.baseDataDetectorProgress = ((HostAnalyzer)baseDataDetectorEvent.getSource()).getBaseDataProgress();
            this.model.updateAnalyzeHostProgress();
            this.model.dispatchPatchProProgressEvent(new PatchProEvent(this.model));
        }

        public void baseDataDetectorDone(BaseDataDetectorEvent baseDataDetectorEvent) {
            this.model.baseDataDetectorsDone = true;
            this.model.updateAnalyzeHostProgress();
        }

        public void baseDataDetectorFailed(BaseDataDetectorEvent baseDataDetectorEvent) {
            Throwable throwable = null;
            try {
                throwable = new Throwable(baseDataDetectorEvent.getErrorMessage());
                this.model.setPatchProFailure(throwable);
                PatchProModel.this.log.println(this, 3, "Base Data detectors failed." + throwable.getMessage());
                this.model.dispatchPatchProFailedEvent(new PatchProEvent(this.model));
            }
            catch (Exception exception) {
                PatchProModel.this.log.printStackTrace(this, 3, exception);
            }
        }

        public void realizationDetectorProgress(RealizationDetectorEvent realizationDetectorEvent) {
            this.model.realizationDetectorProgress = ((HostAnalyzer)realizationDetectorEvent.getSource()).getRealizationProgress();
            this.model.updateAnalyzeHostProgress();
            this.model.dispatchPatchProProgressEvent(new PatchProEvent(this.model));
        }

        public void realizationDetectorDone(RealizationDetectorEvent realizationDetectorEvent) {
            PatchProModel.this.realizationDetectorsDone = true;
            this.model.updateAnalyzeHostProgress();
        }

        public void realizationDetectorFailed(RealizationDetectorEvent realizationDetectorEvent) {
            Throwable throwable = null;
            try {
                throwable = new Throwable(realizationDetectorEvent.getErrorMessage());
                this.model.setPatchProFailure(throwable);
                PatchProModel.this.log.println(this, 3, "Realization detector failed." + throwable.getMessage());
                this.model.dispatchPatchProFailedEvent(new PatchProEvent(this.model));
            }
            catch (Exception exception) {
                PatchProModel.this.log.printStackTrace(this, 3, exception);
            }
        }

        public void downloadPatchDBProgress(DownloadPatchDBEvent downloadPatchDBEvent) {
            this.model.downloadPatchDBProgress = ((PatchDBBuilder)downloadPatchDBEvent.getSource()).percentComplete();
            this.model.updateAnalyzeHostProgress();
            this.model.dispatchPatchProProgressEvent(new PatchProEvent(this.model));
        }

        public void downloadPatchDBDone(DownloadPatchDBEvent downloadPatchDBEvent) {
            this.model.downloadPatchDBDone = true;
            this.model.updateAnalyzeHostProgress();
        }

        public void downloadPatchDBFailed(DownloadPatchDBEvent downloadPatchDBEvent) {
            Throwable throwable = null;
            try {
                throwable = new Throwable(downloadPatchDBEvent.getErrorMessage());
                this.model.setPatchProFailure(throwable);
                PatchProModel.this.log.println(this, 3, "Failure downloading patch database." + throwable.getMessage());
                this.model.dispatchPatchProFailedEvent(new PatchProEvent(this.model));
            }
            catch (Exception exception) {
                PatchProModel.this.log.printStackTrace(this, 3, exception);
            }
        }

        public void downloadDetectorsProgress(DownloadDetectorsEvent downloadDetectorsEvent) {
            this.model.downloadDetectorsProgress = ((HostAnalyzer)downloadDetectorsEvent.getSource()).getDetectorDownloadProgress();
            this.model.updateAnalyzeHostProgress();
            this.model.dispatchPatchProProgressEvent(new PatchProEvent(this.model));
        }

        public void downloadDetectorsDone(DownloadDetectorsEvent downloadDetectorsEvent) {
            this.model.downloadDetectorsDone = true;
            this.model.updateAnalyzeHostProgress();
        }

        public void downloadDetectorsFailed(DownloadDetectorsEvent downloadDetectorsEvent) {
            Throwable throwable = null;
            try {
                throwable = new Throwable(downloadDetectorsEvent.getErrorMessage());
                this.model.setPatchProFailure(throwable);
                PatchProModel.this.log.println(this, 3, "Download detectors failed." + throwable.getMessage());
                this.model.dispatchPatchProFailedEvent(new PatchProEvent(this.model));
            }
            catch (Exception exception) {
                PatchProModel.this.log.printStackTrace(this, 3, exception);
            }
        }
    }

    private class InnerAbbreviatedHostThread
    extends Thread
    implements BaseDataDetectorListener {
        PatchProModel model = null;

        private InnerAbbreviatedHostThread() {
        }

        public void setModel(PatchProModel patchProModel) {
            this.model = patchProModel;
            patchProModel.baseDataDetectorsDone = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                try {
                    PatchProModel.this.hostAnalyzer.addListener(this);
                    PatchProModel.this.stateMachine.start(0, 5);
                }
                catch (Throwable throwable) {
                    this.model.setPatchProFailure(throwable);
                    this.model.dispatchPatchProFailedEvent(new PatchProEvent(this.model));
                    Object var3_2 = null;
                    this.model.hostIsExternal = false;
                    PatchProModel.this.hostAnalyzer.removeListener(this);
                    this.model.dispatchPatchProDoneEvent(new PatchProEvent(this.model));
                }
                Object var3_1 = null;
                this.model.hostIsExternal = false;
                PatchProModel.this.hostAnalyzer.removeListener(this);
                this.model.dispatchPatchProDoneEvent(new PatchProEvent(this.model));
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.model.hostIsExternal = false;
                PatchProModel.this.hostAnalyzer.removeListener(this);
                this.model.dispatchPatchProDoneEvent(new PatchProEvent(this.model));
                throw throwable;
            }
        }

        public void baseDataDetectorProgress(BaseDataDetectorEvent baseDataDetectorEvent) {
            this.model.baseDataDetectorProgress = ((HostAnalyzer)baseDataDetectorEvent.getSource()).getBaseDataProgress();
            this.model.updateAbbreviatedHostProgress();
            this.model.dispatchPatchProProgressEvent(new PatchProEvent(this.model));
        }

        public void baseDataDetectorDone(BaseDataDetectorEvent baseDataDetectorEvent) {
            this.model.baseDataDetectorsDone = true;
            this.model.updateAbbreviatedHostProgress();
        }

        public void baseDataDetectorFailed(BaseDataDetectorEvent baseDataDetectorEvent) {
            Throwable throwable = null;
            try {
                throwable = new Throwable(baseDataDetectorEvent.getErrorMessage());
                this.model.setPatchProFailure(throwable);
                PatchProModel.this.log.println(this, 3, "Base Data detectors failed." + throwable.getMessage());
                this.model.dispatchPatchProFailedEvent(new PatchProEvent(this.model));
            }
            catch (Exception exception) {
                PatchProModel.this.log.printStackTrace(this, 3, exception);
            }
        }
    }

    private class InnerInitializeDatabaseThread
    extends Thread
    implements DownloadPatchDBListener {
        PatchProModel model = null;

        private InnerInitializeDatabaseThread() {
        }

        public void setModel(PatchProModel patchProModel) {
            this.model = patchProModel;
            patchProModel.downloadPatchDBDone = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                try {
                    PatchProModel.this.dbBuilder.addListener(this);
                    PatchProModel.this.stateMachine.start(0, 4);
                }
                catch (Throwable throwable) {
                    this.model.setPatchProFailure(throwable);
                    this.model.dispatchPatchProFailedEvent(new PatchProEvent(this.model));
                    Object var3_2 = null;
                    PatchProModel.this.buildingDatabaseOnly = false;
                    PatchProModel.this.dbBuilder.removeListener(this);
                    this.model.dispatchPatchProDoneEvent(new PatchProEvent(this.model));
                }
                Object var3_1 = null;
                PatchProModel.this.buildingDatabaseOnly = false;
                PatchProModel.this.dbBuilder.removeListener(this);
                this.model.dispatchPatchProDoneEvent(new PatchProEvent(this.model));
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                PatchProModel.this.buildingDatabaseOnly = false;
                PatchProModel.this.dbBuilder.removeListener(this);
                this.model.dispatchPatchProDoneEvent(new PatchProEvent(this.model));
                throw throwable;
            }
        }

        public void downloadPatchDBProgress(DownloadPatchDBEvent downloadPatchDBEvent) {
            this.model.downloadPatchDBProgress = ((PatchDBBuilder)downloadPatchDBEvent.getSource()).percentComplete();
            this.model.updateInitializeDatabaseProgress();
            this.model.dispatchPatchProProgressEvent(new PatchProEvent(this.model));
        }

        public void downloadPatchDBDone(DownloadPatchDBEvent downloadPatchDBEvent) {
            this.model.downloadPatchDBDone = true;
        }

        public void downloadPatchDBFailed(DownloadPatchDBEvent downloadPatchDBEvent) {
            Throwable throwable = null;
            try {
                throwable = new Throwable(downloadPatchDBEvent.getErrorMessage());
                this.model.setPatchProFailure(throwable);
                PatchProModel.this.log.println(this, 3, "Failure downloading patch database." + throwable.getMessage());
                this.model.dispatchPatchProFailedEvent(new PatchProEvent(this.model));
            }
            catch (Exception exception) {
                PatchProModel.this.log.printStackTrace(this, 3, exception);
            }
        }
    }
}

