/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.analysis;

import com.sun.patchpro.analysis.BaseDataDetector;
import com.sun.patchpro.analysis.DetectorClassLoader;
import com.sun.patchpro.analysis.DetectorEvent;
import com.sun.patchpro.analysis.DetectorFailedException;
import com.sun.patchpro.analysis.DetectorListener;
import com.sun.patchpro.analysis.RealizationDetector;
import com.sun.patchpro.host.ExtendedHost;
import com.sun.patchpro.host.HardwareComponent;
import com.sun.patchpro.host.Host;
import com.sun.patchpro.host.NoSuchRealizationException;
import com.sun.patchpro.host.ReadOnlyHost;
import com.sun.patchpro.host.Realization;
import com.sun.patchpro.host.RealizationEnumerator;
import com.sun.patchpro.host.RealizationStatus;
import com.sun.patchpro.host.RestrictedHost;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.BaseDataDetectorEvent;
import com.sun.patchpro.model.BaseDataDetectorListener;
import com.sun.patchpro.model.DownloadDetectorsEvent;
import com.sun.patchpro.model.DownloadDetectorsListener;
import com.sun.patchpro.model.PatchProException;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.model.RealizationDetectorEvent;
import com.sun.patchpro.model.RealizationDetectorListener;
import com.sun.patchpro.model.RealizationSetEvent;
import com.sun.patchpro.model.RealizationSetListener;
import com.sun.patchpro.server.NotSupportedException;
import com.sun.patchpro.server.PatchServerProxy;
import com.sun.patchpro.server.PatchServerProxyException;
import com.sun.patchpro.util.CachingDownloader;
import com.sun.patchpro.util.DownloadEvent;
import com.sun.patchpro.util.DownloadListener;
import com.sun.patchpro.util.Downloader;
import com.sun.patchpro.util.FileFinder;
import com.sun.patchpro.util.InstallationParameters;
import com.sun.patchpro.util.Percentage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class HostAnalyzer
implements DetectorListener,
DownloadDetectorsListener,
RealizationSetListener {
    public static final String DETECTORLIST = "/com/sun/patchpro/detectors/detector.list";
    private PatchProProperties properties;
    private PatchProLog log;
    private Host targetHost;
    private Vector realizationDetectorListeners = new Vector();
    private Vector realizationSetListeners = new Vector();
    private Vector detectorListeners = new Vector();
    private Vector baseDataDetectorListeners = new Vector();
    private CachingDownloader detectorDownloader;
    private Vector downloadDetectorsListeners = new Vector();
    private Percentage[] progressList = new Percentage[2];
    private int baseDataProgress;
    private int realizationProgress;
    private Thread baseDataThread = null;
    private boolean targetHostIsNew = false;
    private boolean baseDataDetectorsDone = false;
    private boolean downloadDetectorsDone = false;
    private int currentDetector = -1;
    private boolean countEachDetector = false;
    private boolean realizationDetectorsStarted = false;
    private int totalDetectorCount;
    private int finishedDetectorCount;
    private int nextPercent = 0;
    private int runDetectorsPercent = 0;
    private int percentInterval = 0;
    private int accuPercentInterval = 0;
    private RealizationEnumerator realizationListEnum;
    private RealizationSet realizationSet;
    private InstallationParameters instParms = null;
    static /* synthetic */ Class class$com$sun$patchpro$analysis$HostAnalyzer;

    public HostAnalyzer() {
        this.properties = PatchProProperties.getInstance();
        this.log = PatchProLog.getInstance();
        this.instParms = InstallationParameters.getInstance();
        String string = this.properties.getProperty("patchpro.realization.provided");
        this.realizationSet = string == null || string.equals("") ? new RealizationSetAuto() : new RealizationSetCmdLn();
    }

    public File getDetectorCacheFile() throws PatchProException {
        return this.realizationSet.getDetectorCacheFile();
    }

    public void cancel() {
        this.log.println(this, 2, "Cancel is not implemented in the HostAnalyzer.");
    }

    private BaseDataDetector getAnalyzerFromName(String string) throws DetectorFailedException {
        this.log.println(this, 7, "analyzerName=" + string);
        try {
            Class<?> clazz = Class.forName(string);
            BaseDataDetector baseDataDetector = (BaseDataDetector)clazz.newInstance();
            return baseDataDetector;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log.println(this, 4, "HostAnalyzer.getTargetBase(): Unable to open platform specific analyzer, " + string + ".");
            throw new DetectorFailedException("HostAnalyzer.getTargetBase(): Unable to open platform specific analyzer, " + string + ".");
        }
        catch (InstantiationException instantiationException) {
            this.log.println(this, 4, "HostAnalyzer.getTargetBase(): Unable to instantiate " + string + ".");
            throw new DetectorFailedException("HostAnalyzer.getTargetBase(): Unable to instantiate " + string + ".");
        }
        catch (IllegalAccessException illegalAccessException) {
            this.log.println(this, 4, "HostAnalyzer.getTargetBase(): Unable to access " + string + ".");
            throw new DetectorFailedException("HostAnalyzer.getTargetBase(): Unable to access " + string + ".");
        }
    }

    public synchronized Host getTargetBase() throws DetectorFailedException {
        this.targetHost = new ExtendedHost();
        String string = new String("com.sun.patchpro.analysis." + this.getOSName() + "TargetInfo");
        BaseDataDetector baseDataDetector = this.getAnalyzerFromName(string);
        baseDataDetector.setHost(this.targetHost);
        baseDataDetector.run();
        this.targetHostIsNew = true;
        Enumeration enumeration = null;
        FileFinder fileFinder = new FileFinder();
        String string2 = this.instParms.getClassesDirectoryPath();
        String string3 = this.properties.getProperty("patchpro.basedatadetector.prefix");
        if (string3 == null || string3.equals("")) {
            string3 = this.getOSName();
        }
        this.log.println(this, 7, "classesDir=" + string2);
        String string4 = new String(string3 + "TargetInfoExtension.class");
        try {
            enumeration = fileFinder.findAllMatchingFiles(string2, string4, FileFinder.FORMAT_CLASSNAME);
        }
        catch (Exception exception) {}
        while (enumeration.hasMoreElements()) {
            BaseDataDetector baseDataDetector2 = this.getAnalyzerFromName((String)enumeration.nextElement());
            baseDataDetector2.setHost(this.targetHost);
            baseDataDetector2.run();
        }
        return this.targetHost;
    }

    public synchronized void runBaseDataDetectors() throws DetectorFailedException {
        this.baseDataDetectorsDone = false;
        if (this.targetHost == null) {
            throw new DetectorFailedException("runBaseDataDetectors: Target host emulation does not yet exist.");
        }
        if (!this.targetHostIsNew) {
            throw new DetectorFailedException("runBaseDataDetectors: Target host emulation is stale.");
        }
        BaseDataDetector baseDataDetector = null;
        String string = new String("com.sun.patchpro.analysis." + this.getOSName() + "BaseData");
        baseDataDetector = this.getAnalyzerFromName(string);
        baseDataDetector.setHost(this.targetHost);
        baseDataDetector.addListener(this);
        this.baseDataThread = new Thread(baseDataDetector);
        this.targetHostIsNew = false;
        try {
            this.baseDataThread.setDaemon(false);
            this.baseDataThread.setPriority(10);
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            this.log.println(this, 4, "HostAnalyzer.runBaseDataDetectors(): Couldn't mark the base data object as a daemon.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println(this, 4, "HostAnalyzer.runBaseDataDetectors(): Couldn't set the base data object thread priority.");
        }
        catch (SecurityException securityException) {
            this.log.println(this, 4, "HostAnalyzer.runBaseDataDetectors(): Couldn't set the base data object thread priority.");
        }
        this.baseDataThread.start();
    }

    public void downloadDetectors() throws PatchProException {
        this.realizationSet.addListener(this);
        this.realizationSet.prepare(this);
        this.realizationSet.removeListener(this);
    }

    public void runRealizationDetectors() throws PatchProException {
        this.realizationSet.addListener(this);
        this.realizationSet.getRealizationSet(this.targetHost);
        this.realizationSet.removeListener(this);
    }

    public Host getHost() {
        return this.targetHost;
    }

    private void loadRealizations(Enumeration enumeration, Host host) {
        while (enumeration.hasMoreElements()) {
            host.addRealization((Realization)enumeration.nextElement(), false);
        }
    }

    private String getOSName() {
        String string = System.getProperty("os.name");
        if (string.compareTo("Solaris") == 0) {
            string = "SunOS";
        }
        return string;
    }

    private void initializeProgress() {
        if (this.totalDetectorCount < 100) {
            this.countEachDetector = true;
        }
        this.nextPercent = 1;
        this.finishedDetectorCount = 0;
        this.realizationProgress = 0;
    }

    private void incrementProgress() {
        ++this.finishedDetectorCount;
        this.realizationProgress = (int)((double)((float)this.finishedDetectorCount / (float)this.totalDetectorCount) * 100.0);
        if (this.countEachDetector) {
            this.dispatchProgressEvent(new RealizationDetectorEvent(this));
        } else if (this.realizationProgress > this.nextPercent) {
            ++this.nextPercent;
            this.dispatchProgressEvent(new RealizationDetectorEvent(this));
        }
    }

    public Percentage getBaseDataProgress() {
        Percentage percentage;
        try {
            percentage = new Percentage(this.baseDataProgress);
        }
        catch (Exception exception) {
            this.log.println(this, 4, "HostAnalyzer.getBaseDataProgress(): Unable to create a Percentage from " + this.baseDataProgress + ".");
            this.baseDataProgress = 100;
            percentage = new Percentage(this.baseDataProgress);
            this.baseDataDetectorsDone = true;
        }
        return percentage;
    }

    public Percentage getRealizationProgress() {
        Percentage percentage;
        try {
            percentage = new Percentage(this.realizationProgress);
        }
        catch (Exception exception) {
            this.log.println(this, 4, "HostAnalyzer.getRealizationProgress(): Unable to create a Percentage from " + this.realizationProgress + ".");
            percentage = new Percentage(100);
        }
        return percentage;
    }

    public Percentage getDetectorDownloadProgress() {
        Percentage percentage;
        try {
            percentage = this.realizationSet.getDownloadProgress();
        }
        catch (Exception exception) {
            this.log.println(this, 4, "HostAnalyzer.getDetectorDownloadProgress(): Unable to create a Percentage from realizationSet.getDownloadProgress().");
            percentage = new Percentage(100);
        }
        return percentage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(RealizationDetectorListener realizationDetectorListener) {
        Vector vector = this.realizationDetectorListeners;
        synchronized (vector) {
            this.realizationDetectorListeners.addElement(realizationDetectorListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DetectorListener detectorListener) {
        Vector vector = this.detectorListeners;
        synchronized (vector) {
            this.detectorListeners.addElement(detectorListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(BaseDataDetectorListener baseDataDetectorListener) {
        Vector vector = this.baseDataDetectorListeners;
        synchronized (vector) {
            this.baseDataDetectorListeners.addElement(baseDataDetectorListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DownloadDetectorsListener downloadDetectorsListener) {
        Vector vector = this.downloadDetectorsListeners;
        synchronized (vector) {
            this.downloadDetectorsListeners.addElement(downloadDetectorsListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(RealizationDetectorListener realizationDetectorListener) {
        Vector vector = this.realizationDetectorListeners;
        synchronized (vector) {
            this.realizationDetectorListeners.removeElement(realizationDetectorListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(DetectorListener detectorListener) {
        Vector vector = this.detectorListeners;
        synchronized (vector) {
            this.detectorListeners.removeElement(detectorListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(BaseDataDetectorListener baseDataDetectorListener) {
        Vector vector = this.baseDataDetectorListeners;
        synchronized (vector) {
            this.baseDataDetectorListeners.removeElement(baseDataDetectorListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(DownloadDetectorsListener downloadDetectorsListener) {
        Vector vector = this.downloadDetectorsListeners;
        synchronized (vector) {
            this.downloadDetectorsListeners.removeElement(downloadDetectorsListener);
        }
    }

    public synchronized void downloadDetectorsProgress(DownloadDetectorsEvent downloadDetectorsEvent) {
        this.dispatchProgressEvent(new DownloadDetectorsEvent(this));
    }

    public synchronized void downloadDetectorsDone(DownloadDetectorsEvent downloadDetectorsEvent) {
        this.dispatchDoneEvent(new DownloadDetectorsEvent(this));
    }

    public synchronized void downloadDetectorsFailed(DownloadDetectorsEvent downloadDetectorsEvent) {
        this.dispatchErrorEvent(new DownloadDetectorsEvent(this));
    }

    public synchronized void detectorProgress(DetectorEvent detectorEvent) {
        Percentage percentage = ((BaseDataDetector)detectorEvent.getSource()).percentComplete();
        this.baseDataProgress = percentage.getPercentage();
        this.dispatchProgressEvent(new BaseDataDetectorEvent(this));
        if (this.baseDataProgress >= 100 && !this.baseDataDetectorsDone) {
            this.baseDataDetectorsDone = true;
            this.dispatchDoneEvent(new BaseDataDetectorEvent(this));
        }
    }

    public synchronized void detectorDone(DetectorEvent detectorEvent) {
        this.baseDataDetectorsDone = true;
        this.dispatchDoneEvent(new BaseDataDetectorEvent(this));
    }

    public void detectorFailed(DetectorEvent detectorEvent) {
        this.dispatchErrorEvent(detectorEvent);
    }

    private void dispatchErrorEvent(DetectorEvent detectorEvent) {
        Enumeration enumeration = this.detectorListeners.elements();
        while (enumeration.hasMoreElements()) {
            DetectorListener detectorListener = (DetectorListener)enumeration.nextElement();
            detectorListener.detectorFailed(detectorEvent);
        }
    }

    private void dispatchProgressEvent(RealizationDetectorEvent realizationDetectorEvent) {
        Enumeration enumeration = this.realizationDetectorListeners.elements();
        while (enumeration.hasMoreElements()) {
            RealizationDetectorListener realizationDetectorListener = (RealizationDetectorListener)enumeration.nextElement();
            realizationDetectorListener.realizationDetectorProgress(realizationDetectorEvent);
        }
    }

    private void dispatchDoneEvent(RealizationDetectorEvent realizationDetectorEvent) {
        Enumeration enumeration = this.realizationDetectorListeners.elements();
        while (enumeration.hasMoreElements()) {
            RealizationDetectorListener realizationDetectorListener = (RealizationDetectorListener)enumeration.nextElement();
            realizationDetectorListener.realizationDetectorDone(realizationDetectorEvent);
        }
    }

    protected void dispatchErrorEvent(RealizationDetectorEvent realizationDetectorEvent) {
        Enumeration enumeration = this.realizationDetectorListeners.elements();
        while (enumeration.hasMoreElements()) {
            RealizationDetectorListener realizationDetectorListener = (RealizationDetectorListener)enumeration.nextElement();
            realizationDetectorListener.realizationDetectorFailed(realizationDetectorEvent);
        }
    }

    public void realizationSetProgress(RealizationSetEvent realizationSetEvent) {
        Enumeration enumeration = this.realizationDetectorListeners.elements();
        RealizationDetectorEvent realizationDetectorEvent = new RealizationDetectorEvent(this);
        while (enumeration.hasMoreElements()) {
            RealizationDetectorListener realizationDetectorListener = (RealizationDetectorListener)enumeration.nextElement();
            realizationDetectorListener.realizationDetectorProgress(realizationDetectorEvent);
        }
    }

    public void realizationSetDone(RealizationSetEvent realizationSetEvent) {
        Enumeration enumeration = this.realizationDetectorListeners.elements();
        RealizationDetectorEvent realizationDetectorEvent = new RealizationDetectorEvent(this);
        while (enumeration.hasMoreElements()) {
            RealizationDetectorListener realizationDetectorListener = (RealizationDetectorListener)enumeration.nextElement();
            realizationDetectorListener.realizationDetectorDone(realizationDetectorEvent);
        }
    }

    public void realizationSetFailed(RealizationSetEvent realizationSetEvent) {
        Enumeration enumeration = this.realizationDetectorListeners.elements();
        RealizationDetectorEvent realizationDetectorEvent = new RealizationDetectorEvent(this);
        while (enumeration.hasMoreElements()) {
            RealizationDetectorListener realizationDetectorListener = (RealizationDetectorListener)enumeration.nextElement();
            realizationDetectorListener.realizationDetectorFailed(realizationDetectorEvent);
        }
    }

    private void dispatchProgressEvent(DownloadDetectorsEvent downloadDetectorsEvent) {
        Enumeration enumeration = this.downloadDetectorsListeners.elements();
        while (enumeration.hasMoreElements()) {
            DownloadDetectorsListener downloadDetectorsListener = (DownloadDetectorsListener)enumeration.nextElement();
            downloadDetectorsListener.downloadDetectorsProgress(downloadDetectorsEvent);
        }
    }

    private void dispatchDoneEvent(DownloadDetectorsEvent downloadDetectorsEvent) {
        Enumeration enumeration = this.downloadDetectorsListeners.elements();
        while (enumeration.hasMoreElements()) {
            DownloadDetectorsListener downloadDetectorsListener = (DownloadDetectorsListener)enumeration.nextElement();
            downloadDetectorsListener.downloadDetectorsDone(downloadDetectorsEvent);
        }
        this.downloadDetectorsDone = true;
        this.realizationSet.removeListener(this);
    }

    private void dispatchErrorEvent(DownloadDetectorsEvent downloadDetectorsEvent) {
        Enumeration enumeration = this.downloadDetectorsListeners.elements();
        while (enumeration.hasMoreElements()) {
            DownloadDetectorsListener downloadDetectorsListener = (DownloadDetectorsListener)enumeration.nextElement();
            downloadDetectorsListener.downloadDetectorsFailed(downloadDetectorsEvent);
        }
        this.downloadDetectorsDone = true;
        this.realizationSet.removeListener(this);
    }

    private void dispatchProgressEvent(BaseDataDetectorEvent baseDataDetectorEvent) {
        Enumeration enumeration = this.baseDataDetectorListeners.elements();
        while (enumeration.hasMoreElements()) {
            BaseDataDetectorListener baseDataDetectorListener = (BaseDataDetectorListener)enumeration.nextElement();
            baseDataDetectorListener.baseDataDetectorProgress(baseDataDetectorEvent);
        }
    }

    private void dispatchDoneEvent(BaseDataDetectorEvent baseDataDetectorEvent) {
        Enumeration enumeration = this.baseDataDetectorListeners.elements();
        while (enumeration.hasMoreElements()) {
            BaseDataDetectorListener baseDataDetectorListener = (BaseDataDetectorListener)enumeration.nextElement();
            baseDataDetectorListener.baseDataDetectorDone(baseDataDetectorEvent);
        }
    }

    public static boolean isDetectorCacheValid(File file) {
        if (!file.exists()) {
            return false;
        }
        try {
            String string;
            ClassLoader classLoader = (class$com$sun$patchpro$analysis$HostAnalyzer == null ? (class$com$sun$patchpro$analysis$HostAnalyzer = HostAnalyzer.class$("com.sun.patchpro.analysis.HostAnalyzer")) : class$com$sun$patchpro$analysis$HostAnalyzer).getClassLoader();
            DetectorClassLoader detectorClassLoader = classLoader != null ? new DetectorClassLoader(file, classLoader) : new DetectorClassLoader(file);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(detectorClassLoader.getResourceAsStream(DETECTORLIST)));
            String string2 = bufferedReader.readLine().trim();
            while ((string = bufferedReader.readLine()) != null) {
                RealizationDetector realizationDetector = (RealizationDetector)detectorClassLoader.loadClass(string).newInstance();
            }
        }
        catch (Exception exception) {
            PatchProLog.getInstance().println(null, 7, "Cache file " + file.getPath() + " is corrupt. " + "The Cache file will be refreshed.");
            System.out.println("Realization integrity checks failed");
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ PatchProProperties access$1600(HostAnalyzer hostAnalyzer) {
        return hostAnalyzer.properties;
    }

    static /* synthetic */ RealizationEnumerator access$1702(HostAnalyzer hostAnalyzer, RealizationEnumerator realizationEnumerator) {
        hostAnalyzer.realizationListEnum = realizationEnumerator;
        return hostAnalyzer.realizationListEnum;
    }

    static /* synthetic */ RealizationEnumerator access$1700(HostAnalyzer hostAnalyzer) {
        return hostAnalyzer.realizationListEnum;
    }

    private class RealizationSetCmdLn
    implements RealizationSet {
        Vector realizationSetListeners = new Vector();
        RealizationSetListener realizationSetListener = null;
        HostAnalyzer hostAnalyzer = null;

        private RealizationSetCmdLn() {
        }

        public File getDetectorCacheFile() {
            return null;
        }

        public void prepare(HostAnalyzer hostAnalyzer) {
            Vector vector = new Vector();
            this.hostAnalyzer = hostAnalyzer;
            HostAnalyzer.this.realizationProgress = 100;
            DownloadDetectorsEvent downloadDetectorsEvent = new DownloadDetectorsEvent(this);
            Enumeration enumeration = HostAnalyzer.this.downloadDetectorsListeners.elements();
            while (enumeration.hasMoreElements()) {
                DownloadDetectorsListener downloadDetectorsListener = (DownloadDetectorsListener)enumeration.nextElement();
                downloadDetectorsListener.downloadDetectorsProgress(downloadDetectorsEvent);
                downloadDetectorsListener.downloadDetectorsDone(downloadDetectorsEvent);
            }
        }

        public Percentage getDownloadProgress() {
            return new Percentage(100);
        }

        /*
         * Unable to fully structure code
         */
        public void getRealizationSet(Host var1_1) {
            var2_2 = "patchpro.realization.provided";
            var3_3 = HostAnalyzer.access$1600(HostAnalyzer.this).getProperty(var2_2);
            var4_4 = new StringTokenizer(var3_3, ",\n");
            var5_5 = new Vector<RealizationStatus>();
            block2: while (var4_4.hasMoreTokens()) {
                var6_6 = var4_4.nextToken();
                HostAnalyzer.access$200(HostAnalyzer.this).println(this, 7, "The token is: " + var6_6);
                try {
                    var7_7 = new Realization(var6_6);
                    var8_9 = new RealizationStatus(var7_7, false);
                    var5_5.addElement(var8_9);
                    HostAnalyzer.access$1702(HostAnalyzer.this, new RealizationEnumerator(var5_5.elements()));
                    if (HostAnalyzer.access$1700(HostAnalyzer.this) == null) continue;
                    var1_1.addRealizations(HostAnalyzer.access$1700(HostAnalyzer.this));
                    continue;
                }
                catch (NoSuchRealizationException var7_8) {
                    HostAnalyzer.access$200(HostAnalyzer.this).println(this, 4, "The realization is invalid: " + var7_8.getMessage());
                    HostAnalyzer.access$200(HostAnalyzer.this).printStackTrace(this, 4, var7_8);
                    var8_10 = 0;
                    ** while (var8_10 < this.realizationSetListeners.size())
                }
lbl-1000:
                // 1 sources

                {
                    this.realizationSetListener = (RealizationSetListener)this.realizationSetListeners.elementAt(var8_10);
                    this.realizationSetListener.realizationSetFailed(new RealizationSetEvent(this, var7_8.getMessage()));
                    ++var8_10;
                    continue;
lbl26:
                    // 1 sources

                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addListener(DownloadDetectorsListener downloadDetectorsListener) {
            Vector vector = HostAnalyzer.this.downloadDetectorsListeners;
            synchronized (vector) {
                HostAnalyzer.this.downloadDetectorsListeners.addElement(downloadDetectorsListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeListener(DownloadDetectorsListener downloadDetectorsListener) {
            Vector vector = HostAnalyzer.this.downloadDetectorsListeners;
            synchronized (vector) {
                HostAnalyzer.this.downloadDetectorsListeners.removeElement(downloadDetectorsListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addListener(RealizationSetListener realizationSetListener) {
            Vector vector = this.realizationSetListeners;
            synchronized (vector) {
                this.realizationSetListeners.addElement(realizationSetListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeListener(RealizationSetListener realizationSetListener) {
            Vector vector = this.realizationSetListeners;
            synchronized (vector) {
                this.realizationSetListeners.removeElement(realizationSetListener);
            }
        }
    }

    private class RealizationSetAuto
    implements RealizationSet,
    DownloadListener {
        private ReadOnlyHost currentHost;
        private Enumeration associates;
        private PatchProProperties properties;
        Vector realizationSetListeners = new Vector();
        Vector downloadDetectorsListeners = new Vector();
        RealizationSetListener realizationSetListener = null;
        HostAnalyzer hostAnalyzer = null;
        int hostCount = 1;
        int hostsRemaining = 1;
        Percentage downloadProgress = new Percentage(0);
        boolean downloadDetectorDone;
        boolean debug = false;

        public RealizationSetAuto() {
            this.properties = PatchProProperties.getInstance();
        }

        public void prepare(HostAnalyzer hostAnalyzer) throws PatchProException {
            this.hostAnalyzer = hostAnalyzer;
            this.currentHost = hostAnalyzer.getHost();
            if (this.currentHost != null) {
                this.properties = this.properties.getHostSpecificProperties(this.currentHost);
                this.associates = this.currentHost.getAssociates();
                this.hostCount = this.hostsRemaining = this.currentHost.getAssociateCount() + 1;
            } else {
                this.associates = new Vector().elements();
            }
            boolean bl = true;
            do {
                if (!bl) {
                    this.currentHost = (ReadOnlyHost)this.associates.nextElement();
                    this.properties = this.properties.getHostSpecificProperties(this.currentHost);
                }
                this.downloadDetectors();
                bl = false;
            } while (this.associates.hasMoreElements());
        }

        public void getRealizationSet(Host host) throws PatchProException {
            BufferedReader bufferedReader = null;
            RealizationDetector realizationDetector = null;
            ClassLoader classLoader = (class$com$sun$patchpro$analysis$HostAnalyzer == null ? (class$com$sun$patchpro$analysis$HostAnalyzer = HostAnalyzer.class$("com.sun.patchpro.analysis.HostAnalyzer")) : class$com$sun$patchpro$analysis$HostAnalyzer).getClassLoader();
            this.hostsRemaining = this.hostCount;
            HostAnalyzer.this.realizationDetectorsStarted = true;
            this.initializeProgress();
            boolean bl = this.debug = this.properties.getProperty("patchpro.realization.debug", "false").equals("true");
            if (HostAnalyzer.this.targetHost == null) {
                HostAnalyzer.this.log.println(this, 3, "RealizationSetAuto.getRealizationSet(): Target host emulation does not yet exist.");
            } else if (!HostAnalyzer.this.downloadDetectorsDone) {
                HostAnalyzer.this.log.println(this, 3, "RealizationSetAuto.getRealizationSet(): RealizationDetectors have not been downloaded.");
            } else {
                this.currentHost = host;
                if (this.currentHost != null) {
                    this.properties = this.properties.getHostSpecificProperties(this.currentHost);
                    this.associates = host.getAssociates();
                    this.hostCount = this.hostsRemaining = this.currentHost.getAssociateCount() + 1;
                    HostAnalyzer.this.percentInterval = 100 / this.hostCount;
                } else {
                    this.associates = new Vector().elements();
                    HostAnalyzer.this.percentInterval = 100;
                }
                if (this.debug) {
                    System.out.println("Host Count which includes primary and associate Hosts is : " + this.hostCount);
                }
                boolean bl2 = true;
                do {
                    Object object;
                    Object object2;
                    if (!bl2) {
                        this.currentHost = (ReadOnlyHost)this.associates.nextElement();
                        this.properties = this.properties.getHostSpecificProperties(this.currentHost);
                        if (this.debug) {
                            System.out.println("Processing an AssociatedHost ....");
                            System.out.println("Current Host: " + this.currentHost.getHostName());
                            System.out.println("Current Host Type is " + this.currentHost.getType());
                            object2 = this.currentHost.getHardwareComponents();
                            while (object2.hasMoreElements()) {
                                System.out.println("\n---------------------------------------------------");
                                object = (HardwareComponent)object2.nextElement();
                                System.out.println("... HardwareComponent Product " + ((HardwareComponent)object).getProduct());
                                System.out.println("... HardwareComponent Revision " + ((HardwareComponent)object).getRevision());
                                System.out.println("---------------");
                                System.out.println("Has exact hardware component ? : " + this.currentHost.hasExactHardwareComponent(((HardwareComponent)object).getProduct(), ((HardwareComponent)object).getRevision()));
                                System.out.println("---------------------------------------------------");
                            }
                        }
                    }
                    if (this.debug && bl2) {
                        System.out.println("Current host: " + this.currentHost.getHostName());
                    }
                    if ((object2 = this.getDetectorCacheFile()) == null) {
                        this.dispatchErrorEvent(new DownloadDetectorsEvent(this));
                        return;
                    }
                    if (this.debug) {
                        System.out.println("Detector source name is : " + object2);
                    }
                    object = classLoader != null ? new DetectorClassLoader((File)object2, classLoader) : new DetectorClassLoader((File)object2);
                    try {
                        bufferedReader = new BufferedReader(new InputStreamReader(((ClassLoader)object).getResourceAsStream(HostAnalyzer.DETECTORLIST)));
                    }
                    catch (Exception exception) {
                        HostAnalyzer.this.log.println(this, 4, exception.getMessage());
                    }
                    try {
                        String string;
                        String string2 = bufferedReader.readLine().trim();
                        HostAnalyzer.this.totalDetectorCount = new Integer(string2);
                        HostAnalyzer.this.finishedDetectorCount = 0;
                        if (this.debug) {
                            System.out.println("TotalDetectorCount : " + HostAnalyzer.this.totalDetectorCount);
                        }
                        while ((string = bufferedReader.readLine()) != null) {
                            try {
                                realizationDetector = (RealizationDetector)((ClassLoader)object).loadClass(string).newInstance();
                                if (this.debug) {
                                    System.out.println(" ... CurrentDetectorName is " + string);
                                }
                                HostAnalyzer.this.loadRealizations(realizationDetector.getRealizations(), (Host)this.currentHost);
                                realizationDetector.analyze((RestrictedHost)((Object)this.currentHost));
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                HostAnalyzer.this.log.println(this, 4, "HostAnalyzer.runRealizationDetectors(): Unable to locate class " + string + ".");
                                HostAnalyzer.this.log.printStackTrace(this, 2, classNotFoundException);
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                HostAnalyzer.this.log.println(this, 4, "HostAnalyzer.runRealizationDetectors(): Forbidden to access class " + string + ".");
                                HostAnalyzer.this.log.printStackTrace(this, 2, illegalAccessException);
                            }
                            catch (InstantiationException instantiationException) {
                                HostAnalyzer.this.log.println(this, 4, "HostAnalyzer.runRealizationDetectors(): Unable to instantiate class " + string + ".");
                                HostAnalyzer.this.log.printStackTrace(this, 2, instantiationException);
                            }
                            catch (DetectorFailedException detectorFailedException) {
                                HostAnalyzer.this.log.println(this, 4, "HostAnalyzer.runRealizationDetectors(): " + string + " failed.");
                                HostAnalyzer.this.log.printStackTrace(this, 2, detectorFailedException);
                            }
                            catch (Exception exception) {
                                HostAnalyzer.this.log.println(this, 4, exception.getMessage());
                            }
                            this.incrementProgress();
                        }
                    }
                    catch (IOException iOException) {
                        HostAnalyzer.this.log.println(this, 0, "HostAnalyzer.runRealizationDetectors(): IOException thrown with message : " + iOException.getMessage());
                        HostAnalyzer.this.log.printStackTrace(this, 2, iOException);
                    }
                    catch (Exception exception) {
                        HostAnalyzer.this.log.println(this, 4, exception.getMessage());
                    }
                    if (bl2) {
                        bl2 = false;
                    }
                    --this.hostsRemaining;
                } while (this.associates.hasMoreElements());
                int n = 0;
                while (n < this.realizationSetListeners.size()) {
                    this.realizationSetListener = (RealizationSetListener)this.realizationSetListeners.get(n);
                    this.realizationSetListener.realizationSetProgress(new RealizationSetEvent(this));
                    this.realizationSetListener.realizationSetDone(new RealizationSetEvent(this));
                    ++n;
                }
            }
        }

        private void downloadDetectors() throws PatchProException {
            String string = this.properties.getProperty("patchpro.detectors.download.method");
            String string2 = this.properties.getProperty("patchpro.detectors.name");
            if (string.equalsIgnoreCase("post")) {
                this.downloadDetectorsWithPOST(string2);
            } else {
                this.downloadDetectorsWithGET(string2);
            }
        }

        /*
         * Unable to fully structure code
         */
        private void downloadDetectorsWithPOST(String var1_1) throws PatchProException {
            block5: {
                var2_2 = null;
                try {
                    var2_2 = new PatchServerProxy(this.properties);
                    break block5;
                }
                catch (PatchServerProxyException var3_3) {
                    HostAnalyzer.access$200(HostAnalyzer.this).printStackTrace(this, 3, var3_3);
                    var4_5 = "";
                    var5_6 = new StringTokenizer(var3_3.getMessage(), ":");
                    var6_7 = var5_6.countTokens();
                    var7_8 = 0;
                    ** while (var7_8 < var6_7)
                }
lbl-1000:
                // 1 sources

                {
                    var4_5 = var5_6.nextToken();
                    ++var7_8;
                    continue;
                }
lbl15:
                // 1 sources

                throw new PatchProException(var4_5);
            }
            try {
                var2_2.downloadRealizationDetectors(var1_1);
            }
            catch (NotSupportedException var3_4) {
                var3_4.printStackTrace();
            }
            this.downloadProgress(null);
            this.downloadDone(null);
        }

        private void downloadDetectorsWithGET(String string) throws PatchProException {
            try {
                File file = this.getDetectorCacheFile();
                URL uRL = this.getDetectorSourceURL();
                HostAnalyzer.this.log.println(this, 7, "RealizationSetAuto.prepare(): new CachingDownloader(" + uRL + ")");
                if (!HostAnalyzer.isDetectorCacheValid(file)) {
                    file.delete();
                }
                int n = Integer.parseInt(this.properties.getProperty("patchpro.cache.old.age.days.detectors"));
                int n2 = Integer.parseInt(this.properties.getProperty("patchpro.cache.dead.age.days.detectors"));
                HostAnalyzer.this.detectorDownloader = new CachingDownloader(string, uRL, file, CachingDownloader.days(n), CachingDownloader.days(n2), false);
                this.downloadDetectorDone = false;
                HostAnalyzer.this.detectorDownloader.addListener(this);
                InnerDownloadDetectorsThread innerDownloadDetectorsThread = new InnerDownloadDetectorsThread(HostAnalyzer.this.detectorDownloader, file.getPath());
                innerDownloadDetectorsThread.start();
                while (!this.downloadDetectorDone) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                HostAnalyzer.this.detectorDownloader.close();
            }
            catch (IOException iOException) {
                throw new PatchProException(iOException);
            }
        }

        public File getDetectorCacheFile() throws PatchProException {
            String string = this.properties.getProperty("patchpro.detectors.download.method");
            if (string.equalsIgnoreCase("post")) {
                String string2 = this.properties.getProperty("patchpro.detectors.name");
                PatchServerProxy patchServerProxy = new PatchServerProxy(this.properties);
                return patchServerProxy.getDetectorCacheFile(string2);
            }
            return new File(this.properties.getProperty("patchpro.cache.directory"), URLEncoder.encode(this.getDetectorSourceURL().toString()));
        }

        private URL getDetectorSourceURL() throws PatchProException {
            String string = this.properties.getProperty("patchpro.detectors.name");
            try {
                return new URL(this.properties.getProperty("patchpro.detectors.url.head") + string + this.properties.getProperty("patchpro.detectors.url.tail"));
            }
            catch (MalformedURLException malformedURLException) {
                throw new PatchProException(malformedURLException);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addListener(DownloadDetectorsListener downloadDetectorsListener) {
            Vector vector = this.downloadDetectorsListeners;
            synchronized (vector) {
                this.downloadDetectorsListeners.addElement(downloadDetectorsListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeListener(DownloadDetectorsListener downloadDetectorsListener) {
            Vector vector = this.downloadDetectorsListeners;
            synchronized (vector) {
                this.downloadDetectorsListeners.removeElement(downloadDetectorsListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addListener(RealizationSetListener realizationSetListener) {
            Vector vector = this.realizationSetListeners;
            synchronized (vector) {
                this.realizationSetListeners.addElement(realizationSetListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeListener(RealizationSetListener realizationSetListener) {
            Vector vector = this.realizationSetListeners;
            synchronized (vector) {
                this.realizationSetListeners.removeElement(realizationSetListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void downloadProgress(DownloadEvent downloadEvent) {
            int n = downloadEvent == null ? 100 : ((Downloader)downloadEvent.getSource()).getProgress().getPercentage();
            Percentage percentage = this.downloadProgress;
            synchronized (percentage) {
                this.downloadProgress = new Percentage((int)(((double)(this.hostCount - this.hostsRemaining) * 100.0 + (double)n) / (double)this.hostCount));
            }
            this.dispatchProgressEvent(new DownloadDetectorsEvent(this));
        }

        public synchronized void downloadDone(DownloadEvent downloadEvent) {
            this.downloadDetectorDone = true;
            if (--this.hostsRemaining == 0) {
                this.dispatchDoneEvent(new DownloadDetectorsEvent(this));
            }
        }

        public synchronized void downloadFailed(DownloadEvent downloadEvent) {
            this.dispatchErrorEvent(new DownloadDetectorsEvent(this));
        }

        private void dispatchProgressEvent(DownloadDetectorsEvent downloadDetectorsEvent) {
            Enumeration enumeration = this.downloadDetectorsListeners.elements();
            while (enumeration.hasMoreElements()) {
                DownloadDetectorsListener downloadDetectorsListener = (DownloadDetectorsListener)enumeration.nextElement();
                downloadDetectorsListener.downloadDetectorsProgress(downloadDetectorsEvent);
            }
        }

        public Percentage getDownloadProgress() {
            return this.downloadProgress;
        }

        private void dispatchDoneEvent(DownloadDetectorsEvent downloadDetectorsEvent) {
            Enumeration enumeration = this.downloadDetectorsListeners.elements();
            while (enumeration.hasMoreElements()) {
                DownloadDetectorsListener downloadDetectorsListener = (DownloadDetectorsListener)enumeration.nextElement();
                downloadDetectorsListener.downloadDetectorsDone(downloadDetectorsEvent);
            }
        }

        private void dispatchErrorEvent(DownloadDetectorsEvent downloadDetectorsEvent) {
            Enumeration enumeration = this.downloadDetectorsListeners.elements();
            while (enumeration.hasMoreElements()) {
                DownloadDetectorsListener downloadDetectorsListener = (DownloadDetectorsListener)enumeration.nextElement();
                downloadDetectorsListener.downloadDetectorsFailed(downloadDetectorsEvent);
            }
        }

        private void initializeProgress() {
            if (HostAnalyzer.this.totalDetectorCount < 100) {
                HostAnalyzer.this.countEachDetector = true;
            }
            HostAnalyzer.this.nextPercent = 1;
            HostAnalyzer.this.finishedDetectorCount = 0;
            HostAnalyzer.this.realizationProgress = 0;
        }

        private void incrementProgress() {
            HostAnalyzer.this.finishedDetectorCount++;
            HostAnalyzer.this.runDetectorsPercent = (int)((float)HostAnalyzer.this.finishedDetectorCount * (float)HostAnalyzer.this.percentInterval / (float)HostAnalyzer.this.totalDetectorCount);
            if (HostAnalyzer.this.runDetectorsPercent == HostAnalyzer.this.percentInterval) {
                HostAnalyzer.this.accuPercentInterval = HostAnalyzer.this.accuPercentInterval + HostAnalyzer.this.percentInterval;
                HostAnalyzer.this.realizationProgress = HostAnalyzer.this.accuPercentInterval;
            } else {
                HostAnalyzer.this.realizationProgress = HostAnalyzer.this.accuPercentInterval + HostAnalyzer.this.runDetectorsPercent;
            }
            if (this.hostsRemaining - 1 == 0 && HostAnalyzer.this.finishedDetectorCount == HostAnalyzer.this.totalDetectorCount) {
                HostAnalyzer.this.realizationProgress = 100;
            }
            if (this.debug) {
                System.out.println("RealizationSetAuto: Progress is " + HostAnalyzer.this.realizationProgress);
            }
            HostAnalyzer.this.realizationSetProgress(new RealizationSetEvent(this));
        }
    }

    private static interface RealizationSet {
        public void prepare(HostAnalyzer var1) throws PatchProException;

        public void getRealizationSet(Host var1) throws PatchProException;

        public File getDetectorCacheFile() throws PatchProException;

        public void addListener(DownloadDetectorsListener var1);

        public void removeListener(DownloadDetectorsListener var1);

        public void addListener(RealizationSetListener var1);

        public void removeListener(RealizationSetListener var1);

        public Percentage getDownloadProgress();
    }

    private class InnerDownloadDetectorsThread
    extends Thread {
        private CachingDownloader downloader;
        private String cacheName;

        public InnerDownloadDetectorsThread(CachingDownloader cachingDownloader, String string) {
            this.downloader = cachingDownloader;
            this.cacheName = string;
        }

        public void run() {
            try {
                HostAnalyzer.this.detectorDownloader.getValidCache();
            }
            catch (IOException iOException) {
                HostAnalyzer.this.log.println(this, 3, "InnerDownloadDetectorsThread.run(): Unable to download to " + this.cacheName + ".");
            }
        }
    }
}

