/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.patchmgr.client;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ContextHelpListener;
import com.sun.admin.cis.common.FlowArea;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.patchmgr.client.AnalyzeAddPatchWizard;
import com.sun.admin.patchmgr.client.PatchContextHelpListener;
import com.sun.admin.patchmgr.client.VPatchMgr;
import com.sun.admin.patchmgr.common.AssessedPatchData;
import com.sun.management.viper.console.gui.wizard.VWizardCard;
import com.sun.management.viper.util.ResourceManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class AnalyzeRecommendedCard
extends VWizardCard {
    private VPatchMgr theApp;
    private ResourceBundle bundle;
    private JTable patchTable;
    private JScrollPane scrollPane;
    private Vector vPatches = new Vector();
    private DataTableModel model;
    private static final int N_COLS = 2;
    private AnalyzeAddPatchWizard wiz;
    private ActionString actionString;
    private GenInfoPanel infoPanel;
    private PatchContextHelpListener overviewHelpListener;
    private int columnWidth = 25;
    public static final int HELP_CACHE_SIZE = 2;
    public static final int VISIBLE_ROWS = 10;

    public AnalyzeRecommendedCard(VPatchMgr vPatchMgr, AnalyzeAddPatchWizard analyzeAddPatchWizard) {
        this.theApp = vPatchMgr;
        this.bundle = vPatchMgr.getResourceBundle();
        this.wiz = analyzeAddPatchWizard;
        super.setTitle(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"analyze_step2_title"));
        this.calcColWidth();
        this.constructStep(10, this.columnWidth);
    }

    private void constructStep(int n, int n2) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.actionString = new ActionString(this.bundle, "aa_wiz_recommended_lbl");
        JLabel jLabel = new JLabel(this.actionString.getString());
        jLabel.setDisplayedMnemonic(this.actionString.getMnemonic());
        Constraints.constrain((Container)((Object)this), (Component)jLabel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)24, (int)12, (int)0, (int)0);
        this.model = new DataTableModel();
        this.patchTable = new JTable(this.model);
        this.patchTable.setColumnSelectionAllowed(false);
        this.patchTable.setRowSelectionAllowed(true);
        this.patchTable.setShowGrid(true);
        this.patchTable.setSelectionMode(0);
        jLabel.setLabelFor(this.patchTable);
        this.patchTable.addFocusListener(new ListListener());
        this.patchTable.getTableHeader().setReorderingAllowed(false);
        TableColumnModel tableColumnModel = this.patchTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setMinWidth(n2);
        tableColumn.setPreferredWidth(n2);
        tableColumn.setHeaderValue(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"table_patchid"));
        tableColumn = tableColumnModel.getColumn(1);
        tableColumn.setHeaderValue(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"table_description"));
        this.scrollPane = new JScrollPane(this.patchTable);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        double d = (double)(n * this.patchTable.getRowHeight()) + this.patchTable.getTableHeader().getPreferredSize().getHeight();
        double d2 = this.scrollPane.getPreferredSize().getHeight() - this.scrollPane.getViewport().getPreferredSize().getHeight();
        double d3 = this.scrollPane.getPreferredSize().getWidth();
        this.scrollPane.setPreferredSize(new Dimension((int)d3, (int)(d += d2)));
        this.scrollPane.setMinimumSize(this.scrollPane.getPreferredSize());
        int n3 = (int)d3 - n2;
        tableColumn.setMinWidth(n3);
        tableColumn.setPreferredWidth(n3);
        this.patchTable.setAutoResizeMode(3);
        Constraints.constrain((Container)((Object)this), (Component)this.scrollPane, (int)0, (int)1, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)1.0, (int)5, (int)12, (int)0, (int)0);
    }

    private void calcColWidth() {
        JLabel jLabel = new JLabel();
        jLabel.setFont(ResourceManager.labelFont);
        FontMetrics fontMetrics = jLabel.getFontMetrics(ResourceManager.labelFont);
        jLabel.setFont(ResourceManager.bodyFont);
        FontMetrics fontMetrics2 = jLabel.getFontMetrics(ResourceManager.labelFont);
        String string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"table_patchid");
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics2.stringWidth("XXXXXX-YY");
        this.columnWidth = Math.max(n += fontMetrics.stringWidth("AAAA"), n2 += fontMetrics.stringWidth("AA"));
    }

    private void updateTableSize(int n) {
        int n2 = n <= 0 ? 10 : Math.min(n, 10);
        this.removeAll();
        this.constructStep(n2, this.columnWidth);
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public void loadHelp() {
        Vector vector = new Vector(2);
        this.infoPanel = this.wiz.getInfoPanel();
        this.overviewHelpListener = new PatchContextHelpListener(this.theApp, vector, this.infoPanel, "analyze_wiz_s2_recommended");
        ContextHelpListener.loadHelp(vector);
    }

    public void start() {
        super.start();
        Vector vector = this.wiz.getPatchList();
        int n = vector.size();
        this.updateTableSize(n);
        this.model.deleteAllRows();
        int n2 = 0;
        while (n2 < n) {
            this.model.insertRow((AssessedPatchData)vector.elementAt(n2));
            ++n2;
        }
        this.setProperty("vwp.canmoveforward", "vwp.true");
        this.setProperty("vwp.canmovebackward", "vwp.false");
        this.setProperty("vwp.finishstate", "vwp.false");
        this.infoPanel.setFocusListener((FocusListener)((Object)this.overviewHelpListener), true);
    }

    public boolean stop(boolean bl) {
        if (!bl) {
            return true;
        }
        String string = "analyzedownloaddir";
        this.getManager().setNext(this.getManager().getCurrent(), string);
        return true;
    }

    public boolean isSubStep() {
        return false;
    }

    public void reset() {
        this.wiz.setPreventCancel(false);
        JPanel jPanel = new JPanel(new GridBagLayout());
        FlowArea flowArea = new FlowArea(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"wrn_message"), 30);
        Constraints.constrain((Container)jPanel, (Component)flowArea, (int)0, (int)0, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)1.0, (int)5, (int)5, (int)5, (int)5);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AnalyzeRecommendedCard.this.wiz.setPreventCancel(true);
            }
        };
        WarningDialog warningDialog = new WarningDialog(this.theApp.getFrame(), jPanel, actionListener, ResourceStrings.getString((ResourceBundle)this.bundle, (String)"wrn_btn_resume"));
    }

    private void initButton(JButton jButton, String string) {
        this.actionString = new ActionString(this.bundle, string);
        jButton.setText(this.actionString.getString());
        jButton.setMnemonic(this.actionString.getMnemonic());
    }

    class ListListener
    implements FocusListener {
        ListListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            AnalyzeRecommendedCard.this.patchTable.getSelectionModel().setSelectionInterval(0, 0);
        }

        public void focusLost(FocusEvent focusEvent) {
            AnalyzeRecommendedCard.this.patchTable.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    class DataTableModel
    extends AbstractTableModel {
        DataTableModel() {
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return AnalyzeRecommendedCard.this.vPatches.size();
        }

        public Object getValueAt(int n, int n2) {
            if (AnalyzeRecommendedCard.this.vPatches == null || AnalyzeRecommendedCard.this.vPatches.size() == 0) {
                return null;
            }
            if (n >= this.getRowCount() || n2 >= this.getColumnCount()) {
                return null;
            }
            AssessedPatchData assessedPatchData = (AssessedPatchData)AnalyzeRecommendedCard.this.vPatches.elementAt(n);
            if (assessedPatchData == null) {
                return null;
            }
            String string = assessedPatchData.getPatchId();
            String string2 = assessedPatchData.getSynopsis();
            if (n2 == 0) {
                return string;
            }
            return string2;
        }

        public int insertRow(AssessedPatchData assessedPatchData) {
            AnalyzeRecommendedCard.this.vPatches.addElement(assessedPatchData);
            int n = AnalyzeRecommendedCard.this.vPatches.size() - 1;
            this.fireTableRowsInserted(n, n);
            return n;
        }

        public void deleteAllRows() {
            int n = AnalyzeRecommendedCard.this.vPatches.size();
            if (n > 0) {
                AnalyzeRecommendedCard.this.vPatches.removeAllElements();
                this.fireTableRowsDeleted(0, n - 1);
            }
        }
    }
}

