/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im.iiimp;

import java.awt.event.KeyEvent;
import java.util.Locale;
import java.util.Vector;
import sun.awt.im.iiimp.IIIMPIMValues;
import sun.awt.im.iiimp.IIIMPKey;
import sun.awt.im.iiimp.InputContext;
import sun.awt.im.iiimp.Manager;

class IMServer {
    private Vector ichList = new Vector();
    private Locale locale = null;
    private int id = -1;
    private Locale[] localeList = null;
    private IIIMPKey[] onKey = null;
    private IIIMPKey[] offKey = null;
    private boolean dynamic_event_flow = false;

    IMServer() {
    }

    IMServer(int n) {
        this.id = n;
    }

    boolean open(Locale locale) {
        if (this.isLocaleSupported(locale)) {
            this.locale = locale;
            return true;
        }
        return false;
    }

    boolean reopen(Locale locale) {
        if (this.isLocaleSupported(locale)) {
            this.locale = locale;
            return true;
        }
        return false;
    }

    boolean setData(IIIMPIMValues iIIMPIMValues) {
        if (iIIMPIMValues == null) {
            return false;
        }
        this.id = iIIMPIMValues.id;
        this.dynamic_event_flow = iIIMPIMValues.dynamic_event_flow;
        this.onKey = iIIMPIMValues.onKey;
        this.offKey = iIIMPIMValues.offKey;
        this.localeList = iIIMPIMValues.localeList;
        return true;
    }

    public Locale[] getAvailableLocales() {
        if (this.localeList == null) {
            return null;
        }
        Locale[] localeArray = new Locale[this.localeList.length];
        System.arraycopy(this.localeList, 0, localeArray, 0, this.localeList.length);
        return localeArray;
    }

    void addInputContextHandler(InputContext inputContext) {
        this.ichList.addElement(inputContext);
    }

    void removeInputContextHandler(InputContext inputContext) {
        this.ichList.removeElement(inputContext);
    }

    InputContext getInputContext(int n) {
        for (int i = 0; i < this.ichList.size(); ++i) {
            InputContext inputContext = (InputContext)this.ichList.elementAt(i);
            if (inputContext.getID() != n) continue;
            return inputContext;
        }
        return null;
    }

    public InputContext[] getInputContext() {
        if (this.ichList.size() == 0) {
            return null;
        }
        Object[] objectArray = new InputContext[this.ichList.size()];
        this.ichList.copyInto(objectArray);
        return objectArray;
    }

    int getID() {
        return this.id;
    }

    int getInputContextID(java.awt.im.InputContext inputContext) {
        InputContext[] inputContextArray = this.getInputContext();
        if (inputContextArray == null) {
            this.debug("InputContext is null, return -1");
            return -1;
        }
        for (int i = 0; i < inputContextArray.length; ++i) {
            if (!inputContextArray[i].isIn(inputContext)) continue;
            return inputContextArray[i].getID();
        }
        this.debug("There are no ic in it, return -1");
        return -1;
    }

    private void debug(String string) {
        if (Manager.DEBUG) {
            System.err.println(string);
        }
    }

    boolean isDynamicEventFlow() {
        return this.dynamic_event_flow;
    }

    boolean isConversionOnKey(KeyEvent keyEvent) {
        int n = keyEvent.getModifiers();
        int n2 = keyEvent.getKeyCode();
        if (this.onKey != null) {
            for (int i = 0; i < this.onKey.length; ++i) {
                if ((n & this.onKey[i].modifier) == 0 || n2 != this.onKey[i].keycode) continue;
                return true;
            }
        }
        return false;
    }

    boolean isConversionOffKey(KeyEvent keyEvent) {
        int n = keyEvent.getModifiers();
        int n2 = keyEvent.getKeyCode();
        if (this.offKey != null) {
            for (int i = 0; i < this.offKey.length; ++i) {
                if ((n & this.offKey[i].modifier) == 0 || n2 != this.offKey[i].keycode) continue;
                return true;
            }
        }
        return false;
    }

    boolean isLocaleSupported(Locale locale) {
        if (this.localeList != null && this.localeList.length > 0) {
            for (int i = 0; i < this.localeList.length; ++i) {
                if (!IMServer.localeEquals(locale, this.localeList[i])) continue;
                return true;
            }
        }
        return false;
    }

    static boolean localeEquals(Locale locale, Locale locale2) {
        if (locale == null || locale2 == null) {
            return false;
        }
        String string = locale.getLanguage();
        if (string.equals("en") || string.equals("fr") || string.equals("de") || string.equals("it") || string.equals("sv") || string.equals("es") || string.equals("ja") || string.equals("ko")) {
            return string.equals(locale2.getLanguage());
        }
        if (string.equals("zh")) {
            if (string.equals(locale2.getLanguage())) {
                String string2 = locale.getCountry();
                if (string2 != null && string2.length() > 0) {
                    return string2.equals(locale2.getCountry());
                }
                return true;
            }
            return false;
        }
        return string.equals(locale2.getLanguage());
    }
}

