/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cimom;

import com.sun.wbem.cimom.CIMOMImpl;
import com.sun.wbem.cimom.CIMOMLogService;
import com.sun.wbem.cimom.ProviderClient;
import com.sun.wbem.cimom.ServiceRegistry;
import com.sun.wbem.cimom.UnregHandler;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMInstanceException;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMQualifierType;
import javax.wbem.client.Debug;

class MofregClient
extends ProviderClient {
    private int mode;
    private UnregHandler uh;
    private boolean mustLog = true;

    private void logException(Exception exception) {
        CIMOMLogService cIMOMLogService = (CIMOMLogService)ServiceRegistry.getService("logservice");
        if (cIMOMLogService == null) {
            return;
        }
        try {
            cIMOMLogService.writeLog("Mofreg", "MOFREG_ERROR", "MOFREG_ERROR", null, exception.toString(), false, 2, 1, null);
        }
        catch (Exception exception2) {
            Debug.trace2((String)"logging error", (Throwable)exception2);
        }
    }

    public MofregClient(CIMOMImpl cIMOMImpl, int n, UnregHandler unregHandler) throws CIMException {
        super(cIMOMImpl, new CIMNameSpace("", ""));
        this.mode = n;
        this.uh = unregHandler;
        if (unregHandler == null) {
            this.mustLog = false;
        }
    }

    public void createNameSpace(CIMNameSpace cIMNameSpace) throws CIMException {
        super.createNameSpace(cIMNameSpace);
    }

    public void deleteNameSpace(CIMNameSpace cIMNameSpace) throws CIMException {
        super.createNameSpace(cIMNameSpace);
    }

    public void deleteClass(CIMObjectPath cIMObjectPath) throws CIMException {
        Debug.trace3((String)"In mofreg client deleteclass");
        this.cimom.intMofregRemoveClass(this.nameSpace, cIMObjectPath);
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        Debug.trace3((String)"In mofreg client deleteinstance");
        CIMInstance cIMInstance = null;
        Debug.trace3((String)("path for delete is " + cIMObjectPath));
        CIMClass cIMClass = super.getClass(cIMObjectPath, false);
        CIMInstance cIMInstance2 = cIMClass.newInstance();
        cIMInstance2.updatePropertyValues(cIMObjectPath.getKeys());
        this.cimom.checkInstanceSanity(cIMObjectPath.getNameSpace(), cIMInstance2, cIMClass);
        cIMObjectPath.setKeys(cIMInstance2.getKeyValuePairs());
        cIMInstance = super.getInstance(cIMObjectPath, false);
        if (cIMInstance == null) {
            throw new CIMInstanceException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath.toString());
        }
        this.cimom.intdeleteInstance(this.nameSpace, cIMObjectPath, true);
        if (this.mustLog) {
            CIMObjectPath cIMObjectPath2 = new CIMObjectPath();
            cIMObjectPath2.setNameSpace(cIMObjectPath.getNameSpace());
            cIMObjectPath2.setObjectName(cIMObjectPath.getObjectName());
            this.uh.deleteInstance(cIMObjectPath2, cIMInstance);
        }
    }

    public void createQualifierType(CIMObjectPath cIMObjectPath, CIMQualifierType cIMQualifierType) throws CIMException {
        super.createQualifierType(cIMObjectPath, cIMQualifierType);
    }

    public void setClass(CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        CIMClass cIMClass2 = null;
        try {
            CIMObjectPath cIMObjectPath2 = new CIMObjectPath();
            cIMObjectPath2.setNameSpace(cIMObjectPath.getNameSpace());
            cIMObjectPath2.setObjectName(cIMClass.getName());
            Debug.trace3((String)("Trying to get old class " + cIMObjectPath2));
            cIMClass2 = super.getClass(cIMObjectPath2, true);
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("CIM_ERR_NOT_FOUND")) {
                this.logException((Exception)((Object)cIMException));
                return;
            }
            throw cIMException;
        }
        Debug.trace3((String)("The old class is " + cIMClass2));
        this.cimom.intModifyClass(this.nameSpace, cIMObjectPath, cIMClass);
        if (this.mustLog) {
            this.uh.setClass(cIMObjectPath, cIMClass2, cIMClass);
        }
    }

    public void createClass(CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        try {
            super.createClass(cIMObjectPath, cIMClass);
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("CIM_ERR_ALREADY_EXISTS")) {
                this.logException((Exception)((Object)cIMException));
                return;
            }
            throw cIMException;
        }
        if (this.mustLog) {
            this.uh.createClass(cIMObjectPath, cIMClass);
        }
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        Debug.trace3((String)"In mofreg client setinstance");
        CIMInstance cIMInstance2 = null;
        CIMObjectPath cIMObjectPath2 = new CIMObjectPath();
        cIMObjectPath2.setObjectName(cIMInstance.getClassName());
        cIMObjectPath2.setNameSpace(cIMObjectPath.getNameSpace());
        CIMClass cIMClass = super.getClass(cIMObjectPath2, false);
        CIMInstance cIMInstance3 = cIMClass.newInstance();
        cIMInstance3.updatePropertyValues(cIMInstance.getProperties());
        this.cimom.checkInstanceSanity(cIMObjectPath2.getNameSpace(), cIMInstance3, cIMClass);
        cIMObjectPath2.setKeys(cIMInstance3.getKeyValuePairs());
        cIMInstance2 = super.getInstance(cIMObjectPath2, false);
        if (cIMInstance2 == null) {
            throw new CIMInstanceException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath2.toString());
        }
        this.cimom.intsetCIMElement(this.nameSpace, cIMObjectPath, cIMInstance, true, true, null, true);
        if (this.mustLog) {
            CIMObjectPath cIMObjectPath3 = new CIMObjectPath();
            cIMObjectPath3.setNameSpace(cIMObjectPath.getNameSpace());
            cIMObjectPath3.setObjectName(cIMObjectPath.getObjectName());
            this.uh.setInstance(cIMObjectPath3, cIMInstance2, cIMInstance);
        }
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        CIMObjectPath cIMObjectPath2 = super.createInstance(cIMObjectPath, cIMInstance);
        if (cIMObjectPath2 != null) {
            cIMInstance = super.getInstance(cIMObjectPath, false);
        }
        if (this.mustLog) {
            this.uh.createInstance(cIMObjectPath, cIMInstance);
        }
        return cIMObjectPath2;
    }
}

