/*
 * Decompiled with CFR 0.152.
 */
package com.sun.smartcard.scf;

import com.sun.smartcard.scf.Card;
import com.sun.smartcard.scf.InternalCard;
import com.sun.smartcard.scf.NoCardException;

class CardManager {
    private InternalCard currentInternalCard = null;
    private Card currentCard = null;
    private boolean isActive = false;

    CardManager() {
    }

    void init(InternalCard internalCard) {
        this.currentInternalCard = internalCard;
    }

    void close() {
        this.currentInternalCard = null;
    }

    void activate() {
        this.isActive = true;
    }

    synchronized void passivate() {
        this.isActive = false;
        if (this.currentCard != null) {
            this.currentCard.close();
            this.currentCard = null;
        }
    }

    synchronized Card getCard() throws NoCardException {
        if (!this.isActive) {
            return null;
        }
        if (this.currentInternalCard == null) {
            throw new NoCardException();
        }
        if (this.currentCard == null) {
            this.currentCard = new Card();
            this.currentCard.init(this.currentInternalCard, this);
            this.currentCard.activate();
        }
        return this.currentCard;
    }

    synchronized void cardClosed(Card card) {
        if (this.currentCard == card) {
            this.currentCard = null;
        }
    }

    synchronized void cardInserted(InternalCard internalCard) {
        this.currentInternalCard = internalCard;
    }

    synchronized void cardRemoved() {
        this.currentInternalCard = null;
        if (this.currentCard != null) {
            this.currentCard.close();
            this.currentCard = null;
        }
    }
}

