/*
 * Decompiled with CFR 0.152.
 */
package com.sun.database.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;

public class HierarchicalField
implements Serializable {
    transient Object[] formalObjs = new Object[0];
    String hfield;
    Class hclass;
    Vector classHierarchy = null;
    Vector fieldHierarchy;
    transient Field actualField;
    transient Method actualMethod;
    Class fieldType;
    boolean fieldIsSimple = true;
    boolean fieldIsMethod = false;

    public HierarchicalField() {
    }

    public HierarchicalField(String string, Class clazz) throws NoSuchFieldException, SecurityException {
        this.hfield = string;
        this.hclass = clazz;
        this.generateHierarchy(string, clazz);
    }

    public Class getType() {
        return this.fieldType;
    }

    public Object get(Object object) throws IllegalAccessException {
        Object object2 = this.getApplicableObject(object);
        if (this.fieldIsMethod) {
            try {
                return this.actualMethod.invoke(object2, this.formalObjs);
            }
            catch (Exception exception) {
                throw new IllegalAccessException(exception.getMessage());
            }
        }
        return this.actualField.get(object2);
    }

    public long getLong(Object object) throws IllegalAccessException {
        Object object2 = this.getApplicableObject(object);
        if (this.fieldIsMethod) {
            try {
                Long l = (Long)this.actualMethod.invoke(object2, this.formalObjs);
                return l;
            }
            catch (Exception exception) {
                throw new IllegalAccessException(exception.getMessage());
            }
        }
        return this.actualField.getLong(object2);
    }

    public short getShort(Object object) throws IllegalAccessException {
        Object object2 = this.getApplicableObject(object);
        if (this.fieldIsMethod) {
            try {
                Short s = (Short)this.actualMethod.invoke(object2, this.formalObjs);
                return s;
            }
            catch (Exception exception) {
                throw new IllegalAccessException(exception.getMessage());
            }
        }
        return this.actualField.getShort(object2);
    }

    public int getInt(Object object) throws IllegalAccessException {
        Object object2 = this.getApplicableObject(object);
        if (this.fieldIsMethod) {
            try {
                Integer n = (Integer)this.actualMethod.invoke(object2, this.formalObjs);
                return n;
            }
            catch (Exception exception) {
                throw new IllegalAccessException(exception.getMessage());
            }
        }
        return this.actualField.getInt(object2);
    }

    public boolean getBoolean(Object object) throws IllegalAccessException {
        Object object2 = this.getApplicableObject(object);
        if (this.fieldIsMethod) {
            try {
                Boolean bl = (Boolean)this.actualMethod.invoke(object2, this.formalObjs);
                return bl.equals(new Boolean("true"));
            }
            catch (Exception exception) {
                throw new IllegalAccessException(exception.getMessage());
            }
        }
        return this.actualField.getBoolean(object2);
    }

    public double getDouble(Object object) throws IllegalAccessException {
        Object object2 = this.getApplicableObject(object);
        if (this.fieldIsMethod) {
            try {
                Double d = (Double)this.actualMethod.invoke(object2, this.formalObjs);
                return d;
            }
            catch (Exception exception) {
                throw new IllegalAccessException(exception.getMessage());
            }
        }
        return this.actualField.getDouble(object2);
    }

    public char getChar(Object object) throws IllegalAccessException {
        Object object2 = this.getApplicableObject(object);
        if (this.fieldIsMethod) {
            try {
                Character c = (Character)this.actualMethod.invoke(object2, this.formalObjs);
                return c.charValue();
            }
            catch (Exception exception) {
                throw new IllegalAccessException(exception.getMessage());
            }
        }
        return this.actualField.getChar(object2);
    }

    private Object getApplicableObject(Object object) throws IllegalAccessException {
        Object object2 = object;
        if (!this.fieldIsSimple) {
            Enumeration enumeration = this.fieldHierarchy.elements();
            while (enumeration.hasMoreElements()) {
                object2 = ((Field)enumeration.nextElement()).get(object2);
            }
        }
        return object2;
    }

    private void generateHierarchy(String string, Class clazz) throws NoSuchFieldException, SecurityException {
        int n;
        int n2 = 0;
        Class<?> clazz2 = clazz;
        int n3 = -1;
        int n4 = -1;
        Class[] classArray = new Class[]{};
        if (this.classHierarchy == null) {
            this.classHierarchy = new Vector();
        }
        if (this.fieldHierarchy == null) {
            this.fieldHierarchy = new Vector();
        }
        while ((n = string.indexOf(46, n2)) > -1) {
            this.fieldIsSimple = false;
            String string2 = new String(string.substring(n2, n));
            Field field = clazz2.getField(string2);
            Class<?> clazz3 = field.getType();
            this.classHierarchy.addElement(clazz3);
            this.fieldHierarchy.addElement(field);
            clazz2 = clazz3;
            n2 = n + 1;
        }
        String string3 = string.substring(n2);
        n3 = string3.indexOf("(");
        if (n3 > 0) {
            n4 = string3.indexOf(")");
            if (n4 < 1) {
                throw new NoSuchFieldException("Method field declaration is malformed.");
            }
            try {
                this.actualMethod = clazz2.getMethod(string3.substring(0, n3), classArray);
                this.fieldType = this.actualMethod.getReturnType();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new NoSuchFieldException("Specified method is not part of this class.");
            }
            this.fieldIsMethod = true;
        } else {
            this.actualField = clazz2.getField(string3);
            this.fieldType = this.actualField.getType();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.hfield);
        objectOutputStream.writeObject(this.hclass);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.hfield = (String)objectInputStream.readObject();
        this.hclass = (Class)objectInputStream.readObject();
        try {
            this.generateHierarchy(this.hfield, this.hclass);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

