/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.client;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ISOLatinDocument;
import com.sun.admin.cis.common.ISOLatinField;
import com.sun.admin.hostmgr.client.AbstractPropsPanel;
import com.sun.admin.hostmgr.client.HostMgrContextHelpListener;
import com.sun.admin.hostmgr.client.VHostMgr;
import com.sun.admin.hostmgr.common.HostException;
import com.sun.admin.hostmgr.common.NetworkData;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class NetworkAdvPropsPanel
extends AbstractPropsPanel {
    public static final int HELP_CACHE_SIZE = 3;
    private NetworkData originalNetworkObj;
    private ISOLatinField aliases;
    private JTextArea description;

    public NetworkAdvPropsPanel(VHostMgr vHostMgr, Vector vector, boolean bl, GenInfoPanel genInfoPanel, NetworkData networkData) {
        ResourceBundle resourceBundle = vHostMgr.getResourceBundle();
        this.setLayout(new GridBagLayout());
        ActionString actionString = new ActionString(resourceBundle, "NetAdvPropsTabName");
        this.setBorder(BorderFactory.createTitledBorder(actionString.getString()));
        actionString = new ActionString(resourceBundle, "NetGenPropsAliases");
        JLabel jLabel = new JLabel(actionString.getString());
        Constraints.constrain((Container)this, (Component)jLabel, (int)0, (int)-1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)10, (int)5, (int)10, (int)5);
        jLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        jLabel.setFont(Constants.PROPS_LABEL_FONT);
        jLabel.setDisplayedMnemonic(actionString.getMnemonic());
        this.aliases = new ISOLatinField(-1, networkData.getAliases(), 24);
        Constraints.constrain((Container)this, (Component)this.aliases, (int)1, (int)-1, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)10, (int)0, (int)10, (int)5);
        this.aliases.setFont(Constants.PROPS_RW_VALUE_FONT);
        jLabel.setLabelFor((Component)this.aliases);
        actionString = new ActionString(resourceBundle, "NetGenPropsDescription");
        jLabel = new JLabel(actionString.getString());
        Constraints.constrain((Container)this, (Component)jLabel, (int)0, (int)-1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)0, (int)5, (int)10, (int)5);
        jLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        jLabel.setFont(Constants.PROPS_LABEL_FONT);
        jLabel.setDisplayedMnemonic(actionString.getMnemonic());
        this.description = new JTextArea(networkData.getDescription(), 3, 24);
        this.description.setDocument((Document)new ISOLatinDocument(-1, (JTextComponent)this.description));
        this.description.setLineWrap(true);
        this.description.setFont(Constants.PROPS_RW_VALUE_FONT);
        jLabel.setLabelFor(this.description);
        JScrollPane jScrollPane = new JScrollPane(this.description, 20, 31);
        jScrollPane.setMinimumSize(jScrollPane.getPreferredSize());
        Constraints.constrain((Container)this, (Component)jScrollPane, (int)1, (int)-1, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)10, (int)5);
        if (networkData.getNetworkAddress().length() != 0) {
            this.aliases.addFocusListener((FocusListener)((Object)new HostMgrContextHelpListener(vHostMgr, vector, genInfoPanel, "dlg_netprop_alias")));
            this.description.addFocusListener((FocusListener)((Object)new HostMgrContextHelpListener(vHostMgr, vector, genInfoPanel, "dlg_netprop_desc")));
        } else {
            this.aliases.addFocusListener((FocusListener)((Object)new HostMgrContextHelpListener(vHostMgr, vector, genInfoPanel, "dlg_newnet_alias")));
            this.description.addFocusListener((FocusListener)((Object)new HostMgrContextHelpListener(vHostMgr, vector, genInfoPanel, "dlg_newnet_desc")));
        }
        this.originalNetworkObj = networkData;
    }

    public void dialogDataExchange(Object object) throws HostException {
        NetworkData networkData = (NetworkData)object;
        if (this.description.getText().length() > 0) {
            try {
                NetworkData.validateDescription(this.description.getText());
                networkData.setDescription(this.description.getText());
            }
            catch (HostException hostException) {
                this.description.requestFocus();
                throw hostException;
            }
        }
        if (this.aliases.getText().length() > 0) {
            try {
                NetworkData.validateAliasNames(this.aliases.getText());
                networkData.setAliases(this.aliases.getText());
            }
            catch (HostException hostException) {
                this.aliases.requestFocus();
                throw hostException;
            }
        }
    }

    public void dialogDataInitialize(Object object) {
        NetworkData networkData = (NetworkData)object;
        this.description.setText(networkData.getDescription());
        this.aliases.setText(networkData.getAliases());
        this.originalNetworkObj = networkData;
    }
}

