/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.client;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ISOLatinDocument;
import com.sun.admin.cis.common.ISOLatinField;
import com.sun.admin.hostmgr.client.AbstractPropsPanel;
import com.sun.admin.hostmgr.client.ApplicationContext;
import com.sun.admin.hostmgr.client.HostMgrContextHelpListener;
import com.sun.admin.hostmgr.client.VHostMgr;
import com.sun.admin.hostmgr.common.HostData;
import com.sun.admin.hostmgr.common.HostException;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class HostAdvPropsPanel
extends AbstractPropsPanel {
    public static final int HELP_CACHE_SIZE = 5;
    private HostData originalHostObj;
    private ISOLatinField aliases;
    private JTextArea description;
    private ISOLatinField etherAddress;
    private boolean bNewHost;
    private Vector helpCache;
    private VHostMgr theApp;

    public HostAdvPropsPanel(VHostMgr vHostMgr, Vector vector, GenInfoPanel genInfoPanel, HostData hostData, boolean bl) {
        this.theApp = vHostMgr;
        ResourceBundle resourceBundle = vHostMgr.getResourceBundle();
        this.bNewHost = bl;
        this.helpCache = vector;
        this.setLayout(new GridBagLayout());
        ActionString actionString = new ActionString(resourceBundle, "AdvPropsTabName");
        this.setBorder(BorderFactory.createTitledBorder(actionString.getString()));
        actionString = new ActionString(resourceBundle, "GenPropsAliases");
        JLabel jLabel = new JLabel(actionString.getString());
        Constraints.constrain((Container)this, (Component)jLabel, (int)0, (int)-1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)10, (int)5, (int)10, (int)5);
        jLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        jLabel.setFont(Constants.PROPS_LABEL_FONT);
        jLabel.setDisplayedMnemonic(actionString.getMnemonic());
        this.aliases = new ISOLatinField(-1, hostData.getAliases(), 24);
        Constraints.constrain((Container)this, (Component)this.aliases, (int)1, (int)-1, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)10, (int)0, (int)10, (int)5);
        this.aliases.setFont(Constants.PROPS_RW_VALUE_FONT);
        ApplicationContext applicationContext = vHostMgr.getApplicationContext();
        if (applicationContext.isScopeLDAP()) {
            this.aliases.setEditable(false);
        }
        jLabel.setLabelFor((Component)this.aliases);
        actionString = new ActionString(resourceBundle, "GenPropsDescription");
        jLabel = new JLabel(actionString.getString());
        Constraints.constrain((Container)this, (Component)jLabel, (int)0, (int)-1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)0, (int)5, (int)10, (int)5);
        jLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        jLabel.setFont(Constants.PROPS_LABEL_FONT);
        jLabel.setDisplayedMnemonic(actionString.getMnemonic());
        this.description = new JTextArea();
        this.description.setDocument((Document)new ISOLatinDocument(-1, (JTextComponent)this.description));
        this.description = new JTextArea(hostData.getDescription(), 3, 24);
        this.description.setLineWrap(true);
        this.description.setFont(Constants.PROPS_RW_VALUE_FONT);
        jLabel.setLabelFor(this.description);
        JScrollPane jScrollPane = new JScrollPane(this.description, 20, 31);
        jScrollPane.setMinimumSize(jScrollPane.getPreferredSize());
        Constraints.constrain((Container)this, (Component)jScrollPane, (int)1, (int)-1, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)10, (int)5);
        actionString = new ActionString(resourceBundle, "AdvPropsEtherAddr");
        jLabel = new JLabel(actionString.getString());
        Constraints.constrain((Container)this, (Component)jLabel, (int)0, (int)-1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)0, (int)5, (int)10, (int)5);
        jLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        jLabel.setFont(Constants.PROPS_LABEL_FONT);
        jLabel.setDisplayedMnemonic(actionString.getMnemonic());
        this.etherAddress = new ISOLatinField(17, hostData.getEthernetAddress(), 24);
        Constraints.constrain((Container)this, (Component)this.etherAddress, (int)1, (int)-1, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)10, (int)5);
        this.etherAddress.setFont(Constants.PROPS_RW_VALUE_FONT);
        jLabel.setLabelFor((Component)this.etherAddress);
        if (!bl) {
            MultihomeHostComponent multihomeHostComponent = new MultihomeHostComponent(genInfoPanel, hostData);
            Constraints.constrain((Container)this, (Component)multihomeHostComponent.getLabelPanel(), (int)0, (int)-1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)0, (int)5, (int)10, (int)5);
            Constraints.constrain((Container)this, (Component)multihomeHostComponent.getValuePanel(), (int)1, (int)-1, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0, (int)0, (int)0, (int)10, (int)5);
        }
        if (!bl) {
            this.aliases.addFocusListener((FocusListener)((Object)new HostMgrContextHelpListener(vHostMgr, vector, genInfoPanel, "dlg_hostprop_alias")));
            this.description.addFocusListener((FocusListener)((Object)new HostMgrContextHelpListener(vHostMgr, vector, genInfoPanel, "dlg_hostprop_desc")));
            this.etherAddress.addFocusListener((FocusListener)((Object)new HostMgrContextHelpListener(vHostMgr, vector, genInfoPanel, "dlg_hostprop_ether")));
        } else {
            this.aliases.addFocusListener((FocusListener)((Object)new HostMgrContextHelpListener(vHostMgr, vector, genInfoPanel, "dlg_newhost_alias")));
            this.description.addFocusListener((FocusListener)((Object)new HostMgrContextHelpListener(vHostMgr, vector, genInfoPanel, "dlg_newhost_desc")));
            this.etherAddress.addFocusListener((FocusListener)((Object)new HostMgrContextHelpListener(vHostMgr, vector, genInfoPanel, "dlg_newhost_ether")));
        }
        this.originalHostObj = hostData;
    }

    public void dialogDataExchange(Object object) throws HostException {
        HostData hostData = (HostData)object;
        if (this.etherAddress.getText().length() > 0) {
            try {
                HostData.validateEthernetAddress(this.etherAddress.getText());
                hostData.setEthernetAddress(this.etherAddress.getText());
            }
            catch (HostException hostException) {
                this.etherAddress.requestFocus();
                throw hostException;
            }
        }
        if (this.description.getText().length() > 0) {
            try {
                HostData.validateDescription(this.description.getText());
                hostData.setDescription(this.description.getText());
            }
            catch (HostException hostException) {
                this.description.requestFocus();
                throw hostException;
            }
        }
        if (this.aliases.getText().length() > 0) {
            try {
                HostData.validateAliasNames(this.aliases.getText());
                hostData.setAliases(this.aliases.getText());
            }
            catch (HostException hostException) {
                this.aliases.requestFocus();
                throw hostException;
            }
        }
    }

    public void dialogDataInitialize(Object object) {
        HostData hostData = (HostData)object;
        this.etherAddress.setText(hostData.getEthernetAddress());
        this.description.setText(hostData.getDescription());
        this.aliases.setText(hostData.getAliases());
        this.originalHostObj = hostData;
    }

    class MultihomeHostComponent {
        private JPanel labelPanel;
        private JPanel valuePanel;
        private JButton getButton;
        private JTextArea otherIPAddresses;
        private HostData hostData;
        private ResourceBundle bundle;

        public MultihomeHostComponent(GenInfoPanel genInfoPanel, HostData hostData) {
            this.bundle = HostAdvPropsPanel.this.theApp.getResourceBundle();
            this.hostData = hostData;
            this.labelPanel = new JPanel();
            this.labelPanel.setLayout(new GridBagLayout());
            ActionString actionString = new ActionString(this.bundle, "AdvPropsMultihome1");
            JLabel jLabel = new JLabel(actionString.getString());
            Constraints.constrain((Container)this.labelPanel, (Component)jLabel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
            jLabel.setDisplayedMnemonic(actionString.getMnemonic());
            jLabel.setForeground(Constants.PROPS_LABEL_COLOR);
            jLabel.setFont(Constants.PROPS_LABEL_FONT);
            actionString = new ActionString(this.bundle, "AdvPropsMultihome2");
            JLabel jLabel2 = new JLabel(actionString.getString());
            Constraints.constrain((Container)this.labelPanel, (Component)jLabel2, (int)0, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
            jLabel2.setForeground(Constants.PROPS_LABEL_COLOR);
            jLabel2.setFont(Constants.PROPS_LABEL_FONT);
            this.valuePanel = new JPanel();
            this.valuePanel.setLayout(new GridBagLayout());
            this.otherIPAddresses = new JTextArea(3, 16);
            this.otherIPAddresses.setEditable(false);
            this.otherIPAddresses.setLineWrap(true);
            this.otherIPAddresses.setBackground(HostAdvPropsPanel.this.getBackground());
            this.otherIPAddresses.setFont(Constants.PROPS_RW_VALUE_FONT);
            jLabel.setLabelFor(this.otherIPAddresses);
            JScrollPane jScrollPane = new JScrollPane(this.otherIPAddresses, 20, 31);
            jScrollPane.setMinimumSize(jScrollPane.getPreferredSize());
            Constraints.constrain((Container)this.valuePanel, (Component)jScrollPane, (int)0, (int)0, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
            this.otherIPAddresses.addFocusListener((FocusListener)((Object)new HostMgrContextHelpListener(HostAdvPropsPanel.this.theApp, HostAdvPropsPanel.this.helpCache, genInfoPanel, "dlg_hostprop_multihome")));
            actionString = new ActionString(this.bundle, "AdvPropsMultihomeGet");
            this.getButton = new JButton(actionString.getString());
            this.getButton.setMnemonic(actionString.getMnemonic());
            Constraints.constrain((Container)this.valuePanel, (Component)this.getButton, (int)0, (int)1, (int)1, (int)1, (int)0, (int)13, (double)0.0, (double)0.0, (int)3, (int)0, (int)0, (int)0);
            this.getButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ MultihomeHostComponent this$1;
                {
                    this.this$1 = multihomeHostComponent;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    MultihomeHostComponent.access$200(this.this$1);
                }
            });
            this.getButton.addFocusListener((FocusListener)((Object)new HostMgrContextHelpListener(HostAdvPropsPanel.this.theApp, HostAdvPropsPanel.this.helpCache, genInfoPanel, "dlg_hostprop_multihome")));
        }

        private void onGet() {
            Vector vector = null;
            HostAdvPropsPanel.this.theApp.waitOn();
            try {
                vector = HostAdvPropsPanel.this.theApp.getHostMgr().getHostOtherAddrs(this.hostData);
                String string = new String();
                int n = 0;
                while (n < vector.size()) {
                    string = string + (String)vector.elementAt(n);
                    if (n < vector.size() - 1) {
                        string = string + "\n";
                    }
                    ++n;
                }
                this.otherIPAddresses.setText(string);
            }
            catch (Exception exception) {
                HostAdvPropsPanel.this.theApp.reportErrorException(exception);
            }
            HostAdvPropsPanel.this.theApp.waitOff();
        }

        public JPanel getLabelPanel() {
            return this.labelPanel;
        }

        public JPanel getValuePanel() {
            return this.valuePanel;
        }

        static /* synthetic */ void access$200(MultihomeHostComponent multihomeHostComponent) {
            multihomeHostComponent.onGet();
        }
    }
}

