/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.repository;

import com.sun.wbem.cimom.ReadersWriter;
import com.sun.wbem.cimom.repository.RepositoryIF;
import com.sun.wbem.repository.CIMAssocClassRlogEntry;
import com.sun.wbem.repository.CIMAssocInstanceRlogEntry;
import com.sun.wbem.repository.CIMClassRlogEntry;
import com.sun.wbem.repository.CIMInstanceRlogEntry;
import com.sun.wbem.repository.CIMNameSpaceRlogEntry;
import com.sun.wbem.repository.CIMQualifierTypeRlogEntry;
import com.sun.wbem.repository.CIMRlogEntry;
import com.sun.wbem.repository.EventHelper;
import com.sun.wbem.repository.LogException;
import com.sun.wbem.repository.LogHandler;
import com.sun.wbem.repository.PersistentStore;
import com.sun.wbem.repository.ReliableLog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMClassException;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMInstanceException;
import javax.wbem.cim.CIMNameSpaceException;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMQualifierType;
import javax.wbem.cim.CIMQualifierTypeException;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.provider.EventProvider;
import javax.wbem.query.NonJoinExp;
import javax.wbem.query.QueryExp;
import javax.wbem.query.SelectExp;
import javax.wbem.query.SelectList;
import javax.wbem.query.WQLParser;

public class PSRlogImpl
implements RepositoryIF,
EventProvider {
    private static final int CIMQYALIFY = 0;
    private static final int CIMCLASS = 1;
    private static final int CIMINSTANCE = 2;
    private EventHelper eventHelper;
    public static final String CIMROOT = "/";
    public static final String TOP = "top";
    public static final String CIMBASE = "root/cimv2";
    private static final int LOG_VERSION = 1;
    public static boolean verbose = false;
    private HashMap nameSpacesMap = null;
    private ReliableLog log;
    private boolean inRecovery;
    private ReadersWriter concurrentObj;
    private final Object snapshotNotifier = new Object();
    private int logToSnapshotThresh = 200;
    private int logFileSize = 0;
    private final Thread snapshotter = new SnapshotThread();
    private final Runtime rt = Runtime.getRuntime();
    private PersistentStore store = null;
    private String logpath = null;
    static /* synthetic */ Class class$com$sun$wbem$repository$PSRlogImpl;

    public PSRlogImpl(String string, ReadersWriter readersWriter) throws CIMException {
        try {
            this.concurrentObj = readersWriter;
            this.eventHelper = new EventHelper(readersWriter);
            this.init();
        }
        catch (Exception exception) {
            if (verbose) {
                exception.printStackTrace();
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.toString());
        }
    }

    public PSRlogImpl(String string, ReadersWriter readersWriter, String string2) throws CIMException {
        try {
            this.concurrentObj = readersWriter;
            this.logpath = string2;
            this.init();
        }
        catch (Exception exception) {
            if (verbose) {
                exception.printStackTrace();
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createNameSpace(String string) throws CIMException {
        try {
            this.concurrentObj.writeLock();
            this.createNameSpaceDo(string);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
        this.concurrentObj.writeUnlock();
    }

    private void createNameSpaceDo(String string) throws CIMException {
        String string2 = string.replace('\\', '/');
        try {
            CIMNameSpaceRlogEntry cIMNameSpaceRlogEntry;
            CIMNameSpaceRlogEntry cIMNameSpaceRlogEntry2;
            if (string2 == null || string2.length() == 0 || string2.equals(CIMROOT)) {
                throw new CIMNameSpaceException("CIM_ERR_ALREADY_EXISTS", (Object)string);
            }
            String string3 = string2.substring(0, string2.lastIndexOf(CIMROOT));
            if (string3.length() == 0) {
                string3 = CIMROOT;
            }
            if ((cIMNameSpaceRlogEntry2 = (cIMNameSpaceRlogEntry = this.getNameSpaceEntryFromMap(string3)).getSubNameSpace(string2)) != null) {
                throw new CIMNameSpaceException("CIM_ERR_ALREADY_EXISTS", (Object)string);
            }
            cIMNameSpaceRlogEntry2 = new CIMNameSpaceRlogEntry(string2);
            cIMNameSpaceRlogEntry2.addClass(new CIMClassRlogEntry(cIMNameSpaceRlogEntry2, TOP, ""));
            cIMNameSpaceRlogEntry.addSubNameSpace(cIMNameSpaceRlogEntry2);
            this.putNameSpaceEntryToMap(cIMNameSpaceRlogEntry2);
            this.addLogRecord(new CreateNameSpaceLogObj(string));
        }
        catch (CIMException cIMException) {
            if (verbose) {
                cIMException.printStackTrace();
            }
            throw cIMException;
        }
        catch (Exception exception) {
            if (verbose) {
                exception.printStackTrace();
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCIMElement(String string, CIMQualifierType cIMQualifierType) throws CIMException {
        try {
            this.concurrentObj.writeLock();
            this.addCIMElementDO(string, cIMQualifierType);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
        this.concurrentObj.writeUnlock();
    }

    private void addCIMElementDO(String string, CIMQualifierType cIMQualifierType) throws CIMException {
        String string2 = cIMQualifierType.getName();
        CIMRlogEntry cIMRlogEntry = this.addCIMQualifierTypeDo(string, string2);
        this.createAddElementLogRecord(string, cIMRlogEntry, (CIMElement)cIMQualifierType);
    }

    private CIMRlogEntry addCIMQualifierTypeDo(String string, String string2) throws CIMException {
        try {
            CIMNameSpaceRlogEntry cIMNameSpaceRlogEntry = this.getNameSpaceEntryFromMap(string);
            CIMQualifierTypeRlogEntry cIMQualifierTypeRlogEntry = cIMNameSpaceRlogEntry.getQualifierType(string2);
            if (cIMQualifierTypeRlogEntry != null) {
                throw new CIMQualifierTypeException("CIM_ERR_ALREADY_EXISTS", (Object)string2);
            }
            cIMQualifierTypeRlogEntry = new CIMQualifierTypeRlogEntry(string, string2);
            cIMNameSpaceRlogEntry.addQualifierType(cIMQualifierTypeRlogEntry);
            return cIMQualifierTypeRlogEntry;
        }
        catch (CIMException cIMException) {
            if (verbose) {
                cIMException.printStackTrace();
            }
            throw cIMException;
        }
        catch (Exception exception) {
            if (verbose) {
                exception.printStackTrace();
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.toString());
        }
    }

    private void createAddElementLogRecord(String string, CIMRlogEntry cIMRlogEntry, CIMElement cIMElement) throws CIMException {
        this.createLogRecord(string, cIMRlogEntry, cIMElement, true);
    }

    private void createSetElementLogRecord(String string, CIMRlogEntry cIMRlogEntry, CIMElement cIMElement) throws CIMException {
        this.createLogRecord(string, cIMRlogEntry, cIMElement, false);
    }

    private void createLogRecord(String string, CIMRlogEntry cIMRlogEntry, CIMElement cIMElement, boolean bl) throws CIMException {
        String string2 = null;
        String string3 = cIMElement.getName();
        int n = 0;
        boolean bl2 = false;
        AddCIMQualifierLogObj addCIMQualifierLogObj = null;
        cIMRlogEntry.createPersistObject(PSRlogImpl.serialize(cIMElement));
        PersistentStore.PersistObject persistObject = cIMRlogEntry.getPersistObject();
        if (cIMElement instanceof CIMQualifierType) {
            n = 0;
            addCIMQualifierLogObj = bl ? new AddCIMQualifierLogObj(string, string3, persistObject) : new SetCIMQualifierLogObj(string, string3, persistObject);
        } else if (cIMElement instanceof CIMClass) {
            n = 1;
            bl2 = ((CIMClass)cIMElement).isAssociation();
            string2 = ((CIMClass)cIMElement).getSuperClass();
            addCIMQualifierLogObj = bl ? new AddCIMClassLogObj(string, string3, string2, bl2, persistObject) : new SetCIMClassLogObj(string, string3, string2, persistObject);
        } else if (cIMElement instanceof CIMInstance) {
            n = 2;
            string2 = ((CIMInstance)cIMElement).getClassName();
            if (bl) {
                bl2 = cIMRlogEntry instanceof CIMAssocInstanceRlogEntry;
                addCIMQualifierLogObj = new AddCIMInstanceLogObj(string, string3, string2, bl2, persistObject);
            } else {
                addCIMQualifierLogObj = new SetCIMInstanceLogObj(string, string3, string2, persistObject);
            }
        }
        this.addLogRecord(addCIMQualifierLogObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCIMElement(String string, CIMClass cIMClass) throws CIMException {
        try {
            this.concurrentObj.writeLock();
            this.addCIMElementDO(string, cIMClass);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
        this.concurrentObj.writeUnlock();
    }

    private void addCIMElementDO(String string, CIMClass cIMClass) throws CIMException {
        String string2 = cIMClass.getName();
        String string3 = cIMClass.getSuperClass();
        boolean bl = cIMClass.isAssociation();
        CIMRlogEntry cIMRlogEntry = this.addCIMClassDo(string, string2, string3, bl, cIMClass);
        this.createAddElementLogRecord(string, cIMRlogEntry, (CIMElement)cIMClass);
        this.eventHelper.classCreation(string, cIMClass);
    }

    private CIMRlogEntry addCIMClassDo(String string, String string2, String string3, boolean bl, CIMClass cIMClass) throws CIMException {
        Object var6_6 = null;
        if (string3.length() == 0) {
            string3 = TOP;
        }
        try {
            CIMNameSpaceRlogEntry cIMNameSpaceRlogEntry = this.getNameSpaceEntryFromMap(string);
            CIMClassRlogEntry cIMClassRlogEntry = cIMNameSpaceRlogEntry.getClass(string2);
            if (cIMClassRlogEntry != null) {
                throw new CIMClassException("CIM_ERR_ALREADY_EXISTS", (Object)string2);
            }
            CIMClassRlogEntry cIMClassRlogEntry2 = cIMNameSpaceRlogEntry.getClass(string3);
            if (cIMClassRlogEntry2 == null) {
                throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)string3);
            }
            if (bl) {
                cIMClassRlogEntry = new CIMAssocClassRlogEntry(cIMNameSpaceRlogEntry, string2, string3);
                ((CIMAssocClassRlogEntry)cIMClassRlogEntry).createAssciations(cIMClass);
            } else {
                cIMClassRlogEntry = new CIMClassRlogEntry(cIMNameSpaceRlogEntry, string2, string3);
            }
            cIMClassRlogEntry2.addSubClass(cIMClassRlogEntry);
            cIMNameSpaceRlogEntry.addClass(cIMClassRlogEntry);
            return cIMClassRlogEntry;
        }
        catch (CIMException cIMException) {
            if (verbose) {
                cIMException.printStackTrace();
            }
            throw cIMException;
        }
        catch (Exception exception) {
            if (verbose) {
                exception.printStackTrace();
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCIMElement(String string, CIMInstance cIMInstance) throws CIMException {
        try {
            this.concurrentObj.writeLock();
            this.addCIMElementDo(string, cIMInstance);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
        this.concurrentObj.writeUnlock();
    }

    private void addCIMElementDo(String string, CIMInstance cIMInstance) throws CIMException {
        String string2 = cIMInstance.getClassName();
        String string3 = cIMInstance.getName();
        CIMRlogEntry cIMRlogEntry = this.addCIMInstanceDo(string, string3, string2, cIMInstance);
        this.createAddElementLogRecord(string, cIMRlogEntry, (CIMElement)cIMInstance);
        this.eventHelper.instanceAddition(string.toLowerCase(), cIMInstance);
    }

    private CIMRlogEntry addCIMInstanceDo(String string, String string2, String string3, CIMInstance cIMInstance) throws CIMException {
        try {
            CIMNameSpaceRlogEntry cIMNameSpaceRlogEntry = this.getNameSpaceEntryFromMap(string);
            CIMClassRlogEntry cIMClassRlogEntry = cIMNameSpaceRlogEntry.getClass(string3);
            if (cIMClassRlogEntry == null) {
                throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)string3);
            }
            CIMInstanceRlogEntry cIMInstanceRlogEntry = cIMClassRlogEntry.getInstance(string2);
            if (cIMInstanceRlogEntry != null) {
                throw new CIMInstanceException("CIM_ERR_ALREADY_EXISTS", (Object)string2);
            }
            if (cIMClassRlogEntry instanceof CIMAssocClassRlogEntry) {
                cIMInstanceRlogEntry = new CIMAssocInstanceRlogEntry(cIMNameSpaceRlogEntry, string2);
                CIMAssocInstanceRlogEntry cIMAssocInstanceRlogEntry = (CIMAssocInstanceRlogEntry)cIMInstanceRlogEntry;
                cIMAssocInstanceRlogEntry.validateInstanceAssociations();
                cIMAssocInstanceRlogEntry.createAssciations(cIMInstance);
                cIMAssocInstanceRlogEntry.addInstanceAssociations(string3, cIMAssocInstanceRlogEntry);
            } else {
                cIMInstanceRlogEntry = new CIMInstanceRlogEntry(cIMNameSpaceRlogEntry, string2);
            }
            cIMClassRlogEntry.addInstance(cIMInstanceRlogEntry);
            return cIMInstanceRlogEntry;
        }
        catch (CIMException cIMException) {
            if (verbose) {
                cIMException.printStackTrace();
            }
            throw cIMException;
        }
        catch (Exception exception) {
            if (verbose) {
                exception.printStackTrace();
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQualifierType(String string, CIMQualifierType cIMQualifierType) throws CIMException {
        try {
            this.concurrentObj.writeLock();
            this.setQualifierTypeDo(string, cIMQualifierType);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
        this.concurrentObj.writeUnlock();
    }

    private void setQualifierTypeDo(String string, CIMQualifierType cIMQualifierType) throws CIMException {
        String string2 = cIMQualifierType.getName();
        CIMRlogEntry cIMRlogEntry = this.setQualifierTypeDo(string, string2);
        this.createSetElementLogRecord(string, cIMRlogEntry, (CIMElement)cIMQualifierType);
    }

    private CIMRlogEntry setQualifierTypeDo(String string, String string2) throws CIMException {
        try {
            CIMNameSpaceRlogEntry cIMNameSpaceRlogEntry = this.getNameSpaceEntryFromMap(string);
            CIMQualifierTypeRlogEntry cIMQualifierTypeRlogEntry = cIMNameSpaceRlogEntry.getQualifierType(string2);
            if (cIMQualifierTypeRlogEntry == null) {
                cIMQualifierTypeRlogEntry = new CIMQualifierTypeRlogEntry(string, string2);
                cIMNameSpaceRlogEntry.addQualifierType(cIMQualifierTypeRlogEntry);
            }
            return cIMQualifierTypeRlogEntry;
        }
        catch (CIMException cIMException) {
            if (verbose) {
                cIMException.printStackTrace();
            }
            throw cIMException;
        }
        catch (Exception exception) {
            if (verbose) {
                exception.printStackTrace();
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClass(String string, CIMClass cIMClass) throws CIMException {
        try {
            this.concurrentObj.writeLock();
            this.setClassDo(string, cIMClass);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
        this.concurrentObj.writeUnlock();
    }

    private void setClassDo(String string, CIMClass cIMClass) throws CIMException {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(cIMClass.getName(), string);
        CIMClass cIMClass2 = this.getClassDo(cIMObjectPath.getNameSpace(), cIMObjectPath.getObjectName());
        String string2 = cIMClass.getName();
        String string3 = cIMClass.getSuperClass();
        CIMRlogEntry cIMRlogEntry = this.setClassDo(string, string2, string3);
        this.createSetElementLogRecord(string, cIMRlogEntry, (CIMElement)cIMClass);
        this.eventHelper.classModification(string, cIMClass2, cIMClass);
    }

    private CIMRlogEntry setClassDo(String string, String string2, String string3) throws CIMException {
        if (string3.length() == 0) {
            string3 = TOP;
        }
        try {
            CIMNameSpaceRlogEntry cIMNameSpaceRlogEntry = this.getNameSpaceEntryFromMap(string);
            CIMClassRlogEntry cIMClassRlogEntry = cIMNameSpaceRlogEntry.getClass(string2);
            if (cIMClassRlogEntry == null) {
                cIMClassRlogEntry = new CIMClassRlogEntry(cIMNameSpaceRlogEntry, string2, string3);
                cIMNameSpaceRlogEntry.addClass(cIMClassRlogEntry);
            }
            return cIMClassRlogEntry;
        }
        catch (CIMException cIMException) {
            System.out.print("my exception:" + (Object)((Object)cIMException));
            cIMException.printStackTrace();
            if (verbose) {
                cIMException.printStackTrace();
            }
            throw cIMException;
        }
        catch (Exception exception) {
            if (!verbose) {
                // empty if block
            }
            exception.printStackTrace();
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInstance(String string, CIMInstance cIMInstance) throws CIMException {
        try {
            this.concurrentObj.writeLock();
            this.setInstanceDo(string, cIMInstance);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
        this.concurrentObj.writeUnlock();
    }

    private void setInstanceDo(String string, CIMInstance cIMInstance) throws CIMException {
        String string2 = cIMInstance.getClassName();
        String string3 = cIMInstance.getName();
        CIMRlogEntry cIMRlogEntry = this.setInstanceDo(string, string3, string2);
        CIMInstance cIMInstance2 = (CIMInstance)PSRlogImpl.deserialize(cIMRlogEntry.getValue());
        this.createSetElementLogRecord(string, cIMRlogEntry, (CIMElement)cIMInstance);
        this.eventHelper.instanceModification(string.toLowerCase(), cIMInstance2, cIMInstance);
    }

    private CIMRlogEntry setInstanceDo(String string, String string2, String string3) throws CIMException {
        String string4 = string.replace('\\', '/');
        try {
            CIMNameSpaceRlogEntry cIMNameSpaceRlogEntry = this.getNameSpaceEntryFromMap(string);
            CIMClassRlogEntry cIMClassRlogEntry = cIMNameSpaceRlogEntry.getClass(string3);
            if (cIMClassRlogEntry == null) {
                throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)string3);
            }
            CIMInstanceRlogEntry cIMInstanceRlogEntry = cIMClassRlogEntry.getInstance(string2);
            if (cIMInstanceRlogEntry == null) {
                cIMInstanceRlogEntry = new CIMInstanceRlogEntry(cIMNameSpaceRlogEntry, string2);
                cIMClassRlogEntry.addInstance(cIMInstanceRlogEntry);
            }
            return cIMInstanceRlogEntry;
        }
        catch (CIMException cIMException) {
            if (verbose) {
                cIMException.printStackTrace();
            }
            throw cIMException;
        }
        catch (Exception exception) {
            if (verbose) {
                exception.printStackTrace();
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.toString());
        }
    }

    public CIMQualifierType getQualifierType(CIMObjectPath cIMObjectPath) throws CIMException {
        return this.getQualifierType(cIMObjectPath.getNameSpace(), cIMObjectPath.getObjectName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMQualifierType getQualifierType(String string, String string2) throws CIMException {
        CIMQualifierType cIMQualifierType;
        try {
            this.concurrentObj.readLock();
            cIMQualifierType = this.getQualifierTypeDo(string, string2);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
        this.concurrentObj.readUnlock();
        return cIMQualifierType;
    }

    private CIMQualifierType getQualifierTypeDo(String string, String string2) throws CIMException {
        CIMQualifierType cIMQualifierType = null;
        CIMQualifierTypeRlogEntry cIMQualifierTypeRlogEntry = null;
        try {
            CIMNameSpaceRlogEntry cIMNameSpaceRlogEntry = this.getNameSpaceEntryFromMap(string);
            cIMQualifierTypeRlogEntry = cIMNameSpaceRlogEntry.getQualifierType(string2);
            if (cIMQualifierTypeRlogEntry != null) {
                cIMQualifierType = (CIMQualifierType)PSRlogImpl.deserialize(cIMQualifierTypeRlogEntry.getValue());
            }
        }
        catch (CIMException cIMException) {
            if (verbose) {
                cIMException.printStackTrace();
            }
            throw cIMException;
        }
        catch (Exception exception) {
            if (verbose) {
                exception.printStackTrace();
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.toString());
        }
        return cIMQualifierType;
    }

    public CIMClass getClass(CIMObjectPath cIMObjectPath) throws CIMException {
        return this.getClass(cIMObjectPath.getNameSpace(), cIMObjectPath.getObjectName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMClass getClass(String string, String string2) throws CIMException {
        CIMClass cIMClass;
        try {
            this.concurrentObj.readLock();
            cIMClass = this.getClassDo(string, string2);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
        this.concurrentObj.readUnlock();
        return cIMClass;
    }

    private CIMClass getClassDo(String string, String string2) throws CIMException {
        CIMClass cIMClass = null;
        CIMClassRlogEntry cIMClassRlogEntry = null;
        try {
            CIMNameSpaceRlogEntry cIMNameSpaceRlogEntry = this.getNameSpaceEntryFromMap(string);
            cIMClassRlogEntry = cIMNameSpaceRlogEntry.getClass(string2);
            if (cIMClassRlogEntry != null) {
                cIMClass = (CIMClass)PSRlogImpl.deserialize(cIMClassRlogEntry.getValue());
            }
        }
        catch (CIMException cIMException) {
            return null;
        }
        catch (Exception exception) {
            if (verbose) {
                exception.printStackTrace();
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.toString());
        }
        return cIMClass;
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        String string = cIMObjectPath.getNameSpace();
        String string2 = cIMObjectPath.getObjectName();
        CIMClass cIMClass = this.getClass(string, string2);
        CIMInstance cIMInstance = cIMClass.newInstance();
        cIMInstance.updatePropertyValues(cIMObjectPath.getKeys());
        CIMInstance cIMInstance2 = this.getInstance(string, cIMInstance.getName());
        this.eventHelper.instanceRead(string.toLowerCase(), cIMInstance2);
        return cIMInstance2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMInstance getInstance(String string, String string2) throws CIMException {
        CIMInstance cIMInstance;
        try {
            this.concurrentObj.readLock();
            cIMInstance = this.getInstanceDo(string, string2);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
        this.concurrentObj.readUnlock();
        return cIMInstance;
    }

    private CIMInstance getInstanceDo(String string, String string2) throws CIMException {
        String string3 = string2.substring(0, string2.indexOf(58));
        CIMInstance cIMInstance = null;
        CIMInstanceRlogEntry cIMInstanceRlogEntry = null;
        try {
            CIMNameSpaceRlogEntry cIMNameSpaceRlogEntry = this.getNameSpaceEntryFromMap(string);
            CIMClassRlogEntry cIMClassRlogEntry = cIMNameSpaceRlogEntry.getClass(string3);
            if (cIMClassRlogEntry == null) {
                throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)string3);
            }
            cIMInstanceRlogEntry = cIMClassRlogEntry.getInstance(string2);
            if (cIMInstanceRlogEntry != null) {
                cIMInstance = (CIMInstance)PSRlogImpl.deserialize(cIMInstanceRlogEntry.getValue());
            }
        }
        catch (CIMException cIMException) {
            if (verbose) {
                cIMException.printStackTrace();
            }
            throw cIMException;
        }
        catch (Exception exception) {
            if (verbose) {
                exception.printStackTrace();
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.toString());
        }
        return cIMInstance;
    }

    public void deleteQualifier(CIMObjectPath cIMObjectPath) throws CIMException {
        this.deleteQualifier(cIMObjectPath.getNameSpace(), cIMObjectPath.getObjectName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteQualifier(String string, String string2) throws CIMException {
        try {
            this.concurrentObj.writeLock();
            this.deleteQualifierDo(string, string2);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
        this.concurrentObj.writeUnlock();
    }

    private void deleteQualifierDo(String string, String string2) throws CIMException {
        try {
            CIMNameSpaceRlogEntry cIMNameSpaceRlogEntry = this.getNameSpaceEntryFromMap(string);
            CIMQualifierTypeRlogEntry cIMQualifierTypeRlogEntry = cIMNameSpaceRlogEntry.removeQualifierType(string2);
            this.addLogRecord(new DeleteQualifierLogObj(string, string2));
        }
        catch (CIMException cIMException) {
            if (verbose) {
                cIMException.printStackTrace();
            }
            throw cIMException;
        }
        catch (Exception exception) {
            if (verbose) {
                exception.printStackTrace();
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNameSpace(String string) throws CIMException {
        try {
            this.concurrentObj.writeLock();
            this.deleteNameSpaceDo(string);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
        this.concurrentObj.writeUnlock();
    }

    private void deleteNameSpaceDo(String string) throws CIMException {
        String string2;
        String string3;
        if (string == null || string.length() == 0) {
            string = CIMROOT;
        }
        if ((string3 = (string2 = string.replace('\\', '/')).substring(0, string2.lastIndexOf(CIMROOT))).length() == 0) {
            string3 = CIMROOT;
        }
        try {
            CIMNameSpaceRlogEntry cIMNameSpaceRlogEntry;
            CIMNameSpaceRlogEntry cIMNameSpaceRlogEntry2 = this.getNameSpaceEntryFromMap(string2);
            ArrayList arrayList = new ArrayList(cIMNameSpaceRlogEntry2.getSubNameSpaceCollection());
            int n = 0;
            while (n < arrayList.size()) {
                cIMNameSpaceRlogEntry = (CIMNameSpaceRlogEntry)arrayList.get(n);
                ArrayList arrayList2 = new ArrayList(cIMNameSpaceRlogEntry.getSubNameSpaceCollection());
                int n2 = 0;
                while (n2 < arrayList2.size()) {
                    arrayList.add(arrayList2.get(n2));
                    ++n2;
                }
                cIMNameSpaceRlogEntry.delete();
                this.nameSpacesMap.remove(cIMNameSpaceRlogEntry.getName());
                ++n;
            }
            if (string2.equals(CIMROOT)) {
                this.nameSpacesMap = new HashMap();
                cIMNameSpaceRlogEntry2 = new CIMNameSpaceRlogEntry(CIMROOT);
                cIMNameSpaceRlogEntry2.addClass(new CIMClassRlogEntry(cIMNameSpaceRlogEntry2, TOP, ""));
                this.putNameSpaceEntryToMap(cIMNameSpaceRlogEntry2);
            } else {
                cIMNameSpaceRlogEntry2 = this.getNameSpaceEntryFromMap(string3);
                cIMNameSpaceRlogEntry = cIMNameSpaceRlogEntry2.removeSubNameSpace(string2);
                if (cIMNameSpaceRlogEntry != null) {
                    this.nameSpacesMap.remove(string2);
                } else {
                    throw new CIMNameSpaceException("CIM_ERR_NOT_FOUND", (Object)string);
                }
            }
            this.addLogRecord(new DeleteNameSpaceLogObj(string));
        }
        catch (CIMException cIMException) {
            if (verbose) {
                cIMException.printStackTrace();
            }
            throw cIMException;
        }
        catch (Exception exception) {
            if (verbose) {
                exception.printStackTrace();
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.toString());
        }
    }

    public void deleteClass(CIMObjectPath cIMObjectPath) throws CIMException {
        CIMClass cIMClass = this.getClass(cIMObjectPath);
        String string = cIMObjectPath.getNameSpace();
        this.deleteClass(string, cIMObjectPath.getObjectName());
        this.eventHelper.classDeletion(string, cIMClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteClass(String string, String string2) throws CIMException {
        try {
            this.concurrentObj.writeLock();
            this.deleteClassDo(string, string2);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
        this.concurrentObj.writeUnlock();
    }

    private void deleteClassDo(String string, String string2) throws CIMException {
        try {
            CIMNameSpaceRlogEntry cIMNameSpaceRlogEntry = this.getNameSpaceEntryFromMap(string);
            CIMClassRlogEntry cIMClassRlogEntry = cIMNameSpaceRlogEntry.getClass(string2);
            if (cIMClassRlogEntry == null) {
                throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)string2);
            }
            if (cIMClassRlogEntry.hasClassAssociation()) {
                throw new CIMException("CIM_ERR_FAILED", (Object)string2);
            }
            String string3 = cIMClassRlogEntry.getSuperClassName();
            CIMClassRlogEntry cIMClassRlogEntry2 = cIMNameSpaceRlogEntry.getClass(string3.length() == 0 ? TOP : string3);
            if (cIMClassRlogEntry2 == null) {
                throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)string3);
            }
            this.validateAssociationClass(cIMClassRlogEntry);
            cIMClassRlogEntry2.removeSubClass(string2);
            cIMNameSpaceRlogEntry.removeClass(string2);
            if (cIMClassRlogEntry instanceof CIMAssocClassRlogEntry) {
                ((CIMAssocClassRlogEntry)cIMClassRlogEntry).removeClassAssociations();
            }
            ArrayList arrayList = new ArrayList(cIMClassRlogEntry.getSubClassCollection());
            int n = 0;
            while (n < arrayList.size()) {
                cIMClassRlogEntry = (CIMClassRlogEntry)arrayList.get(n);
                ArrayList arrayList2 = new ArrayList(cIMClassRlogEntry.getSubClassCollection());
                int n2 = 0;
                while (n2 < arrayList2.size()) {
                    arrayList.add(arrayList2.get(n2));
                    ++n2;
                }
                cIMNameSpaceRlogEntry.removeClass(cIMClassRlogEntry.getNameKey());
                if (cIMClassRlogEntry instanceof CIMAssocClassRlogEntry) {
                    ((CIMAssocClassRlogEntry)cIMClassRlogEntry).removeClassAssociations();
                }
                ++n;
            }
            this.addLogRecord(new DeleteClassLogObj(string, string2));
        }
        catch (CIMException cIMException) {
            if (verbose) {
                cIMException.printStackTrace();
            }
            throw cIMException;
        }
        catch (Exception exception) {
            if (verbose) {
                exception.printStackTrace();
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.toString());
        }
    }

    void validateAssociationClass(CIMClassRlogEntry cIMClassRlogEntry) throws CIMException {
        if (cIMClassRlogEntry instanceof CIMAssocClassRlogEntry) {
            ((CIMAssocClassRlogEntry)cIMClassRlogEntry).validateClassAsociations();
        }
        ArrayList arrayList = new ArrayList(cIMClassRlogEntry.getSubClassCollection());
        int n = 0;
        while (n < arrayList.size()) {
            CIMClassRlogEntry cIMClassRlogEntry2 = (CIMClassRlogEntry)arrayList.get(n);
            ArrayList arrayList2 = new ArrayList(cIMClassRlogEntry2.getSubClassCollection());
            int n2 = 0;
            while (n2 < arrayList2.size()) {
                arrayList.add(arrayList2.get(n2));
                ++n2;
            }
            if (cIMClassRlogEntry2 instanceof CIMAssocClassRlogEntry) {
                ((CIMAssocClassRlogEntry)cIMClassRlogEntry2).validateClassAsociations();
            }
            ++n;
        }
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        String string = cIMObjectPath.getNameSpace();
        String string2 = cIMObjectPath.getObjectName();
        CIMClass cIMClass = this.getClass(string, string2);
        CIMInstance cIMInstance = cIMClass.newInstance();
        cIMInstance.updatePropertyValues(cIMObjectPath.getKeys());
        CIMInstance cIMInstance2 = this.getInstance(string, cIMInstance.getName());
        if (cIMInstance2 == null) {
            throw new CIMInstanceException("CIM_ERR_NOT_FOUND", (Object)cIMInstance.getName());
        }
        this.deleteInstance(string, cIMInstance2.getName());
        this.eventHelper.instanceDeletion(string.toLowerCase(), cIMInstance2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteInstance(String string, String string2) throws CIMException {
        try {
            this.concurrentObj.writeLock();
            this.deleteInstanceDo(string, string2);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
        this.concurrentObj.writeUnlock();
    }

    private void deleteInstanceDo(String string, String string2) throws CIMException {
        String string3 = string2.substring(0, string2.indexOf(58));
        try {
            CIMNameSpaceRlogEntry cIMNameSpaceRlogEntry = this.getNameSpaceEntryFromMap(string);
            CIMClassRlogEntry cIMClassRlogEntry = cIMNameSpaceRlogEntry.getClass(string3);
            if (cIMClassRlogEntry == null) {
                throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)string3);
            }
            CIMInstanceRlogEntry cIMInstanceRlogEntry = cIMClassRlogEntry.getInstance(string2);
            if (cIMInstanceRlogEntry.hasAssociation()) {
                throw new CIMException("CIM_ERR_FAILED", (Object)string2);
            }
            if (cIMInstanceRlogEntry instanceof CIMAssocInstanceRlogEntry) {
                ((CIMAssocInstanceRlogEntry)cIMInstanceRlogEntry).removeInstanceAssociations(string3, string2);
            }
            cIMClassRlogEntry.removeInstance(string2);
            this.addLogRecord(new DeleteInstanceLogObj(string, string2));
        }
        catch (CIMException cIMException) {
            if (verbose) {
                cIMException.printStackTrace();
            }
            throw cIMException;
        }
        catch (Exception exception) {
            if (verbose) {
                exception.printStackTrace();
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector enumerateNameSpace(String string, boolean bl) throws CIMException {
        Vector vector;
        try {
            this.concurrentObj.readLock();
            Vector vector2 = new Vector();
            this.enumNameSpaceDo(string, bl, vector2);
            vector = vector2;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
        this.concurrentObj.readUnlock();
        return vector;
    }

    private void enumNameSpaceDo(String string, boolean bl, Vector vector) throws CIMException {
        if (string == null || string.length() == 0) {
            string = CIMROOT;
        }
        vector.addElement(string);
        try {
            CIMNameSpaceRlogEntry cIMNameSpaceRlogEntry = this.getNameSpaceEntryFromMap(string);
            ArrayList arrayList = new ArrayList(cIMNameSpaceRlogEntry.getSubNameSpaceCollection());
            int n = 0;
            while (n < arrayList.size()) {
                CIMNameSpaceRlogEntry cIMNameSpaceRlogEntry2 = (CIMNameSpaceRlogEntry)arrayList.get(n);
                ArrayList arrayList2 = new ArrayList(cIMNameSpaceRlogEntry2.getSubNameSpaceCollection());
                if (bl) {
                    int n2 = 0;
                    while (n2 < arrayList2.size()) {
                        arrayList.add(arrayList2.get(n2));
                        ++n2;
                    }
                }
                vector.add(cIMNameSpaceRlogEntry2.getName());
                ++n;
            }
            vector.remove(0);
        }
        catch (CIMException cIMException) {
            if (verbose) {
                cIMException.printStackTrace();
            }
            throw cIMException;
        }
        catch (Exception exception) {
            if (verbose) {
                exception.printStackTrace();
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.toString());
        }
    }

    public Vector enumerateQualifierTypes(CIMObjectPath cIMObjectPath) throws CIMException {
        return this.enumerateQualifierTypes(cIMObjectPath.getNameSpace());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector enumerateQualifierTypes(String string) throws CIMException {
        Vector vector;
        try {
            this.concurrentObj.readLock();
            vector = this.enumerateQualifierTypesDo(string);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
        this.concurrentObj.readUnlock();
        return vector;
    }

    private Vector enumerateQualifierTypesDo(String string) throws CIMException {
        Vector<CIMQualifierType> vector = new Vector<CIMQualifierType>();
        try {
            CIMNameSpaceRlogEntry cIMNameSpaceRlogEntry = this.getNameSpaceEntryFromMap(string);
            ArrayList arrayList = new ArrayList(cIMNameSpaceRlogEntry.getQualifierCollection());
            CIMQualifierType cIMQualifierType = null;
            int n = 0;
            while (n < arrayList.size()) {
                CIMQualifierTypeRlogEntry cIMQualifierTypeRlogEntry = (CIMQualifierTypeRlogEntry)arrayList.get(n);
                if (cIMQualifierTypeRlogEntry != null) {
                    cIMQualifierType = (CIMQualifierType)PSRlogImpl.deserialize(cIMQualifierTypeRlogEntry.getValue());
                }
                vector.addElement(cIMQualifierType);
                ++n;
            }
        }
        catch (CIMException cIMException) {
            if (verbose) {
                cIMException.printStackTrace();
            }
            throw cIMException;
        }
        catch (Exception exception) {
            if (verbose) {
                exception.printStackTrace();
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.toString());
        }
        return vector;
    }

    public Vector enumerateClasses(CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        return this.enumerateClasses(cIMObjectPath.getNameSpace(), cIMObjectPath.getObjectName(), bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector enumerateClasses(String string, String string2, boolean bl) throws CIMException {
        Vector vector;
        try {
            this.concurrentObj.readLock();
            vector = this.enumClassesDo(string, string2, bl, true, false);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
        this.concurrentObj.readUnlock();
        return vector;
    }

    public Vector enumerateClasses(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2) throws CIMException {
        return this.enumerateClasses(cIMObjectPath.getNameSpace(), cIMObjectPath.getObjectName(), bl, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector enumerateClasses(String string, String string2, boolean bl, boolean bl2) throws CIMException {
        Vector vector;
        try {
            this.concurrentObj.readLock();
            vector = this.enumClassesDo(string, string2, bl, false, bl2);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
        this.concurrentObj.readUnlock();
        return vector;
    }

    private Vector enumClassesDo(String string, String string2, boolean bl, boolean bl2, boolean bl3) throws CIMException {
        Vector<Object> vector = new Vector<Object>();
        if (string2 == null || string2.length() == 0 || string2.equalsIgnoreCase(TOP)) {
            string2 = TOP;
        }
        try {
            CIMNameSpaceRlogEntry cIMNameSpaceRlogEntry = this.getNameSpaceEntryFromMap(string);
            CIMClassRlogEntry cIMClassRlogEntry = cIMNameSpaceRlogEntry.getClass(string2);
            if (cIMClassRlogEntry == null) {
                throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)string2);
            }
            ArrayList arrayList = new ArrayList(cIMClassRlogEntry.getSubClassCollection());
            int n = 0;
            while (n < arrayList.size()) {
                CIMClass cIMClass;
                cIMClassRlogEntry = (CIMClassRlogEntry)arrayList.get(n);
                if (bl) {
                    cIMClass = new ArrayList(cIMClassRlogEntry.getSubClassCollection());
                    int n2 = 0;
                    while (n2 < cIMClass.size()) {
                        arrayList.add(cIMClass.get(n2));
                        ++n2;
                    }
                }
                if (bl2) {
                    vector.addElement(new CIMObjectPath(cIMClassRlogEntry.getName(), string));
                } else {
                    cIMClass = (CIMClass)PSRlogImpl.deserialize(cIMClassRlogEntry.getValue());
                    vector.addElement(bl3 ? cIMClass.localElements() : cIMClass);
                }
                ++n;
            }
        }
        catch (CIMException cIMException) {
            if (verbose) {
                cIMException.printStackTrace();
            }
            throw cIMException;
        }
        catch (Exception exception) {
            if (verbose) {
                exception.printStackTrace();
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.toString());
        }
        return vector;
    }

    public Vector enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        return this.enumerateInstances(cIMObjectPath.getNameSpace(), cIMObjectPath.getObjectName(), bl);
    }

    public Vector enumerateInstances(String string, String string2, boolean bl) throws CIMException {
        return this.enumInstances(string, string2, bl, true, false);
    }

    public Vector enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2) throws CIMException {
        Vector vector = this.enumerateInstances(cIMObjectPath.getNameSpace(), cIMObjectPath.getObjectName(), bl, bl2);
        this.eventHelper.instanceEnumerate(cIMObjectPath, vector);
        return vector;
    }

    public Vector enumerateInstances(String string, String string2, boolean bl, boolean bl2) throws CIMException {
        return this.enumInstances(string, string2, bl, false, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector enumInstances(String string, String string2, boolean bl, boolean bl2, boolean bl3) throws CIMException {
        Vector vector;
        try {
            this.concurrentObj.readLock();
            vector = this.enumInstancesDo(string, string2, bl, bl2, bl3);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
        this.concurrentObj.readUnlock();
        return vector;
    }

    private Vector enumInstancesDo(String string, String string2, boolean bl, boolean bl2, boolean bl3) throws CIMException {
        Vector vector = new Vector();
        if (string2 == null || string2.equalsIgnoreCase(TOP)) {
            string2 = TOP;
        }
        try {
            CIMNameSpaceRlogEntry cIMNameSpaceRlogEntry = this.getNameSpaceEntryFromMap(string);
            CIMClassRlogEntry cIMClassRlogEntry = cIMNameSpaceRlogEntry.getClass(string2);
            if (cIMClassRlogEntry == null) {
                throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)string2);
            }
            this.getInstanceList(string, cIMClassRlogEntry, bl2, vector);
            if (bl) {
                ArrayList arrayList = new ArrayList(cIMClassRlogEntry.getSubClassCollection());
                int n = 0;
                while (n < arrayList.size()) {
                    cIMClassRlogEntry = (CIMClassRlogEntry)arrayList.get(n);
                    ArrayList arrayList2 = new ArrayList(cIMClassRlogEntry.getSubClassCollection());
                    int n2 = 0;
                    while (n2 < arrayList2.size()) {
                        arrayList.add(arrayList2.get(n2));
                        ++n2;
                    }
                    this.getInstanceList(string, (CIMClassRlogEntry)arrayList.get(n), bl2, vector);
                    ++n;
                }
            }
        }
        catch (CIMException cIMException) {
            if (verbose) {
                cIMException.printStackTrace();
            }
            throw cIMException;
        }
        catch (Exception exception) {
            if (verbose) {
                exception.printStackTrace();
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.toString());
        }
        return vector;
    }

    private void getInstanceList(String string, CIMClassRlogEntry cIMClassRlogEntry, boolean bl, Vector vector) throws CIMException {
        try {
            Iterator iterator = cIMClassRlogEntry.getInstanceCollection().iterator();
            while (iterator.hasNext()) {
                CIMInstanceRlogEntry cIMInstanceRlogEntry = (CIMInstanceRlogEntry)iterator.next();
                CIMInstance cIMInstance = (CIMInstance)PSRlogImpl.deserialize(cIMInstanceRlogEntry.getValue());
                if (bl) {
                    CIMObjectPath cIMObjectPath = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
                    cIMObjectPath.setNameSpace(string);
                    vector.addElement(cIMObjectPath);
                    continue;
                }
                vector.addElement(cIMInstance);
            }
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.toString());
        }
    }

    private CIMNameSpaceRlogEntry getNameSpaceEntryFromMap(String string) throws CIMException {
        String string2 = string.replace('\\', '/');
        CIMNameSpaceRlogEntry cIMNameSpaceRlogEntry = (CIMNameSpaceRlogEntry)this.nameSpacesMap.get(string2);
        if (cIMNameSpaceRlogEntry == null) {
            throw new CIMNameSpaceException("CIM_ERR_INVALID_NAMESPACE", (Object)string);
        }
        return cIMNameSpaceRlogEntry;
    }

    private void putNameSpaceEntryToMap(CIMNameSpaceRlogEntry cIMNameSpaceRlogEntry) {
        this.nameSpacesMap.put(cIMNameSpaceRlogEntry.getName(), cIMNameSpaceRlogEntry);
    }

    public Vector execQuery(CIMObjectPath cIMObjectPath, String string, String string2, CIMClass cIMClass) throws CIMException {
        String string3 = cIMObjectPath.getNameSpace();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        WQLParser wQLParser = new WQLParser((InputStream)byteArrayInputStream);
        Vector<CIMElement> vector = new Vector<CIMElement>();
        try {
            SelectExp selectExp = (SelectExp)wQLParser.querySpecification();
            SelectList selectList = selectExp.getSelectList();
            NonJoinExp nonJoinExp = (NonJoinExp)selectExp.getFromClause();
            QueryExp queryExp = selectExp.getWhereClause();
            Vector vector2 = this.enumerateInstances(string3, cIMClass.getName().toLowerCase(), false, false);
            int n = 0;
            while (n < vector2.size()) {
                if (queryExp == null || queryExp.apply((CIMElement)((CIMInstance)vector2.elementAt(n)))) {
                    vector.addElement(selectList.apply((CIMElement)((CIMInstance)vector2.elementAt(n))));
                }
                ++n;
            }
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.toString());
        }
        return vector;
    }

    private void init() throws IOException {
        String string = System.getProperty("propdir", "/usr/sadm/lib/wbem");
        if (this.logpath == null) {
            this.logpath = System.getProperty("logdir", System.getProperty("logparent", "/var/sadm/wbem") + File.separator + "logr");
        }
        this.log = new ReliableLog(this.logpath, new LocalLogHandler());
        this.store = new PersistentStore(this.logpath + "/store");
        CIMRlogEntry.setPersistentStore(this.store);
        this.inRecovery = true;
        this.log.recover();
        this.inRecovery = false;
        if (this.nameSpacesMap == null) {
            this.nameSpacesMap = new HashMap();
            CIMNameSpaceRlogEntry cIMNameSpaceRlogEntry = new CIMNameSpaceRlogEntry(CIMROOT);
            cIMNameSpaceRlogEntry.addClass(new CIMClassRlogEntry(cIMNameSpaceRlogEntry, TOP, ""));
            this.putNameSpaceEntryToMap(cIMNameSpaceRlogEntry);
        }
        this.log.snapshot();
        this.snapshotter.start();
    }

    private void takeSnapshot(OutputStream outputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeUTF((class$com$sun$wbem$repository$PSRlogImpl == null ? (class$com$sun$wbem$repository$PSRlogImpl = PSRlogImpl.class$("com.sun.wbem.repository.PSRlogImpl")) : class$com$sun$wbem$repository$PSRlogImpl).getName());
        objectOutputStream.writeInt(1);
        objectOutputStream.writeObject(this.nameSpacesMap);
        this.store.addToSnapshot(objectOutputStream);
        objectOutputStream.writeObject(null);
        objectOutputStream.flush();
    }

    private void recoverSnapshot(InputStream inputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        if (!(class$com$sun$wbem$repository$PSRlogImpl == null ? (class$com$sun$wbem$repository$PSRlogImpl = PSRlogImpl.class$("com.sun.wbem.repository.PSRlogImpl")) : class$com$sun$wbem$repository$PSRlogImpl).getName().equals(objectInputStream.readUTF())) {
            throw new IOException("log from wrong implementation");
        }
        if (objectInputStream.readInt() != 1) {
            throw new IOException("wrong log format version");
        }
        this.nameSpacesMap = (HashMap)objectInputStream.readObject();
        this.store.recoverFromSnapshot(objectInputStream);
    }

    private void addLogRecord(LogRecord logRecord) {
        try {
            if (!this.inRecovery) {
                this.log.update(logRecord, true);
                if (++this.logFileSize >= this.logToSnapshotThresh) {
                    this.concurrentObj.waiterNotify(this.snapshotNotifier);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Vector associatorClassNames(CIMObjectPath cIMObjectPath, String string, String string2, String string3, String string4) throws CIMException {
        return this.classAssociators(cIMObjectPath, string, string2, string3, string4, false, false, null, true, true);
    }

    public Vector associatorsClass(CIMObjectPath cIMObjectPath, String string, String string2, String string3, String string4, boolean bl, boolean bl2, String[] stringArray) throws CIMException {
        return this.classAssociators(cIMObjectPath, string, string2, string3, string4, bl, bl2, stringArray, false, true);
    }

    public Vector reference(CIMObjectPath cIMObjectPath, String string, String string2, boolean bl, boolean bl2, String[] stringArray) throws CIMException {
        return this.classAssociators(cIMObjectPath, string, null, string2, null, bl, bl2, stringArray, false, false);
    }

    public Vector referenceNames(CIMObjectPath cIMObjectPath, String string, String string2) throws CIMException {
        return this.classAssociators(cIMObjectPath, string, null, string2, null, false, false, null, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector classAssociators(CIMObjectPath cIMObjectPath, String string, String string2, String string3, String string4, boolean bl, boolean bl2, String[] stringArray, boolean bl3, boolean bl4) throws CIMException {
        Vector vector;
        try {
            this.concurrentObj.readLock();
            vector = this.classAssociatorsDo(cIMObjectPath, string, string2, string3, string4, bl, bl2, stringArray, bl3, bl4);
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
        this.concurrentObj.readUnlock();
        return vector;
    }

    private Vector classAssociatorsDo(CIMObjectPath cIMObjectPath, String string, String string2, String string3, String string4, boolean bl, boolean bl2, String[] stringArray, boolean bl3, boolean bl4) throws CIMException {
        Vector vector = new Vector();
        if (string3 != null && string3.length() != 0 && string4 != null && string4.length() != 0 && string3.equalsIgnoreCase(string4)) {
            return vector;
        }
        String string5 = cIMObjectPath.getNameSpace();
        String string6 = cIMObjectPath.getObjectName();
        string5 = string5.replace('\\', '/');
        CIMNameSpaceRlogEntry cIMNameSpaceRlogEntry = this.getNameSpaceEntryFromMap(string5);
        this.ccAssociators(cIMNameSpaceRlogEntry, string6, string, string2, string3, string4, bl, bl2, stringArray, vector, bl3, bl4);
        return vector;
    }

    private void ccAssociators(CIMNameSpaceRlogEntry cIMNameSpaceRlogEntry, String string, String string2, String string3, String string4, String string5, boolean bl, boolean bl2, String[] stringArray, Vector vector, boolean bl3, boolean bl4) throws CIMException {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        try {
            Object object;
            CIMClassRlogEntry cIMClassRlogEntry = cIMNameSpaceRlogEntry.getClass(string);
            if (cIMClassRlogEntry == null) {
                throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)string);
            }
            if (string2 != null && string2.length() != 0) {
                arrayList = this.deepEnum(cIMNameSpaceRlogEntry, string2);
            }
            if (string3 != null && string3.length() != 0) {
                arrayList2 = this.deepEnum(cIMNameSpaceRlogEntry, string3);
                object = cIMNameSpaceRlogEntry.getClass(string3).getSuperClassName();
                while (((String)object).length() != 0 && !((String)object).equals(TOP)) {
                    arrayList2.add(object);
                    object = cIMNameSpaceRlogEntry.getClass((String)object).getSuperClassName();
                }
            }
            object = cIMClassRlogEntry.getAssocications();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            int n = 0;
            while (object != null && n < ((CIMAssocClassRlogEntry[])object).length) {
                if (hashMap.get(((CIMRlogEntry)object[n]).getName()) == null) {
                    boolean bl5 = true;
                    if (string2 != null && string2.length() != 0) {
                        bl5 = this.matchClassList(((CIMRlogEntry)object[n]).getName(), arrayList);
                    }
                    ArrayList arrayList3 = null;
                    if (bl5) {
                        arrayList3 = ((CIMAssocClassRlogEntry)object[n]).matchRole(string, string4, string5);
                    }
                    if (arrayList3 != null && !arrayList3.isEmpty()) {
                        boolean bl6 = false;
                        boolean bl7 = false;
                        int n2 = 0;
                        while (n2 < arrayList3.size()) {
                            if (this.matchClassList((String)arrayList3.get(n2), arrayList2)) {
                                bl7 = true;
                                if (!bl6) {
                                    bl6 = true;
                                    this.addToResultList(cIMNameSpaceRlogEntry, ((CIMRlogEntry)object[n]).getName(), true, true, null, vector, false);
                                    hashMap.put(((CIMRlogEntry)object[n]).getName(), "");
                                }
                                if (bl4) {
                                    this.addToResultList(cIMNameSpaceRlogEntry, (String)arrayList3.get(n2), bl, bl2, stringArray, vector, bl3);
                                }
                            }
                            ++n2;
                        }
                        if (bl7) {
                            vector.addElement(null);
                        }
                    }
                }
                ++n;
            }
            String string6 = cIMClassRlogEntry.getSuperClassName();
            if (string6 == null || string6.length() == 0) {
                return;
            }
            this.ccAssociators(cIMNameSpaceRlogEntry, string6, string2, string3, string4, string5, bl, bl2, stringArray, vector, bl3, bl4);
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace();
            throw cIMException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.toString());
        }
    }

    private boolean matchClassList(String string, ArrayList arrayList) {
        if (arrayList.isEmpty()) {
            return true;
        }
        int n = 0;
        while (n < arrayList.size()) {
            if (string.equalsIgnoreCase((String)arrayList.get(n))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void addToResultList(CIMNameSpaceRlogEntry cIMNameSpaceRlogEntry, String string, boolean bl, boolean bl2, String[] stringArray, Vector vector, boolean bl3) throws CIMException {
        try {
            if (bl3) {
                vector.addElement(new CIMObjectPath(string, cIMNameSpaceRlogEntry.getName()));
                return;
            }
            CIMClassRlogEntry cIMClassRlogEntry = cIMNameSpaceRlogEntry.getClass(string);
            if (cIMClassRlogEntry == null) {
                throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)string);
            }
            CIMClass cIMClass = (CIMClass)PSRlogImpl.deserialize(cIMClassRlogEntry.getValue());
            vector.addElement(cIMClass.filterProperties(stringArray, bl, bl2));
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.toString());
        }
    }

    private ArrayList deepEnum(CIMNameSpaceRlogEntry cIMNameSpaceRlogEntry, String string) throws CIMException {
        CIMClassRlogEntry cIMClassRlogEntry = cIMNameSpaceRlogEntry.getClass(string);
        if (cIMClassRlogEntry == null) {
            throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)string);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        int n = 0;
        while (n < arrayList.size()) {
            cIMClassRlogEntry = cIMNameSpaceRlogEntry.getClass((String)arrayList.get(n));
            if (cIMClassRlogEntry == null) {
                throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)string);
            }
            ArrayList arrayList2 = new ArrayList(cIMClassRlogEntry.getSubClassKeys());
            int n2 = 0;
            while (n2 < arrayList2.size()) {
                arrayList.add((String)arrayList2.get(n2));
                ++n2;
            }
            ++n;
        }
        return arrayList;
    }

    private String getInstanceName(CIMNameSpaceRlogEntry cIMNameSpaceRlogEntry, CIMObjectPath cIMObjectPath) throws CIMException {
        CIMClassRlogEntry cIMClassRlogEntry = cIMNameSpaceRlogEntry.getClass(cIMObjectPath.getObjectName());
        CIMClass cIMClass = (CIMClass)PSRlogImpl.deserialize(cIMClassRlogEntry.getValue());
        CIMInstance cIMInstance = cIMClass.newInstance();
        cIMInstance.updatePropertyValues(cIMObjectPath.getKeys());
        return cIMInstance.getName();
    }

    public Vector associatorNames(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string, String string2, String string3) throws CIMException {
        return this.instanceAssociators(cIMObjectPath, cIMObjectPath2, string, string2, string3, false, false, null, true, false);
    }

    public Vector associators(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string, String string2, String string3, boolean bl, boolean bl2, String[] stringArray) throws CIMException {
        return this.instanceAssociators(cIMObjectPath, cIMObjectPath2, string, string2, string3, bl, bl2, stringArray, true, false);
    }

    public Vector reference(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string, boolean bl, boolean bl2, String[] stringArray) throws CIMException {
        return this.instanceAssociators(cIMObjectPath, cIMObjectPath2, null, string, null, bl, bl2, stringArray, false, true);
    }

    public Vector referenceNames(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string) throws CIMException {
        return this.instanceAssociators(cIMObjectPath, cIMObjectPath2, null, string, null, false, false, null, true, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Vector instanceAssociators(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string, String string2, String string3, boolean bl, boolean bl2, String[] stringArray, boolean bl3, boolean bl4) throws CIMException {
        Vector<Object> vector;
        block23: {
            Vector<Object> vector2;
            block21: {
                vector = new Vector<Object>();
                if (string2 != null && string2.length() != 0 && string3 != null && string3.length() != 0 && string2.equalsIgnoreCase(string3)) {
                    return vector;
                }
                String string5 = cIMObjectPath2.getNameSpace();
                String string6 = cIMObjectPath2.getObjectName();
                String string7 = cIMObjectPath.getObjectName();
                string5 = string5.replace('\\', '/');
                try {
                    try {
                        this.concurrentObj.readLock();
                        CIMNameSpaceRlogEntry cIMNameSpaceRlogEntry = this.getNameSpaceEntryFromMap(string5);
                        CIMClassRlogEntry cIMClassRlogEntry = cIMNameSpaceRlogEntry.getClass(string6);
                        if (cIMClassRlogEntry == null) {
                            throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)string6);
                        }
                        String string4 = this.getInstanceName(cIMNameSpaceRlogEntry, cIMObjectPath2);
                        CIMInstanceRlogEntry cIMInstanceRlogEntry = cIMClassRlogEntry.getInstance(string4);
                        if (cIMInstanceRlogEntry == null) {
                            throw new CIMInstanceException("CIM_ERR_NOT_FOUND", (Object)string4);
                        }
                        CIMAssocInstanceRlogEntry[] cIMAssocInstanceRlogEntryArray = cIMInstanceRlogEntry.getAssociations(string7);
                        if (cIMAssocInstanceRlogEntryArray == null) {
                            vector2 = vector;
                            Object var28_24 = null;
                            break block21;
                        }
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        int n = 0;
                        while (n < cIMAssocInstanceRlogEntryArray.length) {
                            if (hashMap.get(cIMAssocInstanceRlogEntryArray[n].getName()) == null) {
                                Object object;
                                Object object2;
                                hashMap.put(cIMAssocInstanceRlogEntryArray[n].getName(), "");
                                if (bl4) {
                                    object2 = cIMAssocInstanceRlogEntryArray[n].matchAssociator(string4, string2, string3);
                                    if (object2 != null) {
                                        if (bl3) {
                                            vector.addElement(object2);
                                        } else {
                                            object = this.getInstance((CIMObjectPath)object2);
                                            vector.addElement(object.filterProperties(stringArray, bl, bl2));
                                        }
                                    }
                                } else {
                                    CIMObjectPath cIMObjectPath3;
                                    object2 = cIMAssocInstanceRlogEntryArray[n].matchRole(string4, string2, string3);
                                    object = null;
                                    if (string != null && string.length() != 0) {
                                        object = new HashSet();
                                        object.add(string.toLowerCase());
                                        Vector vector3 = this.enumClassesDo(string5, string, true, true, false);
                                        Iterator iterator = vector3.iterator();
                                        while (iterator.hasNext()) {
                                            cIMObjectPath3 = (CIMObjectPath)iterator.next();
                                            object.add(cIMObjectPath3.getObjectName().toLowerCase());
                                        }
                                    }
                                    int n2 = ((ArrayList)object2).size();
                                    int n3 = 0;
                                    while (n3 < n2) {
                                        cIMObjectPath3 = (CIMObjectPath)((ArrayList)object2).get(n3);
                                        if (object == null || object.contains(cIMObjectPath3.getObjectName().toLowerCase())) {
                                            vector.addElement(cIMObjectPath3);
                                        }
                                        ++n3;
                                    }
                                }
                            }
                            ++n;
                        }
                        break block23;
                    }
                    catch (CIMException cIMException) {
                        if (!verbose) throw cIMException;
                        cIMException.printStackTrace();
                        throw cIMException;
                    }
                    catch (Exception exception) {
                        if (!verbose) throw new CIMException("CIM_ERR_FAILED", (Object)exception.toString());
                        exception.printStackTrace();
                        throw new CIMException("CIM_ERR_FAILED", (Object)exception.toString());
                    }
                }
                catch (Throwable throwable) {
                    Object var28_26 = null;
                    this.concurrentObj.readUnlock();
                    throw throwable;
                }
            }
            this.concurrentObj.readUnlock();
            return vector2;
        }
        Object var28_25 = null;
        this.concurrentObj.readUnlock();
        return vector;
    }

    static byte[] serialize(Object object) throws CIMException {
        byte[] byArray;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            byArray = byteArrayOutputStream.toByteArray();
            objectOutputStream.close();
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.toString());
        }
        return byArray;
    }

    static Object deserialize(byte[] byArray) throws CIMException {
        Object object;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object = objectInputStream.readObject();
            objectInputStream.close();
            byteArrayInputStream.close();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.toString());
        }
        return object;
    }

    public void additionTriggerActivate(String string, String string2) {
        this.eventHelper.additionTriggerActivate(string, string2);
    }

    public void deletionTriggerActivate(String string, String string2) {
        this.eventHelper.deletionTriggerActivate(string, string2);
    }

    public void modificationTriggerActivate(String string, String string2) {
        this.eventHelper.modificationTriggerActivate(string, string2);
    }

    public void additionTriggerDeActivate(String string, String string2) {
        this.eventHelper.additionTriggerDeActivate(string, string2);
    }

    public void deletionTriggerDeActivate(String string, String string2) {
        this.eventHelper.deletionTriggerDeActivate(string, string2);
    }

    public void modificationTriggerDeActivate(String string, String string2) {
        this.eventHelper.modificationTriggerDeActivate(string, string2);
    }

    public void authorizeFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, String string2) throws CIMException {
        this.eventHelper.authorizeFilter(selectExp, string, cIMObjectPath, string2);
    }

    public boolean mustPoll(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath) throws CIMException {
        return this.eventHelper.mustPoll(selectExp, string, cIMObjectPath);
    }

    public void activateFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        this.eventHelper.activateFilter(selectExp, string, cIMObjectPath, bl);
    }

    public void deActivateFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        this.eventHelper.deActivateFilter(selectExp, string, cIMObjectPath, bl);
    }

    public void initialize(CIMOMHandle cIMOMHandle) {
    }

    public void cleanup() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SnapshotThread
    extends Thread {
        public SnapshotThread() {
            super("snapshot thread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                PSRlogImpl.this.concurrentObj.readLock();
            }
            catch (ReadersWriter.ConcurrentLockException concurrentLockException) {
                return;
            }
            try {
                while (true) {
                    if (this.isInterrupted()) break;
                    try {
                        PSRlogImpl.this.concurrentObj.readerWait(PSRlogImpl.this.snapshotNotifier, Long.MAX_VALUE);
                        try {
                            PSRlogImpl.this.log.snapshot();
                            PSRlogImpl.this.logFileSize = 0;
                        }
                        catch (InterruptedIOException interruptedIOException) {
                            Object var4_5 = null;
                            PSRlogImpl.this.concurrentObj.readUnlock();
                            return;
                        }
                        catch (Exception exception) {
                            if (exception instanceof LogException && ((LogException)exception).detail instanceof InterruptedIOException) {
                                Object var4_6 = null;
                                PSRlogImpl.this.concurrentObj.readUnlock();
                                return;
                            }
                            exception.printStackTrace();
                        }
                    }
                    catch (ReadersWriter.ConcurrentLockException concurrentLockException) {
                        Object var4_7 = null;
                        PSRlogImpl.this.concurrentObj.readUnlock();
                        return;
                    }
                }
                Object var4_8 = null;
                PSRlogImpl.this.concurrentObj.readUnlock();
                return;
            }
            catch (Throwable throwable) {
                Object var4_9 = null;
                PSRlogImpl.this.concurrentObj.readUnlock();
                throw throwable;
            }
        }
    }

    private class LocalLogHandler
    extends LogHandler {
        public void snapshot(OutputStream outputStream) throws IOException {
            PSRlogImpl.this.takeSnapshot(outputStream);
        }

        public void recover(InputStream inputStream) throws IOException, ClassNotFoundException {
            PSRlogImpl.this.recoverSnapshot(inputStream);
        }

        public void applyUpdate(Object object) {
            ((LogRecord)object).apply(PSRlogImpl.this);
        }
    }

    private static class DeleteInstanceLogObj
    implements LogRecord {
        private static final long serialVersionUID = -244838496512419329L;
        private String namespace;
        private String iname;

        public DeleteInstanceLogObj(String string, String string2) {
            this.namespace = string;
            this.iname = string2;
        }

        public void apply(PSRlogImpl pSRlogImpl) {
            try {
                pSRlogImpl.deleteInstance(this.namespace, this.iname);
            }
            catch (CIMException cIMException) {
                // empty catch block
            }
        }
    }

    private static class DeleteClassLogObj
    implements LogRecord {
        private static final long serialVersionUID = -6444092897893756582L;
        private String namespace;
        private String className;

        public DeleteClassLogObj(String string, String string2) {
            this.namespace = string;
            this.className = string2;
        }

        public void apply(PSRlogImpl pSRlogImpl) {
            try {
                pSRlogImpl.deleteClass(this.namespace, this.className);
            }
            catch (CIMException cIMException) {
                // empty catch block
            }
        }
    }

    private static class DeleteQualifierLogObj
    implements LogRecord {
        private static final long serialVersionUID = -4910178553526207227L;
        private String namespace;
        private String qtName;

        public DeleteQualifierLogObj(String string, String string2) {
            this.namespace = string;
            this.qtName = string2;
        }

        public void apply(PSRlogImpl pSRlogImpl) {
            try {
                pSRlogImpl.deleteQualifier(this.namespace, this.qtName);
            }
            catch (CIMException cIMException) {
                // empty catch block
            }
        }
    }

    private static class AddCIMInstanceLogObj
    extends AddCIMClassLogObj {
        private static final long serialVersionUID = -3727326644253863113L;

        public AddCIMInstanceLogObj(String string, String string2, String string3, boolean bl, PersistentStore.PersistObject persistObject) {
            super(string, string2, string3, bl, persistObject);
        }

        protected void applyDo(PSRlogImpl pSRlogImpl) throws CIMException {
            CIMInstance cIMInstance = this.assoc ? (CIMInstance)this.getCIMElement(pSRlogImpl) : null;
            this.entry = pSRlogImpl.addCIMInstanceDo(this.namespace, this.name, this.otherName, cIMInstance);
        }
    }

    private static class AddCIMClassLogObj
    extends AddCIMQualifierLogObj {
        private static final long serialVersionUID = -7848952153471853442L;
        protected String otherName;
        protected boolean assoc;

        public AddCIMClassLogObj(String string, String string2, String string3, boolean bl, PersistentStore.PersistObject persistObject) {
            super(string, string2, persistObject);
            this.assoc = bl;
            this.otherName = string3;
        }

        protected void applyDo(PSRlogImpl pSRlogImpl) throws CIMException {
            CIMClass cIMClass = this.assoc ? (CIMClass)this.getCIMElement(pSRlogImpl) : null;
            this.entry = pSRlogImpl.addCIMClassDo(this.namespace, this.name, this.otherName, this.assoc, cIMClass);
        }
    }

    private static class SetCIMInstanceLogObj
    extends SetCIMClassLogObj {
        private static final long serialVersionUID = 8152734320755230951L;

        public SetCIMInstanceLogObj(String string, String string2, String string3, PersistentStore.PersistObject persistObject) {
            super(string, string2, string3, persistObject);
        }

        protected void applyDo(PSRlogImpl pSRlogImpl) throws CIMException {
            this.entry = pSRlogImpl.setInstanceDo(this.namespace, this.name, this.otherName);
        }
    }

    private static class SetCIMClassLogObj
    extends AddCIMQualifierLogObj {
        private static final long serialVersionUID = 4842199887990665842L;
        protected String otherName;

        public SetCIMClassLogObj(String string, String string2, String string3, PersistentStore.PersistObject persistObject) {
            super(string, string2, persistObject);
            this.otherName = string3;
        }

        protected void applyDo(PSRlogImpl pSRlogImpl) throws CIMException {
            this.entry = pSRlogImpl.setClassDo(this.namespace, this.name, this.otherName);
        }
    }

    private static class SetCIMQualifierLogObj
    extends AddCIMQualifierLogObj {
        private static final long serialVersionUID = 6509220164924254555L;

        public SetCIMQualifierLogObj(String string, String string2, PersistentStore.PersistObject persistObject) {
            super(string, string2, persistObject);
        }

        protected void applyDo(PSRlogImpl pSRlogImpl) throws CIMException {
            this.entry = pSRlogImpl.setQualifierTypeDo(this.namespace, this.name);
        }
    }

    private static class AddCIMQualifierLogObj
    implements LogRecord {
        private static final long serialVersionUID = 9136358929100936537L;
        protected String namespace;
        protected String name;
        protected PersistentStore.PersistObject po;
        protected transient CIMRlogEntry entry = null;

        public AddCIMQualifierLogObj(String string, String string2, PersistentStore.PersistObject persistObject) {
            this.namespace = string;
            this.name = string2;
            this.po = persistObject;
        }

        public void apply(PSRlogImpl pSRlogImpl) {
            try {
                pSRlogImpl.store.addPersistObject(this.po);
                this.applyDo(pSRlogImpl);
                this.entry.setID(this.po.getID());
            }
            catch (CIMException cIMException) {
                // empty catch block
            }
        }

        protected void applyDo(PSRlogImpl pSRlogImpl) throws CIMException {
            this.entry = pSRlogImpl.addCIMQualifierTypeDo(this.namespace, this.name);
        }

        protected CIMElement getCIMElement(PSRlogImpl pSRlogImpl) throws CIMException {
            try {
                byte[] byArray = pSRlogImpl.store.readObjectBytes(this.po.getID());
                return (CIMElement)PSRlogImpl.deserialize(byArray);
            }
            catch (IOException iOException) {
                System.out.println("exception:" + iOException);
                iOException.printStackTrace();
                throw new RuntimeException("object id = " + this.po.getID() + " does not exist");
            }
        }
    }

    private static class DeleteNameSpaceLogObj
    implements LogRecord {
        private static final long serialVersionUID = 6349423596857633706L;
        private String namespace;

        public DeleteNameSpaceLogObj(String string) {
            this.namespace = string;
        }

        public void apply(PSRlogImpl pSRlogImpl) {
            try {
                pSRlogImpl.deleteNameSpaceDo(this.namespace);
            }
            catch (CIMException cIMException) {
                // empty catch block
            }
        }
    }

    private static class CreateNameSpaceLogObj
    implements LogRecord {
        private static final long serialVersionUID = -3217549711344318384L;
        private String namespace;

        public CreateNameSpaceLogObj(String string) {
            this.namespace = string;
        }

        public void apply(PSRlogImpl pSRlogImpl) {
            try {
                pSRlogImpl.createNameSpaceDo(this.namespace);
            }
            catch (CIMException cIMException) {
                // empty catch block
            }
        }
    }

    private static interface LogRecord
    extends Serializable {
        public void apply(PSRlogImpl var1);
    }
}

