/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.compiler.mib2mof;

import com.sun.wbem.compiler.mib2mof.ASTMib;
import com.sun.wbem.compiler.mib2mof.BeanIfGenerator;
import com.sun.wbem.compiler.mib2mof.Def;
import com.sun.wbem.compiler.mib2mof.MessageHandler;
import com.sun.wbem.compiler.mib2mof.MibNode;
import com.sun.wbem.compiler.mib2mof.ResourceManager;
import com.sun.wbem.compiler.mib2mof.Trace;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class TableBeanIfGenerator
extends BeanIfGenerator
implements Serializable {
    protected MibNode node;
    protected StringBuffer table_impl = new StringBuffer();

    public static String buildTableBeanIfName(String string, String string2) {
        return string + Def.TABLEPREFIX + string2 + Def.MBEANSUFFIX;
    }

    public TableBeanIfGenerator(ResourceManager resourceManager, String string, String string2, String string3, MibNode mibNode, ASTMib aSTMib) throws IOException {
        super(resourceManager, string, string2, string3, mibNode, aSTMib);
        this.node = mibNode;
        this.varName = this.node.getSymbolName();
        this.symboleName = TableBeanIfGenerator.buildTableBeanIfName(string2, this.varName);
        Trace.info(MessageHandler.getMessage("generate.info.if", this.varName));
        this.out = this.openFile(this.symboleName + Def.JAVA);
        this.writeHeader();
        this.writeClassDeclaration();
        this.processTable();
        this.write(this.table_impl.toString());
        this.write("\n" + Def.RBRACE);
        this.closeIO();
    }

    protected void writeClassDeclaration() throws IOException {
        this.write("/**\n * " + MessageHandler.getMessage("generate.mbeanif.comment.desc", Def.TABLEPREFIX + this.varName) + "\n" + " */\n");
        this.write(Def.PUBLIC + Def.INTERFACE + this.symboleName + Def.EXTEND + Def.SNMP_TABLE + Def.MBEANSUFFIX + Def.LBRACE + "\n");
    }

    private void processTable() throws IOException {
        String string = this.getTableEntryName();
        this.table_impl.append(Def.TAB + Def.PUBLIC + Def.VOID + Def.METH_T_ADD + "(" + string + " entry)\n" + Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + Def.SEMICOLON + "\n");
        this.table_impl.append(Def.TAB + Def.PUBLIC + Def.VOID + Def.METH_T_REM + "(" + string + " x)" + Def.SEMICOLON + "\n");
        this.table_impl.append(Def.TAB + Def.PUBLIC + string + "[] " + Def.GET_ENTRIES + "()" + Def.SEMICOLON + "\n");
    }

    private String getTableEntryName() throws IOException {
        Hashtable hashtable = this.node.getChildren();
        if (hashtable.size() != 1) {
            Trace.error(MessageHandler.getMessage("generate.error.table.entry", this.node.getRealSymbolName()));
            throw new IOException();
        }
        Enumeration enumeration = hashtable.elements();
        MibNode mibNode = (MibNode)enumeration.nextElement();
        String string = mibNode.getSymbolName();
        if (string == null) {
            string = this.getClassName(mibNode.getComputedOid());
        }
        String string2 = this.prefix + string;
        return string2;
    }
}

