/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.utility.directorytable;

import com.sun.wbem.utility.common.UException;
import com.sun.wbem.utility.directorytable.DirectoryMask;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableAccessException;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableLibrary;
import com.sun.wbem.utility.directorytable.DirectoryTableOperationNotSupportedException;
import com.sun.wbem.utility.directorytable.DirectoryUtility;
import com.sun.wbem.utility.directorytable.LdapTableDefinitions;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import com.sun.wbem.utility.directorytable.TableSetup;
import java.net.InetAddress;
import java.util.Vector;

public class LdapDirectoryTable
implements DirectoryTable,
TableSetup {
    TableDefinitions tableDefinitions;
    boolean needsFlush;
    String domainName;
    String serverName;
    String authName = "";
    String authPassword = "";
    int port;
    int sessionDescriptor = -1;
    DirectoryMask allSetMask;

    public int access(String string) throws DirectoryTableException {
        int n = 0;
        LdapTableDefinitions ldapTableDefinitions = new LdapTableDefinitions(this.serverName, this.domainName);
        ldapTableDefinitions.loadTableDefinitions(string);
        String string2 = ldapTableDefinitions.getMappedTableName();
        if (DirectoryTableLibrary.ldapAccess(this.serverName, string2, 16, this.authName, this.authPassword, this.port) != 0) {
            return n;
        }
        if (DirectoryTableLibrary.ldapAccess(this.serverName, string2, 4, this.authName, this.authPassword, this.port) == 0) {
            n |= 1;
        }
        if (DirectoryTableLibrary.ldapAccess(this.serverName, string2, 8, this.authName, this.authPassword, this.port) == 0) {
            n |= 2;
        }
        if (DirectoryTableLibrary.ldapAccess(this.serverName, string2, 2, this.authName, this.authPassword, this.port) == 0) {
            n |= 8;
        }
        if (DirectoryTableLibrary.ldapAccess(this.serverName, string2, 1, this.authName, this.authPassword, this.port) == 0) {
            n |= 4;
        }
        return n;
    }

    public int access(TableDefinitions tableDefinitions) throws DirectoryTableException {
        int n = 0;
        String string = tableDefinitions.getMappedTableName();
        if (DirectoryTableLibrary.ldapAccess(this.serverName, string, 16, this.authName, this.authPassword, this.port) != 0) {
            return n;
        }
        if (DirectoryTableLibrary.ldapAccess(this.serverName, string, 4, this.authName, this.authPassword, this.port) == 0) {
            n |= 1;
        }
        if (DirectoryTableLibrary.ldapAccess(this.serverName, string, 8, this.authName, this.authPassword, this.port) == 0) {
            n |= 2;
        }
        if (DirectoryTableLibrary.ldapAccess(this.serverName, string, 2, this.authName, this.authPassword, this.port) == 0) {
            n |= 8;
        }
        if (DirectoryTableLibrary.ldapAccess(this.serverName, string, 1, this.authName, this.authPassword, this.port) == 0) {
            n |= 4;
        }
        return n;
    }

    public void open(String string) throws DirectoryTableException {
        LdapTableDefinitions ldapTableDefinitions = new LdapTableDefinitions(this.serverName, this.domainName);
        ldapTableDefinitions.loadTableDefinitions(string);
        int n = ldapTableDefinitions.getNumberOfColumns();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = ldapTableDefinitions.getMappedColumnName(n2 + 1);
            ++n2;
        }
        this.sessionDescriptor = DirectoryTableLibrary.ldapOpenTable(this.serverName, ldapTableDefinitions.getMappedTableName(), stringArray, this.authName, this.authPassword, this.port);
        if (this.sessionDescriptor < 1) {
            int n3 = 0 - this.sessionDescriptor;
            if (n3 == 32) {
                throw new DirectoryTableDoesNotExistException(ldapTableDefinitions.getMappedTableName(), "DN", ldapTableDefinitions.getMappedTableName());
            }
            DirectoryTableLibrary.ldapErrorToException(n3, ldapTableDefinitions);
        }
        this.tableDefinitions = ldapTableDefinitions;
        this.allSetMask = this.getDirectoryMaskInstance();
        this.allSetMask.setAllColumns();
        this.needsFlush = false;
    }

    public void open(TableDefinitions tableDefinitions) throws DirectoryTableException {
        int n = tableDefinitions.getNumberOfColumns();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = tableDefinitions.getMappedColumnName(n2 + 1);
            ++n2;
        }
        this.sessionDescriptor = DirectoryTableLibrary.ldapOpenTable(this.serverName, tableDefinitions.getMappedTableName(), stringArray, this.authName, this.authPassword, this.port);
        if (this.sessionDescriptor < 1) {
            int n3 = 0 - this.sessionDescriptor;
            if (n3 == 32) {
                throw new DirectoryTableDoesNotExistException(tableDefinitions.getMappedTableName(), "DN", tableDefinitions.getMappedTableName());
            }
            DirectoryTableLibrary.ldapErrorToException(n3, tableDefinitions);
        }
        this.tableDefinitions = tableDefinitions;
        this.allSetMask = this.getDirectoryMaskInstance();
        this.allSetMask.setAllColumns();
        this.needsFlush = false;
    }

    public void create(TableDefinitions tableDefinitions) throws DirectoryTableException {
        char c = tableDefinitions.getColumnSeparators().charAt(0);
        int n = DirectoryTableLibrary.convertAccessToRights(tableDefinitions.getAccess());
        int n2 = tableDefinitions.getNumberOfColumns();
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            stringArray[n3] = tableDefinitions.getMappedColumnName(n3 + 1);
            ++n3;
        }
        this.sessionDescriptor = DirectoryTableLibrary.ldapAddTable(this.serverName, tableDefinitions.getMappedTableName(), n, stringArray, this.authName, this.authPassword, this.port);
        if (this.sessionDescriptor < 1) {
            int n4 = 0 - this.sessionDescriptor;
            DirectoryTableLibrary.ldapErrorToException(n4, tableDefinitions);
        }
        this.tableDefinitions = tableDefinitions;
        this.allSetMask = this.getDirectoryMaskInstance();
        this.allSetMask.setAllColumns();
        this.needsFlush = false;
    }

    public void create(String string) throws DirectoryTableException {
        LdapTableDefinitions ldapTableDefinitions = new LdapTableDefinitions(this.serverName, this.domainName);
        ldapTableDefinitions.loadTableDefinitions(string);
        char c = ldapTableDefinitions.getColumnSeparators().charAt(0);
        int n = DirectoryTableLibrary.convertAccessToRights(ldapTableDefinitions.getAccess());
        int n2 = ldapTableDefinitions.getNumberOfColumns();
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            stringArray[n3] = ldapTableDefinitions.getMappedColumnName(n3 + 1);
            ++n3;
        }
        this.sessionDescriptor = DirectoryTableLibrary.ldapAddTable(this.serverName, ldapTableDefinitions.getMappedTableName(), n, stringArray, this.authName, this.authPassword, this.port);
        if (this.sessionDescriptor < 1) {
            int n4 = 0 - this.sessionDescriptor;
            DirectoryTableLibrary.ldapErrorToException(n4, ldapTableDefinitions);
        }
        this.tableDefinitions = ldapTableDefinitions;
        this.allSetMask = this.getDirectoryMaskInstance();
        this.allSetMask.setAllColumns();
        this.needsFlush = false;
    }

    public void delete(TableDefinitions tableDefinitions) throws DirectoryTableException {
        int n = 0;
        n = DirectoryTableLibrary.ldapDeleteTable(this.serverName, tableDefinitions.getMappedTableName(), this.authName, this.authPassword, this.port);
        DirectoryTableLibrary.ldapErrorToException(n, tableDefinitions);
    }

    public void delete(String string) throws DirectoryTableException {
        int n = 0;
        LdapTableDefinitions ldapTableDefinitions = new LdapTableDefinitions(this.serverName, this.domainName);
        ldapTableDefinitions.loadTableDefinitions(string);
        n = DirectoryTableLibrary.ldapDeleteTable(this.serverName, ldapTableDefinitions.getMappedTableName(), this.authName, this.authPassword, this.port);
        DirectoryTableLibrary.ldapErrorToException(n, ldapTableDefinitions);
    }

    public void close() {
        try {
            this.flush();
        }
        catch (DirectoryTableException directoryTableException) {
            this.needsFlush = false;
        }
        DirectoryTableLibrary.ldapCloseTable(this.sessionDescriptor);
        this.tableDefinitions = null;
        this.sessionDescriptor = -1;
        this.allSetMask = null;
    }

    public void flush() throws DirectoryTableException {
        if (this.needsFlush) {
            this.needsFlush = false;
        }
    }

    public void addRow(DirectoryRow directoryRow) throws DirectoryTableException {
        String string = null;
        if ((this.tableDefinitions.getTableAttributes() & 1) == 1) {
            throw new DirectoryTableAccessException("EXM_READONLY");
        }
        int n = 1;
        while (n <= directoryRow.getNumberOfRows()) {
            string = this.rowToDN(directoryRow, n);
            if (string == null) {
                throw new DirectoryTableAccessException("EXM_NOTUNIQUE");
            }
            int n2 = DirectoryTableLibrary.ldapAddEntry(this.sessionDescriptor, string, this.rowToArray(directoryRow, n));
            DirectoryTableLibrary.ldapErrorToException(n2, this.tableDefinitions);
            ++n;
        }
        this.needsFlush = true;
    }

    public void deleteRow(DirectoryRow directoryRow) throws DirectoryTableException {
        String string = null;
        if ((this.tableDefinitions.getTableAttributes() & 1) == 1) {
            throw new DirectoryTableAccessException("EXM_READONLY");
        }
        int n = directoryRow.getNumberOfColumns();
        int n2 = 1;
        int n3 = 1;
        while (n3 <= n) {
            if ((this.tableDefinitions.getColumnAttributes(n3) & 0x20) != 32) {
                ++n2;
            }
            ++n3;
        }
        String[] stringArray = new String[n2];
        stringArray[0] = this.tableDefinitions.getTableType();
        --n2;
        int n4 = 1;
        while (n4 <= n) {
            if ((this.tableDefinitions.getColumnAttributes(n4) & 0x20) != 32) {
                stringArray[n2--] = this.tableDefinitions.getMappedColumnName(n4);
            }
            ++n4;
        }
        int n5 = 1;
        while (n5 <= directoryRow.getNumberOfRows()) {
            string = this.rowToDN(directoryRow, n5);
            if (string == null) {
                throw new DirectoryTableAccessException("EXM_NOTUNIQUE");
            }
            int n6 = DirectoryTableLibrary.ldapDeleteEntry(this.sessionDescriptor, string, stringArray);
            DirectoryTableLibrary.ldapErrorToException(n6, this.tableDefinitions);
            ++n5;
        }
        this.needsFlush = true;
    }

    public void modifyRow(DirectoryRow directoryRow, DirectoryRow directoryRow2) throws DirectoryTableException {
        if ((this.tableDefinitions.getTableAttributes() & 1) == 1) {
            throw new DirectoryTableAccessException("EXM_READONLY");
        }
        int n = DirectoryTableLibrary.ldapModifyEntry(this.sessionDescriptor, this.rowToDN(directoryRow, 1), this.rowToDN(directoryRow2, 1), this.rowToArray(directoryRow2, 1));
        DirectoryTableLibrary.ldapErrorToException(n, this.tableDefinitions);
        this.needsFlush = true;
    }

    public DirectoryRow getFirstRow() throws DirectoryTableException {
        DirectoryRow directoryRow = new DirectoryRow(this.tableDefinitions.getNumberOfColumns());
        return this.getFirstRow(directoryRow);
    }

    public DirectoryRow getNextRow() throws DirectoryTableException {
        DirectoryRow directoryRow = new DirectoryRow(this.tableDefinitions.getNumberOfColumns());
        return this.getNextRow(directoryRow);
    }

    public DirectoryRow getFirstRow(SearchTemplate searchTemplate) throws DirectoryTableException {
        DirectoryRow directoryRow = searchTemplate.getTemplateAsRow(this.tableDefinitions);
        String string = directoryRow == null ? "" : this.rowToSearchName(directoryRow, 1);
        String[] stringArray = DirectoryTableLibrary.ldapGetFirstEntry(this.sessionDescriptor, string);
        if (stringArray == null) {
            return null;
        }
        DirectoryRow directoryRow2 = this.arrayToRow(stringArray);
        if (!directoryRow2.isEmpty() && searchTemplate.matchRow(directoryRow2, 1, this.tableDefinitions)) {
            return directoryRow2;
        }
        stringArray = DirectoryTableLibrary.ldapGetNextEntry(this.sessionDescriptor);
        while (stringArray != null) {
            directoryRow2 = this.arrayToRow(stringArray);
            if (!directoryRow2.isEmpty() && searchTemplate.matchRow(directoryRow2, 1, this.tableDefinitions)) {
                return directoryRow2;
            }
            stringArray = DirectoryTableLibrary.ldapGetNextEntry(this.sessionDescriptor);
        }
        return null;
    }

    public DirectoryRow getNextRow(SearchTemplate searchTemplate) throws DirectoryTableException {
        String[] stringArray = DirectoryTableLibrary.ldapGetNextEntry(this.sessionDescriptor);
        while (stringArray != null) {
            DirectoryRow directoryRow = this.arrayToRow(stringArray);
            if (!directoryRow.isEmpty() && searchTemplate.matchRow(directoryRow, 1, this.tableDefinitions)) {
                return directoryRow;
            }
            stringArray = DirectoryTableLibrary.ldapGetNextEntry(this.sessionDescriptor);
        }
        return null;
    }

    public DirectoryRow getAll() throws DirectoryTableException {
        return this.getAll(this.allSetMask);
    }

    public DirectoryRow getAll(DirectoryMask directoryMask) throws DirectoryTableException {
        DirectoryRow directoryRow = null;
        DirectoryRow directoryRow2 = null;
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        directoryRow2 = new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), 1);
        String string = this.rowToSearchName(directoryRow2, 1);
        String[] stringArray = DirectoryTableLibrary.ldapGetAllEntries(this.sessionDescriptor, string);
        if (stringArray == null) {
            return directoryRow;
        }
        n = this.tableDefinitions.getNumberOfColumns();
        n2 = stringArray.length / n;
        directoryRow = new DirectoryRow(n, n2);
        this.arrayIntoRow(stringArray, 0, directoryRow, 1, n2, directoryMask);
        return directoryRow;
    }

    public DirectoryRow getAll(SearchTemplate searchTemplate) throws DirectoryTableException {
        return this.getAll(searchTemplate, this.allSetMask);
    }

    public DirectoryRow getAll(SearchTemplate searchTemplate, DirectoryMask directoryMask) throws DirectoryTableException {
        DirectoryRow directoryRow = new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), 1);
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        DirectoryRow directoryRow2 = searchTemplate.getTemplateAsRow(this.tableDefinitions);
        String string = directoryRow2 == null ? "(objectClass=*)" : this.rowToSearchName(directoryRow2, 1);
        String[] stringArray = DirectoryTableLibrary.ldapGetAllEntries(this.sessionDescriptor, string);
        if (stringArray == null) {
            return null;
        }
        n2 = this.tableDefinitions.getNumberOfColumns();
        n3 = stringArray.length / n2;
        int n4 = 0;
        while (n4 < n3) {
            this.arrayIntoRow(stringArray, n4 * n2, directoryRow, n, 1, directoryMask);
            if (!directoryRow.isEmpty() && searchTemplate.matchRow(directoryRow, n, this.tableDefinitions)) {
                directoryRow.addRows(1);
                ++n;
            }
            ++n4;
        }
        directoryRow.deleteRow(n);
        if (n == 1) {
            return null;
        }
        return directoryRow;
    }

    public DirectoryRow getRowInstance() {
        return new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), 1);
    }

    public DirectoryRow getRowInstance(int n) {
        return new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), n);
    }

    public TableDefinitions getTableDefinitionsInstance() {
        return new LdapTableDefinitions(this.serverName, this.domainName);
    }

    public DirectoryMask getDirectoryMaskInstance() {
        return new DirectoryMask(this.tableDefinitions);
    }

    public TableDefinitions getCurrentTableDefinitions() {
        return this.tableDefinitions;
    }

    public void setContext(String string) throws DirectoryTableException {
        String string2;
        try {
            string2 = DirectoryUtility.getDirectoryTableProperty("directorytable.ldap.port");
            if (string2 == null || string2.equals("")) {
                string2 = "389";
            }
        }
        catch (UException uException) {
            string2 = "389";
        }
        this.port = Integer.valueOf(string2);
        this.serverName = DirectoryUtility.getContextProperty(string, "serverName");
        this.domainName = DirectoryUtility.getContextProperty(string, "domainName");
        this.authName = DirectoryUtility.getContextProperty(string, "authName");
        this.authPassword = DirectoryUtility.getContextProperty(string, "authPassword");
        if (!DirectoryUtility.isLocalServer(this.serverName)) {
            throw new DirectoryTableOperationNotSupportedException("Remote LDAP");
        }
    }

    private String[] rowToArray(DirectoryRow directoryRow, int n) throws DirectoryTableException {
        int n2 = directoryRow.getNumberOfColumns();
        String[] stringArray = new String[n2 + 1];
        stringArray[0] = this.tableDefinitions.getTableType();
        int n3 = 1;
        while (n3 < n2 + 1) {
            stringArray[n3] = directoryRow.getColumn(n3, n);
            ++n3;
        }
        if (n2 == 8 && stringArray[2].trim().length() == 0) {
            stringArray[2] = stringArray[1];
        }
        return stringArray;
    }

    private String rowToDN(DirectoryRow directoryRow, int n) throws DirectoryTableException {
        String string = "";
        boolean bl = true;
        int n2 = directoryRow.getNumberOfColumns();
        int n3 = 0;
        while (n3 < n2) {
            if ((this.tableDefinitions.getColumnAttributes(n3 + 1) & 0x20) == 32) {
                if (!bl) {
                    string = string + "+";
                } else {
                    bl = false;
                }
                if (directoryRow.getColumn(n3 + 1, n).equals("")) {
                    String string2 = this.tableDefinitions.getAuxilliaryColumnData(n3 + 1);
                    string = string + this.tableDefinitions.getMappedColumnName(n3 + 1) + "=" + directoryRow.getColumn(this.tableDefinitions.getColumnNumber(string2), n);
                } else {
                    string = string + this.tableDefinitions.getMappedColumnName(n3 + 1) + "=" + directoryRow.getColumn(n3 + 1, n);
                }
            }
            ++n3;
        }
        return string;
    }

    private DirectoryRow arrayToRow(String[] stringArray) throws DirectoryTableException {
        int n = this.tableDefinitions.getNumberOfColumns();
        DirectoryRow directoryRow = new DirectoryRow(n);
        int n2 = 0;
        while (n2 < n) {
            directoryRow.putColumn(n2 + 1, stringArray[n2]);
            ++n2;
        }
        return directoryRow;
    }

    private void arrayIntoRow(String[] stringArray, int n, DirectoryRow directoryRow, int n2, int n3, DirectoryMask directoryMask) throws DirectoryTableException {
        int n4 = this.tableDefinitions.getNumberOfColumns();
        if (n3 == 0) {
            n3 = (stringArray.length - n) / n4;
        }
        int n5 = n2;
        while (n5 < n2 + n3) {
            int n6 = 0;
            while (n6 < n4) {
                if (directoryMask.getColumn(n6 + 1)) {
                    directoryRow.putColumn(n6 + 1, n5, stringArray[(n5 - n2) * n4 + n + n6]);
                }
                ++n6;
            }
            ++n5;
        }
    }

    private String rowToSearchName(DirectoryRow directoryRow, int n) throws DirectoryTableException {
        int n2 = directoryRow.getNumberOfColumns();
        boolean bl = true;
        String string = new String("");
        if (directoryRow.isEmpty()) {
            string = string + "(&(objectClass=" + this.tableDefinitions.getTableType() + "))";
            return string;
        }
        int n3 = 1;
        while (n3 <= n2) {
            if ((this.tableDefinitions.getColumnAttributes(n3) & 1) == 1) {
                if (bl) {
                    string = string + "(&";
                    bl = false;
                }
                if (!directoryRow.getColumn(n3, n).equals("")) {
                    string = string + "(" + this.tableDefinitions.getMappedColumnName(n3) + "=" + directoryRow.getColumn(n3, n) + ")";
                }
            }
            ++n3;
        }
        if (!bl) {
            string = string + "(objectClass=" + this.tableDefinitions.getTableType() + "))";
        }
        return string;
    }

    public Vector getScopes(int n) {
        String string;
        String string2;
        Vector<String> vector = null;
        try {
            string2 = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            return vector;
        }
        try {
            string = DirectoryUtility.getDirectoryTableProperty("directorytable.ldap.port");
            if (string == null || string.equals("")) {
                string = "389";
            }
        }
        catch (UException uException) {
            string = "389";
        }
        int n2 = Integer.valueOf(string);
        String[] stringArray = null;
        stringArray = DirectoryTableLibrary.ldapGetAllDomains(string2, n2);
        vector = new Vector<String>();
        if (stringArray != null) {
            int n3 = 0;
            while (n3 < stringArray.length) {
                int n4;
                String[] stringArray2;
                LdapTableDefinitions ldapTableDefinitions = new LdapTableDefinitions(string2, stringArray[n3]);
                try {
                    ldapTableDefinitions.loadTableDefinitions("passwd");
                }
                catch (Exception exception) {
                    return vector;
                }
                String string3 = ldapTableDefinitions.getMappedTableName();
                int n5 = ldapTableDefinitions.getNumberOfColumns();
                try {
                    stringArray2 = new String[n5];
                    n4 = 0;
                    while (n4 < n5) {
                        stringArray2[n4] = ldapTableDefinitions.getMappedColumnName(n4 + 1);
                        ++n4;
                    }
                }
                catch (Exception exception) {
                    return vector;
                }
                n4 = DirectoryTableLibrary.ldapOpenTable(string2, string3, stringArray2, this.authName, this.authPassword, n2);
                if (n4 >= 0) {
                    vector = new Vector();
                    vector.addElement("ldap:/" + string2 + "/" + stringArray[n3]);
                    DirectoryTableLibrary.ldapCloseTable(n4);
                }
                ++n3;
            }
        }
        return vector;
    }

    public void setup() {
    }

    public void refreshSetup() {
    }
}

