/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.util;

import com.sun.management.viper.util.Debug;
import com.sun.management.viper.util.PlatformSecureReader;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class DefaultSecureReader
implements PlatformSecureReader,
PrivilegedAction {
    protected InputStream iStream = null;
    protected static boolean libraryLoaded = false;

    protected static void loadLibrary() {
        try {
            String string = System.getProperty("os.name");
            string = string.toUpperCase();
            string.replace(' ', '-');
            String string2 = string + "EchoOff";
            System.loadLibrary(string2);
            libraryLoaded = true;
        }
        catch (Throwable throwable) {
            Debug.trace((String)"DefaultSecureReader", (int)Debug.WARNING, (String)"No platform secure reader available!", (Throwable)throwable);
        }
    }

    public Object run() {
        if (!libraryLoaded) {
            DefaultSecureReader.loadLibrary();
        }
        if (this.iStream == null) {
            return null;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.iStream));
            this.echoOff();
            String string = bufferedReader.readLine();
            this.echoOn();
            return string;
        }
        catch (Throwable throwable) {
            Debug.trace((String)"DefaultSecureReader", (int)Debug.ERROR, (String)"Problem reading secure information", (Throwable)throwable);
            return null;
        }
    }

    public String readLine(InputStream inputStream) {
        this.iStream = inputStream;
        try {
            Object t = AccessController.doPrivileged(this);
            return (String)t;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected void echoOff() {
        if (libraryLoaded) {
            DefaultSecureReader.doEchoOff();
        }
    }

    protected void echoOn() {
        if (libraryLoaded) {
            DefaultSecureReader.doEchoOn();
        }
    }

    protected static native void doEchoOff();

    protected static native void doEchoOn();
}

