/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.tty;

import com.sun.management.viperimpl.console.PrivilegeManager;
import com.sun.management.viperimpl.util.ImplResourceManager;
import java.io.BufferedReader;
import java.io.FileDescriptor;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.URL;
import java.security.CodeSource;
import java.text.MessageFormat;
import java.util.LinkedList;

public final class TTYPrivilegeManager
implements PrivilegeManager {
    protected PrintStream output = null;
    protected InputStream input = null;
    protected PrintStream error = null;
    protected boolean trustedMode = false;
    protected LinkedList grantSet = null;
    protected LinkedList denySet = null;
    protected static final int GRANT_PRIVILEGE = 0;
    protected static final int DENY_PRIVILEGE = 1;
    protected static final int GRANT_CODEBASE = 2;
    protected static final int DENY_CODEBASE = 3;
    protected static final int READ = 0;
    protected static final int WRITE = 1;
    protected static final int DELETE = 2;
    protected static final int LINK = 3;
    protected static final int EXEC = 4;
    protected static String title = null;
    protected static String wishToAllow = null;
    protected static String grantString = null;
    protected static String denyString = null;
    protected static String unknownLoc = null;
    protected static String dontAsk = null;
    protected static MessageFormat readDesc = null;
    protected static MessageFormat readFDDesc = null;
    protected static MessageFormat writeDesc = null;
    protected static MessageFormat writeFDDesc = null;
    protected static MessageFormat deleteDesc = null;
    protected static MessageFormat execDesc = null;
    protected static MessageFormat linkDesc = null;

    public TTYPrivilegeManager() {
        this.installStrings();
    }

    void init(InputStream inputStream, PrintStream printStream, PrintStream printStream2, boolean bl) {
        this.input = inputStream;
        this.output = printStream;
        this.error = printStream2;
        this.trustedMode = bl;
    }

    boolean checkGrantSet(URL uRL) {
        if (this.grantSet == null) {
            return false;
        }
        if (uRL == null) {
            return this.grantSet.contains(null);
        }
        return this.grantSet.contains(uRL.toString());
    }

    void checkDenySet(URL uRL) {
        if (this.denySet == null) {
            return;
        }
        if (uRL == null && this.denySet.contains(null)) {
            throw new SecurityException();
        }
        if (this.denySet.contains(uRL.toString())) {
            throw new SecurityException();
        }
    }

    protected synchronized void promptUserToAllow(CodeSource codeSource, int n, Object[] objectArray) {
        URL uRL = null;
        if (codeSource != null) {
            uRL = codeSource.getLocation();
        }
        if (this.checkGrantSet(uRL)) {
            return;
        }
        this.checkDenySet(uRL);
        int n2 = this.doPrompt(codeSource, n, objectArray);
        if (n2 == 2) {
            if (this.grantSet == null) {
                this.grantSet = new LinkedList();
            }
            if (uRL == null) {
                this.grantSet.add(null);
            } else {
                this.grantSet.add(uRL.toString());
            }
        } else {
            if (n2 == 3) {
                if (this.denySet == null) {
                    this.denySet = new LinkedList();
                }
                if (uRL == null) {
                    this.denySet.add(null);
                } else {
                    this.denySet.add(uRL.toString());
                }
                throw new SecurityException();
            }
            if (n2 == 1) {
                throw new SecurityException();
            }
        }
    }

    public void checkReadPrivilege(FileDescriptor fileDescriptor, CodeSource codeSource) {
        if (this.trustedMode) {
            return;
        }
        this.promptUserToAllow(codeSource, 0, new Object[]{fileDescriptor});
    }

    public void checkReadPrivilege(String string, CodeSource codeSource) {
        if (this.trustedMode) {
            return;
        }
        this.promptUserToAllow(codeSource, 0, new Object[]{string});
    }

    public void checkReadPrivilege(String string, Object object, CodeSource codeSource) {
        if (this.trustedMode) {
            return;
        }
        this.promptUserToAllow(codeSource, 0, new Object[]{string, object});
    }

    public void checkWritePrivilege(FileDescriptor fileDescriptor, CodeSource codeSource) {
        if (this.trustedMode) {
            return;
        }
        this.promptUserToAllow(codeSource, 1, new Object[]{fileDescriptor});
    }

    public void checkWritePrivilege(String string, CodeSource codeSource) {
        if (this.trustedMode) {
            return;
        }
        this.promptUserToAllow(codeSource, 1, new Object[]{string});
    }

    public void checkDeletePrivilege(String string, CodeSource codeSource) {
        if (this.trustedMode) {
            return;
        }
        this.promptUserToAllow(codeSource, 2, new Object[]{string});
    }

    public void checkExecPrivilege(String string, CodeSource codeSource) {
        if (this.trustedMode) {
            return;
        }
        this.promptUserToAllow(codeSource, 4, new Object[]{string});
    }

    public void checkLinkPrivilege(String string, CodeSource codeSource) {
        if (this.trustedMode) {
            return;
        }
        this.promptUserToAllow(codeSource, 3, new Object[]{string});
    }

    protected int doPrompt(CodeSource codeSource, int n, Object[] objectArray) {
        switch (n) {
            case 0: {
                return this.doReadPrompt(codeSource, objectArray);
            }
            case 1: {
                return this.doWritePrompt(codeSource, objectArray);
            }
            case 2: {
                return this.doDeletePrompt(codeSource, objectArray);
            }
            case 3: {
                return this.doLinkPrompt(codeSource, objectArray);
            }
            case 4: {
                return this.doExecPrompt(codeSource, objectArray);
            }
        }
        return 1;
    }

    protected int doReadPrompt(CodeSource codeSource, Object[] objectArray) {
        try {
            String string = this.getHostPortFor(codeSource);
            this.error.println("\n[ " + title + " ]");
            if (objectArray[0] instanceof String) {
                String string2 = (String)objectArray[0];
                this.error.println(readDesc.format(new Object[]{string, string2}));
            } else {
                this.error.println(readFDDesc.format(new Object[]{string}));
            }
            return this.handleInput();
        }
        catch (Throwable throwable) {
            return 1;
        }
    }

    protected int doWritePrompt(CodeSource codeSource, Object[] objectArray) {
        try {
            String string = this.getHostPortFor(codeSource);
            this.error.println("\n[ " + title + " ]");
            if (objectArray[0] instanceof String) {
                String string2 = (String)objectArray[0];
                this.error.println(writeDesc.format(new Object[]{string, string2}));
            } else {
                this.error.println(writeFDDesc.format(new Object[]{string}));
            }
            return this.handleInput();
        }
        catch (Throwable throwable) {
            return 1;
        }
    }

    protected int doDeletePrompt(CodeSource codeSource, Object[] objectArray) {
        try {
            String string = this.getHostPortFor(codeSource);
            this.error.println("\n[ " + title + " ]");
            String string2 = (String)objectArray[0];
            this.error.println(deleteDesc.format(new Object[]{string, string2}));
            return this.handleInput();
        }
        catch (Throwable throwable) {
            return 1;
        }
    }

    protected int doLinkPrompt(CodeSource codeSource, Object[] objectArray) {
        try {
            String string = this.getHostPortFor(codeSource);
            this.error.println("\n[ " + title + " ]");
            String string2 = (String)objectArray[0];
            this.error.println(linkDesc.format(new Object[]{string, string2}));
            return this.handleInput();
        }
        catch (Throwable throwable) {
            return 1;
        }
    }

    protected int doExecPrompt(CodeSource codeSource, Object[] objectArray) {
        try {
            String string = this.getHostPortFor(codeSource);
            this.error.println("\n[ " + title + " ]");
            String string2 = (String)objectArray[0];
            this.error.println(execDesc.format(new Object[]{string, string2}));
            return this.handleInput();
        }
        catch (Throwable throwable) {
            return 1;
        }
    }

    protected int handleInput() throws Exception {
        this.error.print(wishToAllow);
        this.error.print(" [" + grantString + " | " + denyString + "] : ");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.input));
        String string = bufferedReader.readLine();
        string = string.trim();
        string = string.toLowerCase();
        this.error.println();
        this.error.print(dontAsk);
        this.error.print(" [" + grantString + " | " + denyString + "] : ");
        String string2 = bufferedReader.readLine();
        string2 = string2.trim();
        string2 = string2.toLowerCase();
        String string3 = grantString.toLowerCase();
        if (string.length() == 0 || string.equals(string3)) {
            if (string2.length() == 0 || string2.equals(string3)) {
                return 2;
            }
            return 0;
        }
        if (string2.length() == 0 || string2.equals(string3)) {
            return 3;
        }
        return 1;
    }

    protected String getHostPortFor(CodeSource codeSource) {
        URL uRL = null;
        if (codeSource != null) {
            uRL = codeSource.getLocation();
        }
        if (uRL == null) {
            return unknownLoc;
        }
        String string = uRL.getHost();
        if (string == null) {
            return uRL.toString();
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            string = inetAddress.getHostName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        int n = uRL.getPort();
        if (n != -1) {
            return string + ":" + n;
        }
        return string;
    }

    protected void installStrings() {
        unknownLoc = ImplResourceManager.getString("an unkown location");
        wishToAllow = ImplResourceManager.getString("WishToAllow");
        grantString = ImplResourceManager.getString("GrantString");
        denyString = ImplResourceManager.getString("DenyString");
        try {
            readDesc = new MessageFormat(ImplResourceManager.getString("ReadDescription"));
            readFDDesc = new MessageFormat(ImplResourceManager.getString("ReadFDDescription"));
            writeDesc = new MessageFormat(ImplResourceManager.getString("WriteDescription"));
            writeFDDesc = new MessageFormat(ImplResourceManager.getString("WriteFDDescription"));
            deleteDesc = new MessageFormat(ImplResourceManager.getString("DeleteDescription"));
            execDesc = new MessageFormat(ImplResourceManager.getString("ExecDescription"));
            linkDesc = new MessageFormat(ImplResourceManager.getString("LinkDescription"));
            dontAsk = ImplResourceManager.getString("RememberDecision");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        title = ImplResourceManager.getString("Security Manager Alert");
    }

    public static void main(String[] stringArray) {
        TTYPrivilegeManager tTYPrivilegeManager = new TTYPrivilegeManager();
        tTYPrivilegeManager.init(System.in, System.out, System.err, false);
        tTYPrivilegeManager.checkReadPrivilege("/usr/sadm/lib", null);
        tTYPrivilegeManager.checkWritePrivilege("/usr/sadm/lib", null);
        tTYPrivilegeManager.checkDeletePrivilege("/usr/sadm/lib", null);
        tTYPrivilegeManager.checkLinkPrivilege("/usr/sadm/lib", null);
        tTYPrivilegeManager.checkExecPrivilege("/usr/sadm/lib", null);
        System.exit(0);
    }
}

