/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.gui;

import com.sun.management.viper.console.gui.VOptionPane;
import com.sun.management.viper.resources.ContextHelpLoader;
import com.sun.management.viper.util.ConsoleUtility;
import com.sun.management.viper.util.Debug;
import com.sun.management.viper.util.ResourceManager;
import com.sun.management.viperimpl.console.ManagerUtility;
import com.sun.management.viperimpl.console.config.ConfigManagement;
import com.sun.management.viperimpl.console.config.VBaseConfiguration;
import com.sun.management.viperimpl.console.config.VConfigurationInfo;
import com.sun.management.viperimpl.console.gui.ServerToolBoxChooser;
import com.sun.management.viperimpl.console.gui.ToolBoxChooser;
import com.sun.management.viperimpl.console.gui.ToolBoxChooserUI;
import com.sun.management.viperimpl.util.ImplResourceManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Locale;
import javax.accessibility.AccessibleContext;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ComponentUI;

public class ServerToolBoxChooserUI
extends ComponentUI
implements ToolBoxChooserUI,
Runnable {
    protected static int netTimeout = 20000;
    protected JButton approveButton = null;
    protected JButton cancelButton = null;
    protected JTextArea description = null;
    protected JList tbList = null;
    protected JScrollPane tbListPane = null;
    protected String remoteHelp = null;
    protected JComboBox serverComboBox = null;
    protected JTextField remoteTBField = null;
    protected ToolBoxChooser chooser = null;
    protected String remoteTitle = null;
    protected JLabel serverLabel = null;
    protected JButton goButton = null;
    protected JLabel boxesLabel = null;
    protected JLabel descLabel = null;
    protected JLabel urlLabel = null;
    protected ErrMsgPanel hostNotFound = null;
    protected ErrMsgPanel serverDown = null;
    protected ErrMsgPanel hostUnreachable = null;
    protected JLabel serverDescLabel = null;
    protected JLabel boxesDescLabel = null;
    protected VOptionPane optionPane = null;
    protected JPanel resultPanel = null;
    protected String seedServer = null;
    protected boolean netAccess = true;
    protected String host = null;
    protected Thread queryThread = null;
    protected Thread watchDog = null;

    public static ComponentUI createUI(JComponent jComponent) {
        return new ServerToolBoxChooserUI((ServerToolBoxChooser)((Object)jComponent));
    }

    public ServerToolBoxChooserUI(ToolBoxChooser toolBoxChooser) {
        this.chooser = toolBoxChooser;
        this.remoteHelp = ImplResourceManager.getString("OPENREMOTETOOLBOXHELP");
        this.remoteHelp = ContextHelpLoader.getContextHelp((String)this.remoteHelp, null);
        this.remoteTitle = ImplResourceManager.getString("Server Toolbox");
        this.installComponents(toolBoxChooser);
        toolBoxChooser.setUIReference(this);
    }

    public void setNetworkTimeout(int n) {
        netTimeout = n;
    }

    public void seedServer(String string) {
        this.seedServer = string;
        try {
            this.serverComboBox.addItem(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setLimitedNetworkAccess(boolean bl) {
        this.netAccess = bl;
        try {
            this.serverComboBox.setEnabled(this.netAccess);
            this.goButton.setEnabled(this.netAccess);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JComponent getResultPanel() {
        return this.resultPanel;
    }

    public String getHelpHTML() {
        return this.remoteHelp;
    }

    public String getTitle() {
        return this.remoteTitle;
    }

    public void installComponents(ToolBoxChooser toolBoxChooser) {
        toolBoxChooser.toggleContentTitle(false);
        toolBoxChooser.getContentPane();
        this.resultPanel = new JPanel();
        this.resultPanel.setLayout(new BoxLayout(this.resultPanel, 1));
        this.resultPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.serverLabel = new JLabel();
        jPanel.add(this.serverLabel);
        jPanel.add(Box.createHorizontalGlue());
        this.resultPanel.add(jPanel);
        this.resultPanel.add(Box.createVerticalStrut(3));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        this.serverDescLabel = new JLabel();
        jPanel2.add(this.serverDescLabel);
        jPanel2.add(Box.createHorizontalGlue());
        this.resultPanel.add(jPanel2);
        this.resultPanel.add(Box.createVerticalStrut(3));
        JPanel jPanel3 = new JPanel(){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
            }

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
            }
        };
        jPanel3.setLayout(new BorderLayout());
        this.serverComboBox = new JComboBox();
        this.serverComboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        this.serverComboBox.setAlignmentX(0.0f);
        this.serverComboBox.setAlignmentY(0.5f);
        this.serverComboBox.setEditable(true);
        this.serverComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServerToolBoxChooserUI.this.seedRemoteTBList(null);
            }
        });
        jPanel3.add((Component)this.serverComboBox, "Center");
        this.goButton = new JButton();
        this.goButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServerToolBoxChooserUI.this.seedRemoteTBList(null);
            }
        });
        jPanel3.add((Component)this.goButton, "East");
        this.resultPanel.add(jPanel3);
        this.resultPanel.add(Box.createVerticalStrut(5));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        this.boxesLabel = new JLabel();
        jPanel4.add(this.boxesLabel);
        jPanel4.add(Box.createHorizontalGlue());
        this.resultPanel.add(jPanel4);
        this.resultPanel.add(Box.createVerticalStrut(3));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        this.boxesDescLabel = new JLabel();
        jPanel5.add(this.boxesDescLabel);
        jPanel5.add(Box.createHorizontalGlue());
        this.resultPanel.add(jPanel5);
        this.resultPanel.add(Box.createVerticalStrut(3));
        this.resultPanel.add(this.createTBList());
        this.resultPanel.add(Box.createVerticalStrut(5));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 0));
        this.urlLabel = new JLabel();
        jPanel6.add(this.urlLabel);
        jPanel6.add(Box.createHorizontalGlue());
        this.resultPanel.add(jPanel6);
        this.resultPanel.add(Box.createVerticalStrut(5));
        this.remoteTBField = new JTextField(){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
            }

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
            }
        };
        this.remoteTBField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServerToolBoxChooserUI.this.handleURLEntry();
            }
        });
        this.resultPanel.add(this.remoteTBField);
        this.resultPanel.add(Box.createVerticalStrut(5));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BoxLayout(jPanel7, 0));
        this.descLabel = new JLabel();
        jPanel7.add(this.descLabel);
        jPanel7.add(Box.createHorizontalGlue());
        this.resultPanel.add(jPanel7);
        this.resultPanel.add(Box.createVerticalStrut(5));
        this.resultPanel.add(this.createDesc());
        this.resultPanel.add(Box.createVerticalStrut(10));
        this.resultPanel.add(Box.createVerticalGlue());
        this.approveButton = new JButton();
        this.approveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServerToolBoxChooserUI.this.approveSelection();
            }
        });
        this.approveButton.setEnabled(false);
        toolBoxChooser.getButtonPane().add(this.approveButton);
        toolBoxChooser.getButtonPane().add(Box.createHorizontalStrut(5));
        this.cancelButton = new JButton();
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServerToolBoxChooserUI.this.cancelSelection();
            }
        });
        toolBoxChooser.getButtonPane().add(this.cancelButton);
        this.hostNotFound = this.createHostNotFound();
        this.serverDown = this.createServerDown();
        this.hostUnreachable = this.createHostUnreachable();
        this.installStrings();
        toolBoxChooser.getContentPane().setLayout(new BorderLayout());
        toolBoxChooser.getContentPane().add((Component)this.resultPanel, "Center");
    }

    protected void approveSelection() {
        if (this.chooser != null) {
            this.chooser.approveSelection();
        }
    }

    protected void cancelSelection() {
        if (this.chooser != null) {
            this.chooser.cancelSelection();
        }
    }

    public void refreshDisplay() {
        try {
            this.serverComboBox.setEnabled(this.netAccess);
            this.goButton.setEnabled(this.netAccess);
            this.seedRemoteTBList(null);
            this.updateFontAndColor();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void installStrings() {
        AccessibleContext accessibleContext;
        this.serverLabel.setText(ImplResourceManager.getString("Server:"));
        this.serverLabel.setDisplayedMnemonic(ImplResourceManager.getString("Server:_mnemonic").charAt(0));
        this.serverLabel.setLabelFor(this.serverComboBox);
        this.serverDescLabel.setText(ImplResourceManager.getString("Select a server from list or enter server name and click Load button."));
        this.goButton.setText(ImplResourceManager.getString("Load"));
        this.goButton.setToolTipText(ImplResourceManager.getString("Load_tooltip"));
        this.goButton.setMnemonic(ImplResourceManager.getString("Load_mnemonic").charAt(0));
        this.goButton.getAccessibleContext().setAccessibleName(ImplResourceManager.getString("Load_accessible_name"));
        this.boxesLabel.setText(ImplResourceManager.getString("Toolboxes:"));
        this.boxesLabel.setDisplayedMnemonic(ImplResourceManager.getString("Toolboxes:_mnemonic").charAt(0));
        this.boxesLabel.setLabelFor(this.tbList);
        this.boxesDescLabel.setText(ImplResourceManager.getString("Select a toolbox from the list below and click Open button."));
        this.descLabel.setText(ImplResourceManager.getString("Description:"));
        this.descLabel.setDisplayedMnemonic(ImplResourceManager.getString("Description:_mnemonic").charAt(0));
        this.descLabel.setLabelFor(this.description);
        this.urlLabel.setText(ImplResourceManager.getString("URL:"));
        this.urlLabel.setDisplayedMnemonic(ImplResourceManager.getString("URL:_mnemonic").charAt(0));
        this.urlLabel.setLabelFor(this.remoteTBField);
        if (this.chooser.getDialogType() == 0) {
            this.approveButton.setText(ImplResourceManager.getString("OPEN_BUTTON"));
            this.approveButton.setToolTipText(ImplResourceManager.getString("OPEN_BUTTON_tooltip"));
            this.approveButton.setMnemonic(ImplResourceManager.getString("OPEN_BUTTON_mnemonic").charAt(0));
            accessibleContext = this.approveButton.getAccessibleContext();
            accessibleContext.setAccessibleName(ImplResourceManager.getString("OPEN_BUTTON_access_name"));
            accessibleContext.setAccessibleDescription(ImplResourceManager.getString("OPEN_BUTTON_access_desc"));
        } else {
            this.approveButton.setText(ImplResourceManager.getString("SAVE_BUTTON"));
            this.approveButton.setToolTipText(ImplResourceManager.getString("SAVE_BUTTON_tooltip"));
            this.approveButton.setMnemonic(ImplResourceManager.getString("SAVE_BUTTON_mnemonic").charAt(0));
            accessibleContext = this.approveButton.getAccessibleContext();
            accessibleContext.setAccessibleName(ImplResourceManager.getString("SAVE_BUTTON_access_name"));
            accessibleContext.setAccessibleDescription(ImplResourceManager.getString("SAVE_BUTTON_access_desc"));
        }
        this.cancelButton.setText(ImplResourceManager.getString("CANCEL_BUTTON"));
        this.cancelButton.setToolTipText(ImplResourceManager.getString("CANCEL_BUTTON_tooltip"));
        this.cancelButton.setMnemonic(ImplResourceManager.getString("CANCEL_BUTTON_mnemonic").charAt(0));
        accessibleContext = this.cancelButton.getAccessibleContext();
        accessibleContext.setAccessibleName(ImplResourceManager.getString("CANCEL_BUTTON_access_name"));
        accessibleContext.setAccessibleDescription(ImplResourceManager.getString("CANCEL_BUTTON_access_desc"));
    }

    protected void updateFontAndColor() {
        this.serverLabel.setFont(ResourceManager.labelFont);
        this.serverLabel.setForeground(ResourceManager.labelColor);
        this.serverDescLabel.setFont(ResourceManager.bodyFont);
        this.serverDescLabel.setForeground(ResourceManager.bodyColor);
        this.serverComboBox.setFont(ResourceManager.bodyFont);
        this.serverComboBox.setForeground(ResourceManager.bodyColor);
        this.goButton.setFont(ResourceManager.menuFont);
        this.goButton.setForeground(ResourceManager.menuColor);
        this.boxesLabel.setFont(ResourceManager.labelFont);
        this.boxesLabel.setForeground(ResourceManager.labelColor);
        this.boxesDescLabel.setFont(ResourceManager.bodyFont);
        this.boxesDescLabel.setForeground(ResourceManager.bodyColor);
        this.tbList.setFont(ResourceManager.bodyFont);
        this.tbList.setForeground(ResourceManager.bodyColor);
        this.urlLabel.setFont(ResourceManager.labelFont);
        this.urlLabel.setForeground(ResourceManager.labelColor);
        this.remoteTBField.setFont(ResourceManager.bodyFont);
        this.remoteTBField.setForeground(ResourceManager.bodyColor);
        this.descLabel.setFont(ResourceManager.labelFont);
        this.descLabel.setForeground(ResourceManager.labelColor);
        this.description.setFont(ResourceManager.bodyFont);
        this.description.setForeground(ResourceManager.bodyColor);
        this.approveButton.setFont(ResourceManager.menuFont);
        this.approveButton.setForeground(ResourceManager.menuColor);
        this.cancelButton.setFont(ResourceManager.menuFont);
        this.cancelButton.setForeground(ResourceManager.menuColor);
    }

    protected JPanel createTBList() {
        JPanel jPanel = new JPanel(new BorderLayout()){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, 80);
            }
        };
        this.tbList = new JList();
        this.tbList.setCellRenderer(new TBRenderer());
        this.tbList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ServerToolBoxChooserUI.this.handleTBListSelection();
            }
        });
        this.tbList.addMouseListener(this.createDoubleClickListener(this.chooser, this.tbList));
        this.tbListPane = new JScrollPane(this.tbList);
        jPanel.add((Component)this.tbListPane, "Center");
        return jPanel;
    }

    protected JPanel createDesc() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.description = new JTextArea(){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, 80);
            }
        };
        this.description.setEditable(false);
        this.description.setBackground(Color.lightGray);
        this.description.setLineWrap(true);
        this.description.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(this.description);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    protected ErrMsgPanel createHostNotFound() {
        return new ErrMsgPanel(0);
    }

    protected ErrMsgPanel createServerDown() {
        return new ErrMsgPanel(1);
    }

    protected ErrMsgPanel createHostUnreachable() {
        return new ErrMsgPanel(2);
    }

    protected MouseListener createDoubleClickListener(ToolBoxChooser toolBoxChooser, JList jList) {
        return new DoubleClickListener(jList);
    }

    public void setApproveButtonText(String string) {
    }

    public void setOptionPane(VOptionPane vOptionPane) {
        if (vOptionPane == null) {
            return;
        }
        this.optionPane = vOptionPane;
        vOptionPane.setTitle(this.remoteTitle);
        vOptionPane.setHelpHTML(this.remoteHelp);
    }

    protected void seedRemoteTBList(String string) {
        try {
            if (this.queryThread != null && this.queryThread.isAlive()) {
                return;
            }
            if (string == null) {
                string = (String)this.serverComboBox.getSelectedItem();
            }
            if (string == null) {
                return;
            }
            this.chooser.showBusyState(true);
            this.remoteTBField.setText("");
            this.description.setText("");
            this.tbList.setModel(new DefaultListModel());
            this.tbListPane.setViewportView(this.tbList);
            this.chooser.getContentPane().validate();
            this.chooser.getContentPane().repaint();
            this.host = string;
            this.queryThread = new Thread(this);
            this.queryThread.start();
            this.watchDog = new Thread(new Runnable(){

                public void run() {
                    try {
                        Thread.currentThread();
                        Thread.sleep(netTimeout);
                        if (!ServerToolBoxChooserUI.this.queryThread.isAlive()) {
                            return;
                        }
                        ServerToolBoxChooserUI.this.queryThread.interrupt();
                        ServerToolBoxChooserUI.this.tbList.setModel(new DefaultListModel());
                        ServerToolBoxChooserUI.this.remoteTBField.setText("");
                        ServerToolBoxChooserUI.this.description.setText("");
                        ServerToolBoxChooserUI.this.chooser.showBusyState(false);
                    }
                    catch (Throwable throwable) {
                        Debug.trace((String)"TB Chooser", (int)Debug.WARNING, (String)"Watchdog interrupt", (Throwable)throwable);
                    }
                }
            });
            this.watchDog.start();
        }
        catch (Throwable throwable) {
            Debug.trace((String)"TB Chooser", (int)Debug.WARNING, (String)"Unexpected error", (Throwable)throwable);
        }
    }

    public void run() {
        try {
            Thread.currentThread();
            Thread.sleep(1500L);
            int n = ManagerUtility.parsePortFromString(this.host);
            if (n < 0) {
                n = 898;
            }
            this.host = ManagerUtility.parseHostFromString(this.host);
            InetAddress inetAddress = InetAddress.getByName(this.host);
            Locale locale = ResourceManager.currentLocale;
            if (locale == null) {
                locale = Locale.getDefault();
            }
            URL uRL = new URL("http://" + this.host + ":" + n + "/toolboxes/");
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setRequestProperty("Locale", locale.toString());
            ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(uRLConnection.getInputStream()));
            Object object = objectInputStream.readObject();
            VConfigurationInfo[] vConfigurationInfoArray = (VConfigurationInfo[])object;
            int n2 = 0;
            while (n2 < vConfigurationInfoArray.length) {
                vConfigurationInfoArray[n2].setURL(ServerToolBoxChooserUI.cleanURL(vConfigurationInfoArray[n2].getURL()));
                ++n2;
            }
            this.tbListPane.setViewportView(this.tbList);
            this.tbList.setModel(new TBListModel(vConfigurationInfoArray));
            this.remoteTBField.setText("");
            this.description.setText("");
        }
        catch (UnknownHostException unknownHostException) {
            Debug.trace((String)"TB Chooser", (int)Debug.WARNING, (String)"Unknown Host", (Throwable)unknownHostException);
            this.tbList.setModel(new DefaultListModel());
            this.remoteTBField.setText("");
            this.description.setText("");
            this.tbListPane.setViewportView(this.hostNotFound);
        }
        catch (IOException iOException) {
            Debug.trace((String)"TB Chooser", (int)Debug.WARNING, (String)"Server Not Running", (Throwable)iOException);
            this.tbList.setModel(new DefaultListModel());
            this.remoteTBField.setText("");
            this.description.setText("");
            this.tbListPane.setViewportView(this.serverDown);
        }
        catch (Throwable throwable) {
            Debug.trace((String)"TB Chooser", (int)Debug.WARNING, (String)"Query interrupt", (Throwable)throwable);
            this.tbList.setModel(new DefaultListModel());
            this.remoteTBField.setText("");
            this.description.setText("");
            this.tbListPane.setViewportView(this.hostUnreachable);
        }
        try {
            if (this.watchDog != null && this.watchDog.isAlive()) {
                this.watchDog.interrupt();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.chooser.getContentPane().validate();
        this.chooser.getContentPane().repaint();
        this.chooser.showBusyState(false);
    }

    protected static URL cleanURL(URL uRL) {
        try {
            String string = uRL.toString();
            int n = string.indexOf("//");
            int n2 = string.indexOf(":", n + 2);
            if (n2 == -1) {
                n2 = string.indexOf("/", n + 2);
            }
            String string2 = string.substring(n + 2, n2);
            string2 = InetAddress.getByName(string2).getHostName();
            String string3 = string.substring(0, n + 2) + string2;
            string3 = string3 + string.substring(n2, string.length());
            return new URL(string3);
        }
        catch (Throwable throwable) {
            return uRL;
        }
    }

    protected void handleTBListSelection() {
        try {
            if (this.tbList.isSelectionEmpty()) {
                return;
            }
            VConfigurationInfo vConfigurationInfo = (VConfigurationInfo)this.tbList.getSelectedValue();
            this.remoteTBField.setText(ConfigManagement.aliasifyURL(vConfigurationInfo.getURL()).toString());
            this.description.setText(vConfigurationInfo.getDescription());
            this.approveButton.setEnabled(true);
            this.chooser.setToolBoxURL(vConfigurationInfo.getURL());
        }
        catch (Throwable throwable) {
            this.remoteTBField.setText("");
            this.tbList.setModel(new DefaultListModel());
            this.description.setText("");
            this.approveButton.setEnabled(false);
            this.chooser.setToolBoxURL(null);
        }
    }

    protected void handleURLEntry() {
        try {
            URL uRL = new URL(this.remoteTBField.getText());
            uRL = ConfigManagement.unaliasifyURL(uRL);
            VBaseConfiguration vBaseConfiguration = VBaseConfiguration.createConfiguration(uRL, ResourceManager.currentLocale);
            this.chooser.setToolBoxURL(uRL);
            this.chooser.approveSelection();
        }
        catch (Throwable throwable) {
            Debug.trace((String)"ConsoleManager", (int)Debug.ERROR, (String)"Problem loading toolbox", (Throwable)throwable);
            this.remoteTBField.setText("");
            this.tbList.setModel(new DefaultListModel());
            this.description.setText("");
            this.approveButton.setEnabled(false);
            this.chooser.setToolBoxURL(null);
        }
    }

    protected JButton getApproveButton(ToolBoxChooser toolBoxChooser) {
        return this.approveButton;
    }

    class ErrMsgPanel
    extends JPanel {
        protected JLabel title = null;
        protected JTextArea desc = null;
        protected ImageIcon errIcon = null;
        protected int type = 0;

        public ErrMsgPanel(int n) {
            if (n < 0 || n > 2) {
                n = 0;
            }
            this.type = n;
            this.setLayout(new BorderLayout());
            this.setBorder(new EmptyBorder(5, 5, 5, 5));
            JPanel jPanel = new JPanel();
            jPanel.setBorder(new EmptyBorder(0, 0, 0, 5));
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            if (this.errIcon == null) {
                this.errIcon = ConsoleUtility.loadImageIcon((String)"images/Event_Err16.gif", this.getClass());
            }
            jPanel.add(new JLabel(this.errIcon));
            jPanel.add(Box.createVerticalGlue());
            this.add((Component)jPanel, "West");
            JPanel jPanel2 = new JPanel(new BorderLayout());
            this.title = new JLabel();
            jPanel2.add((Component)this.title, "North");
            this.desc = new JTextArea();
            jPanel2.add((Component)this.desc, "Center");
            this.desc.setEditable(false);
            this.desc.setOpaque(false);
            this.desc.setLineWrap(true);
            this.desc.setWrapStyleWord(true);
            this.add((Component)jPanel2, "Center");
            this.installStrings();
        }

        protected void installStrings() {
            if (this.type == 0) {
                this.title.setText(ImplResourceManager.getString("Host Not Found"));
                this.desc.setText(ImplResourceManager.getString("NoServerFound"));
            } else if (this.type == 1) {
                this.title.setText(ImplResourceManager.getString("Server Not Running"));
                this.desc.setText(ImplResourceManager.getString("NoServerOnHost"));
            } else if (this.type == 2) {
                this.title.setText(ImplResourceManager.getString("Connection Timeout"));
                this.desc.setText(ImplResourceManager.getString("ConnectionTimeout"));
            }
        }
    }

    protected class TBListModel
    implements ListModel {
        protected VConfigurationInfo[] infoList = null;

        public TBListModel(VConfigurationInfo[] vConfigurationInfoArray) {
            this.infoList = vConfigurationInfoArray;
        }

        public void addListDataListener(ListDataListener listDataListener) {
        }

        public Object getElementAt(int n) {
            return this.infoList[n];
        }

        public int getSize() {
            return this.infoList.length;
        }

        public void removeListDataListener(ListDataListener listDataListener) {
        }
    }

    protected class TBRenderer
    extends DefaultListCellRenderer {
        protected TBRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            VConfigurationInfo vConfigurationInfo = (VConfigurationInfo)object;
            this.setText(vConfigurationInfo.getName());
            this.setIcon(ConsoleUtility.loadImageIcon((URL)vConfigurationInfo.getSmallIcon(), (String)""));
            return this;
        }
    }

    protected class DoubleClickListener
    extends MouseAdapter {
        JList list;

        public DoubleClickListener(JList jList) {
            this.list = jList;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            try {
                if (mouseEvent.getClickCount() == 2) {
                    int n = this.list.locationToIndex(mouseEvent.getPoint());
                    Object e = this.list.getModel().getElementAt(n);
                    VConfigurationInfo vConfigurationInfo = (VConfigurationInfo)e;
                    ServerToolBoxChooserUI.this.chooser.setToolBoxURL(vConfigurationInfo.getURL());
                    ServerToolBoxChooserUI.this.chooser.approveSelection();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

