/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.apps.common;

import com.sun.wbem.apps.common.Constants;
import com.sun.wbem.apps.common.Constraints;
import com.sun.wbem.apps.common.FlowArea;
import com.sun.wbem.apps.common.I18N;
import com.sun.wbem.apps.common.Util;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ErrorDialog {
    private JDialog dialog;
    private String title = I18N.loadString("TTL_ERROR", "com.sun.wbem.apps.common.common");
    private static final ImageIcon errorIcon = Util.loadImageIcon("log-error.gif");
    private static final ImageIcon infoIcon = Util.loadImageIcon("log-info.gif");
    private JButton cancelBtn = new JButton(I18N.loadString("LBL_OK", "com.sun.wbem.apps.common.common"));
    private static final Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();

    public ErrorDialog(JFrame jFrame, String string) {
        this.createErrorDialog(jFrame, this.title, string, false);
    }

    public ErrorDialog(JFrame jFrame, String string, String string2) {
        this.createErrorDialog(jFrame, string, string2, false);
    }

    public ErrorDialog(JFrame jFrame, String string, String string2, boolean bl) {
        this.createErrorDialog(jFrame, string, string2, bl);
    }

    private void createErrorDialog(JFrame jFrame, String string, String string2, boolean bl) {
        this.dialog = new JDialog(jFrame, string, true);
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        SpecialKeyListener specialKeyListener = new SpecialKeyListener();
        this.dialog.addKeyListener(specialKeyListener);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(gridBagLayout);
        Constraints.constrain(jPanel, jPanel2, 0, 0, 1, 2, 3, 17, 0.0, 1.0, 5, 5, 5, 0);
        JLabel jLabel = this.getIconLabel(bl);
        Constraints.constrain(jPanel2, jLabel, 0, 0, 1, 1, 0, 17, 0.0, 0.0, 5, 5, 5, 5);
        JPanel jPanel3 = new JPanel();
        Constraints.constrain(jPanel2, jPanel3, 0, 1, 1, 1, 3, 17, 0.0, 1.0, 0, 0, 0, 0);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(gridBagLayout);
        Constraints.constrain(jPanel, jPanel4, 1, 0, 1, 1, 1, 17, 1.0, 1.0, 0, 0, 0, 0);
        FlowArea flowArea = new FlowArea(string2, 30, Constants.ERROR_DIALOG_FONT);
        flowArea.setSize(flowArea.getPreferredSize());
        Constraints.constrain(jPanel4, flowArea, 0, 0, 1, 1, 1, 17, 1.0, 1.0, 20, 10, 20, 20);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(gridBagLayout);
        Constraints.constrain(jPanel, jPanel5, 1, 1, 1, 1, 2, 17, 1.0, 0.0, 5, 5, 5, 5);
        jPanel3 = new JPanel();
        Constraints.constrain(jPanel5, jPanel3, 0, 0, 1, 1, 2, 17, 1.0, 0.0, 0, 0, 0, 0);
        this.cancelBtn.addActionListener(new CancelBtnListener());
        Constraints.constrain(jPanel5, this.cancelBtn, 1, 0, 1, 1, 0, 17, 0.0, 0.0, 5, 5, 5, 5);
        this.dialog.getContentPane().setLayout(gridBagLayout);
        Constraints.constrain(this.dialog.getContentPane(), jPanel, 0, 0, 1, 1, 1, 10, 1.0, 1.0, 0, 0, 0, 0);
        this.dialog.pack();
        this.dialog.setResizable(false);
        this.centerDialog();
        this.cancelBtn.requestFocus();
        this.dialog.setVisible(true);
    }

    private JLabel getIconLabel(boolean bl) {
        JLabel jLabel = bl ? new JLabel(infoIcon) : new JLabel(errorIcon);
        return jLabel;
    }

    public void centerDialog() {
        this.dialog.setLocation(ErrorDialog.screenSize.width / 2 - this.dialog.getSize().width / 2, ErrorDialog.screenSize.height / 2 - this.dialog.getSize().height / 2);
    }

    protected class SpecialKeyListener
    extends KeyAdapter {
        protected SpecialKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                ErrorDialog.this.cancelBtn.doClick();
            } else if (keyEvent.getKeyCode() == 27) {
                ErrorDialog.this.dialog.dispose();
            }
        }
    }

    protected class CancelBtnListener
    implements ActionListener {
        protected CancelBtnListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ErrorDialog.this.dialog.dispose();
        }
    }
}

