/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.apps.cimworkshop;

import com.sun.wbem.apps.cimworkshop.CIMTableTabbedPane;
import com.sun.wbem.apps.cimworkshop.InstanceActionPanel;
import com.sun.wbem.apps.common.AboutDialog;
import com.sun.wbem.apps.common.ActionString;
import com.sun.wbem.apps.common.CIMClientObject;
import com.sun.wbem.apps.common.I18N;
import com.sun.wbem.apps.common.ToolBarPanel;
import com.sun.wbem.apps.common.Util;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.wbem.cim.CIMClass;
import javax.wbem.client.CIMClient;

public class InstanceFrame
extends JFrame
implements WindowListener,
ActionListener {
    private CIMTableTabbedPane tablePane;
    InstanceActionPanel instancePanel;
    private JSplitPane desktop;
    private JButton btnDeleteInstance;
    private JButton btnSaveInstance;
    private JButton btnAddInstance;
    private JMenu mnuInstanceEditor;
    private JMenu mnuAction;
    private JMenu mnuProperties;
    private JMenu mnuMethods;
    private JMenu mnuHelp;
    private JMenuItem mnuExit;
    private JMenuItem mnuAddInstance;
    private JMenuItem mnuDeleteInstance;
    private JMenuItem mnuSaveInstance;
    private JMenuItem mnuAssocTraversal;
    private JMenuItem mnuRefresh;
    private JMenuItem mnuPropQualifiers;
    private JMenuItem mnuShowValue;
    private JMenuItem mnuMethodQualifiers;
    private JMenuItem mnuInvokeMethod;
    private JMenuItem mnuHelpAbout;

    public InstanceFrame(Frame frame, CIMClient cIMClient, CIMClass cIMClass) {
        this(frame, cIMClient, cIMClass, false);
    }

    public InstanceFrame(Frame frame, CIMClient cIMClient, CIMClass cIMClass, boolean bl) {
        this.setTitle(I18N.loadStringFormat("TTL_INSTANCES", cIMClass.getName()));
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout());
        this.desktop = new JSplitPane(1);
        this.tablePane = new CIMTableTabbedPane();
        this.instancePanel = new InstanceActionPanel(this.tablePane, this, cIMClass, bl);
        this.instancePanel.setPreferredSize(new Dimension(300, 200));
        this.tablePane.setPreferredSize(new Dimension(300, 200));
        this.desktop.setLeftComponent(this.instancePanel);
        this.desktop.setRightComponent(this.tablePane);
        jPanel.add("Center", this.desktop);
        this.createMenuBar();
        this.createToolBar(jPanel);
        this.instancePanel.refreshInstanceList();
        this.addWindowListener(this);
        this.setBounds(100, 100, 600, 400);
        this.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("EXIT")) {
            this.dispose();
        } else if (string.equals("ABOUT_INSTANCE_EDITOR")) {
            ActionString actionString = new ActionString("MNU_INSTANCE_EDITOR");
            String string2 = actionString.getString();
            String string3 = "2.5.0 04/02/07:20:26";
            AboutDialog aboutDialog = new AboutDialog(this, string2, string3, "Copyright 2001 Sun Microsystems, Inc.\nAll rights reserved.", "");
        }
    }

    private void createMenuBar() {
        boolean bl = CIMClientObject.userHasWritePermission();
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        ActionString actionString = new ActionString("MNU_INSTANCE_EDITOR");
        ActionString actionString2 = new ActionString("MNU_ACTION", "com.sun.wbem.apps.common.common");
        ActionString actionString3 = new ActionString("MNU_PROPERTIES");
        ActionString actionString4 = new ActionString("MNU_METHODS");
        ActionString actionString5 = new ActionString("MNU_HELP", "com.sun.wbem.apps.common.common");
        ActionString actionString6 = new ActionString("MNU_EXIT", "com.sun.wbem.apps.common.common");
        ActionString actionString7 = new ActionString("MNU_REFRESH", "com.sun.wbem.apps.common.common");
        ActionString actionString8 = new ActionString("MNU_ADD_INSTANCE");
        ActionString actionString9 = new ActionString("MNU_DELETE_INSTANCE");
        ActionString actionString10 = new ActionString("MNU_SAVE_INSTANCE");
        ActionString actionString11 = new ActionString("MNU_ASSOC_TRAVERSAL");
        ActionString actionString12 = new ActionString("MNU_QUALIFIERS");
        ActionString actionString13 = new ActionString("MNU_SHOW_VALUE");
        ActionString actionString14 = new ActionString("MNU_INVOKE_METHOD");
        ActionString actionString15 = new ActionString("MNU_ABOUT_INSTANCE_EDITOR");
        this.mnuInstanceEditor = new JMenu(actionString.getString());
        this.mnuInstanceEditor.setMnemonic(actionString.getMnemonic());
        this.mnuAction = new JMenu(actionString2.getString());
        this.mnuAction.setMnemonic(actionString2.getMnemonic());
        this.mnuProperties = new JMenu(actionString3.getString());
        this.mnuProperties.setMnemonic(actionString3.getMnemonic());
        this.mnuMethods = new JMenu(actionString4.getString());
        this.mnuMethods.setMnemonic(actionString4.getMnemonic());
        this.mnuHelp = new JMenu(actionString5.getString());
        this.mnuHelp.setMnemonic(actionString5.getMnemonic());
        jMenuBar.add(this.mnuInstanceEditor);
        jMenuBar.add(this.mnuAction);
        jMenuBar.add(this.mnuHelp);
        this.mnuExit = new JMenuItem(actionString6.getString());
        this.mnuExit.setMnemonic(actionString6.getMnemonic());
        this.mnuExit.setActionCommand("EXIT");
        this.mnuExit.addActionListener(this);
        this.mnuAddInstance = new JMenuItem(actionString8.getString());
        this.mnuAddInstance.setMnemonic(actionString8.getMnemonic());
        this.mnuAddInstance.setActionCommand("ADD_INSTANCE");
        this.mnuAddInstance.addActionListener(this.instancePanel);
        this.mnuAddInstance.setEnabled(bl);
        this.mnuAssocTraversal = new JMenuItem(actionString11.getString());
        this.mnuAssocTraversal.setMnemonic(actionString11.getMnemonic());
        this.mnuAssocTraversal.setActionCommand("ASSOC_TRAVERSAL");
        this.mnuAssocTraversal.addActionListener(this.instancePanel);
        this.mnuAssocTraversal.setEnabled(false);
        this.mnuDeleteInstance = new JMenuItem(actionString9.getString());
        this.mnuDeleteInstance.setMnemonic(actionString9.getMnemonic());
        this.mnuDeleteInstance.setActionCommand("DELETE_INSTANCE");
        this.mnuDeleteInstance.addActionListener(this.instancePanel);
        this.mnuDeleteInstance.setEnabled(false);
        this.mnuSaveInstance = new JMenuItem(actionString10.getString());
        this.mnuSaveInstance.setMnemonic(actionString10.getMnemonic());
        this.mnuSaveInstance.setActionCommand("SAVE_INSTANCE");
        this.mnuSaveInstance.addActionListener(this.instancePanel);
        this.mnuSaveInstance.setEnabled(false);
        this.mnuRefresh = new JMenuItem(actionString7.getString());
        this.mnuRefresh.setMnemonic(actionString7.getMnemonic());
        this.mnuRefresh.setActionCommand("REFRESH");
        this.mnuRefresh.addActionListener(this.instancePanel);
        this.mnuPropQualifiers = new JMenuItem(actionString12.getString());
        this.mnuPropQualifiers.setMnemonic(actionString12.getMnemonic());
        this.mnuPropQualifiers.setActionCommand("QUALIFIERS");
        this.mnuPropQualifiers.addActionListener(this.tablePane.getPropertiesTable());
        this.mnuShowValue = new JMenuItem(actionString13.getString());
        this.mnuShowValue.setMnemonic(actionString13.getMnemonic());
        this.mnuShowValue.setActionCommand("SHOW_VALUE");
        this.mnuShowValue.addActionListener(this.tablePane.getPropertiesTable());
        this.mnuMethodQualifiers = new JMenuItem(actionString12.getString());
        this.mnuMethodQualifiers.setMnemonic(actionString12.getMnemonic());
        this.mnuMethodQualifiers.setActionCommand("QUALIFIERS");
        this.mnuMethodQualifiers.addActionListener(this.tablePane.getMethodsTable());
        this.mnuInvokeMethod = new JMenuItem(actionString14.getString());
        this.mnuInvokeMethod.setMnemonic(actionString14.getMnemonic());
        this.mnuInvokeMethod.setActionCommand("INVOKE_METHOD");
        this.mnuInvokeMethod.addActionListener(this.tablePane.getMethodsTable());
        this.mnuHelpAbout = new JMenuItem(actionString15.getString());
        this.mnuHelpAbout.setMnemonic(actionString15.getMnemonic());
        this.mnuHelpAbout.setActionCommand("ABOUT_INSTANCE_EDITOR");
        this.mnuHelpAbout.addActionListener(this);
        this.mnuInstanceEditor.add(this.mnuExit);
        this.mnuAction.add(this.mnuAddInstance);
        this.mnuAction.add(this.mnuDeleteInstance);
        this.mnuAction.add(this.mnuSaveInstance);
        this.mnuAction.addSeparator();
        this.mnuAction.add(this.mnuProperties);
        this.mnuAction.add(this.mnuMethods);
        this.mnuAction.addSeparator();
        this.mnuAction.add(this.mnuAssocTraversal);
        this.mnuAction.addSeparator();
        this.mnuAction.add(this.mnuRefresh);
        this.mnuProperties.add(this.mnuPropQualifiers);
        this.mnuProperties.add(this.mnuShowValue);
        this.mnuMethods.add(this.mnuMethodQualifiers);
        this.mnuMethods.add(this.mnuInvokeMethod);
        this.mnuHelp.add(this.mnuHelpAbout);
    }

    private void createToolBar(JPanel jPanel) {
        ToolBarPanel toolBarPanel = new ToolBarPanel();
        this.btnAddInstance = toolBarPanel.createButton(Util.loadImageIcon("instances.gif"), I18N.loadString("TIP_ADD_INSTANCE"), "ADD_INSTANCE", this.instancePanel);
        this.btnAddInstance.setEnabled(CIMClientObject.userHasWritePermission());
        this.btnDeleteInstance = toolBarPanel.createButton(Util.loadImageIcon("delete.gif"), I18N.loadString("TIP_DELETE_INSTANCE"), "DELETE_INSTANCE", this.instancePanel);
        this.btnDeleteInstance.setEnabled(false);
        this.btnSaveInstance = toolBarPanel.createButton(Util.loadImageIcon("save.gif"), I18N.loadString("TIP_SAVE_INSTANCE"), "SAVE_INSTANCE", this.instancePanel);
        this.btnSaveInstance.setEnabled(false);
        toolBarPanel.createButton(Util.loadImageIcon("refresh.gif"), I18N.loadString("TIP_REFRESH_INSTANCES"), "REFRESH", this.instancePanel);
        jPanel.add("North", toolBarPanel);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (this.btnSaveInstance.isEnabled()) {
            this.instancePanel.saveCurrentInstance(true);
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
        this.desktop.setDividerLocation(0.4);
    }

    public void enableDeleteInstanceMenu(boolean bl) {
        this.mnuDeleteInstance.setEnabled(bl);
        this.btnDeleteInstance.setEnabled(bl);
    }

    public void enableSaveInstanceMenu(boolean bl) {
        this.mnuSaveInstance.setEnabled(bl);
        this.btnSaveInstance.setEnabled(bl);
    }

    public void enableAssocMenu(boolean bl) {
        this.mnuAssocTraversal.setEnabled(bl);
    }

    public void enablePropMenu(boolean bl) {
        boolean bl2 = bl && this.tablePane.isPropertySelected();
        boolean bl3 = bl && this.tablePane.isMethodSelected();
        this.mnuPropQualifiers.setEnabled(bl2);
        this.mnuShowValue.setEnabled(bl2);
        this.mnuMethodQualifiers.setEnabled(bl3);
        this.mnuInvokeMethod.setEnabled(bl3);
    }
}

