/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.apps.cimworkshop;

import com.sun.wbem.apps.common.ActionString;
import com.sun.wbem.apps.common.CIMClientObject;
import com.sun.wbem.apps.common.CIMErrorDialog;
import com.sun.wbem.apps.common.I18N;
import com.sun.wbem.apps.common.Util;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Stack;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.client.CIMClient;

public class ClassTreePane
extends JScrollPane
implements ActionListener,
TreeSelectionListener,
TreeExpansionListener,
MouseListener {
    protected JTree tree;
    protected DefaultTreeSelectionModel selectionModel;
    protected DefaultTreeModel treeModel;
    protected JComboBox objectBox;
    protected JScrollPane thisPane = this;
    protected CIMClient cimClient = null;
    protected RootTreeNode root;
    protected JPopupMenu popupMenu = new JPopupMenu();
    protected JPopupMenu rootPopupMenu = new JPopupMenu();
    protected ImageIcon classIcon;

    public ClassTreePane() {
        Object object;
        this.root = new RootTreeNode(new CIMObjectPath());
        this.treeModel = new DefaultTreeModel(this.root);
        this.tree = new JTree(this.treeModel);
        this.tree.addTreeSelectionListener(this);
        this.tree.addTreeExpansionListener(this);
        this.tree.addMouseListener(this);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setRootVisible(true);
        this.tree.setBorder(BorderFactory.createBevelBorder(1));
        this.selectionModel = (DefaultTreeSelectionModel)this.tree.getSelectionModel();
        this.classIcon = Util.loadImageIcon("class.gif");
        TreeCellRenderer treeCellRenderer = this.tree.getCellRenderer();
        if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
            object = new CustomBasicRenderer();
            this.tree.setCellRenderer((TreeCellRenderer)object);
        }
        object = new ActionString("LBL_CLASS_SCHEMA");
        JLabel jLabel = new JLabel(((ActionString)object).getString() + ":");
        jLabel.setDisplayedMnemonic(((ActionString)object).getMnemonic());
        this.setTreeLabel(jLabel);
        this.setViewportView(this.tree);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.tree.scrollPathToVisible(treeSelectionEvent.getPath());
    }

    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.tree.addTreeSelectionListener(treeSelectionListener);
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        ClassTreeNode classTreeNode = (ClassTreeNode)treePath.getLastPathComponent();
        if (!classTreeNode.isExplored()) {
            Cursor cursor = this.getCursor();
            Util.setWaitCursor(this);
            this.exploreNode(classTreeNode);
            Util.setCursor(this, cursor);
        }
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }

    public ClassTreeNode getSelectedNode() {
        if (this.tree.getSelectionPath() == null) {
            return null;
        }
        return (ClassTreeNode)this.tree.getSelectionPath().getLastPathComponent();
    }

    public String getSelectedNodeString() {
        ClassTreeNode classTreeNode = this.getSelectedNode();
        if (classTreeNode == null) {
            return null;
        }
        return classTreeNode.toString();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Util.setWaitCursor(this);
        String string = actionEvent.getActionCommand();
        if (string.equals("FIND_CLASS")) {
            String string2 = JOptionPane.showInputDialog(this, (Object)I18N.loadString("ASK_FIND_CLASS"));
            if (string2 != null && !string2.equals("")) {
                Stack stack = new Stack();
                Util.setWaitCursor(this);
                if (this.findClass(new CIMObjectPath(""), string2, stack)) {
                    Stack stack2 = (Stack)stack.clone();
                    if (!this.selectNode(stack2)) {
                        this.refreshTree(this.root);
                        if (!this.selectNode(stack)) {
                            // empty if block
                        }
                    }
                } else {
                    JOptionPane.showMessageDialog(this, I18N.loadStringFormat("ERR_FIND_CLASS", string2), I18N.loadString("TTL_CIM_ERROR"), 1);
                }
                Util.setDefaultCursor(this);
            }
        } else if (string.equals("REFRESH")) {
            this.refreshTree(this.getSelectedNode());
        }
        Util.setDefaultCursor(this);
    }

    private void exploreNode(ClassTreeNode classTreeNode) {
        Enumeration enumeration = classTreeNode.getChildList();
        if (enumeration == null) {
            classTreeNode.setChildList();
            enumeration = classTreeNode.getChildList();
        }
        if (!classTreeNode.isExplored() && enumeration != null) {
            int n = 0;
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
            while (enumeration.hasMoreElements()) {
                CIMObjectPath cIMObjectPath = (CIMObjectPath)enumeration.nextElement();
                ClassTreeNode classTreeNode2 = new ClassTreeNode(cIMObjectPath);
                defaultTreeModel.insertNodeInto(classTreeNode2, classTreeNode, n++);
            }
            classTreeNode.setExplored();
        }
    }

    protected void generateTree(ClassTreeNode classTreeNode) {
        this.cleanTree(classTreeNode);
        this.exploreNode(classTreeNode);
    }

    protected void cleanTree(ClassTreeNode classTreeNode) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        TreePath treePath = new TreePath(classTreeNode.getPath());
        this.tree.setSelectionPath(treePath);
        while (defaultTreeModel.getChildCount(classTreeNode) > 0) {
            ClassTreeNode classTreeNode2 = (ClassTreeNode)defaultTreeModel.getChild(classTreeNode, 0);
            defaultTreeModel.removeNodeFromParent(classTreeNode2);
        }
        classTreeNode.clear();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showPopupMenu(mouseEvent.getPoint());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showPopupMenu(mouseEvent.getPoint());
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showPopupMenu(mouseEvent.getPoint());
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    protected void showPopupMenu(Point point) {
        TreePath treePath = this.tree.getPathForLocation(point.x, point.y);
        if (treePath == null) {
            return;
        }
        this.tree.setSelectionPath(treePath);
        JPopupMenu jPopupMenu = this.getSelectedNode() == this.root ? this.rootPopupMenu : this.popupMenu;
        Point point2 = this.getViewport().getViewPosition();
        jPopupMenu.show(this, point.x - point2.x + 10, point.y - point2.y);
    }

    protected void deleteSelectedNode() {
        ClassTreeNode classTreeNode = this.getSelectedNode();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        ClassTreeNode classTreeNode2 = (ClassTreeNode)classTreeNode.getParent();
        ClassTreeNode classTreeNode3 = (ClassTreeNode)classTreeNode2.getChildBefore(classTreeNode);
        if (classTreeNode3 == null) {
            classTreeNode3 = (ClassTreeNode)classTreeNode2.getChildAfter(classTreeNode);
        }
        if (classTreeNode3 == null) {
            classTreeNode3 = classTreeNode2;
            classTreeNode2.setLeaf(true);
        }
        TreePath treePath = new TreePath(classTreeNode3.getPath());
        this.tree.setSelectionPath(treePath);
        defaultTreeModel.removeNodeFromParent(classTreeNode);
        defaultTreeModel.reload(classTreeNode2);
        this.tree.expandPath(treePath);
        this.tree.setSelectionPath(treePath);
    }

    public boolean isRootSelected() {
        return this.getSelectedNode() instanceof RootTreeNode;
    }

    public void setTreeLabel(JLabel jLabel) {
        this.setColumnHeaderView(jLabel);
        jLabel.setLabelFor(this.tree);
    }

    protected boolean findClass(CIMObjectPath cIMObjectPath, String string, Stack stack) {
        stack.push(cIMObjectPath);
        if (cIMObjectPath.getObjectName().equalsIgnoreCase(string)) {
            return true;
        }
        try {
            Enumeration enumeration = this.cimClient.enumerateClassNames(cIMObjectPath, false);
            while (enumeration.hasMoreElements()) {
                CIMObjectPath cIMObjectPath2 = (CIMObjectPath)enumeration.nextElement();
                if (!this.findClass(cIMObjectPath2, string, stack)) continue;
                return true;
            }
        }
        catch (CIMException cIMException) {
            // empty catch block
        }
        stack.pop();
        return false;
    }

    public void refreshTree() {
        this.cimClient = CIMClientObject.getClient();
        this.root.setLabel(CIMClientObject.getNameSpace());
        this.tree.setSelectionRow(0);
        this.refreshTree(this.root);
    }

    public void refreshTree(ClassTreeNode classTreeNode) {
        this.generateTree(classTreeNode);
        this.tree.expandPath(new TreePath(classTreeNode));
        this.tree.repaint();
    }

    public void refreshSelectedNode() {
        this.refreshTree(this.getSelectedNode());
    }

    protected boolean selectNode(Stack stack) {
        Object object;
        stack.removeElementAt(0);
        boolean bl = false;
        ClassTreeNode classTreeNode = this.root;
        int n = 0;
        while (n < stack.size()) {
            bl = false;
            object = ((CIMObjectPath)stack.elementAt(n)).getObjectName();
            Enumeration<TreeNode> enumeration = classTreeNode.children();
            while (enumeration.hasMoreElements()) {
                classTreeNode = (ClassTreeNode)enumeration.nextElement();
                if (!((String)object).equals(classTreeNode.toString())) continue;
                bl = true;
                break;
            }
            this.exploreNode(classTreeNode);
            ++n;
        }
        if (bl) {
            object = new TreePath(classTreeNode.getPath());
            this.tree.setSelectionPath((TreePath)object);
            this.tree.expandPath((TreePath)object);
        }
        return bl;
    }

    public ClassTreeNode addNodeToSelected(String string) {
        ClassTreeNode classTreeNode = new ClassTreeNode(new CIMObjectPath(string));
        return this.addNodeToSelected(classTreeNode);
    }

    public ClassTreeNode addNodeToSelected(ClassTreeNode classTreeNode) {
        ClassTreeNode classTreeNode2 = this.getSelectedNode();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        Enumeration<TreeNode> enumeration = classTreeNode2.children();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            if (classTreeNode.toString().compareToIgnoreCase(enumeration.nextElement().toString()) < 0) break;
            ++n;
        }
        defaultTreeModel.insertNodeInto(classTreeNode, classTreeNode2, n);
        classTreeNode2.setLeaf(false);
        return classTreeNode;
    }

    class RootTreeNode
    extends ClassTreeNode {
        private String label = "root";

        public RootTreeNode(CIMObjectPath cIMObjectPath) {
            super(cIMObjectPath);
        }

        public void setLabel(String string) {
            this.label = string;
        }

        public String toString() {
            return this.label;
        }
    }

    class ClassTreeNode
    extends DefaultMutableTreeNode {
        protected boolean explored = false;
        protected boolean leaf = false;
        protected Enumeration childList = null;

        public ClassTreeNode() {
        }

        public ClassTreeNode(CIMObjectPath cIMObjectPath) {
            this.setUserObject(cIMObjectPath);
            this.setChildList();
        }

        public void clear() {
            this.explored = false;
            this.childList = null;
        }

        public CIMObjectPath getObjectPath() {
            return (CIMObjectPath)this.getUserObject();
        }

        public String toString() {
            CIMObjectPath cIMObjectPath = (CIMObjectPath)this.getUserObject();
            return cIMObjectPath.getObjectName().toString();
        }

        public boolean isLeaf() {
            return this.leaf;
        }

        public void setLeaf(boolean bl) {
            this.leaf = bl;
        }

        public boolean isExplored() {
            return this.explored;
        }

        public void setExplored() {
            this.explored = true;
        }

        public void setExplored(boolean bl) {
            this.explored = bl;
        }

        public Enumeration getChildList() {
            return this.childList;
        }

        public void setChildList() {
            try {
                if (ClassTreePane.this.cimClient != null) {
                    Enumeration enumeration = ClassTreePane.this.cimClient.enumerateClassNames(this.getObjectPath(), false);
                    this.childList = Util.sortEnumeration(enumeration);
                    this.leaf = !this.childList.hasMoreElements();
                } else {
                    this.leaf = true;
                }
            }
            catch (CIMException cIMException) {
                CIMErrorDialog.display(ClassTreePane.this.thisPane, cIMException);
                return;
            }
        }
    }

    protected class CustomBasicRenderer
    extends DefaultTreeCellRenderer {
        protected CustomBasicRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                if (bl3 && n != 0) {
                    jLabel.setIcon(ClassTreePane.this.classIcon);
                }
            }
            return component;
        }
    }
}

