/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.apps.cimworkshop;

import com.sun.wbem.apps.cimworkshop.CIMTypes;
import com.sun.wbem.apps.cimworkshop.CIMValueDialog;
import com.sun.wbem.apps.common.ActionString;
import com.sun.wbem.apps.common.CIMClientObject;
import com.sun.wbem.apps.common.CancelObject;
import com.sun.wbem.apps.common.I18N;
import com.sun.wbem.apps.common.Util;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.cim.CIMQualifierType;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMClient;

public class CIMElementsTable
extends JScrollPane
implements ListSelectionListener,
TableModelListener,
MouseListener,
ActionListener,
KeyListener {
    public static final int PROPERTY_TABLE = 0;
    public static final int QUALIFIER_TABLE = 1;
    public static final int NON_EDITABLE = 0;
    public static final int EDITABLE = 1;
    public static final int ONLY_VALUE_EDITABLE = 2;
    protected JTable table;
    protected Vector tableHeading;
    protected Vector cimElements = null;
    protected CIMElement parentElement = null;
    protected ElementsDataModel elementsDataModel;
    protected String emptyString;
    protected boolean dataChanged = false;
    protected boolean isClass = false;
    protected boolean newElement = false;
    protected int tableType;
    protected CIMValue currentCIMValue;
    protected int accessState;
    protected JPopupMenu popupMenu;
    protected CIMClient cimClient;
    protected ImageIcon keyIcon;
    protected ImageIcon inheritedIcon;
    protected ImageIcon blankIcon;
    protected CIMTypes cimTypes;
    private final int INHERITED_COLUMN = 0;
    private final int KEY_COLUMN = 1;
    private int nameColumn;
    private int typeColumn;
    private int valueColumn;
    protected Vector uneditableRows;

    public CIMElementsTable() {
        this(1, 0, false);
    }

    public CIMElementsTable(int n) {
        this(0, n);
    }

    public CIMElementsTable(int n, boolean bl) {
        this(0, n, bl);
        if (bl) {
            this.accessState = 2;
        }
    }

    public CIMElementsTable(int n, int n2) {
        this(n, n2, false);
    }

    public CIMElementsTable(int n, int n2, boolean bl) {
        TableColumn tableColumn;
        this.accessState = n;
        this.tableType = n2;
        this.newElement = bl;
        this.nameColumn = this.tableType == 0 ? 2 : 0;
        this.typeColumn = this.nameColumn + 1;
        this.valueColumn = this.nameColumn + 2;
        this.uneditableRows = new Vector();
        this.cimTypes = new CIMTypes();
        this.emptyString = I18N.loadString("LBL_EMPTY");
        this.cimElements = new Vector();
        this.keyIcon = Util.loadImageIcon("key.gif");
        this.blankIcon = Util.loadImageIcon("blank.gif");
        this.inheritedIcon = Util.loadImageIcon("inherited.gif");
        this.popupMenu = new JPopupMenu();
        this.elementsDataModel = new ElementsDataModel();
        this.tableHeading = new Vector();
        if (this.tableType == 0) {
            this.tableHeading.addElement("");
            this.tableHeading.addElement("");
        }
        ActionString actionString = new ActionString("LBL_NAME", "com.sun.wbem.apps.common.common");
        ActionString actionString2 = new ActionString("LBL_TYPE");
        ActionString actionString3 = new ActionString("LBL_VALUE");
        this.tableHeading.addElement(actionString.getString());
        this.tableHeading.addElement(actionString2.getString());
        this.tableHeading.addElement(actionString3.getString());
        this.table = new JTable(this.elementsDataModel){

            public String getToolTipText(MouseEvent mouseEvent) {
                String string = "";
                Point point = mouseEvent.getPoint();
                int n = this.columnAtPoint(point);
                int n2 = this.rowAtPoint(point);
                if (n2 < 0 || n2 >= CIMElementsTable.this.elementsDataModel.getRowCount()) {
                    return "";
                }
                Object object = CIMElementsTable.this.elementsDataModel.getValueAt(n2, n);
                String string2 = CIMElementsTable.this.elementsDataModel.getValueAt(n2, CIMElementsTable.this.nameColumn).toString();
                if (n >= CIMElementsTable.this.nameColumn && n <= CIMElementsTable.this.valueColumn) {
                    string = object.toString();
                } else if (n == 0) {
                    string = object == CIMElementsTable.this.inheritedIcon ? I18N.loadStringFormat("MSG_PROP_INHERITED", string2) : I18N.loadStringFormat("MSG_PROP_NOT_INHERITED", string2);
                } else if (n == 1) {
                    string = object == CIMElementsTable.this.keyIcon ? I18N.loadStringFormat("MSG_PROP_KEY", string2) : I18N.loadStringFormat("MSG_PROP_NOT_KEY", string2);
                }
                return string;
            }
        };
        this.table.setBackground(this.getBackground());
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setCellSelectionEnabled(true);
        this.elementsDataModel.addTableModelListener(this);
        JTextField jTextField = new JTextField();
        JTextField jTextField2 = new JTextField();
        JTextField jTextField3 = new JTextField();
        JTextField jTextField4 = new JTextField();
        JTextField jTextField5 = new JTextField();
        if (this.tableType == 0) {
            tableColumn = this.table.getColumnModel().getColumn(0);
            TableColumn tableColumn2 = this.table.getColumnModel().getColumn(1);
            tableColumn.setMinWidth(20);
            tableColumn.setMaxWidth(20);
            tableColumn2.setMinWidth(20);
            tableColumn2.setMaxWidth(20);
            this.table.sizeColumnsToFit(0);
            tableColumn.setCellEditor(new DefaultCellEditor(jTextField2){

                public boolean isCellEditable(EventObject eventObject) {
                    return false;
                }
            });
            tableColumn2.setCellEditor(new DefaultCellEditor(jTextField){

                public boolean isCellEditable(EventObject eventObject) {
                    return false;
                }
            });
        }
        this.table.getColumnModel().getColumn(this.nameColumn).setCellEditor(new DefaultCellEditor(jTextField3){

            public boolean isCellEditable(EventObject eventObject) {
                return false;
            }
        });
        this.table.getColumnModel().getColumn(this.typeColumn).setCellEditor(new DefaultCellEditor(jTextField5){

            public boolean isCellEditable(EventObject eventObject) {
                return false;
            }
        });
        tableColumn = this.table.getColumnModel().getColumn(this.valueColumn);
        this.table.getColumnModel().getColumn(this.valueColumn).setCellEditor(new DefaultCellEditor(jTextField5){

            public boolean isCellEditable(EventObject eventObject) {
                return false;
            }
        });
        this.table.addKeyListener(this);
        this.table.addMouseListener(this);
        this.table.setPreferredScrollableViewportSize(new Dimension(300, 200));
        this.setViewportView(this.table);
    }

    public JTable getTable() {
        return this.table;
    }

    public void selectCell(int n, int n2) {
        this.table.clearSelection();
        this.table.addRowSelectionInterval(n, n);
        this.table.addColumnSelectionInterval(n2, n2);
    }

    public void selectValueCell(int n) {
        this.selectCell(n, this.valueColumn);
    }

    public void hideIconColumns() {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
        TableColumn tableColumn2 = this.table.getColumnModel().getColumn(1);
        tableColumnModel.removeColumn(tableColumn);
        tableColumnModel.removeColumn(tableColumn2);
        this.table.sizeColumnsToFit(0);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("SHOW_VALUE")) {
            this.showValue(false, this.table.getSelectedRow(), this.valueColumn);
        }
    }

    public void showValue() {
        this.showValue(false, this.table.getSelectedRow(), this.valueColumn);
    }

    public void showValue(boolean bl, int n, int n2) {
        Object object;
        boolean bl2 = false;
        if (bl) {
            bl2 = this.isCellEditable(n, n2);
        }
        String string = null;
        CIMDataType cIMDataType = null;
        Object object2 = null;
        CIMElement cIMElement = (CIMElement)this.cimElements.elementAt(this.getSelectedRow());
        string = cIMElement.getName();
        if (this.tableType == 0) {
            cIMDataType = ((CIMProperty)cIMElement).getType();
            object = ((CIMProperty)cIMElement).getValue();
            object2 = object != null ? object.getValue() : null;
        } else if (this.tableType == 1) {
            object = ((CIMQualifier)cIMElement).getValue();
            if (object != null) {
                cIMDataType = object.getType();
                object2 = object.getValue();
            } else {
                object2 = null;
            }
        }
        object = CIMValueDialog.showDialog(Util.getFrame(this.table), object2, string, cIMDataType, bl2);
        if (bl2 && !(object instanceof CancelObject)) {
            this.elementsDataModel.setValueAt(object, n, n2);
        }
    }

    public void setUneditableRows(Vector vector) {
        this.uneditableRows = vector;
    }

    public void addTableListener(TableModelListener tableModelListener) {
        this.elementsDataModel.addTableModelListener(tableModelListener);
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.table.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    protected void setParentElement(CIMElement cIMElement) {
        this.parentElement = cIMElement;
    }

    protected void deleteElement(int n) {
        if (this.tableType == 0) {
            CIMProperty cIMProperty = (CIMProperty)this.cimElements.elementAt(n);
        } else if (this.tableType == 1) {
            CIMQualifier cIMQualifier = (CIMQualifier)this.cimElements.elementAt(n);
        }
    }

    public int getSelectedRow() {
        return this.table.getSelectedRow();
    }

    public int getSelectedColumn() {
        return this.table.getSelectedColumn();
    }

    public boolean isNameDefined(String string) {
        if (string != null) {
            int n = 0;
            while (n < this.cimElements.size()) {
                String string2 = (String)this.elementsDataModel.getValueAt(n, this.nameColumn);
                if (string.equalsIgnoreCase(string2)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (this.table.getSelectedColumn() == this.valueColumn && keyEvent.getKeyChar() == ' ') {
            this.showValue(true, this.table.getSelectedRow(), this.valueColumn);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
    }

    public boolean isSelectionEmpty() {
        return this.table == null || this.table.getSelectedRow() < 0;
    }

    protected void createPopupMenu(Point point) {
        int n = this.table.rowAtPoint(point);
        this.table.setRowSelectionInterval(n, n);
        Point point2 = this.getViewport().getViewPosition();
        this.popupMenu.show(this, point.x - point2.x + 10, point.y - point2.y);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.createPopupMenu(mouseEvent.getPoint());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.createPopupMenu(mouseEvent.getPoint());
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        Point point = mouseEvent.getPoint();
        if (mouseEvent.isPopupTrigger()) {
            this.createPopupMenu(point);
        } else if (mouseEvent.getClickCount() == 2 && (n = this.table.columnAtPoint(point)) == this.valueColumn) {
            int n2 = this.table.rowAtPoint(point);
            this.showValue(true, n2, n);
        }
    }

    private boolean isCellEditable(int n, int n2) {
        boolean bl = false;
        if (n2 != this.valueColumn || !CIMClientObject.userHasWritePermission() || this.uneditableRows.contains(new Integer(n)) || this.accessState == 0) {
            bl = false;
        } else if (this.newElement) {
            bl = true;
        } else if (this.parentElement instanceof CIMInstance) {
            CIMElement cIMElement = (CIMElement)this.cimElements.elementAt(n);
            bl = this.tableType != 0 || !((CIMProperty)cIMElement).isKey();
        }
        return bl;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
    }

    public void setAccessState(int n) {
        this.accessState = n;
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    class ElementsDataModel
    extends DefaultTableModel {
        ElementsDataModel() {
        }

        public int getColumnCount() {
            if (CIMElementsTable.this.tableHeading != null) {
                return CIMElementsTable.this.tableHeading.size();
            }
            return 0;
        }

        public Object getValueAt(int n, int n2) {
            CIMQualifier cIMQualifier;
            if (CIMElementsTable.this.tableType == 0) {
                CIMProperty cIMProperty = (CIMProperty)CIMElementsTable.this.cimElements.elementAt(n);
                if (cIMProperty != null) {
                    if (n2 == CIMElementsTable.this.nameColumn) {
                        return cIMProperty.getName();
                    }
                    if (n2 == CIMElementsTable.this.typeColumn) {
                        return Util.getDataTypeString(cIMProperty.getType());
                    }
                    if (n2 == CIMElementsTable.this.valueColumn) {
                        CIMValue cIMValue = cIMProperty.getValue();
                        String string = CIMElementsTable.this.emptyString;
                        if (cIMValue != null && cIMValue.getValue() != null && (string = cIMValue.getValue().toString()).equals("")) {
                            string = CIMElementsTable.this.emptyString;
                        }
                        return string;
                    }
                    if (n2 == 0) {
                        String string = cIMProperty.getOriginClass();
                        if (string == null || CIMElementsTable.this.parentElement == null) {
                            return CIMElementsTable.this.blankIcon;
                        }
                        if (CIMElementsTable.this.parentElement.getName().equals(string)) {
                            return CIMElementsTable.this.blankIcon;
                        }
                        return CIMElementsTable.this.inheritedIcon;
                    }
                    if (n2 == 1) {
                        if (cIMProperty.isKey()) {
                            return CIMElementsTable.this.keyIcon;
                        }
                        return CIMElementsTable.this.blankIcon;
                    }
                }
            } else if (CIMElementsTable.this.tableType == 1 && (cIMQualifier = (CIMQualifier)CIMElementsTable.this.cimElements.elementAt(n)) != null) {
                if (n2 == CIMElementsTable.this.nameColumn) {
                    return cIMQualifier.getName();
                }
                if (n2 == CIMElementsTable.this.typeColumn) {
                    try {
                        CIMQualifierType cIMQualifierType = CIMElementsTable.this.cimClient.getQualifierType(new CIMObjectPath(cIMQualifier.getName()));
                        return Util.getDataTypeString(cIMQualifierType.getType());
                    }
                    catch (Exception exception) {
                        return "NULL";
                    }
                }
                if (n2 == CIMElementsTable.this.valueColumn) {
                    CIMValue cIMValue = cIMQualifier.getValue();
                    String string = CIMElementsTable.this.emptyString;
                    if (cIMValue != null && cIMValue.getValue() != null && (string = cIMValue.getValue().toString()).equals("")) {
                        string = CIMElementsTable.this.emptyString;
                    }
                    return string;
                }
                return CIMElementsTable.this.blankIcon;
            }
            return CIMElementsTable.this.emptyString;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (CIMElementsTable.this.tableType == 0) {
                CIMProperty cIMProperty = (CIMProperty)CIMElementsTable.this.cimElements.elementAt(n);
                if (cIMProperty == null) {
                    cIMProperty = new CIMProperty();
                }
                if (n2 == CIMElementsTable.this.nameColumn) {
                    cIMProperty.setName((String)object);
                } else if (n2 == CIMElementsTable.this.typeColumn) {
                    CIMDataType cIMDataType = ((String)object).indexOf(95) > 0 ? new CIMDataType((String)object) : new CIMDataType(CIMElementsTable.this.cimTypes.getCIMType((String)object));
                    cIMProperty.setType(cIMDataType);
                } else if (n2 == CIMElementsTable.this.valueColumn) {
                    cIMProperty.setValue(new CIMValue(object));
                }
                CIMElementsTable.this.cimElements.setElementAt(cIMProperty, n);
            } else if (CIMElementsTable.this.tableType == 1) {
                CIMQualifier cIMQualifier = (CIMQualifier)CIMElementsTable.this.cimElements.elementAt(n);
                if (cIMQualifier == null) {
                    cIMQualifier = new CIMQualifier();
                }
                if (n2 == CIMElementsTable.this.valueColumn) {
                    cIMQualifier.setValue(new CIMValue(object));
                }
                CIMElementsTable.this.cimElements.setElementAt(cIMQualifier, n);
            }
            this.fireTableCellUpdated(n, n2);
        }

        public String getColumnName(int n) {
            return (String)CIMElementsTable.this.tableHeading.elementAt(n);
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

