/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.terminal.IFDCardTerminal;

import java.util.Properties;
import opencard.core.terminal.CardTerminalException;
import opencard.core.util.Tracer;

class IFDCardTerminalNative {
    static final int POWER_UP = 0;
    static final int POWER_DOWN = 1;
    static final int RESET = 2;
    private boolean[] readerConnected;
    private boolean nativeLibLoaded = false;
    private int numTerminalSupported = 0;
    private int numTerminalServed = 0;
    private Object terminalServedCounterLock = new Object();
    private Tracer tracer = new Tracer(class$com$sun$opencard$terminal$IFDCardTerminal$IFDCardTerminalNative == null ? (class$com$sun$opencard$terminal$IFDCardTerminal$IFDCardTerminalNative = IFDCardTerminalNative.class$("com.sun.opencard.terminal.IFDCardTerminal.IFDCardTerminalNative")) : class$com$sun$opencard$terminal$IFDCardTerminal$IFDCardTerminalNative);
    private int libIndex;
    static /* synthetic */ Class class$com$sun$opencard$terminal$IFDCardTerminal$IFDCardTerminalNative;

    private native byte[] nativeIFDHPowerICC(int var1, int var2, int var3, int var4);

    private native boolean nativeIFDHICCPresence(int var1, int var2, int var3);

    private native Properties nativeIFDHGetCapabilities(int var1, int var2);

    private native byte[] nativeIFDHTransmitICC(int var1, int var2, int var3, byte[] var4);

    private native boolean nativeIFDHCreateChannel(int var1, int var2, String var3);

    private native boolean nativeIFDHCloseChannel(int var1, int var2);

    private native int nativeInit(String var1);

    private native int getNumSupportedReaders(int var1);

    IFDCardTerminalNative(String string) throws CardTerminalException {
        try {
            this.tracer.debug("Constructor", "Going to load native library");
            System.loadLibrary("IFDNative");
            this.nativeLibLoaded = true;
            this.tracer.debug("Constructor", "Successful loaded native library");
        }
        catch (Exception exception) {
            this.tracer.debug("Constructor", "Failed to load native library" + exception);
            throw new CardTerminalException("Failed to load native library");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.tracer.debug("Constructor", "Failed to load native library" + unsatisfiedLinkError);
            throw new CardTerminalException("Failed to load native library");
        }
        if (string == null) {
            this.tracer.debug("Constructor", "IFDH library name is null");
            throw new CardTerminalException("Invalid IFD handler library name");
        }
        this.tracer.debug("Constructor", "IFD library Name = " + string);
        this.libIndex = this.nativeInit(string);
        if (this.libIndex < 0) {
            throw new CardTerminalException("Failed to initialize native library");
        }
        this.numTerminalSupported = this.getNumSupportedReaders(this.libIndex);
        if (this.numTerminalSupported < 1) {
            this.numTerminalSupported = 1;
        }
        this.readerConnected = new boolean[this.numTerminalSupported];
        int n = 0;
        while (n < this.numTerminalSupported) {
            this.readerConnected[n] = false;
            ++n;
        }
        this.tracer.debug("Constructor", "Done with nativeInit()");
    }

    byte[] IFDHPowerICC(int n, int n2, int n3) throws CardTerminalException {
        this.verifyState(n);
        return this.nativeIFDHPowerICC(this.libIndex, n, n2, n3);
    }

    boolean IFDHICCPresence(int n, int n2) throws CardTerminalException {
        this.verifyState(n);
        return this.nativeIFDHICCPresence(this.libIndex, n, n2);
    }

    Properties IFDHGetCapabilities(int n) throws CardTerminalException {
        this.verifyState(n);
        return this.nativeIFDHGetCapabilities(this.libIndex, n);
    }

    byte[] IFDHTransmitICC(int n, int n2, byte[] byArray) throws CardTerminalException {
        this.verifyState(n);
        return this.nativeIFDHTransmitICC(this.libIndex, n, n2, byArray);
    }

    boolean IFDHCreateChannel(int n, String string) throws CardTerminalException {
        if (!this.nativeLibLoaded || n < 0 || n >= this.numTerminalSupported) {
            throw new CardTerminalException();
        }
        boolean bl = this.nativeIFDHCreateChannel(this.libIndex, n, string);
        this.readerConnected[n] = true;
        return bl;
    }

    boolean IFDHCloseChannel(int n) throws CardTerminalException {
        this.verifyState(n);
        boolean bl = this.nativeIFDHCloseChannel(this.libIndex, n);
        this.readerConnected[n] = false;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean maxReaderServiced() {
        boolean bl = false;
        Object object = this.terminalServedCounterLock;
        synchronized (object) {
            if (this.numTerminalServed == this.numTerminalSupported) {
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNextReaderIndex() {
        int n;
        if (this.maxReaderServiced()) {
            return -1;
        }
        Object object = this.terminalServedCounterLock;
        synchronized (object) {
            n = this.numTerminalServed++;
        }
        return n;
    }

    int getNumSlots(int n) throws CardTerminalException {
        this.verifyState(n);
        Properties properties = this.nativeIFDHGetCapabilities(this.libIndex, n);
        if (properties == null) {
            return 1;
        }
        String string = properties.getProperty("slots", "1");
        return Integer.parseInt(string);
    }

    private void verifyState(int n) throws CardTerminalException {
        if (!this.nativeLibLoaded) {
            throw new CardTerminalException("Error: JNI library not loaded!");
        }
        if (this.libIndex < 0) {
            throw new CardTerminalException("Error: JNI library not correctly initialized!");
        }
        if (n < 0 || n >= this.numTerminalSupported) {
            throw new CardTerminalException("Error: Invalid terminal index");
        }
        if (!this.readerConnected[n]) {
            throw new CardTerminalException("Error: reader not connected");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

