/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.terminal.IFDCardTerminal;

import com.sun.opencard.terminal.IFDCardTerminal.IFDCardTerminal;
import com.sun.opencard.terminal.IFDCardTerminal.IFDCardTerminalNative;
import java.util.Hashtable;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalFactory;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.terminal.TerminalInitException;

public class IFDCardTerminalFactory
implements CardTerminalFactory {
    Hashtable multiTerminalIFDHandlers = new Hashtable();

    public void createCardTerminals(CardTerminalRegistry cardTerminalRegistry, String[] stringArray) throws CardTerminalException, TerminalInitException {
        if (stringArray.length != 4) {
            throw new TerminalInitException("IFDCardTerminalFactory: Invalid configuration parameters. Expecting 4 arguments, received " + stringArray.length + " arguments");
        }
        String string = stringArray[3];
        if (string == null) {
            throw new TerminalInitException("IFDCardTerminalFactory: ifdHandler library name is missing");
        }
        IFDCardTerminalNative iFDCardTerminalNative = (IFDCardTerminalNative)this.multiTerminalIFDHandlers.get(string);
        int n = 0;
        if (iFDCardTerminalNative == null) {
            iFDCardTerminalNative = new IFDCardTerminalNative(string);
            if (!iFDCardTerminalNative.maxReaderServiced()) {
                this.multiTerminalIFDHandlers.put(string, iFDCardTerminalNative);
            }
        } else {
            n = iFDCardTerminalNative.getNextReaderIndex();
            if (n < 0) {
                n = 0;
                iFDCardTerminalNative = new IFDCardTerminalNative(string);
                if (!iFDCardTerminalNative.maxReaderServiced()) {
                    this.multiTerminalIFDHandlers.put(string, iFDCardTerminalNative);
                }
            } else if (iFDCardTerminalNative.maxReaderServiced()) {
                this.multiTerminalIFDHandlers.remove(string);
            }
        }
        cardTerminalRegistry.add((CardTerminal)new IFDCardTerminal(stringArray[0], stringArray[1], stringArray[2], iFDCardTerminalNative, n));
    }

    public void open() {
    }

    public void close() {
    }
}

