/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.sysinfo.client;

import com.sun.admin.sysinfo.client.ServiceWrapper;
import com.sun.admin.sysinfo.common.NetworkInterfaceData;
import com.sun.admin.sysinfo.common.ProcessorData;
import com.sun.admin.sysinfo.common.SysInfoData;
import com.sun.admin.sysinfo.common.SysInfoException;
import com.sun.admin.sysinfo.common.TimeZoneData;
import com.sun.management.viper.VPermission;
import java.security.Permission;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.cim.UnsignedInt64;
import javax.wbem.client.CIMClient;
import javax.wbem.client.CIMSecurityException;

public class WbemServiceWrapper
extends ServiceWrapper {
    private static final String CIM_ACCESS_DENIED = "CIM_ERR_ACCESS_DENIED";
    private static final String CIM_GEN_EXCEPTION = "GENERAL_EXCEPTION";
    private static final String LOOPBACK = "loopback";
    private static final String SOLARIS_TZ = "Solaris_TimeZone";
    private static final String[] PROC_PROPS = new String[]{"DeviceID", "Family", "CurrentClockSpeed", "LoadPercentage", "Status", "OtherFamilyDescription"};
    private static final String[] OS_PROPS = new String[]{"CSName", "Name", "Version", "OtherTypeDescription", "LastBootUpTime", "LocalDateTime", "TotalVisibleMemorySize", "TotalSwapSpaceSize", "UsedSwapSpace"};
    private static final String[] CS_PROPS = new String[]{"Description", "HostId"};
    private static final String[] IP_PROPS = new String[]{"Address", "OptionsEnabled"};
    private static final String[] TZ_PROPS = new String[]{"StandardName", "Caption", "DaylightStartYear"};
    private static final int CIM_PROCESSOR_OTHER = 1;
    CIMClient cimClient = null;
    CIMObjectPath processorObjPath = null;
    CIMObjectPath osObjPath = null;
    CIMObjectPath computerObjPath = null;
    CIMObjectPath ipObjPath = null;
    CIMObjectPath timezoneObjPath = null;
    CIMObjectPath systemTZObjPath = null;

    protected boolean isDemo() {
        return false;
    }

    public boolean hasWriteAuthorization() {
        try {
            if (this.permissionCollection == null) {
                return false;
            }
            VPermission vPermission = new VPermission("solaris.compsys.write");
            if (this.permissionCollection.implies((Permission)vPermission)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void init(Object object, Object object2) throws Exception {
        super.init(object, object2);
        this.cimClient = (CIMClient)object;
        this.processorObjPath = new CIMObjectPath("CIM_Processor");
        this.osObjPath = new CIMObjectPath("CIM_OperatingSystem");
        this.computerObjPath = new CIMObjectPath("CIM_UnitaryComputerSystem");
        this.ipObjPath = new CIMObjectPath("CIM_IPProtocolEndPoint");
        this.timezoneObjPath = new CIMObjectPath(SOLARIS_TZ);
        this.systemTZObjPath = new CIMObjectPath("Solaris_SystemTimeZone");
    }

    protected void terminateConnection() {
    }

    public SysInfoData getSystemInfo() throws SysInfoException {
        SysInfoData sysInfoData = new SysInfoData();
        try {
            this.populateProcessorData(sysInfoData);
        }
        catch (Exception exception) {
            sysInfoData.setProcessors(null);
            this.mapException(exception);
        }
        try {
            this.populateTimeZoneData(sysInfoData);
        }
        catch (Exception exception) {
            sysInfoData.setTimeZones(null);
            this.mapException(exception);
        }
        try {
            this.populateSystemTZData(sysInfoData);
        }
        catch (Exception exception) {
            sysInfoData.setCurrentTimeZone(null);
            this.mapException(exception);
        }
        try {
            this.populateCSData(sysInfoData);
        }
        catch (Exception exception) {
            sysInfoData.setModel(null);
            sysInfoData.setHostID(null);
            this.mapException(exception);
        }
        try {
            this.populateIPData(sysInfoData);
        }
        catch (Exception exception) {
            sysInfoData.setNetworkInterfaces(null);
            this.mapException(exception);
        }
        try {
            this.populateOSData(sysInfoData);
        }
        catch (Exception exception) {
            sysInfoData.setVirtMemUsed(-1);
            sysInfoData.setVirtMem(-1);
            sysInfoData.setPhysMem(-1);
            sysInfoData.setDateTime(null);
            sysInfoData.setLastBoot(null);
            sysInfoData.setOS(null);
            sysInfoData.setHostName(null);
            this.mapException(exception);
        }
        return sysInfoData;
    }

    private boolean isPropertyInCIMInstance(String string, CIMInstance cIMInstance) {
        boolean bl = false;
        Enumeration enumeration = cIMInstance.getProperties().elements();
        while (enumeration.hasMoreElements()) {
            CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
            if (!cIMProperty.getName().equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void mapException(Exception exception) throws SysInfoException {
        if (exception instanceof CIMSecurityException) {
            if (((CIMSecurityException)exception).getID().equals(CIM_ACCESS_DENIED)) {
                throw new SysInfoException("EXM_SI_SVR_SEC_GETDATA");
            }
            throw new SysInfoException("EXM_SI_SVR_SEC_ERR");
        }
        if (exception instanceof CIMException) {
            if (((CIMException)exception).getID().equals(CIM_GEN_EXCEPTION)) {
                Object[] objectArray = ((CIMException)exception).getParams();
                String string = (String)objectArray[0];
                throw new SysInfoException("EXM_SI_SVR_REMOTE", string);
            }
            throw new SysInfoException("CANT_CONNECT_TO_SERVER", exception.getLocalizedMessage());
        }
    }

    public void updateTimeData(SysInfoData sysInfoData) throws SysInfoException {
        try {
            long l = System.currentTimeMillis();
            this.populateOSData(sysInfoData);
            long l2 = System.currentTimeMillis();
            sysInfoData.updateDateTime(l2 - l);
        }
        catch (Exception exception) {
            this.mapException(exception);
        }
    }

    private void populateOSData(SysInfoData sysInfoData) throws Exception {
        Enumeration enumeration = this.cimClient.enumerateInstances(this.osObjPath, true, false, false, false, OS_PROPS);
        CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
        String string = null;
        try {
            string = (String)cIMInstance.getProperty("CSName").getValue().getValue();
            sysInfoData.setHostName(string);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        string = null;
        try {
            string = cIMInstance.getProperty("Name").getValue().getValue() + " " + cIMInstance.getProperty("Version").getValue().getValue() + " " + cIMInstance.getProperty("OtherTypeDescription").getValue().getValue();
            sysInfoData.setOS(string);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        CIMDateTime cIMDateTime = null;
        try {
            cIMDateTime = (CIMDateTime)cIMInstance.getProperty("LastBootUpTime").getValue().getValue();
            sysInfoData.setLastBoot(cIMDateTime.getCalendar());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        cIMDateTime = null;
        try {
            cIMDateTime = (CIMDateTime)cIMInstance.getProperty("LocalDateTime").getValue().getValue();
            sysInfoData.setDateTime(cIMDateTime.getCalendar());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        UnsignedInt64 unsignedInt64 = null;
        try {
            unsignedInt64 = (UnsignedInt64)cIMInstance.getProperty("TotalVisibleMemorySize").getValue().getValue();
            sysInfoData.setPhysMem(unsignedInt64.intValue());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        unsignedInt64 = null;
        try {
            unsignedInt64 = (UnsignedInt64)cIMInstance.getProperty("TotalSwapSpaceSize").getValue().getValue();
            sysInfoData.setVirtMem(unsignedInt64.intValue());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        unsignedInt64 = null;
        try {
            unsignedInt64 = (UnsignedInt64)cIMInstance.getProperty("UsedSwapSpace").getValue().getValue();
            sysInfoData.setVirtMemUsed(unsignedInt64.intValue());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void populateIPData(SysInfoData sysInfoData) throws Exception {
        Enumeration enumeration = this.cimClient.enumerateInstances(this.ipObjPath, true, false, false, false, IP_PROPS);
        Vector<NetworkInterfaceData> vector = new Vector<NetworkInterfaceData>();
        String string = null;
        while (enumeration.hasMoreElements()) {
            CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
            boolean bl = this.isPropertyInCIMInstance("OptionsEnabled", cIMInstance);
            NetworkInterfaceData networkInterfaceData = new NetworkInterfaceData();
            if (bl) {
                try {
                    string = (String)cIMInstance.getProperty("OptionsEnabled").getValue().getValue();
                    string = string.toLowerCase();
                    if (string.indexOf(LOOPBACK) >= 0) continue;
                    try {
                        string = (String)cIMInstance.getProperty("Address").getValue().getValue();
                        networkInterfaceData.setIPAddress(string);
                        vector.addElement(networkInterfaceData);
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                }
                catch (NullPointerException nullPointerException) {}
                continue;
            }
            try {
                string = (String)cIMInstance.getProperty("Address").getValue().getValue();
                networkInterfaceData.setIPAddress(string);
                vector.addElement(networkInterfaceData);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        vector.trimToSize();
        sysInfoData.setNetworkInterfaces(vector);
    }

    private void populateCSData(SysInfoData sysInfoData) throws Exception {
        Enumeration enumeration = this.cimClient.enumerateInstances(this.computerObjPath, true, false, false, false, CS_PROPS);
        CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
        String string = null;
        try {
            string = (String)cIMInstance.getProperty("Description").getValue().getValue();
            sysInfoData.setModel(string);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        string = null;
        if (this.isPropertyInCIMInstance("HostId", cIMInstance)) {
            try {
                string = (String)cIMInstance.getProperty("HostId").getValue().getValue();
                sysInfoData.setHostID(string);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    private void populateProcessorData(SysInfoData sysInfoData) throws Exception {
        Enumeration enumeration = this.cimClient.enumerateInstances(this.processorObjPath, true, false, false, false, PROC_PROPS);
        Vector<ProcessorData> vector = new Vector<ProcessorData>();
        while (enumeration.hasMoreElements()) {
            CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
            ProcessorData processorData = new ProcessorData();
            String string = null;
            try {
                string = (String)cIMInstance.getProperty("DeviceID").getValue().getValue();
                processorData.setDeviceID(string);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            UnsignedInt16 unsignedInt16 = null;
            try {
                unsignedInt16 = (UnsignedInt16)cIMInstance.getProperty("Family").getValue().getValue();
                int n = unsignedInt16.intValue();
                processorData.setType(n);
                if (n == 1) {
                    String string2 = (String)cIMInstance.getProperty("OtherFamilyDescription").getValue().getValue();
                    processorData.setOtherDescr(string2);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            UnsignedInt32 unsignedInt32 = null;
            try {
                unsignedInt32 = (UnsignedInt32)cIMInstance.getProperty("CurrentClockSpeed").getValue().getValue();
                processorData.setClockSpeed(unsignedInt32.intValue());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            unsignedInt16 = null;
            try {
                unsignedInt16 = (UnsignedInt16)cIMInstance.getProperty("LoadPercentage").getValue().getValue();
                processorData.setUsage(unsignedInt16.intValue());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            string = null;
            try {
                string = (String)cIMInstance.getProperty("Status").getValue().getValue();
                processorData.setStatus(string);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            vector.addElement(processorData);
        }
        vector.trimToSize();
        sysInfoData.setProcessors(vector);
    }

    private void populateTimeZoneData(SysInfoData sysInfoData) throws Exception {
        Enumeration enumeration = this.cimClient.enumerateInstances(this.timezoneObjPath, true, false, false, false, TZ_PROPS);
        Vector<TimeZoneData> vector = new Vector<TimeZoneData>();
        while (enumeration.hasMoreElements()) {
            CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
            TimeZoneData timeZoneData = new TimeZoneData();
            String string = (String)cIMInstance.getProperty("StandardName").getValue().getValue();
            timeZoneData.setName(string);
            string = (String)cIMInstance.getProperty("Caption").getValue().getValue();
            timeZoneData.setOffset(string);
            CIMValue cIMValue = cIMInstance.getProperty("DaylightStartYear").getValue();
            timeZoneData.setDST(cIMValue != null);
            vector.addElement(timeZoneData);
        }
        vector.trimToSize();
        sysInfoData.setTimeZones(vector);
    }

    private void populateSystemTZData(SysInfoData sysInfoData) throws Exception {
        Enumeration enumeration = this.cimClient.enumerateInstances(this.systemTZObjPath, true, false, false, false, null);
        CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
        CIMValue cIMValue = cIMInstance.getProperty("Setting").getValue();
        CIMObjectPath cIMObjectPath = (CIMObjectPath)cIMValue.getValue();
        cIMInstance = this.cimClient.getInstance(cIMObjectPath, false, true, true, TZ_PROPS);
        TimeZoneData timeZoneData = new TimeZoneData();
        String string = (String)cIMInstance.getProperty("StandardName").getValue().getValue();
        timeZoneData.setName(string);
        string = (String)cIMInstance.getProperty("Caption").getValue().getValue();
        timeZoneData.setOffset(string);
        cIMValue = cIMInstance.getProperty("DaylightStartYear").getValue();
        timeZoneData.setDST(cIMValue != null);
        sysInfoData.setCurrentTimeZone(timeZoneData);
    }

    public void setDateTime(SysInfoData sysInfoData) throws SysInfoException {
        try {
            CIMDateTime cIMDateTime = new CIMDateTime(sysInfoData.getDateTime());
            CIMValue cIMValue = new CIMValue((Object)cIMDateTime, new CIMDataType(12));
            Enumeration enumeration = this.cimClient.enumerateInstanceNames(this.osObjPath);
            CIMObjectPath cIMObjectPath = (CIMObjectPath)enumeration.nextElement();
            this.cimClient.setProperty(cIMObjectPath, "LocalDateTime", cIMValue);
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals(CIM_GEN_EXCEPTION)) {
                Object[] objectArray = cIMException.getParams();
                String string = (String)objectArray[0];
                throw new SysInfoException("EXM_SI_SVR_REMOTE", string);
            }
            if (cIMException.getID().startsWith(CIM_ACCESS_DENIED)) {
                throw new SysInfoException("EXM_SI_SVR_NTP_SETDATE");
            }
            throw new SysInfoException("EXM_SI_SVR_CIM_SETDATE", cIMException.getLocalizedMessage());
        }
        catch (Exception exception) {
            throw new SysInfoException("EXM_SI_SVR_SETDATE", exception.getLocalizedMessage());
        }
    }

    public void setTimeZone(SysInfoData sysInfoData) throws SysInfoException {
        try {
            Enumeration enumeration = this.cimClient.enumerateInstances(this.systemTZObjPath, true, false, false, false, null);
            CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
            CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_TZ);
            CIMObjectPath cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
            String string = sysInfoData.getCurrentTimeZone().getName();
            cIMObjectPath2.addKey("StandardName", new CIMValue((Object)string));
            cIMInstance.setProperty("Setting", new CIMValue((Object)cIMObjectPath2));
            Enumeration enumeration2 = this.cimClient.enumerateInstanceNames(this.systemTZObjPath);
            CIMObjectPath cIMObjectPath3 = (CIMObjectPath)enumeration2.nextElement();
            this.cimClient.setInstance(cIMObjectPath3, cIMInstance);
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals(CIM_GEN_EXCEPTION)) {
                Object[] objectArray = cIMException.getParams();
                String string = (String)objectArray[0];
                throw new SysInfoException("EXM_SI_SVR_REMOTE", string);
            }
            throw new SysInfoException("EXM_SI_SVR_CIM_SETTZ", cIMException.getLocalizedMessage());
        }
        catch (Exception exception) {
            throw new SysInfoException("EXM_SI_SVR_SETTZ", exception.getLocalizedMessage());
        }
    }
}

